/*
 * Decompiled with CFR 0.152.
 */
package xaero.common.minimap.waypoints.render;

import com.mojang.blaze3d.systems.RenderSystem;
import java.util.Collection;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import net.minecraft.class_1297;
import net.minecraft.class_243;
import net.minecraft.class_287;
import net.minecraft.class_289;
import net.minecraft.class_290;
import net.minecraft.class_308;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_3532;
import net.minecraft.class_4587;
import net.minecraft.class_5498;
import net.minecraft.class_898;
import org.lwjgl.opengl.GL11;
import xaero.common.AXaeroMinimap;
import xaero.common.XaeroMinimapSession;
import xaero.common.gui.GuiMisc;
import xaero.common.interfaces.render.InterfaceRenderer;
import xaero.common.minimap.waypoints.Waypoint;
import xaero.common.minimap.waypoints.WaypointSet;
import xaero.common.minimap.waypoints.WaypointsManager;
import xaero.common.misc.Misc;
import xaero.common.settings.ModSettings;

public class WaypointsIngameRenderer {
    private AXaeroMinimap modMain;
    private class_4587 identityMatrixStack;

    public WaypointsIngameRenderer(AXaeroMinimap modMain, class_310 mc) {
        this.modMain = modMain;
        this.identityMatrixStack = new class_4587();
    }

    public void render(XaeroMinimapSession minimapSession, float partial) {
        if (this.modMain.getSettings().getShowIngameWaypoints()) {
            Hashtable<String, Hashtable<Integer, Waypoint>> customWaypoints;
            class_310 mc = class_310.method_1551();
            if (mc.field_1690.method_31044() != class_5498.field_26664) {
                return;
            }
            WaypointsManager waypointsManager = minimapSession.getWaypointsManager();
            class_1297 entity = mc.method_1560();
            class_243 eyePos = entity.method_5836(partial);
            double actualEntityY = entity.method_23318();
            double d3 = eyePos.method_10216();
            double d4 = eyePos.method_10214();
            double d5 = eyePos.method_10215();
            class_289 tessellator = class_289.method_1348();
            class_287 bufferbuilder = tessellator.method_1349();
            RenderSystem.disableCull();
            RenderSystem.pushMatrix();
            float yaw = 180.0f + entity.method_5705(partial);
            float pitch = entity.method_5695(partial);
            RenderSystem.rotatef((float)pitch, (float)1.0f, (float)0.0f, (float)0.0f);
            RenderSystem.rotatef((float)yaw, (float)0.0f, (float)1.0f, (float)0.0f);
            double dimDiv = waypointsManager.getDimensionDivision(waypointsManager.getCurrentContainerID());
            if (waypointsManager.getWaypoints() != null) {
                if (this.modMain.getSettings().renderAllSets) {
                    HashMap<String, WaypointSet> sets = waypointsManager.getCurrentWorld().getSets();
                    for (Map.Entry<String, WaypointSet> setEntry : sets.entrySet()) {
                        this.renderWaypointsList(setEntry.getValue().getList(), d3, d4, d5, entity, bufferbuilder, tessellator, dimDiv, actualEntityY, yaw, pitch);
                    }
                } else {
                    this.renderWaypointsList(waypointsManager.getWaypoints().getList(), d3, d4, d5, entity, bufferbuilder, tessellator, dimDiv, actualEntityY, yaw, pitch);
                }
            }
            if (!(customWaypoints = WaypointsManager.customWaypoints).isEmpty()) {
                for (Hashtable<Integer, Waypoint> modCustomWaypoints : customWaypoints.values()) {
                    this.renderWaypointsList(modCustomWaypoints.values(), d3, d4, d5, entity, bufferbuilder, tessellator, dimDiv, actualEntityY, yaw, pitch);
                }
            }
            class_308.method_1450();
            RenderSystem.enableDepthTest();
            RenderSystem.enableCull();
            RenderSystem.depthMask((boolean)true);
            RenderSystem.popMatrix();
        }
    }

    private void renderWaypointsList(Collection<Waypoint> list, double d3, double d4, double d5, class_1297 entity, class_287 bufferbuilder, class_289 tessellator, double dimDiv, double actualEntityY, float yaw, float pitch) {
        float cameraAngleYaw = class_3532.method_15393((float)entity.field_6031);
        class_243 lookVector = entity.method_5720();
        for (Waypoint w : list) {
            this.renderWaypointIngame(cameraAngleYaw, lookVector, w, this.modMain, 12.0, d3, d4, d5, entity, bufferbuilder, tessellator, dimDiv, actualEntityY, yaw, pitch);
        }
    }

    private void renderWaypointIngame(float cameraAngleYaw, class_243 lookVector, Waypoint w, AXaeroMinimap modMain, double radius, double d3, double d4, double d5, class_1297 entity, class_287 bufferBuilder, class_289 tessellator, double dimDiv, double actualEntityY, float yaw, float pitch) {
        float offZ;
        float offY;
        if (w.isDisabled() || w.getType() == 1 && !modMain.getSettings().getDeathpoints()) {
            return;
        }
        float offX = (float)((double)w.getX(dimDiv) - d3) + 0.5f;
        if ((double)offX * lookVector.field_1352 + (double)(offY = (float)((double)w.getY() - d4) + 1.0f) * lookVector.field_1351 + (double)(offZ = (float)((double)w.getZ(dimDiv) - d5) + 0.5f) * lookVector.field_1350 < 0.0) {
            return;
        }
        double distance = Math.sqrt(offX * offX + offY * offY + offZ * offZ);
        double correctDistance = Math.sqrt((double)(offX * offX) + (actualEntityY - (double)w.getY()) * (actualEntityY - (double)w.getY()) + (double)(offZ * offZ));
        double distance2D = Math.sqrt(offX * offX + offZ * offZ);
        if (w.getType() == 0 && !w.isGlobal() && modMain.getSettings().waypointsDistance != 0.0 && distance2D > modMain.getSettings().waypointsDistance || modMain.getSettings().waypointsDistanceMin != 0.0 && distance2D < modMain.getSettings().waypointsDistanceMin) {
            return;
        }
        class_898 renderManager = class_310.method_1551().method_1561();
        class_327 fontrenderer = renderManager.method_3949();
        if (fontrenderer == null) {
            return;
        }
        float f = 1.6f;
        float f1 = 0.016666668f * f;
        RenderSystem.pushMatrix();
        float textSize = 1.0f;
        String name = w.getLocalizedName();
        String distanceText = "";
        boolean showDistance = false;
        float zoomer2 = 1.0f;
        if (modMain.getSettings().keepWaypointNames) {
            textSize = 1.6f;
        }
        if (distance > radius) {
            double maxDistance = (double)class_310.method_1551().field_1690.field_1870 * 16.0;
            if (distance > maxDistance) {
                zoomer2 = (float)(maxDistance / radius);
                float zoomer = (float)(maxDistance / distance);
                offX *= zoomer;
                offY *= zoomer;
                offZ *= zoomer;
            } else {
                zoomer2 = (float)(distance / radius);
            }
        }
        if (correctDistance > 20.0 || modMain.getSettings().alwaysShowDistance) {
            textSize = 1.6f;
            if (modMain.getSettings().distance == 1) {
                float offset;
                float Z = (float)(offZ == 0.0f ? 0.001 : (double)offZ);
                float angle = (float)Math.toDegrees(Math.atan(-offX / Z));
                if (offZ < 0.0f) {
                    angle = offX < 0.0f ? (angle += 180.0f) : (angle -= 180.0f);
                }
                boolean bl = showDistance = Math.abs(offset = class_3532.method_15393((float)(angle - cameraAngleYaw))) < (float)modMain.getSettings().lookingAtAngle;
                if (modMain.getSettings().lookingAtAngleVertical != 180) {
                    float cameraAnglePitch = entity.field_5965;
                    float verticalAngle = (float)Math.toDegrees(Math.asin((double)(-offY) / (distance == 0.0 ? 1.0E-5 : distance)));
                    showDistance = showDistance && Math.abs(verticalAngle - cameraAnglePitch) < (float)modMain.getSettings().lookingAtAngleVertical;
                }
            } else if (modMain.getSettings().distance == 2) {
                showDistance = true;
            }
            if (showDistance) {
                distanceText = GuiMisc.simpleFormat.format(correctDistance) + "m";
                if (!modMain.getSettings().keepWaypointNames) {
                    name = "";
                }
            } else {
                name = "";
            }
        }
        RenderSystem.translatef((float)offX, (float)offY, (float)offZ);
        GL11.glNormal3f((float)0.0f, (float)1.0f, (float)0.0f);
        RenderSystem.rotatef((float)(180.0f - yaw), (float)0.0f, (float)1.0f, (float)0.0f);
        RenderSystem.rotatef((float)pitch, (float)1.0f, (float)0.0f, (float)0.0f);
        RenderSystem.scalef((float)(-f1), (float)(-f1), (float)f1);
        RenderSystem.scalef((float)zoomer2, (float)zoomer2, (float)1.0f);
        RenderSystem.disableLighting();
        RenderSystem.disableDepthTest();
        RenderSystem.enableBlend();
        RenderSystem.blendFuncSeparate((int)770, (int)771, (int)1, (int)0);
        RenderSystem.scalef((float)2.0f, (float)2.0f, (float)2.0f);
        this.drawIconInWorld(w, modMain.getSettings(), bufferBuilder, tessellator, fontrenderer, name, distanceText, textSize, showDistance);
        RenderSystem.enableLighting();
        RenderSystem.disableBlend();
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.popMatrix();
    }

    public void drawIconInWorld(Waypoint w, ModSettings settings, class_287 vertexBuffer, class_289 tessellator, class_327 fontrenderer, String name, String distance, float textSize, boolean showDistance) {
        RenderSystem.scaled((double)settings.waypointsScale, (double)settings.waypointsScale, (double)1.0);
        int addedFrame = 0;
        if (w.getType() == 0) {
            int c = ModSettings.COLORS[w.getColor()];
            float l = (float)(c >> 16 & 0xFF) / 255.0f;
            float i1 = (float)(c >> 8 & 0xFF) / 255.0f;
            float j1 = (float)(c & 0xFF) / 255.0f;
            int s = fontrenderer.method_1727(w.getSymbol()) / 2;
            RenderSystem.disableTexture();
            vertexBuffer.method_1328(7, class_290.field_1592);
            RenderSystem.color4f((float)l, (float)i1, (float)j1, (float)(133.3f * ((float)settings.waypointOpacityIngame / 100.0f) / 255.0f));
            if (s > 4) {
                addedFrame = s - 4;
            }
            vertexBuffer.method_22912(-5.0 - (double)addedFrame, -9.0 - (double)addedFrame, 0.0).method_1344();
            vertexBuffer.method_22912(-5.0 - (double)addedFrame, (double)addedFrame, 0.0).method_1344();
            vertexBuffer.method_22912(4.0 + (double)addedFrame, (double)addedFrame, 0.0).method_1344();
            vertexBuffer.method_22912(4.0 + (double)addedFrame, -9.0 - (double)addedFrame, 0.0).method_1344();
            tessellator.method_1350();
            RenderSystem.enableTexture();
            Misc.drawPiercingText(this.identityMatrixStack, w.getSymbol(), (float)(-s), -8.0f, -1, false);
        } else if (w.getType() == 1) {
            class_310.method_1551().method_1531().method_22813(InterfaceRenderer.guiTextures);
            float f = 0.00390625f;
            float f1 = 0.00390625f;
            RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)(250.0f * ((float)settings.waypointOpacityIngame / 100.0f) / 255.0f));
            vertexBuffer.method_1328(7, class_290.field_1585);
            vertexBuffer.method_22912(-5.0, -9.0, 0.0).method_22913(0.0f, 78.0f * f1).method_1344();
            vertexBuffer.method_22912(-5.0, 0.0, 0.0).method_22913(0.0f, 87.0f * f1).method_1344();
            vertexBuffer.method_22912(4.0, 0.0, 0.0).method_22913(9.0f * f, 87.0f * f1).method_1344();
            vertexBuffer.method_22912(4.0, -9.0, 0.0).method_22913(9.0f * f, 78.0f * f1).method_1344();
            tessellator.method_1350();
            if (!showDistance) {
                name = w.getLocalizedName();
                if (!settings.keepWaypointNames) {
                    textSize = 1.0f;
                }
            }
        }
        RenderSystem.enableBlend();
        RenderSystem.blendFuncSeparate((int)770, (int)771, (int)1, (int)0);
        if (class_310.method_1551().method_1573()) {
            textSize *= 1.5f;
        }
        boolean showingName = name.length() > 0;
        RenderSystem.translatef((float)0.0f, (float)(1 + addedFrame), (float)0.0f);
        RenderSystem.scalef((float)(textSize / 2.0f), (float)(textSize / 2.0f), (float)1.0f);
        if (distance.length() > 0) {
            int t = fontrenderer.method_1727(distance) / 2;
            RenderSystem.disableTexture();
            RenderSystem.color4f((float)0.0f, (float)0.0f, (float)0.0f, (float)0.27450982f);
            vertexBuffer.method_1328(7, class_290.field_1592);
            vertexBuffer.method_22912((double)(-t) - 1.0, (double)(showingName ? 10 : 0), 0.0).method_1344();
            vertexBuffer.method_22912((double)(-t) - 1.0, 9.0 + (double)(showingName ? 10 : 0), 0.0).method_1344();
            vertexBuffer.method_22912((double)t, 9.0 + (double)(showingName ? 10 : 0), 0.0).method_1344();
            vertexBuffer.method_22912((double)t, (double)(showingName ? 10 : 0), 0.0).method_1344();
            tessellator.method_1350();
            RenderSystem.enableTexture();
            Misc.drawPiercingText(this.identityMatrixStack, distance, (float)(-t), (float)(1 + (showingName ? 10 : 0)), -1, false);
        }
        if (showingName) {
            int t = fontrenderer.method_1727(name) / 2;
            Misc.drawPiercingText(this.identityMatrixStack, name, (float)(-t), 1.0f, -1, false);
        }
    }
}

