/*
 * Decompiled with CFR 0.152.
 */
package xaero.pvp;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import net.fabricmc.api.ClientModInitializer;
import net.fabricmc.api.DedicatedServerModInitializer;
import net.fabricmc.fabric.api.network.PacketConsumer;
import net.fabricmc.fabric.impl.networking.ClientSidePacketRegistryImpl;
import net.fabricmc.loader.ModContainer;
import net.fabricmc.loader.api.FabricLoader;
import net.fabricmc.loader.util.UrlConversionException;
import net.fabricmc.loader.util.UrlUtil;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import xaero.common.AXaeroMinimap;
import xaero.common.XaeroMinimapSession;
import xaero.common.controls.ControlsRegister;
import xaero.common.core.XaeroMinimapCore;
import xaero.common.events.FMLEventHandler;
import xaero.common.events.ForgeEventHandler;
import xaero.common.events.ModEvents;
import xaero.common.file.SimpleBackup;
import xaero.common.gui.GuiHelper;
import xaero.common.gui.widget.WidgetLoadingHandler;
import xaero.common.gui.widget.WidgetScreenHandler;
import xaero.common.interfaces.InterfaceManager;
import xaero.common.interfaces.render.InterfaceRenderer;
import xaero.common.message.MinimapMessage;
import xaero.common.message.MinimapPacketConsumer;
import xaero.common.misc.Internet;
import xaero.common.mods.SupportMods;
import xaero.common.server.XaeroMinimapServer;
import xaero.common.server.core.XaeroMinimapServerCore;
import xaero.common.settings.ModOptions;
import xaero.common.settings.ModSettings;
import xaero.common.validator.FieldValidatorHolder;
import xaero.common.validator.NumericFieldValidator;
import xaero.patreon.Patreon5;
import xaero.patreon.PatreonMod3;
import xaero.pvp.BetterPVPClient;
import xaero.pvp.BetterPVPSession;
import xaero.pvp.controls.BPVPControlsRegister;
import xaero.pvp.events.BPVPEvents;
import xaero.pvp.events.BPVPFMLEvents;
import xaero.pvp.gui.BPVPGuiHelper;
import xaero.pvp.interfaces.BPVPInterfaceHandler;
import xaero.pvp.interfaces.BPVPInterfaceLoader;
import xaero.pvp.settings.BPVPModSettings;

public class BetterPVP
extends AXaeroMinimap
implements ClientModInitializer,
DedicatedServerModInitializer {
    public static BetterPVP instance;
    private final Logger LOGGER = LogManager.getLogger();
    private static final String versionID = "1.16.4_20.29.0_fabric";
    private int newestUpdateID;
    private boolean isOutdated = true;
    public static String fileLayoutID;
    private String latestVersion;
    public static final File old_optionsFile;
    public static final File oldConfigFile;
    private ModSettings settings;
    private String message = "";
    private ControlsRegister controlsRegister;
    private ForgeEventHandler events;
    private FMLEventHandler fmlEvents;
    private ModEvents modEvents;
    protected InterfaceRenderer interfaceRenderer;
    protected InterfaceManager interfaces;
    private GuiHelper guiHelper;
    private FieldValidatorHolder fieldValidators;
    private SupportMods supportMods;
    private WidgetScreenHandler widgetScreenHandler;
    private WidgetLoadingHandler widgetLoader;
    private File modJAR = null;
    private File configFile;
    public File waypointsFile;
    public File waypointsFolder;
    private boolean loadLaterDone;
    private XaeroMinimapServer minimapServer;

    public void onInitializeClient() {
        INSTANCE = this;
        instance = this;
        this.loadClient();
    }

    public void onInitializeServer() {
        INSTANCE = this;
        instance = this;
        this.loadServer();
    }

    private void loadClient() {
        SupportMods.checkForMinimapDuplicates();
        this.LOGGER.info("Loading Better PVP Mod - Stage 1/2");
        try {
            Path gameDir;
            Path modFile;
            ModOptions.init(this);
            ModContainer modContainer = FabricLoader.getInstance().getModContainer(versionID.endsWith("fair") ? "xaerobetterpvpfair" : "xaerobetterpvp").orElse(null);
            if (modContainer == null) {
                modContainer = FabricLoader.getInstance().getModContainer("xaerodev").orElse(null);
            }
            try {
                modFile = UrlUtil.asPath((URL)modContainer.getOriginUrl());
            }
            catch (UrlConversionException e) {
                throw new RuntimeException("Weird... Couldn't convert URL to Path.", e);
            }
            new BetterPVPClient().preInit(modContainer.getInfo().getId(), this);
            String fileName = modFile.getFileName().toString();
            if (fileName.endsWith(".jar")) {
                this.modJAR = modFile.toFile();
            }
            if ((gameDir = FabricLoader.getInstance().getGameDirectory().toPath()).getFileName().toString().equals(".")) {
                gameDir = gameDir.getParent();
            }
            Path config = FabricLoader.getInstance().getConfigDirectory().toPath();
            this.waypointsFile = config.resolve("xaerowaypoints.txt").toFile();
            Path wrongWaypointsFolder3 = config.resolve("XaeroWaypoints");
            Path wrongWaypointsFolder2 = this.modJAR != null ? this.modJAR.toPath().getParent().resolve("XaeroWaypoints") : config.getParent().resolve("mods").resolve("XaeroWaypoints");
            Path wrongWaypointsFolder4 = new File(config.toFile().getCanonicalPath()).toPath().getParent().resolve("XaeroWaypoints");
            Path wrongWaypointsFolder5 = config.getParent().resolve("XaeroWaypoints");
            this.waypointsFolder = gameDir.resolve("XaeroWaypoints").toFile();
            if (wrongWaypointsFile.exists() && !this.waypointsFile.exists()) {
                Files.move(wrongWaypointsFile.toPath(), this.waypointsFile.toPath(), new CopyOption[0]);
            }
            if (wrongWaypointsFolder.exists() && !this.waypointsFolder.exists()) {
                Files.move(wrongWaypointsFolder.toPath(), this.waypointsFolder.toPath(), new CopyOption[0]);
            } else if (wrongWaypointsFolder2.toFile().exists() && !this.waypointsFolder.exists()) {
                Files.move(wrongWaypointsFolder2, this.waypointsFolder.toPath(), new CopyOption[0]);
            } else if (wrongWaypointsFolder3.toFile().exists() && !this.waypointsFolder.exists()) {
                Files.move(wrongWaypointsFolder3, this.waypointsFolder.toPath(), new CopyOption[0]);
            } else if (wrongWaypointsFolder4.toFile().exists() && !this.waypointsFolder.exists()) {
                Files.move(wrongWaypointsFolder4, this.waypointsFolder.toPath(), new CopyOption[0]);
            } else if (wrongWaypointsFolder5.toFile().exists() && !this.waypointsFolder.exists()) {
                Files.move(wrongWaypointsFolder5, this.waypointsFolder.toPath(), new CopyOption[0]);
            }
            Path waypointsFolderBackup062020 = this.waypointsFolder.toPath().resolveSibling(this.waypointsFolder.getName() + "_BACKUP062020");
            if (!Files.exists(waypointsFolderBackup062020, new LinkOption[0]) && this.waypointsFolder.exists()) {
                System.out.println("Backing up XaeroWaypoints...");
                SimpleBackup.copyDirectoryWithContents(this.waypointsFolder.toPath(), waypointsFolderBackup062020, 32, StandardCopyOption.REPLACE_EXISTING);
                System.out.println("Done backing up XaeroWaypoints!");
            }
            this.configFile = config.resolve("pvpsettings.txt").toFile();
            if (oldConfigFile.exists() && !this.configFile.getAbsolutePath().equals(oldConfigFile.getAbsolutePath())) {
                Files.move(oldConfigFile.toPath(), this.configFile.toPath(), new CopyOption[0]);
            }
            Patreon5.checkPatreon();
            Patreon5.rendersCapes = fileLayoutID;
            this.widgetScreenHandler = new WidgetScreenHandler();
            this.widgetLoader = new WidgetLoadingHandler(this.widgetScreenHandler);
            this.settings = new BPVPModSettings(this);
            this.controlsRegister = new BPVPControlsRegister();
            this.guiHelper = new BPVPGuiHelper(this);
            this.fieldValidators = new FieldValidatorHolder(new NumericFieldValidator());
            this.interfaceRenderer = new InterfaceRenderer(this);
            BPVPInterfaceLoader interfaceLoader = new BPVPInterfaceLoader(this);
            this.interfaces = new BPVPInterfaceHandler(this, interfaceLoader);
            this.settings = new BPVPModSettings(this);
            if (old_optionsFile.exists() && !this.configFile.exists()) {
                this.configFile.getParentFile().mkdirs();
                Files.move(old_optionsFile.toPath(), this.configFile.toPath(), new CopyOption[0]);
            }
            if (old_waypointsFile.exists() && !this.waypointsFile.exists()) {
                this.waypointsFile.getParentFile().mkdirs();
                Files.move(old_waypointsFile.toPath(), this.waypointsFile.toPath(), new CopyOption[0]);
            }
            this.modEvents = new ModEvents(this);
            XaeroMinimapCore.modMain = this;
            ClientSidePacketRegistryImpl.INSTANCE.register(MinimapMessage.MAIN_CHANNEL, (PacketConsumer)new MinimapPacketConsumer());
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void tryLoadLater() {
        if (this.loadLaterDone) {
            return;
        }
        this.loadLaterDone = true;
        this.LOGGER.info("Loading Better PVP Mod - Stage 2/2");
        try {
            PatreonMod3 patreonEntry;
            ((BPVPControlsRegister)this.controlsRegister).onStage2();
            this.settings.loadSettings();
            Internet.checkModVersion(this);
            if (this.isOutdated && (patreonEntry = this.getPatreon()) != null) {
                patreonEntry.modJar = this.modJAR;
                patreonEntry.currentVersion = versionID;
                patreonEntry.latestVersion = this.latestVersion;
                patreonEntry.onVersionIgnore = () -> {
                    ModSettings.ignoreUpdate = this.newestUpdateID;
                    try {
                        this.getSettings().saveSettings();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                };
                Patreon5.addOutdatedMod(patreonEntry);
            }
            this.events = new BPVPEvents(this);
            this.fmlEvents = new BPVPFMLEvents(this);
            this.supportMods = new SupportMods(this);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        this.loaded = true;
    }

    public void loadServer() {
        this.minimapServer = new XaeroMinimapServer(this);
        this.minimapServer.load();
        XaeroMinimapServerCore.minimapServer = this.minimapServer;
    }

    @Override
    public void tryLoadLaterServer() {
        if (this.loadLaterDone) {
            return;
        }
        this.loadLaterDone = true;
        this.minimapServer.loadLater();
    }

    @Override
    public String getVersionsURL() {
        return "http://data.chocolateminecraft.com/Versions/BetterPvPMod.txt";
    }

    @Override
    public String getUpdateLink() {
        return "http://chocolateminecraft.com/update/bpvp.html";
    }

    @Override
    public File getOldOptionsFile() {
        return old_optionsFile;
    }

    @Override
    public File getOldConfigFile() {
        return oldConfigFile;
    }

    @Override
    public String getFileLayoutID() {
        return fileLayoutID;
    }

    @Override
    public File getConfigFile() {
        return this.configFile;
    }

    @Override
    public File getModJAR() {
        return this.modJAR;
    }

    public BPVPModSettings getBPVPSettings() {
        return (BPVPModSettings)this.settings;
    }

    @Override
    public ModSettings getSettings() {
        return this.settings;
    }

    @Override
    public void setSettings(ModSettings minimapSettings) {
        this.settings = minimapSettings;
    }

    @Override
    public void resetSettings() {
        this.settings = new BPVPModSettings(this);
    }

    @Override
    public boolean isOutdated() {
        return this.isOutdated;
    }

    @Override
    public void setOutdated(boolean value) {
        this.isOutdated = value;
    }

    @Override
    public String getMessage() {
        return this.message;
    }

    @Override
    public void setMessage(String string) {
        this.message = string;
    }

    @Override
    public String getLatestVersion() {
        return this.latestVersion;
    }

    @Override
    public void setLatestVersion(String string) {
        this.latestVersion = string;
    }

    @Override
    public int getNewestUpdateID() {
        return this.newestUpdateID;
    }

    @Override
    public void setNewestUpdateID(int parseInt) {
        this.newestUpdateID = parseInt;
    }

    @Override
    public PatreonMod3 getPatreon() {
        return Patreon5.mods.get(fileLayoutID);
    }

    @Override
    public String getVersionID() {
        return versionID;
    }

    @Override
    public Object getSettingsKey() {
        return BPVPControlsRegister.keyBindSettings;
    }

    @Override
    public File getWaypointsFile() {
        return this.waypointsFile;
    }

    @Override
    public File getWaypointsFolder() {
        return this.waypointsFolder;
    }

    @Override
    public Logger getLogger() {
        return this.LOGGER;
    }

    @Override
    public WidgetScreenHandler getWidgetScreenHandler() {
        return this.widgetScreenHandler;
    }

    @Override
    public WidgetLoadingHandler getWidgetLoader() {
        return this.widgetLoader;
    }

    @Override
    public XaeroMinimapSession createSession() {
        return new BetterPVPSession(this);
    }

    @Override
    public SupportMods getSupportMods() {
        return this.supportMods;
    }

    @Override
    public FMLEventHandler getFMLEvents() {
        return this.fmlEvents;
    }

    @Override
    public ModEvents getModEvents() {
        return this.modEvents;
    }

    @Override
    public GuiHelper getGuiHelper() {
        return this.guiHelper;
    }

    @Override
    public FieldValidatorHolder getFieldValidators() {
        return this.fieldValidators;
    }

    @Override
    public ControlsRegister getControlsRegister() {
        return this.controlsRegister;
    }

    @Override
    public ForgeEventHandler getEvents() {
        return this.events;
    }

    @Override
    public InterfaceManager getInterfaces() {
        return this.interfaces;
    }

    @Override
    public InterfaceRenderer getInterfaceRenderer() {
        return this.interfaceRenderer;
    }

    static {
        fileLayoutID = versionID.endsWith("fair") ? "bpvpfair_fabric" : "bpvp_fabric";
        old_optionsFile = new File("pvpsettings.txt");
        oldConfigFile = new File("config/pvpsettings.txt");
    }
}

