/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.api;

import java.util.Collections;
import java.util.Map;
import java.util.function.Function;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Inventory;
import net.minecraft.item.DyeColor;
import net.minecraft.item.IArmorMaterial;
import net.minecraft.item.IItemTier;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Rarity;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.util.Direction;
import net.minecraft.util.LazyValue;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.registry.Registry;
import net.minecraft.world.World;
import org.apache.logging.log4j.LogManager;
import vazkii.botania.api.brew.Brew;
import vazkii.botania.api.corporea.ICorporeaNodeDetector;
import vazkii.botania.api.internal.DummyManaNetwork;
import vazkii.botania.api.internal.IManaNetwork;

public interface BotaniaAPI {
    public static final String MODID = "botania";
    public static final LazyValue<BotaniaAPI> INSTANCE = new LazyValue(() -> {
        try {
            return (BotaniaAPI)Class.forName("vazkii.botania.common.impl.BotaniaAPIImpl").newInstance();
        }
        catch (ReflectiveOperationException e) {
            LogManager.getLogger().warn("Unable to find BotaniaAPIImpl, using a dummy");
            return new BotaniaAPI(){};
        }
    });
    public static final IArmorMaterial DUMMY_ARMOR_MATERIAL = new IArmorMaterial(){

        public int func_200896_a(@Nonnull EquipmentSlotType slot) {
            return 0;
        }

        public int func_200902_b(@Nonnull EquipmentSlotType slot) {
            return 0;
        }

        public int func_200900_a() {
            return 0;
        }

        @Nonnull
        public SoundEvent func_200899_b() {
            return SoundEvents.field_187728_s;
        }

        @Nonnull
        public Ingredient func_200898_c() {
            return Ingredient.field_193370_a;
        }

        public String func_200897_d() {
            return "missingno";
        }

        public float func_200901_e() {
            return 0.0f;
        }

        public float func_230304_f_() {
            return 0.0f;
        }
    };
    public static final IItemTier DUMMY_ITEM_TIER = new IItemTier(){

        public int func_200926_a() {
            return 0;
        }

        public float func_200928_b() {
            return 0.0f;
        }

        public float func_200929_c() {
            return 0.0f;
        }

        public int func_200925_d() {
            return 0;
        }

        public int func_200927_e() {
            return 0;
        }

        @Nonnull
        public Ingredient func_200924_f() {
            return Ingredient.field_193370_a;
        }
    };

    public static BotaniaAPI instance() {
        return (BotaniaAPI)INSTANCE.func_179281_c();
    }

    default public int apiVersion() {
        return 0;
    }

    default public Registry<Brew> getBrewRegistry() {
        return null;
    }

    default public Map<ResourceLocation, Integer> getOreWeights() {
        return Collections.emptyMap();
    }

    default public Map<ResourceLocation, Integer> getNetherOreWeights() {
        return Collections.emptyMap();
    }

    default public void registerOreWeight(ResourceLocation tag, int weight) {
    }

    default public void registerNetherOreWeight(ResourceLocation tag, int weight) {
    }

    default public Map<ResourceLocation, Function<DyeColor, Block>> getPaintableBlocks() {
        return Collections.emptyMap();
    }

    default public void registerPaintableBlock(Block block, Function<DyeColor, Block> transformer) {
        this.registerPaintableBlock(Registry.field_212618_g.func_177774_c((Object)block), transformer);
    }

    default public void registerPaintableBlock(ResourceLocation blockId, Function<DyeColor, Block> transformer) {
    }

    default public IArmorMaterial getManasteelArmorMaterial() {
        return DUMMY_ARMOR_MATERIAL;
    }

    default public IArmorMaterial getElementiumArmorMaterial() {
        return DUMMY_ARMOR_MATERIAL;
    }

    default public IArmorMaterial getManaweaveArmorMaterial() {
        return DUMMY_ARMOR_MATERIAL;
    }

    default public IArmorMaterial getTerrasteelArmorMaterial() {
        return DUMMY_ARMOR_MATERIAL;
    }

    default public IItemTier getManasteelItemTier() {
        return DUMMY_ITEM_TIER;
    }

    default public IItemTier getElementiumItemTier() {
        return DUMMY_ITEM_TIER;
    }

    default public IItemTier getTerrasteelItemTier() {
        return DUMMY_ITEM_TIER;
    }

    default public Rarity getRelicRarity() {
        return Rarity.EPIC;
    }

    default public IManaNetwork getManaNetworkInstance() {
        return DummyManaNetwork.instance;
    }

    default public int getPassiveFlowerDecay() {
        return 0;
    }

    default public IInventory getAccessoriesInventory(PlayerEntity player) {
        return new Inventory(0);
    }

    default public void breakOnAllCursors(PlayerEntity player, ItemStack stack, BlockPos pos, Direction side) {
    }

    default public boolean hasSolegnoliaAround(Entity e) {
        return false;
    }

    default public void sparkleFX(World world, double x, double y, double z, float r, float g, float b, float size, int m) {
    }

    default public boolean shouldForceCheck() {
        return false;
    }

    default public void registerCorporeaNodeDetector(ICorporeaNodeDetector detector) {
    }
}

