/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.client.integration.jei.orechid;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.IRecipeLayout;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.drawable.IDrawableStatic;
import mezz.jei.api.gui.ingredient.IGuiItemStackGroup;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.ResourceLocation;
import vazkii.botania.client.integration.jei.JEIBotaniaPlugin;
import vazkii.botania.client.integration.jei.orechid.OrechidRecipeWrapper;
import vazkii.botania.common.lib.ResourceLocationHelper;

public abstract class OrechidRecipeCategoryBase<T extends OrechidRecipeWrapper>
implements IRecipeCategory<T> {
    private final IDrawableStatic background;
    private final String localizedName;
    private final IDrawableStatic overlay;
    private final IDrawable icon;
    private final ItemStack iconStack;
    private final ItemStack inputStack;

    public OrechidRecipeCategoryBase(IGuiHelper guiHelper, ItemStack iconStack, ItemStack inputStack, String localizedName) {
        this.overlay = guiHelper.createDrawable(ResourceLocationHelper.prefix("textures/gui/pure_daisy_overlay.png"), 0, 0, 64, 44);
        this.background = guiHelper.createBlankDrawable(96, 44);
        this.localizedName = localizedName;
        this.icon = guiHelper.createDrawableIngredient((Object)iconStack);
        this.iconStack = iconStack;
        this.inputStack = inputStack;
    }

    @Nonnull
    public abstract Class<? extends T> getRecipeClass();

    @Nonnull
    public String getTitle() {
        return this.localizedName;
    }

    @Nonnull
    public IDrawable getBackground() {
        return this.background;
    }

    @Nonnull
    public IDrawable getIcon() {
        return this.icon;
    }

    public void setIngredients(T recipe, IIngredients ingredients) {
        ingredients.setInput(VanillaTypes.ITEM, (Object)this.inputStack);
        int myWeight = ((OrechidRecipeWrapper)recipe).entry.getValue();
        int amount = Math.max(1, Math.round((float)myWeight * 64.0f / OrechidRecipeCategoryBase.getTotalOreWeight(this.getOreWeights(), myWeight)));
        List<ItemStack> stackList = BlockTags.func_199896_a().func_241834_b(((OrechidRecipeWrapper)recipe).entry.getKey()).func_230236_b_().stream().filter(s -> s.func_199767_j() != Items.field_190931_a).map(ItemStack::new).collect(Collectors.toList());
        stackList.forEach(s -> s.func_190920_e(amount));
        ingredients.setOutputLists(VanillaTypes.ITEM, Collections.singletonList(stackList));
    }

    public static float getTotalOreWeight(Map<ResourceLocation, Integer> weights, int myWeight) {
        return weights.entrySet().stream().filter(e -> JEIBotaniaPlugin.doesOreExist((ResourceLocation)e.getKey())).map(Map.Entry::getValue).reduce(Integer::sum).orElse(myWeight * 64 * 64).intValue();
    }

    protected abstract Map<ResourceLocation, Integer> getOreWeights();

    public void setRecipe(@Nonnull IRecipeLayout recipeLayout, @Nonnull T recipeWrapper, @Nonnull IIngredients ingredients) {
        IGuiItemStackGroup itemStacks = recipeLayout.getItemStacks();
        itemStacks.init(0, true, 9, 12);
        itemStacks.set(0, (List)ingredients.getInputs(VanillaTypes.ITEM).get(0));
        itemStacks.init(1, true, 39, 12);
        itemStacks.set(1, this.iconStack);
        itemStacks.init(2, true, 68, 12);
        itemStacks.set(2, (List)ingredients.getOutputs(VanillaTypes.ITEM).get(0));
    }

    public void draw(T recipe, MatrixStack ms, double mouseX, double mouseY) {
        RenderSystem.enableAlphaTest();
        RenderSystem.enableBlend();
        this.overlay.draw(ms, 17, 0);
        RenderSystem.disableBlend();
        RenderSystem.disableAlphaTest();
    }
}

