/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.client.render.tile;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import com.mojang.datafixers.util.Pair;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.Blocks;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.Atlases;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.model.IBakedModel;
import net.minecraft.client.renderer.model.ItemCameraTransforms;
import net.minecraft.client.renderer.model.ModelRenderer;
import net.minecraft.client.renderer.tileentity.TileEntityRenderer;
import net.minecraft.client.renderer.tileentity.TileEntityRendererDispatcher;
import net.minecraft.item.BlockItem;
import net.minecraft.item.ItemStack;
import net.minecraft.state.Property;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.util.Direction;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.vector.Vector3f;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;
import vazkii.botania.api.item.TinyPotatoRenderEvent;
import vazkii.botania.client.core.handler.ContributorFancinessHandler;
import vazkii.botania.client.core.handler.MiscellaneousIcons;
import vazkii.botania.client.core.helper.RenderHelper;
import vazkii.botania.client.core.helper.ShaderHelper;
import vazkii.botania.client.core.helper.ShaderWrappedRenderLayer;
import vazkii.botania.client.core.proxy.ClientProxy;
import vazkii.botania.common.block.tile.TileTinyPotato;
import vazkii.botania.common.item.ModItems;
import vazkii.botania.common.item.block.ItemBlockTinyPotato;
import vazkii.botania.common.item.equipment.bauble.ItemFlightTiara;

public class RenderTileTinyPotato
extends TileEntityRenderer<TileTinyPotato> {
    private static final ResourceLocation texture = new ResourceLocation("botania:textures/model/tiny_potato.png");
    private static final ResourceLocation textureGrayscale = new ResourceLocation("botania:textures/model/tiny_potato_gray.png");
    private static final ResourceLocation textureHalloween = new ResourceLocation("botania:textures/model/tiny_potato_halloween.png");
    private final ModelRenderer potatoModel = new ModelRenderer(16, 16, 0, 0);

    public RenderTileTinyPotato(TileEntityRendererDispatcher manager) {
        super(manager);
        this.potatoModel.func_228300_a_(0.0f, 0.0f, 0.0f, 4.0f, 6.0f, 4.0f);
        this.potatoModel.func_78793_a(-2.0f, 18.0f, -2.0f);
        this.potatoModel.func_78787_b(64, 32);
    }

    private static boolean matches(String name, String match) {
        return name.equals(match) || name.startsWith(match + " ");
    }

    private static String removeFromFront(String name, String match) {
        return name.substring(match.length()).trim();
    }

    private static Pair<ShaderHelper.BotaniaShader, String> stripShaderName(String name) {
        if (RenderTileTinyPotato.matches(name, "gaia")) {
            return Pair.of((Object)((Object)ShaderHelper.BotaniaShader.DOPPLEGANGER), (Object)RenderTileTinyPotato.removeFromFront(name, "gaia"));
        }
        if (RenderTileTinyPotato.matches(name, "hot")) {
            return Pair.of((Object)((Object)ShaderHelper.BotaniaShader.HALO), (Object)RenderTileTinyPotato.removeFromFront(name, "hot"));
        }
        if (RenderTileTinyPotato.matches(name, "magic")) {
            return Pair.of((Object)((Object)ShaderHelper.BotaniaShader.ENCHANTER_RUNE), (Object)RenderTileTinyPotato.removeFromFront(name, "magic"));
        }
        if (RenderTileTinyPotato.matches(name, "gold")) {
            return Pair.of((Object)((Object)ShaderHelper.BotaniaShader.GOLD), (Object)RenderTileTinyPotato.removeFromFront(name, "gold"));
        }
        if (RenderTileTinyPotato.matches(name, "snoop")) {
            return Pair.of((Object)((Object)ShaderHelper.BotaniaShader.TERRA_PLATE), (Object)RenderTileTinyPotato.removeFromFront(name, "snoop"));
        }
        return Pair.of(null, (Object)name);
    }

    private static RenderType getRenderLayer(@Nullable ShaderHelper.BotaniaShader shader, String name) {
        RenderType base = "kyle hyde".equals(name) ? RenderType.func_228634_a_((ResourceLocation)textureGrayscale) : (ClientProxy.dootDoot ? RenderType.func_228634_a_((ResourceLocation)textureHalloween) : RenderType.func_228634_a_((ResourceLocation)texture));
        return shader == null || !ShaderHelper.useShaders() ? base : new ShaderWrappedRenderLayer(shader, null, base);
    }

    public void render(@Nonnull TileTinyPotato potato, float partialTicks, MatrixStack ms, IRenderTypeBuffer buffers, int light, int overlay) {
        boolean render;
        ms.func_227860_a_();
        String name = potato.name.getString().toLowerCase().trim();
        Pair<ShaderHelper.BotaniaShader, String> shaderStrippedName = RenderTileTinyPotato.stripShaderName(name);
        ShaderHelper.BotaniaShader shader = (ShaderHelper.BotaniaShader)((Object)shaderStrippedName.getFirst());
        name = (String)shaderStrippedName.getSecond();
        RenderType layer = RenderTileTinyPotato.getRenderLayer(shader, name);
        ms.func_227861_a_(0.5, 1.5, 0.5);
        ms.func_227862_a_(1.0f, -1.0f, -1.0f);
        Direction potatoFacing = (Direction)potato.func_195044_w().func_177229_b((Property)BlockStateProperties.field_208157_J);
        float rotY = 0.0f;
        switch (potatoFacing) {
            default: {
                break;
            }
            case NORTH: {
                rotY = 180.0f;
                break;
            }
            case EAST: {
                rotY = 270.0f;
                break;
            }
            case WEST: {
                rotY = 90.0f;
            }
        }
        ms.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(rotY));
        float jump = potato.jumpTicks;
        if (jump > 0.0f) {
            jump -= partialTicks;
        }
        float up = (float)(-Math.abs(Math.sin((double)(jump / 10.0f) * Math.PI))) * 0.2f;
        float rotZ = (float)Math.sin((double)(jump / 10.0f) * Math.PI) * 2.0f;
        ms.func_227861_a_(0.0, (double)up, 0.0);
        ms.func_227863_a_(Vector3f.field_229183_f_.func_229187_a_(rotZ));
        ms.func_227860_a_();
        float r = 1.0f;
        float g = 1.0f;
        float b = 1.0f;
        switch (name) {
            case "pahimar": {
                ms.func_227862_a_(1.0f, 0.3f, 1.0f);
                ms.func_227861_a_(0.0, 3.5, 0.0);
                break;
            }
            case "dinnerbone": 
            case "grumm": {
                ms.func_227863_a_(Vector3f.field_229183_f_.func_229187_a_(180.0f));
                ms.func_227861_a_(0.0, -2.625, 0.0);
                break;
            }
            case "aureylian": {
                g = 0.5f;
            }
        }
        IVertexBuilder buffer = buffers.getBuffer(layer);
        boolean bl = render = !name.equals("mami") && !name.equals("soaryn") && (!name.equals("eloraam") || jump == 0.0f);
        if (render) {
            this.potatoModel.func_228309_a_(ms, buffer, light, overlay, r, g, b, 1.0f);
        }
        if (name.equals("kingdaddydmac")) {
            ms.func_227861_a_(0.5, 0.0, 0.0);
            this.potatoModel.func_228309_a_(ms, buffer, light, overlay, r, g, b, 1.0f);
        }
        ms.func_227865_b_();
        this.renderItems(potato, potatoFacing, name, partialTicks, ms, buffers, light, overlay);
        ms.func_227860_a_();
        MinecraftForge.EVENT_BUS.post((Event)new TinyPotatoRenderEvent(potato, potato.name, partialTicks, ms, buffers, light, overlay));
        ms.func_227865_b_();
        ms.func_227863_a_(Vector3f.field_229183_f_.func_229187_a_(-rotZ));
        ms.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(-rotY));
        ms.func_227862_a_(1.0f, -1.0f, -1.0f);
        this.renderName(potato, name, ms, buffers, light);
        ms.func_227865_b_();
    }

    private void renderName(TileTinyPotato potato, String name, MatrixStack ms, IRenderTypeBuffer buffers, int light) {
        Minecraft mc = Minecraft.func_71410_x();
        RayTraceResult pos = mc.field_71476_x;
        if (!name.isEmpty() && pos != null && pos.func_216346_c() == RayTraceResult.Type.BLOCK && potato.func_174877_v().equals((Object)((BlockRayTraceResult)pos).func_216350_a())) {
            ms.func_227860_a_();
            ms.func_227861_a_(0.0, (double)-0.6f, 0.0);
            ms.func_227863_a_(mc.func_175598_ae().func_229098_b_());
            float f1 = 0.02666667f;
            ms.func_227862_a_(-f1, -f1, f1);
            ms.func_227861_a_(0.0, (double)(0.0f / f1), 0.0);
            int halfWidth = mc.field_71466_p.func_78256_a(potato.name.getString()) / 2;
            float opacity = Minecraft.func_71410_x().field_71474_y.func_216840_a(0.25f);
            int opacityRGB = (int)(opacity * 255.0f) << 24;
            mc.field_71466_p.func_243247_a(potato.name, (float)(-halfWidth), 0.0f, 0x20FFFFFF, false, ms.func_227866_c_().func_227870_a_(), buffers, true, opacityRGB, light);
            mc.field_71466_p.func_243247_a(potato.name, (float)(-halfWidth), 0.0f, -1, false, ms.func_227866_c_().func_227870_a_(), buffers, false, 0, light);
            if (name.equals("pahimar") || name.equals("soaryn")) {
                ms.func_227861_a_(0.0, 14.0, 0.0);
                String str = name.equals("pahimar") ? "[WIP]" : "(soon)";
                halfWidth = mc.field_71466_p.func_78256_a(str) / 2;
                mc.field_71466_p.func_228079_a_(str, (float)(-halfWidth), 0.0f, 0x20FFFFFF, false, ms.func_227866_c_().func_227870_a_(), buffers, true, opacityRGB, light);
                mc.field_71466_p.func_228079_a_(str, (float)(-halfWidth), 0.0f, -1, false, ms.func_227866_c_().func_227870_a_(), buffers, true, 0, light);
            }
            ms.func_227865_b_();
        }
    }

    private void renderItems(TileTinyPotato potato, Direction facing, String name, float partialTicks, MatrixStack ms, IRenderTypeBuffer buffers, int light, int overlay) {
        ms.func_227860_a_();
        ms.func_227863_a_(Vector3f.field_229183_f_.func_229187_a_(180.0f));
        ms.func_227861_a_(0.0, -1.0, 0.0);
        float s = 0.2857143f;
        ms.func_227862_a_(s, s, s);
        for (int i = 0; i < potato.inventorySize(); ++i) {
            ItemStack stack = potato.getItemHandler().func_70301_a(i);
            if (stack.func_190926_b()) continue;
            ms.func_227860_a_();
            Direction side = Direction.values()[i];
            if (side.func_176740_k() != Direction.Axis.Y) {
                float sideAngle = side.func_185119_l() - facing.func_185119_l();
                side = Direction.func_176733_a((double)sideAngle);
            }
            boolean block = stack.func_77973_b() instanceof BlockItem;
            boolean mySon = stack.func_77973_b() instanceof ItemBlockTinyPotato;
            switch (side) {
                case UP: {
                    if (mySon) {
                        ms.func_227861_a_(0.0, (double)0.6f, 0.5);
                    } else if (block) {
                        ms.func_227861_a_(0.0, (double)0.3f, 0.5);
                    }
                    ms.func_227861_a_(0.0, -0.5, (double)-0.4f);
                    break;
                }
                case DOWN: {
                    ms.func_227861_a_(0.0, (double)-2.3f, (double)-0.88f);
                    if (mySon) {
                        ms.func_227861_a_(0.0, (double)0.65f, (double)0.6f);
                        break;
                    }
                    if (!block) break;
                    ms.func_227861_a_(0.0, 1.0, (double)0.6f);
                    break;
                }
                case NORTH: {
                    ms.func_227861_a_(0.0, (double)-1.9f, (double)0.02f);
                    if (mySon) {
                        ms.func_227861_a_(0.0, 1.0, (double)0.6f);
                        break;
                    }
                    if (!block) break;
                    ms.func_227861_a_(0.0, 1.0, (double)0.6f);
                    break;
                }
                case SOUTH: {
                    ms.func_227861_a_(0.0, (double)-1.6f, (double)-0.89f);
                    if (mySon) {
                        ms.func_227861_a_(0.0, (double)1.4f, 0.5);
                        break;
                    }
                    if (!block) break;
                    ms.func_227861_a_(0.0, 1.0, 0.5);
                    break;
                }
                case EAST: {
                    if (mySon) {
                        ms.func_227861_a_((double)-0.4f, (double)0.65f, 0.0);
                    } else if (block) {
                        ms.func_227861_a_((double)-0.4f, (double)0.8f, 0.0);
                    } else {
                        ms.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(-90.0f));
                    }
                    ms.func_227861_a_((double)-0.3f, (double)-1.9f, (double)0.04f);
                    break;
                }
                case WEST: {
                    if (mySon) {
                        ms.func_227861_a_(1.0, (double)0.65f, 1.0);
                    } else if (block) {
                        ms.func_227861_a_(1.0, (double)0.8f, 1.0);
                    } else {
                        ms.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(-90.0f));
                    }
                    ms.func_227861_a_((double)-0.3f, (double)-1.9f, (double)-0.92f);
                }
            }
            if (mySon) {
                ms.func_227862_a_(1.1f, 1.1f, 1.1f);
            } else if (block) {
                ms.func_227862_a_(0.5f, 0.5f, 0.5f);
            }
            if (block && side == Direction.NORTH) {
                ms.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(180.0f));
            }
            this.renderItem(ms, buffers, light, overlay, stack);
            ms.func_227865_b_();
        }
        ms.func_227865_b_();
        ms.func_227860_a_();
        if (!name.isEmpty()) {
            ContributorFancinessHandler.firstStart();
            float scale = 0.25f;
            ms.func_227861_a_(0.0, 1.0, 0.0);
            ms.func_227862_a_(scale, scale, scale);
            if (name.equals("phi") || name.equals("vazkii")) {
                ms.func_227860_a_();
                ms.func_227861_a_(-0.15, 0.1, 0.4);
                ms.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(90.0f));
                ms.func_227863_a_(new Vector3f(1.0f, 0.0f, 1.0f).func_229187_a_(20.0f));
                this.renderModel(ms, buffers, light, overlay, MiscellaneousIcons.INSTANCE.phiFlowerModel);
                ms.func_227865_b_();
                if (name.equals("vazkii")) {
                    ms.func_227862_a_(1.25f, 1.25f, 1.25f);
                    ms.func_227863_a_(Vector3f.field_229179_b_.func_229187_a_(180.0f));
                    ms.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(-90.0f));
                    ms.func_227861_a_(0.2, -1.25, 0.0);
                    this.renderModel(ms, buffers, light, overlay, MiscellaneousIcons.INSTANCE.nerfBatModel);
                }
            } else if (name.equals("haighyorkie")) {
                ms.func_227862_a_(1.25f, 1.25f, 1.25f);
                ms.func_227863_a_(Vector3f.field_229183_f_.func_229187_a_(180.0f));
                ms.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(-90.0f));
                ms.func_227861_a_(-0.5, (double)-1.2f, (double)-0.075f);
                this.renderModel(ms, buffers, light, overlay, MiscellaneousIcons.INSTANCE.goldfishModel);
            } else if (name.equals("martysgames") || name.equals("marty")) {
                ms.func_227862_a_(0.7f, 0.7f, 0.7f);
                ms.func_227863_a_(Vector3f.field_229183_f_.func_229187_a_(180.0f));
                ms.func_227861_a_((double)-0.3f, (double)-2.7f, (double)-1.2f);
                ms.func_227863_a_(Vector3f.field_229183_f_.func_229187_a_(15.0f));
                this.renderItem(ms, buffers, light, overlay, new ItemStack((IItemProvider)ModItems.infiniteFruit, 1).func_200302_a((ITextComponent)new StringTextComponent("das boot")));
            } else if (name.equals("jibril")) {
                ms.func_227862_a_(1.5f, 1.5f, 1.5f);
                ms.func_227861_a_(0.0, (double)0.8f, 0.0);
                ItemFlightTiara.renderHalo(null, null, ms, buffers, partialTicks);
            } else if (name.equals("kingdaddydmac")) {
                ms.func_227862_a_(0.5f, 0.5f, 0.5f);
                ms.func_227863_a_(Vector3f.field_229183_f_.func_229187_a_(180.0f));
                ms.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(90.0f));
                ms.func_227860_a_();
                ms.func_227861_a_(0.0, -2.5, (double)0.65f);
                ItemStack ring = new ItemStack((IItemProvider)ModItems.manaRing);
                this.renderItem(ms, buffers, light, overlay, ring);
                ms.func_227861_a_(0.0, 0.0, -4.0);
                this.renderItem(ms, buffers, light, overlay, ring);
                ms.func_227865_b_();
                ms.func_227861_a_(1.5, -4.0, -2.5);
                this.renderBlock(ms, buffers, light, overlay, Blocks.field_150414_aQ);
            } else {
                ItemStack icon = ContributorFancinessHandler.getFlower(name);
                if (!icon.func_190926_b()) {
                    ms.func_227863_a_(Vector3f.field_229179_b_.func_229187_a_(180.0f));
                    ms.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(180.0f));
                    ms.func_227861_a_(0.0, -0.75, -0.5);
                    RenderHelper.renderItemModelGold(null, icon, ItemCameraTransforms.TransformType.HEAD, ms, buffers, null, light, overlay);
                }
            }
        }
        ms.func_227865_b_();
    }

    private void renderModel(MatrixStack ms, IRenderTypeBuffer buffers, int light, int overlay, IBakedModel model) {
        Minecraft.func_71410_x().func_175602_ab().func_175019_b().func_228804_a_(ms.func_227866_c_(), buffers.getBuffer(Atlases.func_228785_j_()), null, model, 1.0f, 1.0f, 1.0f, light, overlay);
    }

    private void renderItem(MatrixStack ms, IRenderTypeBuffer buffers, int light, int overlay, ItemStack stack) {
        Minecraft.func_71410_x().func_175599_af().func_229110_a_(stack, ItemCameraTransforms.TransformType.HEAD, light, overlay, ms, buffers);
    }

    private void renderBlock(MatrixStack ms, IRenderTypeBuffer buffers, int light, int overlay, Block block) {
        Minecraft.func_71410_x().func_175602_ab().func_228791_a_(block.func_176223_P(), ms, buffers, light, overlay);
    }
}

