/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.block.subtile.generating;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import net.minecraft.block.Blocks;
import net.minecraft.fluid.Fluid;
import net.minecraft.fluid.FluidState;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.particles.IParticleData;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.ITag;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.biome.Biome;
import vazkii.botania.api.subtile.RadiusDescriptor;
import vazkii.botania.api.subtile.TileEntityGeneratingFlower;
import vazkii.botania.client.fx.WispParticleData;
import vazkii.botania.common.block.ModSubtiles;

public class SubTileHydroangeas
extends TileEntityGeneratingFlower {
    private static final String TAG_BURN_TIME = "burnTime";
    public static final String TAG_COOLDOWN = "cooldown";
    private static final BlockPos[] OFFSETS = new BlockPos[]{new BlockPos(0, 0, 1), new BlockPos(0, 0, -1), new BlockPos(1, 0, 0), new BlockPos(-1, 0, 0), new BlockPos(-1, 0, 1), new BlockPos(-1, 0, -1), new BlockPos(1, 0, 1), new BlockPos(1, 0, -1)};
    int burnTime;
    int cooldown;

    public SubTileHydroangeas() {
        this(ModSubtiles.HYDROANGEAS);
    }

    public SubTileHydroangeas(TileEntityType<?> type) {
        super(type);
    }

    @Override
    public void tickFlower() {
        super.tickFlower();
        if (this.cooldown > 0) {
            --this.cooldown;
            for (int i = 0; i < 3; ++i) {
                WispParticleData data = WispParticleData.wisp((float)Math.random() / 6.0f, 0.1f, 0.1f, 0.1f, 1.0f);
                this.field_145850_b.func_195594_a((IParticleData)data, (double)this.getEffectivePos().func_177958_n() + 0.5 + Math.random() * 0.2 - 0.1, (double)this.getEffectivePos().func_177956_o() + 0.5 + Math.random() * 0.2 - 0.1, (double)this.getEffectivePos().func_177952_p() + 0.5 + Math.random() * 0.2 - 0.1, 0.0, (double)((float)Math.random() / 30.0f), 0.0);
            }
        }
        if (this.burnTime == 0) {
            if (this.getMana() < this.getMaxMana() && !this.func_145831_w().field_72995_K) {
                List<BlockPos> offsets = Arrays.asList(OFFSETS);
                Collections.shuffle(offsets);
                for (BlockPos offset : offsets) {
                    ITag<Fluid> search;
                    BlockPos pos = this.getEffectivePos().func_177971_a((Vector3i)offset);
                    FluidState fstate = this.func_145831_w().func_204610_c(pos);
                    if (!fstate.func_206884_a(search = this.getMaterialToSearchFor()) || !fstate.func_206889_d()) continue;
                    if (search != FluidTags.field_206959_a) {
                        this.func_145831_w().func_175656_a(pos, Blocks.field_150350_a.func_176223_P());
                    } else {
                        int waterAround = 0;
                        for (Direction dir : Direction.values()) {
                            if (!this.func_145831_w().func_204610_c(pos.func_177972_a(dir)).func_206884_a(search)) continue;
                            ++waterAround;
                        }
                        if (waterAround < 2) {
                            this.func_145831_w().func_175656_a(pos, Blocks.field_150350_a.func_176223_P());
                        }
                    }
                    if (this.cooldown == 0) {
                        this.burnTime += this.getBurnTime();
                    } else {
                        this.cooldown = this.getCooldown();
                    }
                    this.sync();
                    this.playSound();
                    break;
                }
            }
        } else {
            if (this.func_145831_w().field_73012_v.nextInt(8) == 0) {
                this.doBurnParticles();
            }
            --this.burnTime;
            if (this.burnTime == 0) {
                this.cooldown = this.getCooldown();
                this.sync();
            }
        }
    }

    public void doBurnParticles() {
        WispParticleData data = WispParticleData.wisp((float)Math.random() / 6.0f, 0.05f, 0.05f, 0.7f, 1.0f);
        this.field_145850_b.func_195594_a((IParticleData)data, (double)this.getEffectivePos().func_177958_n() + 0.55 + Math.random() * 0.2 - 0.1, (double)this.getEffectivePos().func_177956_o() + 0.55 + Math.random() * 0.2 - 0.1, (double)this.getEffectivePos().func_177952_p() + 0.5, 0.0, (double)((float)Math.random() / 60.0f), 0.0);
    }

    public ITag<Fluid> getMaterialToSearchFor() {
        return FluidTags.field_206959_a;
    }

    public void playSound() {
        this.func_145831_w().func_184133_a(null, this.getEffectivePos(), SoundEvents.field_187664_bz, SoundCategory.BLOCKS, 0.01f, 0.5f + (float)Math.random() * 0.5f);
    }

    public int getBurnTime() {
        return 40;
    }

    @Override
    public RadiusDescriptor getRadius() {
        return new RadiusDescriptor.Square(this.getEffectivePos(), 1);
    }

    @Override
    public int getMaxMana() {
        return 150;
    }

    @Override
    public int getColor() {
        return 5451744;
    }

    @Override
    public void writeToPacketNBT(CompoundNBT cmp) {
        super.writeToPacketNBT(cmp);
        cmp.func_74768_a(TAG_BURN_TIME, this.burnTime);
        cmp.func_74768_a(TAG_COOLDOWN, this.cooldown);
    }

    @Override
    public void readFromPacketNBT(CompoundNBT cmp) {
        super.readFromPacketNBT(cmp);
        this.burnTime = cmp.func_74762_e(TAG_BURN_TIME);
        this.cooldown = cmp.func_74762_e(TAG_COOLDOWN);
    }

    @Override
    public boolean canGeneratePassively() {
        return this.burnTime > 0;
    }

    @Override
    public int getDelayBetweenPassiveGeneration() {
        boolean rain = this.func_145831_w().func_226691_t_(this.getEffectivePos()).func_201851_b() == Biome.RainType.RAIN && (this.func_145831_w().func_72896_J() || this.func_145831_w().func_72911_I());
        return rain ? 2 : 3;
    }

    public int getCooldown() {
        return 0;
    }

    @Override
    public boolean isPassiveFlower() {
        return true;
    }
}

