/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.core.command;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import com.mojang.brigadier.tree.CommandNode;
import com.mojang.brigadier.tree.LiteralCommandNode;
import java.util.UUID;
import net.minecraft.command.CommandSource;
import net.minecraft.command.Commands;
import net.minecraft.command.ISuggestionProvider;
import net.minecraft.command.arguments.EntityArgument;
import net.minecraft.command.arguments.UUIDArgument;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.util.Util;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import vazkii.botania.common.world.IslandPos;
import vazkii.botania.common.world.SkyblockChunkGenerator;
import vazkii.botania.common.world.SkyblockSavedData;
import vazkii.botania.common.world.SkyblockWorldEvents;

public class SkyblockCommand {
    private static final SimpleCommandExceptionType NOT_SKYBLOCK_WORLD = new SimpleCommandExceptionType((Message)new TranslationTextComponent("botaniamisc.command.skyblock.world"));
    private static final SimpleCommandExceptionType NO_ISLAND = new SimpleCommandExceptionType((Message)new TranslationTextComponent("botaniamisc.command.skyblock.noisland"));

    public static void register(CommandDispatcher<CommandSource> dispatcher) {
        LiteralArgumentBuilder commandBuilder = (LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.func_197057_a((String)"botania-skyblock").requires(s -> s.func_197034_c(2))).then(Commands.func_197057_a((String)"help").executes(SkyblockCommand::printHelp))).then(Commands.func_197057_a((String)"island").then(Commands.func_197056_a((String)"player", (ArgumentType)EntityArgument.func_197096_c()).executes(SkyblockCommand::createIsland)))).then(Commands.func_197057_a((String)"spawn").executes(SkyblockCommand::teleportToSpawn))).then(((LiteralArgumentBuilder)Commands.func_197057_a((String)"visit").then(Commands.func_197056_a((String)"player", (ArgumentType)EntityArgument.func_197096_c()).executes(ctx -> SkyblockCommand.teleportToIsland((CommandContext<CommandSource>)ctx, (PlayerEntity)EntityArgument.func_197089_d((CommandContext)ctx, (String)"player"))))).then(Commands.func_197056_a((String)"playerUuid", (ArgumentType)UUIDArgument.func_239194_a_()).suggests((ctx, builder) -> ISuggestionProvider.func_197013_a(SkyblockSavedData.get((ServerWorld)((CommandSource)ctx.getSource()).func_197023_e()).skyblocks.values().stream().map(UUID::toString), (SuggestionsBuilder)builder)).executes(ctx -> SkyblockCommand.teleportToIsland((CommandContext<CommandSource>)ctx, UUIDArgument.func_239195_a_((CommandContext)ctx, (String)"playerUuid")))))).then(((LiteralArgumentBuilder)Commands.func_197057_a((String)"regen-island").then(Commands.func_197056_a((String)"player", (ArgumentType)EntityArgument.func_197096_c()).executes(ctx -> SkyblockCommand.rebuildIsland((CommandContext<CommandSource>)ctx, EntityArgument.func_197089_d((CommandContext)ctx, (String)"player"))))).then(Commands.func_197056_a((String)"playerUuid", (ArgumentType)UUIDArgument.func_239194_a_()).suggests((ctx, builder) -> ISuggestionProvider.func_197013_a(SkyblockSavedData.get((ServerWorld)((CommandSource)ctx.getSource()).func_197023_e()).skyblocks.values().stream().map(UUID::toString), (SuggestionsBuilder)builder)).executes(ctx -> SkyblockCommand.rebuildIsland((CommandContext<CommandSource>)ctx, UUIDArgument.func_239195_a_((CommandContext)ctx, (String)"playerUuid")))));
        LiteralCommandNode command = dispatcher.register(commandBuilder);
        dispatcher.register((LiteralArgumentBuilder)Commands.func_197057_a((String)"gardenofglass").redirect((CommandNode)command));
        dispatcher.register((LiteralArgumentBuilder)Commands.func_197057_a((String)"gog").redirect((CommandNode)command));
    }

    private static int printHelp(CommandContext<CommandSource> ctx) {
        for (int i = 0; i < 5; ++i) {
            ((CommandSource)ctx.getSource()).func_197030_a((ITextComponent)new TranslationTextComponent("botaniamisc.command.skyblock.help." + i), false);
        }
        return 1;
    }

    private static int doTeleportToIsland(CommandContext<CommandSource> ctx, UUID owner, ITextComponent feedback) throws CommandSyntaxException {
        ServerWorld world = SkyblockCommand.getSkyblockWorld(ctx);
        IslandPos pos = SkyblockCommand.getIslandForUUID(owner, SkyblockSavedData.get(world));
        ServerPlayerEntity player = ((CommandSource)ctx.getSource()).func_197035_h();
        BlockPos blockPos = pos.getCenter();
        player.func_200619_a(world, (double)blockPos.func_177958_n() + 0.5, (double)blockPos.func_177956_o(), (double)blockPos.func_177952_p() + 0.5, player.field_70177_z, player.field_70125_A);
        ((CommandSource)ctx.getSource()).func_197030_a(feedback, true);
        return 1;
    }

    private static int createIsland(CommandContext<CommandSource> ctx) throws CommandSyntaxException {
        ServerPlayerEntity player = EntityArgument.func_197089_d(ctx, (String)"player");
        SkyblockSavedData data = SkyblockSavedData.get(SkyblockCommand.getSkyblockWorld(ctx));
        UUID uuid = player.func_110124_au();
        if (data.skyblocks.containsValue((Object)uuid)) {
            SkyblockCommand.doTeleportToIsland(ctx, uuid, (ITextComponent)new TranslationTextComponent("botaniamisc.command.skyblock.island.teleported", new Object[]{((CommandSource)ctx.getSource()).func_197019_b()}));
            return 1;
        }
        SkyblockWorldEvents.spawnPlayer((PlayerEntity)player, data.create(uuid));
        ((CommandSource)ctx.getSource()).func_197030_a((ITextComponent)new TranslationTextComponent("botaniamisc.command.skyblock.island.success", new Object[]{player.func_145748_c_()}), true);
        return 1;
    }

    private static int doRebuildIsland(CommandContext<CommandSource> ctx, UUID player, ITextComponent feedback) throws CommandSyntaxException {
        ServerWorld world = SkyblockCommand.getSkyblockWorld(ctx);
        IslandPos pos = SkyblockCommand.getIslandForUUID(player, SkyblockSavedData.get(world));
        SkyblockWorldEvents.createSkyblock((World)world, pos.getCenter());
        ((CommandSource)ctx.getSource()).func_197030_a(feedback, true);
        return 1;
    }

    private static IslandPos getIslandForUUID(UUID player, SkyblockSavedData data) throws CommandSyntaxException {
        IslandPos pos = (IslandPos)data.skyblocks.inverse().get((Object)player);
        if (pos == null) {
            throw NO_ISLAND.create();
        }
        return pos;
    }

    private static ServerWorld getSkyblockWorld(CommandContext<CommandSource> ctx) throws CommandSyntaxException {
        ServerWorld world = ((CommandSource)ctx.getSource()).func_197023_e();
        if (!SkyblockChunkGenerator.isWorldSkyblock((World)world)) {
            throw NOT_SKYBLOCK_WORLD.create();
        }
        return world;
    }

    private static int teleportToIsland(CommandContext<CommandSource> ctx, PlayerEntity owner) throws CommandSyntaxException {
        return SkyblockCommand.doTeleportToIsland(ctx, owner.func_110124_au(), (ITextComponent)new TranslationTextComponent("botaniamisc.command.skyblock.teleport.success", new Object[]{((CommandSource)ctx.getSource()).func_197019_b(), owner.func_200200_C_()}));
    }

    private static int teleportToIsland(CommandContext<CommandSource> ctx, UUID owner) throws CommandSyntaxException {
        return SkyblockCommand.doTeleportToIsland(ctx, owner, (ITextComponent)new TranslationTextComponent("botaniamisc.command.skyblock.teleport.success", new Object[]{((CommandSource)ctx.getSource()).func_197019_b(), owner}));
    }

    private static int teleportToSpawn(CommandContext<CommandSource> ctx) throws CommandSyntaxException {
        return SkyblockCommand.doTeleportToIsland(ctx, Util.field_240973_b_, (ITextComponent)new TranslationTextComponent("botaniamisc.command.skyblock.spawn.success", new Object[]{((CommandSource)ctx.getSource()).func_197019_b()}));
    }

    private static int rebuildIsland(CommandContext<CommandSource> ctx, ServerPlayerEntity owner) throws CommandSyntaxException {
        return SkyblockCommand.doRebuildIsland(ctx, owner.func_110124_au(), (ITextComponent)new TranslationTextComponent("botaniamisc.command.skyblock.regenisland.success", new Object[]{owner.func_145748_c_()}));
    }

    private static int rebuildIsland(CommandContext<CommandSource> ctx, UUID owner) throws CommandSyntaxException {
        return SkyblockCommand.doRebuildIsland(ctx, owner, (ITextComponent)new TranslationTextComponent("botaniamisc.command.skyblock.regenisland.success", new Object[]{owner}));
    }
}

