/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.integration.corporea;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.minecraft.world.World;
import vazkii.botania.api.corporea.ICorporeaNode;
import vazkii.botania.api.corporea.ICorporeaNodeDetector;
import vazkii.botania.api.corporea.ICorporeaSpark;
import vazkii.botania.common.impl.corporea.DummyCorporeaNode;
import vazkii.botania.common.integration.corporea.ForgeCapNodeDetector;
import vazkii.botania.common.integration.corporea.VanillaNodeDetector;

public class CorporeaNodeDetectors {
    private static final List<ICorporeaNodeDetector> API_DETECTORS = Collections.synchronizedList(new ArrayList());
    private static final List<ICorporeaNodeDetector> DETECTORS = new ArrayList<ICorporeaNodeDetector>();

    public static void register(ICorporeaNodeDetector detector) {
        API_DETECTORS.add(detector);
    }

    public static void init() {
        DETECTORS.clear();
        DETECTORS.addAll(API_DETECTORS);
        DETECTORS.add(new ForgeCapNodeDetector());
        DETECTORS.add(new VanillaNodeDetector());
    }

    public static ICorporeaNode findNode(World world, ICorporeaSpark spark) {
        for (ICorporeaNodeDetector detector : DETECTORS) {
            ICorporeaNode node = detector.getNode(world, spark);
            if (node == null) continue;
            return node;
        }
        return new DummyCorporeaNode(world, spark.getAttachPos(), spark);
    }
}

