/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.item;

import java.util.List;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.CommandBlockBlock;
import net.minecraft.client.Minecraft;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUseContext;
import net.minecraft.particles.IParticleData;
import net.minecraft.state.Property;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResult;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.NonNullList;
import net.minecraft.util.Rotation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.GlobalPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import vazkii.botania.api.state.BotaniaStateProps;
import vazkii.botania.api.wand.ICoordBoundItem;
import vazkii.botania.api.wand.ITileBound;
import vazkii.botania.api.wand.IWandBindable;
import vazkii.botania.api.wand.IWandable;
import vazkii.botania.client.fx.SparkleParticleData;
import vazkii.botania.client.fx.WispParticleData;
import vazkii.botania.common.Botania;
import vazkii.botania.common.block.BlockPistonRelay;
import vazkii.botania.common.block.ModBlocks;
import vazkii.botania.common.block.tile.TileEnchanter;
import vazkii.botania.common.core.handler.ConfigHandler;
import vazkii.botania.common.core.handler.ModSounds;
import vazkii.botania.common.core.helper.ItemNBTHelper;
import vazkii.botania.common.core.helper.PlayerHelper;
import vazkii.botania.common.core.helper.Vector3;
import vazkii.botania.common.item.ModItems;
import vazkii.botania.common.lib.ResourceLocationHelper;
import vazkii.botania.common.network.PacketBotaniaEffect;
import vazkii.botania.common.network.PacketHandler;

public class ItemTwigWand
extends Item
implements ICoordBoundItem {
    private static final String TAG_COLOR1 = "color1";
    private static final String TAG_COLOR2 = "color2";
    private static final String TAG_BOUND_TILE_X = "boundTileX";
    private static final String TAG_BOUND_TILE_Y = "boundTileY";
    private static final String TAG_BOUND_TILE_Z = "boundTileZ";
    private static final String TAG_BIND_MODE = "bindMode";
    private static final BlockPos UNBOUND_POS = new BlockPos(0, -1, 0);

    public ItemTwigWand(Item.Properties builder) {
        super(builder);
    }

    private static boolean tryCompleteBinding(BlockPos src, ItemStack stack, ItemUseContext ctx) {
        BlockPos dest = ctx.func_195995_a();
        if (!dest.equals((Object)src)) {
            ItemTwigWand.setBindingAttempt(stack, UNBOUND_POS);
            TileEntity srcTile = ctx.func_195991_k().func_175625_s(src);
            if (srcTile instanceof IWandBindable) {
                if (((IWandBindable)srcTile).bindTo(ctx.func_195999_j(), stack, dest, ctx.func_196000_l())) {
                    ItemTwigWand.doParticleBeamWithOffset(ctx.func_195991_k(), src, dest);
                    ItemTwigWand.setBindingAttempt(stack, UNBOUND_POS);
                }
                return true;
            }
        }
        return false;
    }

    private static boolean tryFormEnchanter(ItemUseContext ctx) {
        BlockPos pos;
        World world = ctx.func_195991_k();
        Direction.Axis axis = TileEnchanter.canEnchanterExist(world, pos = ctx.func_195995_a());
        if (axis != null) {
            if (!world.field_72995_K) {
                world.func_175656_a(pos, (BlockState)ModBlocks.enchanter.func_176223_P().func_206870_a(BotaniaStateProps.ENCHANTER_DIRECTION, (Comparable)axis));
                world.func_184133_a(null, pos, ModSounds.enchanterForm, SoundCategory.BLOCKS, 0.5f, 0.6f);
                PlayerHelper.grantCriterion((ServerPlayerEntity)ctx.func_195999_j(), ResourceLocationHelper.prefix("main/enchanter_make"), "code_triggered");
            } else {
                for (int i = 0; i < 50; ++i) {
                    float red = (float)Math.random();
                    float green = (float)Math.random();
                    float blue = (float)Math.random();
                    double x = (Math.random() - 0.5) * 6.0;
                    double y = (Math.random() - 0.5) * 6.0;
                    double z = (Math.random() - 0.5) * 6.0;
                    float velMul = 0.07f;
                    float motionx = (float)(-x) * velMul;
                    float motiony = (float)(-y) * velMul;
                    float motionz = (float)(-z) * velMul;
                    WispParticleData data = WispParticleData.wisp((float)Math.random() * 0.15f + 0.15f, red, green, blue);
                    world.func_195594_a((IParticleData)data, (double)pos.func_177958_n() + 0.5 + x, (double)pos.func_177956_o() + 0.5 + y, (double)pos.func_177952_p() + 0.5 + z, (double)motionx, (double)motiony, (double)motionz);
                }
            }
            return true;
        }
        return false;
    }

    private static boolean tryCompletePistonRelayBinding(ItemUseContext ctx) {
        World world = ctx.func_195991_k();
        BlockPos pos = ctx.func_195995_a();
        PlayerEntity player = ctx.func_195999_j();
        GlobalPos bindPos = ((BlockPistonRelay)ModBlocks.pistonRelay).activeBindingAttempts.get(player.func_110124_au());
        if (bindPos != null && bindPos.func_239646_a_() == world.func_234923_W_()) {
            ((BlockPistonRelay)ModBlocks.pistonRelay).activeBindingAttempts.remove(player.func_110124_au());
            BlockPistonRelay.WorldData data = BlockPistonRelay.WorldData.get(world);
            data.mapping.put(bindPos.func_218180_b(), pos.func_185334_h());
            data.func_76185_a();
            PacketHandler.sendToNearby(world, pos, (Object)new PacketBotaniaEffect(PacketBotaniaEffect.EffectType.PARTICLE_BEAM, (double)bindPos.func_218180_b().func_177958_n() + 0.5, (double)bindPos.func_218180_b().func_177956_o() + 0.5, (double)bindPos.func_218180_b().func_177952_p() + 0.5, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p()));
            world.func_184148_a(null, player.func_226277_ct_(), player.func_226278_cu_(), player.func_226281_cx_(), ModSounds.ding, SoundCategory.PLAYERS, 1.0f, 1.0f);
            return true;
        }
        return false;
    }

    @Nonnull
    public ActionResultType func_195939_a(ItemUseContext ctx) {
        ItemStack stack = ctx.func_195996_i();
        World world = ctx.func_195991_k();
        PlayerEntity player = ctx.func_195999_j();
        BlockPos pos = ctx.func_195995_a();
        BlockState state = world.func_180495_p(pos);
        Block block = state.func_177230_c();
        Direction side = ctx.func_196000_l();
        Optional<BlockPos> boundPos = ItemTwigWand.getBindingAttempt(stack);
        if (player == null) {
            return ActionResultType.PASS;
        }
        if (player.func_225608_bj_()) {
            BlockState newState;
            if (boundPos.isPresent() && ItemTwigWand.tryCompleteBinding(boundPos.get(), stack, ctx)) {
                return ActionResultType.SUCCESS;
            }
            if (player.func_175151_a(pos, side, stack) && (!(block instanceof CommandBlockBlock) || player.func_195070_dx()) && (newState = ItemTwigWand.rotate(state, side.func_176740_k())) != state) {
                world.func_175656_a(pos, newState);
                return ActionResultType.SUCCESS;
            }
        }
        if (block == Blocks.field_150368_y && ((Boolean)ConfigHandler.COMMON.enchanterEnabled.get()).booleanValue() && ItemTwigWand.tryFormEnchanter(ctx)) {
            return ActionResultType.SUCCESS;
        }
        if (block instanceof IWandable) {
            boolean wanded;
            TileEntity tile = world.func_175625_s(pos);
            boolean bindable = tile instanceof IWandBindable;
            if (ItemTwigWand.getBindMode(stack) && bindable && player.func_225608_bj_() && ((IWandBindable)tile).canSelect(player, stack, pos, side)) {
                if (boundPos.isPresent() && boundPos.get().equals((Object)pos)) {
                    ItemTwigWand.setBindingAttempt(stack, UNBOUND_POS);
                } else {
                    ItemTwigWand.setBindingAttempt(stack, pos);
                }
                if (world.field_72995_K) {
                    player.func_184185_a(ModSounds.ding, 0.11f, 1.0f);
                }
                wanded = true;
            } else {
                wanded = ((IWandable)block).onUsedByWand(player, stack, world, pos, side);
            }
            return wanded ? ActionResultType.SUCCESS : ActionResultType.FAIL;
        }
        if (!world.field_72995_K && ItemTwigWand.getBindMode(stack) && ItemTwigWand.tryCompletePistonRelayBinding(ctx)) {
            return ActionResultType.SUCCESS;
        }
        return ActionResultType.PASS;
    }

    private static BlockState rotate(BlockState old, Direction.Axis axis) {
        for (Property prop : old.func_235904_r_()) {
            Direction newDir;
            Property facingProp;
            Direction oldDir;
            if (!prop.func_177701_a().equals("facing") || prop.func_177699_b() != Direction.class || (oldDir = (Direction)old.func_177229_b(facingProp = prop)) == (newDir = ItemTwigWand.rotateAround(oldDir, axis)) || !facingProp.func_177700_c().contains(newDir)) continue;
            return (BlockState)old.func_206870_a(facingProp, (Comparable)newDir);
        }
        return old.func_185907_a(Rotation.CLOCKWISE_90);
    }

    private static Direction rotateAround(Direction old, Direction.Axis axis) {
        switch (axis) {
            case X: {
                switch (old) {
                    case DOWN: {
                        return Direction.SOUTH;
                    }
                    case SOUTH: {
                        return Direction.UP;
                    }
                    case UP: {
                        return Direction.NORTH;
                    }
                    case NORTH: {
                        return Direction.DOWN;
                    }
                }
                break;
            }
            case Y: {
                switch (old) {
                    case NORTH: {
                        return Direction.EAST;
                    }
                    case EAST: {
                        return Direction.SOUTH;
                    }
                    case SOUTH: {
                        return Direction.WEST;
                    }
                    case WEST: {
                        return Direction.NORTH;
                    }
                }
                break;
            }
            case Z: {
                switch (old) {
                    case DOWN: {
                        return Direction.WEST;
                    }
                    case WEST: {
                        return Direction.UP;
                    }
                    case UP: {
                        return Direction.EAST;
                    }
                    case EAST: {
                        return Direction.DOWN;
                    }
                }
            }
        }
        return old;
    }

    public static void doParticleBeamWithOffset(World world, BlockPos orig, BlockPos end) {
        Vector3d origOffset = world.func_180495_p(orig).func_191059_e((IBlockReader)world, orig);
        Vector3 vorig = new Vector3((double)orig.func_177958_n() + origOffset.func_82615_a() + 0.5, (double)orig.func_177956_o() + origOffset.func_82617_b() + 0.5, (double)orig.func_177952_p() + origOffset.func_82616_c() + 0.5);
        Vector3d endOffset = world.func_180495_p(end).func_191059_e((IBlockReader)world, end);
        Vector3 vend = new Vector3((double)end.func_177958_n() + endOffset.func_82615_a() + 0.5, (double)end.func_177956_o() + endOffset.func_82617_b() + 0.5, (double)end.func_177952_p() + endOffset.func_82616_c() + 0.5);
        ItemTwigWand.doParticleBeam(world, vorig, vend);
    }

    public static void doParticleBeam(World world, Vector3 orig, Vector3 end) {
        if (!world.field_72995_K) {
            return;
        }
        Vector3 diff = end.subtract(orig);
        Vector3 movement = diff.normalize().multiply(0.05);
        int iters = (int)(diff.mag() / movement.mag());
        float huePer = 1.0f / (float)iters;
        float hueSum = (float)Math.random();
        Vector3 currentPos = orig;
        for (int i = 0; i < iters; ++i) {
            float hue = (float)i * huePer + hueSum;
            int color = MathHelper.func_181758_c((float)hue, (float)1.0f, (float)1.0f);
            float r = (float)(color >> 16 & 0xFF) / 255.0f;
            float g = (float)(color >> 8 & 0xFF) / 255.0f;
            float b = (float)(color & 0xFF) / 255.0f;
            SparkleParticleData data = SparkleParticleData.noClip(0.5f, r, g, b, 4);
            Botania.proxy.addParticleForceNear(world, data, currentPos.x, currentPos.y, currentPos.z, 0.0, 0.0, 0.0);
            currentPos = currentPos.add(movement);
        }
    }

    public void func_77663_a(ItemStack stack, World world, Entity entity, int slot, boolean selected) {
        ItemTwigWand.getBindingAttempt(stack).ifPresent(coords -> {
            TileEntity tile = world.func_175625_s(coords);
            if (!(tile instanceof IWandBindable)) {
                ItemTwigWand.setBindingAttempt(stack, UNBOUND_POS);
            }
        });
    }

    @Nonnull
    public ActionResult<ItemStack> func_77659_a(World world, PlayerEntity player, @Nonnull Hand hand) {
        ItemStack stack = player.func_184586_b(hand);
        if (player.func_225608_bj_()) {
            if (!world.field_72995_K) {
                ItemTwigWand.setBindMode(stack, !ItemTwigWand.getBindMode(stack));
            } else {
                player.func_184185_a(ModSounds.ding, 0.1f, 1.0f);
            }
        }
        return ActionResult.func_226248_a_((Object)stack);
    }

    public void func_150895_a(@Nonnull ItemGroup group, @Nonnull NonNullList<ItemStack> stacks) {
        if (this.func_194125_a(group)) {
            for (int i = 0; i < 16; ++i) {
                stacks.add((Object)ItemTwigWand.forColors(i, i));
            }
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_77624_a(ItemStack stack, World world, List<ITextComponent> list, ITooltipFlag flags) {
        list.add((ITextComponent)new TranslationTextComponent(ItemTwigWand.getModeString(stack)).func_240699_a_(TextFormatting.GRAY));
    }

    public ITextComponent getHighlightTip(ItemStack stack, ITextComponent displayName) {
        IFormattableTextComponent mode = new StringTextComponent(" (").func_230529_a_((ITextComponent)new TranslationTextComponent(ItemTwigWand.getModeString(stack)).func_240699_a_(TextFormatting.DARK_GREEN)).func_240702_b_(")");
        return displayName.func_230532_e_().func_230529_a_((ITextComponent)mode);
    }

    public static ItemStack forColors(int color1, int color2) {
        ItemStack stack = new ItemStack((IItemProvider)ModItems.twigWand);
        ItemNBTHelper.setInt(stack, TAG_COLOR1, color1);
        ItemNBTHelper.setInt(stack, TAG_COLOR2, color2);
        return stack;
    }

    public static int getColor1(ItemStack stack) {
        return ItemNBTHelper.getInt(stack, TAG_COLOR1, 0);
    }

    public static int getColor2(ItemStack stack) {
        return ItemNBTHelper.getInt(stack, TAG_COLOR2, 0);
    }

    public static void setBindingAttempt(ItemStack stack, BlockPos pos) {
        ItemNBTHelper.setInt(stack, TAG_BOUND_TILE_X, pos.func_177958_n());
        ItemNBTHelper.setInt(stack, TAG_BOUND_TILE_Y, pos.func_177956_o());
        ItemNBTHelper.setInt(stack, TAG_BOUND_TILE_Z, pos.func_177952_p());
    }

    public static Optional<BlockPos> getBindingAttempt(ItemStack stack) {
        int x = ItemNBTHelper.getInt(stack, TAG_BOUND_TILE_X, 0);
        int y = ItemNBTHelper.getInt(stack, TAG_BOUND_TILE_Y, -1);
        int z = ItemNBTHelper.getInt(stack, TAG_BOUND_TILE_Z, 0);
        return y < 0 ? Optional.empty() : Optional.of(new BlockPos(x, y, z));
    }

    public static boolean getBindMode(ItemStack stack) {
        return ItemNBTHelper.getBoolean(stack, TAG_BIND_MODE, true);
    }

    public static void setBindMode(ItemStack stack, boolean bindMode) {
        ItemNBTHelper.setBoolean(stack, TAG_BIND_MODE, bindMode);
    }

    public static String getModeString(ItemStack stack) {
        return "botaniamisc.wandMode." + (ItemTwigWand.getBindMode(stack) ? "bind" : "function");
    }

    @Override
    @Nullable
    public BlockPos getBinding(World world, ItemStack stack) {
        TileEntity tile;
        Optional<BlockPos> bound = ItemTwigWand.getBindingAttempt(stack);
        if (bound.isPresent()) {
            return bound.get();
        }
        RayTraceResult pos = Minecraft.func_71410_x().field_71476_x;
        if (pos != null && pos.func_216346_c() == RayTraceResult.Type.BLOCK && (tile = world.func_175625_s(((BlockRayTraceResult)pos).func_216350_a())) instanceof ITileBound) {
            return ((ITileBound)tile).getBinding();
        }
        return null;
    }
}

