/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.item.equipment.bauble;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.Atlases;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.entity.model.BipedModel;
import net.minecraft.client.renderer.model.IBakedModel;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import vazkii.botania.api.BotaniaAPI;
import vazkii.botania.api.brew.Brew;
import vazkii.botania.api.brew.IBrewContainer;
import vazkii.botania.api.brew.IBrewItem;
import vazkii.botania.api.mana.IManaUsingItem;
import vazkii.botania.api.mana.ManaItemHandler;
import vazkii.botania.client.core.handler.MiscellaneousIcons;
import vazkii.botania.common.brew.ModBrews;
import vazkii.botania.common.core.helper.ItemNBTHelper;
import vazkii.botania.common.item.equipment.bauble.ItemBauble;

public class ItemBloodPendant
extends ItemBauble
implements IBrewContainer,
IBrewItem,
IManaUsingItem {
    private static final String TAG_BREW_KEY = "brewKey";

    public ItemBloodPendant(Item.Properties props) {
        super(props);
    }

    public void func_150895_a(ItemGroup tab, NonNullList<ItemStack> list) {
        super.func_150895_a(tab, list);
        if (this.func_194125_a(tab)) {
            for (Brew brew : BotaniaAPI.instance().getBrewRegistry()) {
                ItemStack brewStack = this.getItemForBrew(brew, new ItemStack((IItemProvider)this));
                if (brewStack.func_190926_b()) continue;
                list.add((Object)brewStack);
            }
        }
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void addHiddenTooltip(ItemStack stack, World world, List<ITextComponent> tooltip, ITooltipFlag adv) {
        super.addHiddenTooltip(stack, world, tooltip, adv);
        Brew brew = this.getBrew(stack);
        if (brew == ModBrews.fallbackBrew) {
            tooltip.add((ITextComponent)new TranslationTextComponent("botaniamisc.notInfused").func_240699_a_(TextFormatting.LIGHT_PURPLE));
            return;
        }
        tooltip.add((ITextComponent)new TranslationTextComponent("botaniamisc.brewOf", new Object[]{I18n.func_135052_a((String)brew.getTranslationKey(stack), (Object[])new Object[0])}).func_240699_a_(TextFormatting.LIGHT_PURPLE));
        for (EffectInstance effect : brew.getPotionEffects(stack)) {
            TextFormatting format = effect.func_188419_a().func_220303_e().func_220306_a();
            TranslationTextComponent cmp = new TranslationTextComponent(effect.func_76453_d());
            if (effect.func_76458_c() > 0) {
                cmp.func_240702_b_(" ");
                cmp.func_230529_a_((ITextComponent)new TranslationTextComponent("botania.roman" + (effect.func_76458_c() + 1)));
            }
            tooltip.add((ITextComponent)cmp.func_240699_a_(format));
        }
    }

    @Override
    public void onWornTick(ItemStack stack, LivingEntity player) {
        Brew brew = ((IBrewItem)stack.func_77973_b()).getBrew(stack);
        if (brew != ModBrews.fallbackBrew && player instanceof PlayerEntity && !player.field_70170_p.field_72995_K) {
            boolean doRand;
            PlayerEntity eplayer = (PlayerEntity)player;
            EffectInstance effect = brew.getPotionEffects(stack).get(0);
            float cost = (float)brew.getManaCost(stack) / (float)effect.func_76459_b() / (float)(1 + effect.func_76458_c()) * 2.5f;
            boolean bl = doRand = cost < 1.0f;
            if (ManaItemHandler.instance().requestManaExact(stack, eplayer, (int)Math.ceil(cost), false)) {
                boolean nightVision;
                EffectInstance currentEffect = player.func_70660_b(effect.func_188419_a());
                boolean bl2 = nightVision = effect.func_188419_a() == Effects.field_76439_r;
                if (currentEffect == null || currentEffect.func_76459_b() < (nightVision ? 305 : 3)) {
                    EffectInstance applyEffect = new EffectInstance(effect.func_188419_a(), nightVision ? 385 : 80, effect.func_76458_c(), true, true);
                    player.func_195064_c(applyEffect);
                }
                if (!doRand || Math.random() < (double)cost) {
                    ManaItemHandler.instance().requestManaExact(stack, eplayer, (int)Math.ceil(cost), true);
                }
            }
        }
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void doRender(BipedModel<?> bipedModel, ItemStack stack, LivingEntity player, MatrixStack ms, IRenderTypeBuffer buffers, int light, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch) {
        boolean armor = !player.func_184582_a(EquipmentSlotType.CHEST).func_190926_b();
        bipedModel.field_78115_e.func_228307_a_(ms);
        ms.func_227861_a_(-0.25, 0.4, armor ? 0.05 : 0.12);
        ms.func_227862_a_(0.5f, -0.5f, -0.5f);
        IBakedModel model = MiscellaneousIcons.INSTANCE.bloodPendantChain;
        IVertexBuilder buffer = buffers.getBuffer(Atlases.func_228783_h_());
        Minecraft.func_71410_x().func_175602_ab().func_175019_b().func_228804_a_(ms.func_227866_c_(), buffer, null, model, 1.0f, 1.0f, 1.0f, light, OverlayTexture.field_229196_a_);
        model = MiscellaneousIcons.INSTANCE.bloodPendantGem;
        int color = Minecraft.func_71410_x().getItemColors().func_186728_a(stack, 1);
        float r = (float)(color >> 16 & 0xFF) / 255.0f;
        float g = (float)(color >> 8 & 0xFF) / 255.0f;
        float b = (float)(color & 0xFF) / 255.0f;
        Minecraft.func_71410_x().func_175602_ab().func_175019_b().func_228804_a_(ms.func_227866_c_(), buffer, null, model, r, g, b, 0xF000F0, OverlayTexture.field_229196_a_);
    }

    @Override
    public Brew getBrew(ItemStack stack) {
        String key = ItemNBTHelper.getString(stack, TAG_BREW_KEY, "");
        return (Brew)((Object)BotaniaAPI.instance().getBrewRegistry().func_82594_a(ResourceLocation.func_208304_a((String)key)));
    }

    public static void setBrew(ItemStack stack, Brew brew) {
        ItemBloodPendant.setBrew(stack, BotaniaAPI.instance().getBrewRegistry().func_177774_c((Object)brew));
    }

    public static void setBrew(ItemStack stack, ResourceLocation brew) {
        ItemNBTHelper.setString(stack, TAG_BREW_KEY, brew.toString());
    }

    @Override
    public ItemStack getItemForBrew(Brew brew, ItemStack stack) {
        if (!brew.canInfuseBloodPendant() || brew.getPotionEffects(stack).size() != 1 || brew.getPotionEffects(stack).get(0).func_188419_a().func_76403_b()) {
            return ItemStack.field_190927_a;
        }
        ItemStack brewStack = new ItemStack((IItemProvider)this);
        ItemBloodPendant.setBrew(brewStack, brew);
        return brewStack;
    }

    @Override
    public int getManaCost(Brew brew, ItemStack stack) {
        return brew.getManaCost() * 10;
    }

    @Override
    public boolean usesMana(ItemStack stack) {
        return this.getBrew(stack) != ModBrews.fallbackBrew;
    }
}

