/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.item.rod;

import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUseContext;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.registry.Registry;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import vazkii.botania.api.BotaniaAPI;
import vazkii.botania.api.item.IBlockProvider;
import vazkii.botania.api.item.IManaProficiencyArmor;
import vazkii.botania.api.item.IWireframeCoordinateListProvider;
import vazkii.botania.api.mana.IManaUsingItem;
import vazkii.botania.api.mana.ManaItemHandler;
import vazkii.botania.client.core.handler.ItemsRemainingRenderHandler;
import vazkii.botania.common.block.BlockPlatform;
import vazkii.botania.common.core.helper.ItemNBTHelper;

public class ItemExchangeRod
extends Item
implements IManaUsingItem,
IWireframeCoordinateListProvider {
    private static final int RANGE = 3;
    private static final int COST = 40;
    private static final String TAG_BLOCK_NAME = "blockName";
    private static final String TAG_TARGET_BLOCK_NAME = "targetBlock";
    private static final String TAG_SWAPPING = "swapping";
    private static final String TAG_SELECT_X = "selectX";
    private static final String TAG_SELECT_Y = "selectY";
    private static final String TAG_SELECT_Z = "selectZ";
    private static final String TAG_EXTRA_RANGE = "extraRange";

    public ItemExchangeRod(Item.Properties props) {
        super(props);
        MinecraftForge.EVENT_BUS.addListener(this::onLeftClick);
    }

    @Nonnull
    public ActionResultType func_195939_a(ItemUseContext ctx) {
        BlockState state;
        List<BlockPos> swap;
        World world = ctx.func_195991_k();
        BlockPos pos = ctx.func_195995_a();
        PlayerEntity player = ctx.func_195999_j();
        ItemStack stack = ctx.func_195996_i();
        BlockState wstate = world.func_180495_p(pos);
        if (player != null && player.func_225608_bj_()) {
            TileEntity tile = world.func_175625_s(pos);
            if (tile == null && BlockPlatform.isValidBlock(wstate, world, pos)) {
                this.setBlock(stack, wstate);
                this.displayRemainderCounter(player, stack);
                return ActionResultType.SUCCESS;
            }
        } else if (this.canExchange(stack) && !ItemNBTHelper.getBoolean(stack, TAG_SWAPPING, false) && (swap = this.getTargetPositions(world, stack, state = ItemExchangeRod.getState(stack), pos, wstate.func_177230_c())).size() > 0) {
            ItemNBTHelper.setBoolean(stack, TAG_SWAPPING, true);
            ItemNBTHelper.setInt(stack, TAG_SELECT_X, pos.func_177958_n());
            ItemNBTHelper.setInt(stack, TAG_SELECT_Y, pos.func_177956_o());
            ItemNBTHelper.setInt(stack, TAG_SELECT_Z, pos.func_177952_p());
            this.setTarget(stack, wstate.func_177230_c());
        }
        return ActionResultType.SUCCESS;
    }

    private void onLeftClick(PlayerInteractEvent.LeftClickBlock event) {
        ItemStack stack = event.getItemStack();
        if (!stack.func_190926_b() && stack.func_77973_b() == this && this.canExchange(stack) && ManaItemHandler.instance().requestManaExactForTool(stack, event.getPlayer(), 40, false) && this.exchange(event.getWorld(), event.getPlayer(), event.getPos(), stack, ItemExchangeRod.getState(stack))) {
            ManaItemHandler.instance().requestManaExactForTool(stack, event.getPlayer(), 40, true);
        }
    }

    public void func_77663_a(ItemStack stack, World world, Entity entity, int slot, boolean equipped) {
        int extraRangeNew;
        if (!this.canExchange(stack) || !(entity instanceof PlayerEntity)) {
            return;
        }
        PlayerEntity player = (PlayerEntity)entity;
        int extraRange = ItemNBTHelper.getInt(stack, TAG_EXTRA_RANGE, 1);
        int n = extraRangeNew = IManaProficiencyArmor.hasProficiency(player, stack) ? 3 : 1;
        if (extraRange != extraRangeNew) {
            ItemNBTHelper.setInt(stack, TAG_EXTRA_RANGE, extraRangeNew);
        }
        BlockState state = ItemExchangeRod.getState(stack);
        if (ItemNBTHelper.getBoolean(stack, TAG_SWAPPING, false)) {
            Block target;
            int z;
            int y;
            if (!ManaItemHandler.instance().requestManaExactForTool(stack, player, 40, false)) {
                ItemNBTHelper.setBoolean(stack, TAG_SWAPPING, false);
                return;
            }
            int x = ItemNBTHelper.getInt(stack, TAG_SELECT_X, 0);
            List<BlockPos> swap = this.getTargetPositions(world, stack, state, new BlockPos(x, y = ItemNBTHelper.getInt(stack, TAG_SELECT_Y, 0), z = ItemNBTHelper.getInt(stack, TAG_SELECT_Z, 0)), target = ItemExchangeRod.getTargetState(stack));
            if (swap.size() == 0) {
                ItemNBTHelper.setBoolean(stack, TAG_SWAPPING, false);
                return;
            }
            BlockPos coords = swap.get(world.field_73012_v.nextInt(swap.size()));
            boolean exchange = this.exchange(world, player, coords, stack, state);
            if (exchange) {
                ManaItemHandler.instance().requestManaExactForTool(stack, player, 40, true);
            } else {
                ItemNBTHelper.setBoolean(stack, TAG_SWAPPING, false);
            }
        }
    }

    public List<BlockPos> getTargetPositions(World world, ItemStack stack, BlockState toPlace, BlockPos pos, Block toReplace) {
        ArrayList<BlockPos> coordsList = new ArrayList<BlockPos>();
        int effRange = 3 + ItemNBTHelper.getInt(stack, TAG_EXTRA_RANGE, 1) - 1;
        for (int offsetX = -effRange; offsetX <= effRange; ++offsetX) {
            for (int offsetY = -effRange; offsetY <= effRange; ++offsetY) {
                block2: for (int offsetZ = -effRange; offsetZ <= effRange; ++offsetZ) {
                    BlockPos pos_ = pos.func_177982_a(offsetX, offsetY, offsetZ);
                    BlockState currentState = world.func_180495_p(pos_);
                    if (currentState.func_177230_c() != toReplace || currentState == toPlace) continue;
                    for (Direction dir : Direction.values()) {
                        BlockPos adjPos = pos_.func_177972_a(dir);
                        BlockState adjState = world.func_180495_p(adjPos);
                        if (Block.func_208061_a((VoxelShape)adjState.func_196951_e((IBlockReader)world, pos), (Direction)dir.func_176734_d())) continue;
                        coordsList.add(pos_);
                        continue block2;
                    }
                }
            }
        }
        return coordsList;
    }

    public boolean exchange(World world, PlayerEntity player, BlockPos pos, ItemStack stack, BlockState state) {
        BlockState stateAt;
        Block blockAt;
        TileEntity tile = world.func_175625_s(pos);
        if (tile != null) {
            return false;
        }
        ItemStack placeStack = ItemExchangeRod.removeFromInventory(player, stack, state.func_177230_c(), false);
        if (!placeStack.func_190926_b() && !(blockAt = (stateAt = world.func_180495_p(pos)).func_177230_c()).isAir(world.func_180495_p(pos), (IBlockReader)world, pos) && stateAt.func_185903_a(player, (IBlockReader)world, pos) > 0.0f && stateAt != state) {
            if (!world.field_72995_K) {
                world.func_175655_b(pos, !player.field_71075_bZ.field_75098_d);
                if (!player.field_71075_bZ.field_75098_d) {
                    ItemExchangeRod.removeFromInventory(player, stack, state.func_177230_c(), true);
                }
                world.func_175656_a(pos, state);
                state.func_177230_c().func_180633_a(world, pos, state, (LivingEntity)player, placeStack);
            }
            this.displayRemainderCounter(player, stack);
            return true;
        }
        return false;
    }

    public boolean canExchange(ItemStack stack) {
        return !ItemExchangeRod.getState(stack).func_196958_f();
    }

    public static ItemStack removeFromInventory(PlayerEntity player, IInventory inv, ItemStack stack, Block block, boolean doit) {
        ArrayList<ItemStack> providers = new ArrayList<ItemStack>();
        for (int i = inv.func_70302_i_() - 1; i >= 0; --i) {
            ItemStack invStack = inv.func_70301_a(i);
            if (invStack.func_190926_b()) continue;
            Item item = invStack.func_77973_b();
            if (item == block.func_199767_j()) {
                ItemStack ret;
                if (doit) {
                    ret = inv.func_70298_a(i, 1);
                } else {
                    ret = invStack.func_77946_l();
                    ret.func_190920_e(1);
                }
                return ret;
            }
            if (!(item instanceof IBlockProvider)) continue;
            providers.add(invStack);
        }
        for (ItemStack provStack : providers) {
            IBlockProvider prov = (IBlockProvider)provStack.func_77973_b();
            if (!prov.provideBlock(player, stack, provStack, block, doit)) continue;
            return new ItemStack((IItemProvider)block);
        }
        return ItemStack.field_190927_a;
    }

    public static ItemStack removeFromInventory(PlayerEntity player, ItemStack stack, Block block, boolean doit) {
        if (player.field_71075_bZ.field_75098_d) {
            return new ItemStack((IItemProvider)block);
        }
        ItemStack outStack = ItemExchangeRod.removeFromInventory(player, BotaniaAPI.instance().getAccessoriesInventory(player), stack, block, doit);
        if (outStack.func_190926_b()) {
            outStack = ItemExchangeRod.removeFromInventory(player, (IInventory)player.field_71071_by, stack, block, doit);
        }
        return outStack;
    }

    public static int getInventoryItemCount(PlayerEntity player, ItemStack stack, Block block) {
        if (player.field_71075_bZ.field_75098_d) {
            return -1;
        }
        int baubleCount = ItemExchangeRod.getInventoryItemCount(player, BotaniaAPI.instance().getAccessoriesInventory(player), stack, block);
        if (baubleCount == -1) {
            return -1;
        }
        int count = ItemExchangeRod.getInventoryItemCount(player, (IInventory)player.field_71071_by, stack, block);
        if (count == -1) {
            return -1;
        }
        return count + baubleCount;
    }

    public static int getInventoryItemCount(PlayerEntity player, IInventory inv, ItemStack stack, Block block) {
        if (player.field_71075_bZ.field_75098_d) {
            return -1;
        }
        int count = 0;
        for (int i = 0; i < inv.func_70302_i_(); ++i) {
            ItemStack invStack = inv.func_70301_a(i);
            if (invStack.func_190926_b()) continue;
            Item item = invStack.func_77973_b();
            if (item == block.func_199767_j()) {
                count += invStack.func_190916_E();
            }
            if (!(item instanceof IBlockProvider)) continue;
            IBlockProvider prov = (IBlockProvider)item;
            int provCount = prov.getBlockCount(player, stack, invStack, block);
            if (provCount == -1) {
                return -1;
            }
            count += provCount;
        }
        return count;
    }

    public void displayRemainderCounter(PlayerEntity player, ItemStack stack) {
        Block block = ItemExchangeRod.getState(stack).func_177230_c();
        int count = ItemExchangeRod.getInventoryItemCount(player, stack, block);
        if (!player.field_70170_p.field_72995_K) {
            ItemsRemainingRenderHandler.send(player, new ItemStack((IItemProvider)block), count);
        }
    }

    @Override
    public boolean usesMana(ItemStack stack) {
        return true;
    }

    private void setBlock(ItemStack stack, BlockState state) {
        ItemNBTHelper.setCompound(stack, TAG_BLOCK_NAME, NBTUtil.func_190009_a((BlockState)state));
    }

    @Nonnull
    public ITextComponent func_200295_i(@Nonnull ItemStack stack) {
        BlockState state = ItemExchangeRod.getState(stack);
        IFormattableTextComponent cmp = super.func_200295_i(stack).func_230532_e_();
        if (!state.func_196958_f()) {
            cmp.func_240702_b_(" (");
            ITextComponent sub = new ItemStack((IItemProvider)state.func_177230_c()).func_200301_q();
            cmp.func_230529_a_((ITextComponent)sub.func_230532_e_().func_240699_a_(TextFormatting.GREEN));
            cmp.func_240702_b_(")");
        }
        return cmp;
    }

    public static BlockState getState(ItemStack stack) {
        return NBTUtil.func_190008_d((CompoundNBT)ItemNBTHelper.getCompound(stack, TAG_BLOCK_NAME, false));
    }

    private void setTarget(ItemStack stack, Block block) {
        ItemNBTHelper.setString(stack, TAG_TARGET_BLOCK_NAME, Registry.field_212618_g.func_177774_c((Object)block).toString());
    }

    public static Block getTargetState(ItemStack stack) {
        ResourceLocation id = new ResourceLocation(ItemNBTHelper.getString(stack, TAG_TARGET_BLOCK_NAME, "minecraft:air"));
        return (Block)Registry.field_212618_g.func_82594_a(id);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public List<BlockPos> getWireframesToDraw(PlayerEntity player, ItemStack stack) {
        ItemStack holding = player.func_184614_ca();
        if (holding != stack || !this.canExchange(stack)) {
            return ImmutableList.of();
        }
        BlockState state = ItemExchangeRod.getState(stack);
        RayTraceResult pos = Minecraft.func_71410_x().field_71476_x;
        if (pos != null && pos.func_216346_c() == RayTraceResult.Type.BLOCK) {
            BlockPos bPos = ((BlockRayTraceResult)pos).func_216350_a();
            Block target = Minecraft.func_71410_x().field_71441_e.func_180495_p(bPos).func_177230_c();
            if (ItemNBTHelper.getBoolean(stack, TAG_SWAPPING, false)) {
                bPos = new BlockPos(ItemNBTHelper.getInt(stack, TAG_SELECT_X, 0), ItemNBTHelper.getInt(stack, TAG_SELECT_Y, 0), ItemNBTHelper.getInt(stack, TAG_SELECT_Z, 0));
                target = ItemExchangeRod.getTargetState(stack);
            }
            if (!player.field_70170_p.func_175623_d(bPos)) {
                List<BlockPos> coordsList = this.getTargetPositions(player.field_70170_p, stack, state, bPos, target);
                coordsList.removeIf(arg_0 -> ((BlockPos)bPos).equals(arg_0));
                return coordsList;
            }
        }
        return ImmutableList.of();
    }
}

