/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.data;

import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.block.FenceBlock;
import net.minecraft.block.FenceGateBlock;
import net.minecraft.block.PaneBlock;
import net.minecraft.block.RotatedPillarBlock;
import net.minecraft.block.SlabBlock;
import net.minecraft.block.StairsBlock;
import net.minecraft.block.TallFlowerBlock;
import net.minecraft.block.WallBlock;
import net.minecraft.block.WallHeight;
import net.minecraft.data.DataGenerator;
import net.minecraft.item.DyeColor;
import net.minecraft.state.EnumProperty;
import net.minecraft.state.Property;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.state.properties.DoubleBlockHalf;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.registry.Registry;
import net.minecraftforge.client.model.generators.BlockModelBuilder;
import net.minecraftforge.client.model.generators.BlockStateProvider;
import net.minecraftforge.client.model.generators.ConfiguredModel;
import net.minecraftforge.client.model.generators.ExistingFileHelper;
import net.minecraftforge.client.model.generators.ModelBuilder;
import net.minecraftforge.client.model.generators.ModelFile;
import net.minecraftforge.client.model.generators.MultiPartBlockStateBuilder;
import vazkii.botania.api.state.BotaniaStateProps;
import vazkii.botania.api.state.enums.AlfPortalState;
import vazkii.botania.api.state.enums.CratePattern;
import vazkii.botania.common.Botania;
import vazkii.botania.common.block.BlockAltGrass;
import vazkii.botania.common.block.BlockAltar;
import vazkii.botania.common.block.BlockModDoubleFlower;
import vazkii.botania.common.block.BlockModFlower;
import vazkii.botania.common.block.BlockSpecialFlower;
import vazkii.botania.common.block.ModBlocks;
import vazkii.botania.common.block.ModFluffBlocks;
import vazkii.botania.common.block.decor.BlockBuriedPetals;
import vazkii.botania.common.block.decor.BlockFloatingFlower;
import vazkii.botania.common.block.decor.BlockModMushroom;
import vazkii.botania.common.block.decor.BlockMotifFlower;
import vazkii.botania.common.block.decor.BlockPetalBlock;
import vazkii.botania.common.block.string.BlockRedString;
import vazkii.botania.common.lib.ResourceLocationHelper;

public class BlockstateProvider
extends BlockStateProvider {
    private static final Map<Direction, EnumProperty<WallHeight>> DIRECTION_TO_WALL_SIDE = ImmutableMap.builder().put((Object)Direction.NORTH, (Object)WallBlock.field_235613_c_).put((Object)Direction.EAST, (Object)WallBlock.field_235612_b_).put((Object)Direction.SOUTH, (Object)WallBlock.field_235614_d_).put((Object)Direction.WEST, (Object)WallBlock.field_235615_e_).build();

    public BlockstateProvider(DataGenerator gen, ExistingFileHelper exFileHelper) {
        super(gen, "botania", exFileHelper);
    }

    @Nonnull
    public String func_200397_b() {
        return "Botania Blockstates";
    }

    protected void registerStatesAndModels() {
        Set<Block> remainingBlocks = Registry.field_212618_g.func_201756_e().filter(b -> "botania".equals(Registry.field_212618_g.func_177774_c(b).func_110624_b())).collect(Collectors.toSet());
        remainingBlocks.remove(ModBlocks.ghostRail);
        remainingBlocks.remove(ModBlocks.solidVines);
        this.manualModel(remainingBlocks, ModBlocks.cocoon);
        this.manualModel(remainingBlocks, ModBlocks.corporeaCrystalCube);
        this.manualModel(remainingBlocks, ModBlocks.distributor);
        this.manualModel(remainingBlocks, ModBlocks.prism);
        this.manualModel(remainingBlocks, ModBlocks.runeAltar);
        this.manualModel(remainingBlocks, ModBlocks.spawnerClaw);
        String alfPortalName = Registry.field_212618_g.func_177774_c((Object)ModBlocks.alfPortal).func_110623_a();
        ModelBuilder alfPortalModel = this.models().cubeAll(alfPortalName, ResourceLocationHelper.prefix("block/" + alfPortalName));
        ModelBuilder alfPortalActivatedModel = this.models().cubeAll(alfPortalName + "_activated", ResourceLocationHelper.prefix("block/" + alfPortalName + "_activated"));
        this.getVariantBuilder(ModBlocks.alfPortal).partialState().with(BotaniaStateProps.ALFPORTAL_STATE, (Comparable)((Object)AlfPortalState.OFF)).setModels(new ConfiguredModel[]{new ConfiguredModel((ModelFile)alfPortalModel)});
        this.getVariantBuilder(ModBlocks.alfPortal).partialState().with(BotaniaStateProps.ALFPORTAL_STATE, (Comparable)((Object)AlfPortalState.ON_X)).setModels(new ConfiguredModel[]{new ConfiguredModel((ModelFile)alfPortalActivatedModel)});
        this.getVariantBuilder(ModBlocks.alfPortal).partialState().with(BotaniaStateProps.ALFPORTAL_STATE, (Comparable)((Object)AlfPortalState.ON_Z)).setModels(new ConfiguredModel[]{new ConfiguredModel((ModelFile)alfPortalActivatedModel)});
        remainingBlocks.remove(ModBlocks.alfPortal);
        String bifrostPermName = Registry.field_212618_g.func_177774_c((Object)ModBlocks.bifrostPerm).func_110623_a();
        this.simpleBlock(ModBlocks.bifrostPerm, (ModelFile)this.models().cubeAll(bifrostPermName, ResourceLocationHelper.prefix("block/bifrost")));
        remainingBlocks.remove(ModBlocks.bifrostPerm);
        String cacophoniumName = Registry.field_212618_g.func_177774_c((Object)ModBlocks.cacophonium).func_110623_a();
        this.simpleBlock(ModBlocks.cacophonium, (ModelFile)this.models().cubeTop(cacophoniumName, ResourceLocationHelper.prefix("block/" + cacophoniumName), ResourceLocationHelper.prefix("block/" + cacophoniumName + "_top")));
        remainingBlocks.remove(ModBlocks.cacophonium);
        String craftCrateName = Registry.field_212618_g.func_177774_c((Object)ModBlocks.craftCrate).func_110623_a();
        this.getVariantBuilder(ModBlocks.craftCrate).forAllStates(s -> {
            CratePattern pat = (CratePattern)((Object)((Object)s.func_177229_b(BotaniaStateProps.CRATE_PATTERN)));
            String suffix = pat == CratePattern.NONE ? "" : "_" + pat.func_176610_l().substring("crafty_".length());
            String name = craftCrateName + suffix;
            ModelBuilder model = ((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent(name, ResourceLocationHelper.prefix("block/shapes/crate"))).texture("bottom", ResourceLocationHelper.prefix("block/" + craftCrateName + "_bottom"))).texture("side", ResourceLocationHelper.prefix("block/" + name));
            return new ConfiguredModel[]{new ConfiguredModel((ModelFile)model)};
        });
        remainingBlocks.remove(ModBlocks.craftCrate);
        String elfGlassName = Registry.field_212618_g.func_177774_c((Object)ModBlocks.elfGlass).func_110623_a();
        ConfiguredModel[] elfGlassFiles = (ConfiguredModel[])IntStream.rangeClosed(0, 3).mapToObj(i -> {
            String varName = elfGlassName + "_" + i;
            return (BlockModelBuilder)this.models().cubeAll(varName, ResourceLocationHelper.prefix("block/" + varName));
        }).map(ConfiguredModel::new).toArray(ConfiguredModel[]::new);
        this.getVariantBuilder(ModBlocks.elfGlass).partialState().setModels(elfGlassFiles);
        remainingBlocks.remove(ModBlocks.elfGlass);
        String enchSoilName = Registry.field_212618_g.func_177774_c((Object)ModBlocks.enchantedSoil).func_110623_a();
        this.simpleBlock(ModBlocks.enchantedSoil, (ModelFile)this.models().cubeBottomTop(enchSoilName, ResourceLocationHelper.prefix("block/" + enchSoilName + "_side"), new ResourceLocation("block/dirt"), ResourceLocationHelper.prefix("block/" + enchSoilName + "_top")));
        remainingBlocks.remove(ModBlocks.enchantedSoil);
        String felName = Registry.field_212618_g.func_177774_c((Object)ModBlocks.felPumpkin).func_110623_a();
        this.simpleBlock(ModBlocks.felPumpkin, (ModelFile)this.models().orientable(felName, new ResourceLocation("block/pumpkin_side"), ResourceLocationHelper.prefix("block/" + felName), new ResourceLocation("block/pumpkin_top")));
        remainingBlocks.remove(ModBlocks.felPumpkin);
        String forestEyeName = Registry.field_212618_g.func_177774_c((Object)ModBlocks.forestEye).func_110623_a();
        ModelBuilder forestEyeFile = ((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent(forestEyeName, ResourceLocationHelper.prefix("block/shapes/eightbyeight"))).texture("bottom", ResourceLocationHelper.prefix("block/" + forestEyeName + "_bottom"))).texture("top", ResourceLocationHelper.prefix("block/" + forestEyeName + "_top"))).texture("north", ResourceLocationHelper.prefix("block/" + forestEyeName + "_north"))).texture("south", ResourceLocationHelper.prefix("block/" + forestEyeName + "_south"))).texture("west", ResourceLocationHelper.prefix("block/" + forestEyeName + "_west"))).texture("east", ResourceLocationHelper.prefix("block/" + forestEyeName + "_east"));
        this.simpleBlock(ModBlocks.forestEye, (ModelFile)forestEyeFile);
        remainingBlocks.remove(ModBlocks.forestEye);
        String plateName = Registry.field_212618_g.func_177774_c((Object)ModBlocks.incensePlate).func_110623_a();
        ModelFile.ExistingModelFile plateFile = this.models().getExistingFile(ResourceLocationHelper.prefix("block/" + plateName));
        this.horizontalBlock(ModBlocks.incensePlate, (ModelFile)plateFile, 0);
        remainingBlocks.remove(ModBlocks.incensePlate);
        String lightLauncherName = Registry.field_212618_g.func_177774_c((Object)ModBlocks.lightLauncher).func_110623_a();
        ModelBuilder lightLauncherFile = ((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent(lightLauncherName, ResourceLocationHelper.prefix("block/shapes/four_high_bottom_top"))).texture("bottom", ResourceLocationHelper.prefix("block/" + lightLauncherName + "_end"))).texture("top", ResourceLocationHelper.prefix("block/" + lightLauncherName + "_end"))).texture("side", ResourceLocationHelper.prefix("block/" + lightLauncherName + "_side"));
        this.simpleBlock(ModBlocks.lightLauncher, (ModelFile)lightLauncherFile);
        remainingBlocks.remove(ModBlocks.lightLauncher);
        String openCrateName = Registry.field_212618_g.func_177774_c((Object)ModBlocks.openCrate).func_110623_a();
        ModelBuilder openCrateFile = ((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent(openCrateName, ResourceLocationHelper.prefix("block/shapes/crate"))).texture("side", ResourceLocationHelper.prefix("block/" + openCrateName))).texture("bottom", ResourceLocationHelper.prefix("block/" + openCrateName + "_bottom"));
        this.simpleBlock(ModBlocks.openCrate, (ModelFile)openCrateFile);
        remainingBlocks.remove(ModBlocks.openCrate);
        String sparkChangerName = Registry.field_212618_g.func_177774_c((Object)ModBlocks.sparkChanger).func_110623_a();
        ModelBuilder sparkChangerFile = ((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent(sparkChangerName, ResourceLocationHelper.prefix("block/shapes/three_high_bottom_top"))).texture("bottom", ResourceLocationHelper.prefix("block/" + sparkChangerName + "_bottom"))).texture("top", ResourceLocationHelper.prefix("block/" + sparkChangerName + "_top"))).texture("side", ResourceLocationHelper.prefix("block/" + sparkChangerName + "_side"));
        this.simpleBlock(ModBlocks.sparkChanger, (ModelFile)sparkChangerFile);
        remainingBlocks.remove(ModBlocks.sparkChanger);
        String starfieldName = Registry.field_212618_g.func_177774_c((Object)ModBlocks.starfield).func_110623_a();
        ModelBuilder starfieldFile = ((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent(starfieldName, ResourceLocationHelper.prefix("block/shapes/four_high_bottom_top"))).texture("bottom", ResourceLocationHelper.prefix("block/" + starfieldName + "_bottom"))).texture("top", ResourceLocationHelper.prefix("block/" + starfieldName + "_top"))).texture("side", ResourceLocationHelper.prefix("block/" + starfieldName + "_side"));
        this.simpleBlock(ModBlocks.starfield, (ModelFile)starfieldFile);
        remainingBlocks.remove(ModBlocks.starfield);
        String terraPlateName = Registry.field_212618_g.func_177774_c((Object)ModBlocks.terraPlate).func_110623_a();
        ModelBuilder terraPlateFile = ((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent(terraPlateName, ResourceLocationHelper.prefix("block/shapes/three_high_bottom_top"))).texture("bottom", ResourceLocationHelper.prefix("block/" + terraPlateName + "_bottom"))).texture("top", ResourceLocationHelper.prefix("block/" + terraPlateName + "_top"))).texture("side", ResourceLocationHelper.prefix("block/" + terraPlateName + "_side"));
        this.simpleBlock(ModBlocks.terraPlate, (ModelFile)terraPlateFile);
        remainingBlocks.remove(ModBlocks.terraPlate);
        String tinyPlanetName = Registry.field_212618_g.func_177774_c((Object)ModBlocks.tinyPlanet).func_110623_a();
        ModelBuilder tinyPlanetFile = ((BlockModelBuilder)this.models().withExistingParent(tinyPlanetName, ResourceLocationHelper.prefix("block/shapes/tenbyten_all"))).texture("all", ResourceLocationHelper.prefix("block/" + tinyPlanetName));
        this.simpleBlock(ModBlocks.tinyPlanet, (ModelFile)tinyPlanetFile);
        remainingBlocks.remove(ModBlocks.tinyPlanet);
        String turnTableName = Registry.field_212618_g.func_177774_c((Object)ModBlocks.turntable).func_110623_a();
        this.simpleBlock(ModBlocks.turntable, (ModelFile)this.models().cubeBottomTop(turnTableName, ResourceLocationHelper.prefix("block/" + turnTableName + "_side"), ResourceLocationHelper.prefix("block/" + turnTableName + "_bottom"), ResourceLocationHelper.prefix("block/" + turnTableName + "_top")));
        remainingBlocks.remove(ModBlocks.turntable);
        this.fixedWallBlock((WallBlock)ModFluffBlocks.dreamwoodWall, ResourceLocationHelper.prefix("block/dreamwood"));
        this.fixedWallBlock((WallBlock)ModFluffBlocks.livingrockWall, ResourceLocationHelper.prefix("block/livingrock"));
        this.fixedWallBlock((WallBlock)ModFluffBlocks.livingwoodWall, ResourceLocationHelper.prefix("block/livingwood"));
        remainingBlocks.remove(ModFluffBlocks.dreamwoodWall);
        remainingBlocks.remove(ModFluffBlocks.livingrockWall);
        remainingBlocks.remove(ModFluffBlocks.livingwoodWall);
        this.fenceBlock((FenceBlock)ModFluffBlocks.dreamwoodFence, ResourceLocationHelper.prefix("block/dreamwood_planks"));
        this.fenceGateBlock((FenceGateBlock)ModFluffBlocks.dreamwoodFenceGate, ResourceLocationHelper.prefix("block/dreamwood_planks"));
        this.fenceBlock((FenceBlock)ModFluffBlocks.livingwoodFence, ResourceLocationHelper.prefix("block/livingwood_planks"));
        this.fenceGateBlock((FenceGateBlock)ModFluffBlocks.livingwoodFenceGate, ResourceLocationHelper.prefix("block/livingwood_planks"));
        remainingBlocks.remove(ModFluffBlocks.dreamwoodFence);
        remainingBlocks.remove(ModFluffBlocks.dreamwoodFenceGate);
        remainingBlocks.remove(ModFluffBlocks.livingwoodFence);
        remainingBlocks.remove(ModFluffBlocks.livingwoodFenceGate);
        this.particleOnly(remainingBlocks, ModBlocks.animatedTorch, new ResourceLocation("block/redstone_torch"));
        this.particleOnly(remainingBlocks, ModBlocks.avatar, ResourceLocationHelper.prefix("block/livingwood"));
        this.particleOnly(remainingBlocks, ModBlocks.bellows, ResourceLocationHelper.prefix("block/livingwood"));
        this.particleOnly(remainingBlocks, ModBlocks.brewery, ResourceLocationHelper.prefix("block/livingrock"));
        this.particleOnly(remainingBlocks, ModBlocks.corporeaIndex, ResourceLocationHelper.prefix("block/elementium_block"));
        this.particleOnly(remainingBlocks, ModBlocks.lightRelayDetector, ResourceLocationHelper.prefix("block/detector_light_relay"));
        this.simpleBlock(ModBlocks.fakeAir, (ModelFile)this.models().getBuilder(Registry.field_212618_g.func_177774_c((Object)ModBlocks.fakeAir).func_110623_a()));
        remainingBlocks.remove(ModBlocks.fakeAir);
        this.particleOnly(remainingBlocks, ModBlocks.lightRelayFork, ResourceLocationHelper.prefix("block/fork_light_relay"));
        this.particleOnly(remainingBlocks, ModBlocks.gaiaHead, new ResourceLocation("block/soul_sand"));
        this.particleOnly(remainingBlocks, ModBlocks.gaiaHeadWall, new ResourceLocation("block/soul_sand"));
        this.particleOnly(remainingBlocks, ModBlocks.gaiaPylon, ResourceLocationHelper.prefix("block/elementium_block"));
        this.particleOnly(remainingBlocks, ModBlocks.hourglass, ResourceLocationHelper.prefix("block/mana_glass"));
        this.particleOnly(remainingBlocks, ModBlocks.lightRelayDefault, ResourceLocationHelper.prefix("block/light_relay"));
        this.particleOnly(remainingBlocks, ModBlocks.manaFlame, new ResourceLocation("block/fire_0"));
        this.particleOnly(remainingBlocks, ModBlocks.manaPylon, ResourceLocationHelper.prefix("block/manasteel_block"));
        this.particleOnly(remainingBlocks, ModBlocks.naturaPylon, ResourceLocationHelper.prefix("block/terrasteel_block"));
        this.particleOnly(remainingBlocks, ModBlocks.teruTeruBozu, new ResourceLocation("block/white_wool"));
        this.particleOnly(remainingBlocks, ModBlocks.lightRelayToggle, ResourceLocationHelper.prefix("block/toggle_light_relay"));
        Predicate<Block> flowers = b -> b instanceof BlockSpecialFlower || b instanceof BlockModMushroom || b instanceof BlockModFlower;
        BlockstateProvider.takeAll(remainingBlocks, flowers).forEach(b -> {
            String name = Registry.field_212618_g.func_177774_c(b).func_110623_a();
            ModelBuilder model = ((BlockModelBuilder)this.models().withExistingParent(name, ResourceLocationHelper.prefix("block/shapes/cross"))).texture("cross", ResourceLocationHelper.prefix("block/" + name));
            this.simpleBlock((Block)b, (ModelFile)model);
        });
        BlockstateProvider.takeAll(remainingBlocks, b -> b instanceof BlockMotifFlower).forEach(b -> {
            String name = Registry.field_212618_g.func_177774_c(b).func_110623_a().replace("_motif", "");
            ModelBuilder model = ((BlockModelBuilder)this.models().withExistingParent(name, ResourceLocationHelper.prefix("block/shapes/cross"))).texture("cross", ResourceLocationHelper.prefix("block/" + name));
            this.simpleBlock((Block)b, (ModelFile)model);
        });
        BlockstateProvider.takeAll(remainingBlocks, ModBlocks.corporeaFunnel, ModBlocks.corporeaInterceptor, ModBlocks.corporeaRetainer).forEach(b -> {
            String name = Registry.field_212618_g.func_177774_c(b).func_110623_a();
            this.simpleBlock((Block)b, (ModelFile)this.models().cubeColumn(name, ResourceLocationHelper.prefix("block/" + name + "_side"), ResourceLocationHelper.prefix("block/" + name + "_end")));
        });
        BlockstateProvider.takeAll(remainingBlocks, ModBlocks.gatheringDrum, ModBlocks.canopyDrum, ModBlocks.wildDrum).forEach(b -> {
            String name = Registry.field_212618_g.func_177774_c(b).func_110623_a();
            ModelBuilder model = ((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent(name, ResourceLocationHelper.prefix("block/shapes/drum"))).texture("top", ResourceLocationHelper.prefix("block/drum_top"))).texture("side", ResourceLocationHelper.prefix("block/" + name));
            this.simpleBlock((Block)b, (ModelFile)model);
        });
        BlockstateProvider.takeAll(remainingBlocks, ModBlocks.manaSpreader, ModBlocks.redstoneSpreader, ModBlocks.gaiaSpreader, ModBlocks.elvenSpreader).forEach(b -> {
            String name = Registry.field_212618_g.func_177774_c(b).func_110623_a();
            String material = b == ModBlocks.elvenSpreader ? "dreamwood" : (b == ModBlocks.gaiaSpreader ? name + "_material" : "livingwood");
            ModelBuilder model = ((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent(name, ResourceLocationHelper.prefix("block/shapes/spreader"))).texture("side", ResourceLocationHelper.prefix("block/" + name + "_side"))).texture("material", ResourceLocationHelper.prefix("block/" + material));
            ((BlockModelBuilder)this.models().withExistingParent(name + "_inside", ResourceLocationHelper.prefix("block/shapes/spreader_inside"))).texture("inside", ResourceLocationHelper.prefix("block/" + name + "_inside"));
            this.simpleBlock((Block)b, (ModelFile)model);
        });
        BlockstateProvider.takeAll(remainingBlocks, ModBlocks.manaPool, ModBlocks.dilutedPool, ModBlocks.fabulousPool, ModBlocks.creativePool).forEach(b -> {
            String name = Registry.field_212618_g.func_177774_c(b).func_110623_a();
            ResourceLocation tex = b == ModBlocks.manaPool || b == ModBlocks.fabulousPool ? ResourceLocationHelper.prefix("block/livingrock") : ResourceLocationHelper.prefix("block/" + name);
            ModelBuilder pool = ((BlockModelBuilder)this.models().withExistingParent(name, ResourceLocationHelper.prefix("block/shapes/pool"))).texture("all", tex);
            ((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent(name + "_full", ResourceLocationHelper.prefix("block/shapes/pool_full"))).texture("all", tex)).texture("liquid", ResourceLocationHelper.prefix("block/mana_water"));
            this.simpleBlock((Block)b, (ModelFile)pool);
        });
        BlockstateProvider.takeAll(remainingBlocks, ModBlocks.pump, ModBlocks.tinyPotato).forEach(b -> {
            String name = Registry.field_212618_g.func_177774_c(b).func_110623_a();
            ModelFile.ExistingModelFile file = this.models().getExistingFile(ResourceLocationHelper.prefix("block/" + name));
            this.horizontalBlock((Block)b, (ModelFile)file);
        });
        BlockstateProvider.takeAll(remainingBlocks, ModBlocks.enderEye, ModBlocks.manaDetector).forEach(b -> {
            String name = Registry.field_212618_g.func_177774_c(b).func_110623_a();
            ModelBuilder offFile = this.models().cubeAll(name, ResourceLocationHelper.prefix("block/" + name));
            ModelBuilder onFile = this.models().cubeAll(name + "_powered", ResourceLocationHelper.prefix("block/" + name + "_powered"));
            this.getVariantBuilder((Block)b).partialState().with((Property)BlockStateProperties.field_208194_u, (Comparable)Boolean.valueOf(false)).setModels(new ConfiguredModel[]{new ConfiguredModel((ModelFile)offFile)});
            this.getVariantBuilder((Block)b).partialState().with((Property)BlockStateProperties.field_208194_u, (Comparable)Boolean.valueOf(true)).setModels(new ConfiguredModel[]{new ConfiguredModel((ModelFile)onFile)});
        });
        ModelBuilder petalBlockModel = ((BlockModelBuilder)this.models().withExistingParent("petal_block", ResourceLocationHelper.prefix("block/shapes/cube_all_tinted"))).texture("all", ResourceLocationHelper.prefix("block/petal_block"));
        BlockstateProvider.takeAll(remainingBlocks, b -> b instanceof BlockPetalBlock).forEach(arg_0 -> this.lambda$registerStatesAndModels$15((ModelFile)petalBlockModel, arg_0));
        BlockstateProvider.takeAll(remainingBlocks, b -> b instanceof BlockAltGrass).forEach(b -> {
            String name = Registry.field_212618_g.func_177774_c(b).func_110623_a();
            ResourceLocation side = ResourceLocationHelper.prefix("block/" + name + "_side");
            ResourceLocation top = ResourceLocationHelper.prefix("block/" + name + "_top");
            ModelBuilder model = this.models().cubeBottomTop(name, side, new ResourceLocation("block/dirt"), top);
            this.getVariantBuilder((Block)b).partialState().setModels(new ConfiguredModel[]{new ConfiguredModel((ModelFile)model), new ConfiguredModel((ModelFile)model, 0, 90, false), new ConfiguredModel((ModelFile)model, 0, 180, false), new ConfiguredModel((ModelFile)model, 0, 270, false)});
        });
        BlockstateProvider.takeAll(remainingBlocks, b -> b instanceof BlockRedString).forEach(this::redStringBlock);
        BlockstateProvider.takeAll(remainingBlocks, b -> b instanceof BlockModDoubleFlower).forEach(b -> {
            String name = Registry.field_212618_g.func_177774_c(b).func_110623_a();
            ModelBuilder bottom = this.models().cross(name, ResourceLocationHelper.prefix("block/" + name));
            ModelBuilder top = this.models().cross(name + "_top", ResourceLocationHelper.prefix("block/" + name + "_top"));
            this.getVariantBuilder((Block)b).partialState().with((Property)TallFlowerBlock.field_176492_b, (Comparable)DoubleBlockHalf.LOWER).setModels(new ConfiguredModel[]{new ConfiguredModel((ModelFile)bottom)}).partialState().with((Property)TallFlowerBlock.field_176492_b, (Comparable)DoubleBlockHalf.UPPER).setModels(new ConfiguredModel[]{new ConfiguredModel((ModelFile)top)});
        });
        for (String variant : new String[]{"desert", "forest", "fungal", "mesa", "mountain", "plains", "swamp", "taiga"}) {
            ResourceLocation baseId = ResourceLocationHelper.prefix("metamorphic_" + variant + "_stone");
            Block base = (Block)Registry.field_212618_g.func_241873_b(baseId).get();
            this.simpleBlock(base);
            ResourceLocation cobbleId = ResourceLocationHelper.prefix("metamorphic_" + variant + "_cobblestone");
            Block cobble = (Block)Registry.field_212618_g.func_241873_b(cobbleId).get();
            this.simpleBlock(cobble);
            ResourceLocation cobbleWallId = ResourceLocationHelper.prefix("metamorphic_" + variant + "_cobblestone" + "_wall");
            Block cobbleWall = (Block)Registry.field_212618_g.func_241873_b(cobbleWallId).get();
            this.fixedWallBlock((WallBlock)cobbleWall, ResourceLocationHelper.prefix("block/" + cobbleId.func_110623_a()));
            ResourceLocation brickId = ResourceLocationHelper.prefix("metamorphic_" + variant + "_bricks");
            Block brick = (Block)Registry.field_212618_g.func_241873_b(brickId).get();
            this.simpleBlock(brick);
            ResourceLocation chiseledBricksId = ResourceLocationHelper.prefix("chiseled_metamorphic_" + variant + "_bricks");
            Block chiseledBricks = (Block)Registry.field_212618_g.func_241873_b(chiseledBricksId).get();
            this.simpleBlock(chiseledBricks);
            remainingBlocks.removeAll(Arrays.asList(base, cobble, cobbleWall, brick, chiseledBricks));
        }
        for (String variant : new String[]{"dark", "mana", "blaze", "lavender", "red", "elf", "sunny"}) {
            ResourceLocation quartzId = ResourceLocationHelper.prefix(variant + "_quartz");
            Block quartz = (Block)Registry.field_212618_g.func_241873_b(quartzId).get();
            this.simpleBlock(quartz, (ModelFile)this.models().cubeBottomTop(quartzId.func_110623_a(), ResourceLocationHelper.prefix("block/" + quartzId.func_110623_a() + "_side"), ResourceLocationHelper.prefix("block/" + quartzId.func_110623_a() + "_bottom"), ResourceLocationHelper.prefix("block/" + quartzId.func_110623_a() + "_top")));
            ResourceLocation pillarId = ResourceLocationHelper.prefix(variant + "_quartz_pillar");
            Block pillar = (Block)Registry.field_212618_g.func_241873_b(pillarId).get();
            ModelBuilder pillarModel = this.models().cubeColumn(pillarId.func_110623_a(), ResourceLocationHelper.prefix("block/" + pillarId.func_110623_a() + "_side"), ResourceLocationHelper.prefix("block/" + pillarId.func_110623_a() + "_end"));
            this.getVariantBuilder(pillar).partialState().with((Property)RotatedPillarBlock.field_176298_M, (Comparable)Direction.Axis.X).setModels(new ConfiguredModel[]{new ConfiguredModel((ModelFile)pillarModel, 90, 90, false)}).partialState().with((Property)RotatedPillarBlock.field_176298_M, (Comparable)Direction.Axis.Y).setModels(new ConfiguredModel[]{new ConfiguredModel((ModelFile)pillarModel)}).partialState().with((Property)RotatedPillarBlock.field_176298_M, (Comparable)Direction.Axis.Z).setModels(new ConfiguredModel[]{new ConfiguredModel((ModelFile)pillarModel, 90, 0, false)});
            ResourceLocation chiseledId = ResourceLocationHelper.prefix("chiseled_" + variant + "_quartz");
            Block chiseled = (Block)Registry.field_212618_g.func_241873_b(chiseledId).get();
            this.simpleBlock(chiseled, (ModelFile)this.models().cubeColumn(chiseledId.func_110623_a(), ResourceLocationHelper.prefix("block/" + chiseledId.func_110623_a() + "_side"), ResourceLocationHelper.prefix("block/" + chiseledId.func_110623_a() + "_end")));
            remainingBlocks.remove(quartz);
            remainingBlocks.remove(pillar);
            remainingBlocks.remove(chiseled);
        }
        BlockstateProvider.takeAll(remainingBlocks, b -> b instanceof BlockBuriedPetals).forEach(b -> {
            DyeColor color = ((BlockBuriedPetals)b).color;
            ResourceLocation wool = new ResourceLocation("block/" + color.func_176610_l() + "_wool");
            this.particleOnly(remainingBlocks, (Block)b, wool);
        });
        BlockstateProvider.takeAll(remainingBlocks, b -> b instanceof BlockAltar).forEach(b -> {
            String name = Registry.field_212618_g.func_177774_c(b).func_110623_a();
            ModelBuilder model = ((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent(name, ResourceLocationHelper.prefix("block/shapes/petal_apothecary"))).texture("side", ResourceLocationHelper.prefix("block/" + name + "_side"))).texture("goblet", ResourceLocationHelper.prefix("block/" + name + "_goblet"))).texture("top_bottom", ResourceLocationHelper.prefix("block/" + name + "_top_bottom"));
            this.simpleBlock((Block)b, (ModelFile)model);
        });
        BlockstateProvider.takeAll(remainingBlocks, b -> b instanceof BlockFloatingFlower).forEach(b -> {
            String name = Registry.field_212618_g.func_177774_c(b).func_110623_a();
            this.simpleBlock((Block)b, (ModelFile)new ModelFile.UncheckedModelFile(ResourceLocationHelper.prefix("block/" + name)));
        });
        BlockstateProvider.takeAll(remainingBlocks, b -> b instanceof PaneBlock).forEach(b -> {
            String name = Registry.field_212618_g.func_177774_c(b).func_110623_a();
            ResourceLocation edge = ResourceLocationHelper.prefix("block/" + name);
            ResourceLocation pane = ResourceLocationHelper.prefix("block/" + name.substring(0, name.length() - "_pane".length()));
            this.paneBlock((PaneBlock)b, pane, edge);
        });
        BlockstateProvider.takeAll(remainingBlocks, b -> b instanceof StairsBlock).forEach(b -> {
            String name = Registry.field_212618_g.func_177774_c(b).func_110623_a();
            String baseName = name.substring(0, name.length() - "_stairs".length());
            boolean quartz = name.contains("quartz");
            if (quartz) {
                ResourceLocation side = ResourceLocationHelper.prefix("block/" + baseName + "_side");
                ResourceLocation bottom = ResourceLocationHelper.prefix("block/" + baseName + "_bottom");
                ResourceLocation top = ResourceLocationHelper.prefix("block/" + baseName + "_top");
                this.stairsBlock((StairsBlock)b, side, bottom, top);
            } else {
                this.stairsBlock((StairsBlock)b, ResourceLocationHelper.prefix("block/" + baseName));
            }
        });
        Collection<Block> slabs = BlockstateProvider.takeAll(remainingBlocks, b -> b instanceof SlabBlock);
        remainingBlocks.forEach(arg_0 -> ((BlockstateProvider)this).simpleBlock(arg_0));
        slabs.forEach(b -> {
            String name = Registry.field_212618_g.func_177774_c(b).func_110623_a();
            String baseName = name.substring(0, name.length() - "_slab".length());
            boolean quartz = name.contains("quartz");
            if (quartz) {
                ResourceLocation side = ResourceLocationHelper.prefix("block/" + baseName + "_side");
                ResourceLocation bottom = ResourceLocationHelper.prefix("block/" + baseName + "_bottom");
                ResourceLocation top = ResourceLocationHelper.prefix("block/" + baseName + "_top");
                this.slabBlock((SlabBlock)b, ResourceLocationHelper.prefix(baseName), side, bottom, top);
            } else {
                this.slabBlock((SlabBlock)b, ResourceLocationHelper.prefix(baseName), ResourceLocationHelper.prefix("block/" + baseName));
            }
        });
    }

    private void particleOnly(Set<Block> blocks, Block b, ResourceLocation particle) {
        String name = Registry.field_212618_g.func_177774_c((Object)b).func_110623_a();
        ModelBuilder f = ((BlockModelBuilder)this.models().getBuilder(name)).texture("particle", particle);
        this.simpleBlock(b, (ModelFile)f);
        blocks.remove(b);
    }

    private void manualModel(Set<Block> blocks, Block b) {
        String name = Registry.field_212618_g.func_177774_c((Object)b).func_110623_a();
        this.simpleBlock(b, (ModelFile)this.models().getExistingFile(ResourceLocationHelper.prefix("block/" + name)));
        blocks.remove(b);
    }

    @SafeVarargs
    public static <T> Collection<T> takeAll(Set<? extends T> src, T ... items) {
        List<T> ret = Arrays.asList(items);
        for (T item : items) {
            if (src.contains(item)) continue;
            Botania.LOGGER.warn("Item {} not found in set", item);
        }
        if (!src.removeAll(ret)) {
            Botania.LOGGER.warn("takeAll array didn't yield anything ({})", (Object)Arrays.toString(items));
        }
        return ret;
    }

    public static <T> Collection<T> takeAll(Set<T> src, Predicate<T> pred) {
        ArrayList<T> ret = new ArrayList<T>();
        Iterator<T> iter = src.iterator();
        while (iter.hasNext()) {
            T item = iter.next();
            if (!pred.test(item)) continue;
            iter.remove();
            ret.add(item);
        }
        if (ret.isEmpty()) {
            Botania.LOGGER.warn("takeAll predicate yielded nothing", new Throwable());
        }
        return ret;
    }

    private void fixedWallBlock(WallBlock block, ResourceLocation tex) {
        String name = Registry.field_212618_g.func_177774_c((Object)block).func_110623_a();
        ModelBuilder post = ((BlockModelBuilder)this.models().withExistingParent(name + "_post", "block/template_wall_post")).texture("wall", tex);
        ModelBuilder side = ((BlockModelBuilder)this.models().withExistingParent(name + "_wall_side", "block/template_wall_side")).texture("wall", tex);
        ModelBuilder tallSide = ((BlockModelBuilder)this.models().withExistingParent(name + "_wall_side_tall", "block/template_wall_side_tall")).texture("wall", tex);
        MultiPartBlockStateBuilder builder = ((MultiPartBlockStateBuilder.PartBuilder)this.getMultipartBuilder((Block)block).part().modelFile((ModelFile)post).addModel()).condition((Property)WallBlock.field_176256_a, (Comparable[])new Boolean[]{true}).end();
        DIRECTION_TO_WALL_SIDE.forEach((arg_0, arg_1) -> BlockstateProvider.lambda$fixedWallBlock$33(builder, (ModelFile)side, (ModelFile)tallSide, arg_0, arg_1));
    }

    private void redStringBlock(Block b) {
        String name = Registry.field_212618_g.func_177774_c((Object)b).func_110623_a();
        ResourceLocation selfName = ResourceLocationHelper.prefix("block/" + name);
        ResourceLocation front = ResourceLocationHelper.prefix("block/red_string_sender");
        ModelBuilder file = this.models().orientable(name, selfName, front, selfName);
        this.getVariantBuilder(b).partialState().with((Property)BlockStateProperties.field_208155_H, (Comparable)Direction.NORTH).setModels(new ConfiguredModel[]{new ConfiguredModel((ModelFile)file)}).partialState().with((Property)BlockStateProperties.field_208155_H, (Comparable)Direction.SOUTH).setModels(new ConfiguredModel[]{new ConfiguredModel((ModelFile)file, 0, 180, false)}).partialState().with((Property)BlockStateProperties.field_208155_H, (Comparable)Direction.WEST).setModels(new ConfiguredModel[]{new ConfiguredModel((ModelFile)file, 0, 270, false)}).partialState().with((Property)BlockStateProperties.field_208155_H, (Comparable)Direction.EAST).setModels(new ConfiguredModel[]{new ConfiguredModel((ModelFile)file, 0, 90, false)}).partialState().with((Property)BlockStateProperties.field_208155_H, (Comparable)Direction.DOWN).setModels(new ConfiguredModel[]{new ConfiguredModel((ModelFile)file, 90, 0, false)}).partialState().with((Property)BlockStateProperties.field_208155_H, (Comparable)Direction.UP).setModels(new ConfiguredModel[]{new ConfiguredModel((ModelFile)file, 270, 0, false)});
    }

    private static /* synthetic */ void lambda$fixedWallBlock$33(MultiPartBlockStateBuilder builder, ModelFile side, ModelFile tallSide, Direction dir, EnumProperty value) {
        ((MultiPartBlockStateBuilder.PartBuilder)((MultiPartBlockStateBuilder.PartBuilder)builder.part().modelFile(side).rotationY(((int)dir.func_185119_l() + 180) % 360).uvLock(true).addModel()).condition((Property)value, (Comparable[])new WallHeight[]{WallHeight.LOW}).end().part().modelFile(tallSide).rotationY(((int)dir.func_185119_l() + 180) % 360).uvLock(true).addModel()).condition((Property)value, (Comparable[])new WallHeight[]{WallHeight.TALL});
    }

    private /* synthetic */ void lambda$registerStatesAndModels$15(ModelFile petalBlockModel, Block b) {
        this.simpleBlock(b, petalBlockModel);
    }
}

