/*
 * Decompiled with CFR 0.152.
 */
package com.talhanation.camels;

import com.talhanation.camels.init.ModEntityTypes;
import com.talhanation.camels.init.SoundInit;
import com.talhanation.camels.items.CamelSpawnEggItem;
import com.talhanation.camels.items.ModItems;
import net.minecraft.item.Item;
import net.minecraft.util.IItemProvider;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.ColorHandlerEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.RegistryObject;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.ObfuscationReflectionHelper;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.event.server.FMLServerStartingEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(value="camels")
public class Main {
    private static final Logger LOGGER = LogManager.getLogger();
    public static final String MOD_ID = "camels";

    public Main() {
        IEventBus modEventBus = FMLJavaModLoadingContext.get().getModEventBus();
        modEventBus.addListener(this::setup);
        SoundInit.SOUNDS.register(modEventBus);
        ModItems.ITEMS.register(modEventBus);
        ModEntityTypes.ENTITY_TYPES.register(modEventBus);
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    private void setup(FMLCommonSetupEvent event) {
        ModEntityTypes.addEntitySpawns();
    }

    private void doClientStuff(FMLClientSetupEvent event) {
    }

    @SubscribeEvent
    public void onServerStarting(FMLServerStartingEvent event) {
    }

    @OnlyIn(value=Dist.CLIENT)
    private void registerItemColors(ColorHandlerEvent.Item event) {
        for (RegistryObject<Item> items : ModItems.SPAWN_EGGS) {
            Item item;
            if (ObfuscationReflectionHelper.getPrivateValue(RegistryObject.class, items, (String)"value") == null || !((item = (Item)items.get()) instanceof CamelSpawnEggItem)) continue;
            event.getItemColors().func_199877_a((itemColor, itemsIn) -> ((CamelSpawnEggItem)item).func_195983_a(itemsIn), new IItemProvider[]{item});
        }
    }
}

