/*
 * Decompiled with CFR 0.152.
 */
package com.talhanation.camels.entities;

import com.talhanation.camels.entities.ai.goal.CamelFollowCaravanGoal;
import com.talhanation.camels.init.ModEntityTypes;
import com.talhanation.camels.init.SoundInit;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.CarpetBlock;
import net.minecraft.entity.AgeableEntity;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntitySize;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.ILivingEntityData;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.Pose;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.ai.goal.BreedGoal;
import net.minecraft.entity.ai.goal.FollowParentGoal;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.LookAtGoal;
import net.minecraft.entity.ai.goal.LookRandomlyGoal;
import net.minecraft.entity.ai.goal.PanicGoal;
import net.minecraft.entity.ai.goal.RunAroundLikeCrazyGoal;
import net.minecraft.entity.ai.goal.SwimGoal;
import net.minecraft.entity.ai.goal.WaterAvoidingRandomWalkingGoal;
import net.minecraft.entity.passive.AnimalEntity;
import net.minecraft.entity.passive.horse.AbstractHorseEntity;
import net.minecraft.entity.passive.horse.LlamaEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.DyeColor;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.tags.ItemTags;
import net.minecraft.util.DamageSource;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;

public class CamelEntity
extends LlamaEntity {
    private static final DataParameter<Integer> DATA_STRENGTH_ID = EntityDataManager.func_187226_a(CamelEntity.class, (IDataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Integer> DATA_COLOR_ID = EntityDataManager.func_187226_a(CamelEntity.class, (IDataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Integer> DATA_VARIANT_ID = EntityDataManager.func_187226_a(CamelEntity.class, (IDataSerializer)DataSerializers.field_187192_b);
    public int field_110278_bp;
    private int eatingCounter;
    @Nullable
    private CamelEntity caravanHead;
    @Nullable
    private CamelEntity caravanTail;

    public CamelEntity(EntityType<? extends CamelEntity> entity, World world) {
        super(entity, world);
    }

    private void setStrength(int x) {
        this.field_70180_af.func_187227_b(DATA_STRENGTH_ID, (Object)Math.max(1, Math.min(5, x)));
    }

    private void setRandomStrength() {
        int x = this.field_70146_Z.nextFloat() < 0.04f ? 5 : 3;
        this.setStrength(3 + this.field_70146_Z.nextInt(x));
    }

    public int func_190707_dL() {
        return (Integer)this.field_70180_af.func_187225_a(DATA_STRENGTH_ID);
    }

    public void func_213281_b(CompoundNBT comnbt) {
        super.func_213281_b(comnbt);
        comnbt.func_74768_a("Variant", this.func_190719_dM());
        comnbt.func_74768_a("Strength", this.func_190707_dL());
        if (!this.field_110296_bG.func_70301_a(1).func_190926_b()) {
            comnbt.func_218657_a("DecorItem", (INBT)this.field_110296_bG.func_70301_a(1).func_77955_b(new CompoundNBT()));
        }
    }

    public void func_70037_a(CompoundNBT comnbt) {
        this.setStrength(comnbt.func_74762_e("Strength"));
        super.func_70037_a(comnbt);
        this.func_190710_o(comnbt.func_74762_e("Variant"));
        if (comnbt.func_150297_b("DecorItem", 10)) {
            this.field_110296_bG.func_70299_a(1, ItemStack.func_199557_a((CompoundNBT)comnbt.func_74775_l("DecorItem")));
        }
        this.func_110232_cE();
    }

    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(0, (Goal)new SwimGoal((MobEntity)this));
        this.field_70714_bg.func_75776_a(1, (Goal)new RunAroundLikeCrazyGoal((AbstractHorseEntity)this, 1.2));
        this.field_70714_bg.func_75776_a(2, (Goal)new CamelFollowCaravanGoal(this, 2.1));
        this.field_70714_bg.func_75776_a(3, (Goal)new PanicGoal((CreatureEntity)this, 1.2));
        this.field_70714_bg.func_75776_a(4, (Goal)new BreedGoal((AnimalEntity)this, 1.0));
        this.field_70714_bg.func_75776_a(5, (Goal)new FollowParentGoal((AnimalEntity)this, 1.0));
        this.field_70714_bg.func_75776_a(6, (Goal)new WaterAvoidingRandomWalkingGoal((CreatureEntity)this, 0.7));
        this.field_70714_bg.func_75776_a(7, (Goal)new LookAtGoal((MobEntity)this, PlayerEntity.class, 6.0f));
        this.field_70714_bg.func_75776_a(8, (Goal)new LookRandomlyGoal((MobEntity)this));
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111265_b).func_111128_a(40.0);
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a((double)0.15f);
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(55.0);
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(DATA_STRENGTH_ID, (Object)0);
        this.field_70180_af.func_187214_a(DATA_COLOR_ID, (Object)-1);
        this.field_70180_af.func_187214_a(DATA_VARIANT_ID, (Object)0);
    }

    public int func_190719_dM() {
        return MathHelper.func_76125_a((int)((Integer)this.field_70180_af.func_187225_a(DATA_VARIANT_ID)), (int)0, (int)4);
    }

    public void func_190710_o(int variant) {
        this.field_70180_af.func_187227_b(DATA_VARIANT_ID, (Object)variant);
    }

    protected int func_190686_di() {
        return this.func_190695_dh() ? 2 + 5 * this.func_190696_dl() : super.func_190686_di();
    }

    @Nullable
    public void func_184232_k(Entity entity) {
        if (this.func_184196_w(entity)) {
            float x = MathHelper.func_76134_b((float)(this.field_70761_aq * ((float)Math.PI / 180)));
            float y = MathHelper.func_76126_a((float)(this.field_70761_aq * ((float)Math.PI / 180)));
            float z = 0.3f;
            entity.func_70107_b(this.func_226277_ct_() + (double)(0.3f * y), this.func_226278_cu_() + this.func_70042_X() + entity.func_70033_W(), this.func_226281_cx_() - (double)(0.3f * x));
        }
    }

    public double func_70042_X() {
        return (double)this.func_213302_cg() * 0.78;
    }

    public boolean func_82171_bF() {
        return true;
    }

    @Nullable
    protected boolean func_190678_b(PlayerEntity player, ItemStack stack) {
        boolean flag = false;
        float f = 0.0f;
        int i = 0;
        int j = 0;
        Item item = stack.func_77973_b();
        if (item == Items.field_151015_O) {
            f = 2.0f;
            i = 20;
            j = 3;
        } else if (item == Items.field_151102_aT) {
            f = 1.0f;
            i = 30;
            j = 3;
        } else if (item == Blocks.field_150407_cf.func_199767_j()) {
            f = 20.0f;
            i = 180;
        } else if (item == Items.field_151034_e) {
            f = 3.0f;
            i = 60;
            j = 3;
        } else if (item == Items.field_151150_bK) {
            f = 4.0f;
            i = 60;
            j = 5;
            if (this.func_110248_bS() && this.func_70874_b() == 0 && !this.func_70880_s()) {
                flag = true;
                this.func_146082_f(player);
            }
        } else if (item == Items.field_151153_ao || item == Items.field_196100_at) {
            f = 10.0f;
            i = 240;
            j = 10;
            if (this.func_110248_bS() && this.func_70874_b() == 0 && !this.func_70880_s()) {
                flag = true;
                this.func_146082_f(player);
            }
        }
        if (this.func_110143_aJ() < this.func_110138_aP() && f > 0.0f) {
            this.func_70691_i(f);
            flag = true;
        }
        if (this.func_70631_g_() && i > 0) {
            this.field_70170_p.func_195594_a((IParticleData)ParticleTypes.field_197632_y, this.func_226282_d_(1.0), this.func_226279_cv_() + 0.5, this.func_226287_g_(1.0), 0.0, 0.0, 0.0);
            if (!this.field_70170_p.field_72995_K) {
                this.func_110195_a(i);
            }
            flag = true;
        }
        if (j > 0 && (flag || !this.func_110248_bS()) && this.func_110252_cg() < this.func_190676_dC()) {
            flag = true;
            if (!this.field_70170_p.field_72995_K) {
                this.func_110198_t(j);
            }
        }
        if (flag && !this.func_174814_R()) {
            this.field_70170_p.func_184148_a((PlayerEntity)null, this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_(), SoundEvents.field_191253_dD, this.func_184176_by(), 1.0f, 1.0f + (this.field_70146_Z.nextFloat() - this.field_70146_Z.nextFloat()) * 0.2f);
        }
        return flag;
    }

    protected boolean func_70610_aX() {
        return this.func_110143_aJ() <= 0.0f || this.func_110204_cc();
    }

    @Nullable
    public ILivingEntityData func_213386_a(IWorld world, DifficultyInstance diff, SpawnReason spawn, @Nullable ILivingEntityData data, @Nullable CompoundNBT comnbt) {
        int x;
        this.setRandomStrength();
        if (data instanceof CamelData) {
            x = ((CamelData)((Object)data)).variant;
        } else {
            x = this.field_70146_Z.nextInt(4);
            data = new CamelData(x);
        }
        this.func_190710_o(x);
        return super.func_213386_a(world, diff, spawn, data, comnbt);
    }

    protected SoundEvent func_184785_dv() {
        return this.func_70631_g_() ? (SoundEvent)SoundInit.ENTITY_CAMEL_ANGRY_BABY.get() : (SoundEvent)SoundInit.ENTITY_CAMEL_ANGRY.get();
    }

    protected SoundEvent func_184639_G() {
        return this.func_70631_g_() ? (SoundEvent)SoundInit.ENTITY_CAMEL_AMBIENT_BABY.get() : (SoundEvent)SoundInit.ENTITY_CAMEL_AMBIENT.get();
    }

    protected SoundEvent func_184601_bQ(DamageSource damage) {
        return this.func_70631_g_() ? (SoundEvent)SoundInit.ENTITY_CAMEL_HURT_BABY.get() : (SoundEvent)SoundInit.ENTITY_CAMEL_HURT.get();
    }

    protected SoundEvent func_184615_bR() {
        return this.func_70631_g_() ? (SoundEvent)SoundInit.ENTITY_CAMEL_DEATH_BABY.get() : (SoundEvent)SoundInit.ENTITY_CAMEL_DEATH.get();
    }

    protected void func_180429_a(BlockPos blockpos, BlockState blockState) {
        this.func_184185_a(SoundEvents.field_187709_dP, 0.15f, 1.0f);
    }

    protected void func_190697_dk() {
        this.func_184185_a(SoundEvents.field_191259_dX, 1.0f, (this.field_70146_Z.nextFloat() - this.field_70146_Z.nextFloat()) * 0.2f + 1.0f);
    }

    public int func_190696_dl() {
        return this.func_190707_dL();
    }

    public boolean func_190677_dK() {
        return true;
    }

    public boolean func_190682_f(ItemStack itemStack) {
        Item item = itemStack.func_77973_b();
        return ItemTags.field_200035_e.func_199685_a_((Object)item);
    }

    public boolean func_190685_dA() {
        return true;
    }

    public void func_76316_a(IInventory inventory) {
        DyeColor dye1 = this.func_190704_dO();
        super.func_76316_a(inventory);
        DyeColor dye2 = this.func_190704_dO();
        if (this.field_70173_aa <= 20 || dye2 == null || dye2 != dye1) {
            // empty if block
        }
    }

    protected void func_110232_cE() {
        if (!this.field_70170_p.field_72995_K) {
            super.func_110232_cE();
            this.setColor(CamelEntity.getCarpetColor(this.field_110296_bG.func_70301_a(1)));
        }
    }

    private void setColor(@Nullable DyeColor dye) {
        this.field_70180_af.func_187227_b(DATA_COLOR_ID, (Object)(dye == null ? -1 : dye.func_196059_a()));
    }

    @Nullable
    private static DyeColor getCarpetColor(ItemStack itemStack) {
        Block block = Block.func_149634_a((Item)itemStack.func_77973_b());
        return block instanceof CarpetBlock ? ((CarpetBlock)block).func_196547_d() : null;
    }

    @Nullable
    public DyeColor func_190704_dO() {
        int x = (Integer)this.field_70180_af.func_187225_a(DATA_COLOR_ID);
        return x == -1 ? null : DyeColor.func_196056_a((int)x);
    }

    public int func_190676_dC() {
        return 60;
    }

    public boolean func_70878_b(AnimalEntity animal) {
        return animal != this && animal instanceof CamelEntity && this.func_110200_cJ() && ((CamelEntity)animal).func_110200_cJ();
    }

    public CamelEntity createChild(AgeableEntity ageable) {
        CamelEntity entity = this.createChild();
        this.func_190681_a(ageable, (AbstractHorseEntity)entity);
        CamelEntity entity1 = (CamelEntity)ageable;
        int i = this.field_70146_Z.nextInt(Math.max(this.func_190707_dL(), entity1.func_190707_dL())) + 1;
        if (this.field_70146_Z.nextFloat() < 0.03f) {
            ++i;
        }
        entity.setStrength(i);
        entity.func_190710_o(this.field_70146_Z.nextBoolean() ? this.func_190719_dM() : entity1.func_190719_dM());
        return entity;
    }

    protected CamelEntity createChild() {
        CamelEntity entity = new CamelEntity((EntityType<? extends CamelEntity>)((EntityType)ModEntityTypes.CAMEL_ENTITY.get()), this.field_70170_p);
        entity.func_213386_a((IWorld)this.field_70170_p, this.field_70170_p.func_175649_E(new BlockPos((Entity)entity)), SpawnReason.BREEDING, null, null);
        return entity;
    }

    public boolean func_225503_b_(float x, float y) {
        int z = this.func_225508_e_(x, y);
        if (z <= 0) {
            return false;
        }
        if (x >= 6.0f) {
            this.func_70097_a(DamageSource.field_76379_h, z);
            if (this.func_184207_aI()) {
                for (Entity entity : this.func_184182_bu()) {
                    entity.func_70097_a(DamageSource.field_76379_h, (float)z);
                }
            }
        }
        this.func_226295_cZ_();
        return true;
    }

    public void func_190709_dP() {
        if (this.caravanHead != null) {
            this.caravanHead.caravanTail = null;
        }
        this.caravanHead = null;
    }

    public void joinCaravan(CamelEntity entity) {
        this.caravanHead = entity;
        this.caravanHead.caravanTail = this;
    }

    public boolean func_190712_dQ() {
        return this.caravanTail != null;
    }

    public boolean func_190718_dR() {
        return this.caravanHead != null;
    }

    @Nullable
    public CamelEntity getCaravanHead() {
        return this.caravanHead;
    }

    protected double func_190634_dg() {
        return 1.5;
    }

    protected void func_190679_dD() {
        if (!this.func_190718_dR() && this.func_70631_g_()) {
            super.func_190679_dD();
        }
    }

    public boolean func_190684_dE() {
        return true;
    }

    public void func_70636_d() {
        if (this.field_110278_bp > 0 && ++this.field_110278_bp > 8) {
            this.field_110278_bp = 0;
        }
        if (this.field_70146_Z.nextInt(200) == 0) {
            this.moveTail();
        }
        super.func_70636_d();
        if (!this.field_70170_p.field_72995_K && this.func_70089_S()) {
            if (this.field_70146_Z.nextInt(900) == 0 && this.field_70725_aQ == 0) {
                this.func_70691_i(1.0f);
            }
            if (this.func_190684_dE()) {
                if (!this.func_110204_cc() && !this.func_184207_aI() && this.field_70146_Z.nextInt(300) == 0 && this.field_70170_p.func_180495_p(new BlockPos((Entity)this).func_177977_b()).func_177230_c() == Blocks.field_196658_i) {
                    this.func_110227_p(true);
                }
                if (this.func_110204_cc() && ++this.eatingCounter > 50) {
                    this.eatingCounter = 0;
                    this.func_110227_p(false);
                }
            }
            this.func_190679_dD();
        }
    }

    private void moveTail() {
        this.field_110278_bp = 1;
    }

    protected float func_213348_b(Pose poseIn, EntitySize sizeIn) {
        return sizeIn.field_220316_b * 1.75f;
    }

    public float func_213355_cm() {
        return this.func_70631_g_() ? 0.75f : 1.85f;
    }

    protected void func_190681_a(AgeableEntity ageable, AbstractHorseEntity abstaEntity) {
        double d0 = this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111125_b() + ageable.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111125_b() + (double)this.func_110267_cL();
        abstaEntity.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(d0 / 2.0);
        double d2 = this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111125_b() + ageable.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111125_b() + this.func_110203_cN();
        abstaEntity.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(d2 / 4.0);
    }

    static class CamelData
    extends AgeableEntity.AgeableData {
        public final int variant;

        private CamelData(int x) {
            this.variant = x;
        }
    }

    static class HurtByTargetGoal
    extends net.minecraft.entity.ai.goal.HurtByTargetGoal {
        public HurtByTargetGoal(CamelEntity entity) {
            super((CreatureEntity)entity, new Class[0]);
        }

        public boolean func_75253_b() {
            if (this.field_75299_d instanceof CamelEntity) {
                CamelEntity camelEntity = (CamelEntity)this.field_75299_d;
            }
            return super.func_75253_b();
        }
    }
}

