/*
 * Decompiled with CFR 0.152.
 */
package com.talhanation.camels.entities.ai.goal;

import com.talhanation.camels.entities.CamelEntity;
import java.util.EnumSet;
import java.util.List;
import java.util.Objects;
import net.minecraft.entity.Entity;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.util.math.Vec3d;

public class CamelFollowCaravanGoal
extends Goal {
    private CamelEntity camel;
    private double speedModifier;
    private int distCheckCounter;

    public CamelFollowCaravanGoal(CamelEntity camelln, double speedModifier) {
        this.camel = camelln;
        this.speedModifier = speedModifier;
        this.func_220684_a(EnumSet.of(Goal.Flag.MOVE));
    }

    public boolean func_75250_a() {
        if (this.camel.func_110248_bS() && !this.canLeadCaravan(this.camel) && !this.camel.func_190718_dR()) {
            double distanceSq;
            List list = this.camel.field_70170_p.func_217357_a(((Object)((Object)this.camel)).getClass(), this.camel.func_174813_aQ().func_72314_b(9.0, 4.0, 9.0));
            CamelEntity camel = null;
            double distance = Double.MAX_VALUE;
            for (CamelEntity caravanCamel : list) {
                if (!caravanCamel.func_110248_bS() || !caravanCamel.func_190718_dR() || caravanCamel.func_190712_dQ() || !((distanceSq = this.camel.func_70068_e((Entity)caravanCamel)) <= distance)) continue;
                distance = distanceSq;
                camel = caravanCamel;
            }
            if (camel == null) {
                for (CamelEntity caravanLeader : list) {
                    if (!caravanLeader.func_110248_bS() || !this.canLeadCaravan(caravanLeader) || caravanLeader.func_190712_dQ() || !((distanceSq = this.camel.func_70068_e((Entity)caravanLeader)) <= distance)) continue;
                    distance = distanceSq;
                    camel = caravanLeader;
                }
            }
            if (camel == null) {
                return false;
            }
            if (distance < 4.0) {
                return false;
            }
            if (!this.canLeadCaravan(camel) && !this.firstCanBeCaravanLeader(camel, 1)) {
                return false;
            }
            this.camel.joinCaravan(camel);
            return true;
        }
        return false;
    }

    public boolean func_75253_b() {
        if (this.camel.func_190718_dR() && this.camel.getCaravanHead() != null && this.camel.getCaravanHead().func_70089_S() && this.firstCanBeCaravanLeader(this.camel, 0)) {
            double distanceSq = this.camel.func_70068_e((Entity)this.camel.getCaravanHead());
            if (distanceSq > 676.0) {
                if (this.speedModifier <= 3.0) {
                    this.speedModifier *= 1.75;
                    this.distCheckCounter = 40;
                    return true;
                }
                if (this.distCheckCounter == 0) {
                    return false;
                }
            }
            if (this.distCheckCounter > 0) {
                --this.distCheckCounter;
            }
            return true;
        }
        return false;
    }

    public void func_75251_c() {
        this.camel.func_190709_dP();
        this.speedModifier = 2.1;
    }

    public void func_75246_d() {
        if (this.camel.func_190718_dR()) {
            CamelEntity caravanLeader = this.camel.getCaravanHead();
            double distance = this.camel.func_70032_d((Entity)Objects.requireNonNull(caravanLeader));
            Vec3d vec3d = new Vec3d(caravanLeader.func_226277_ct_() - this.camel.func_226277_ct_(), caravanLeader.func_226278_cu_() - this.camel.func_226278_cu_(), caravanLeader.func_226281_cx_() - this.camel.func_226281_cx_()).func_72432_b().func_186678_a(Math.max(distance - 2.0, 0.0));
            this.camel.func_70661_as().func_75492_a(this.camel.func_226277_ct_() + vec3d.field_72450_a, this.camel.func_226278_cu_() + vec3d.field_72448_b, this.camel.func_226281_cx_() + vec3d.field_72449_c, this.speedModifier);
        }
    }

    private boolean firstCanBeCaravanLeader(CamelEntity camel, int amount) {
        if (amount > 8) {
            return false;
        }
        if (camel.func_190718_dR()) {
            if (camel.getCaravanHead() != null && this.canLeadCaravan(camel.getCaravanHead())) {
                return true;
            }
            CamelEntity caravanLeader = camel.getCaravanHead();
            return this.firstCanBeCaravanLeader(caravanLeader, ++amount);
        }
        return false;
    }

    private boolean canLeadCaravan(CamelEntity camel) {
        return camel.func_110167_bD() || camel.func_110257_ck() && camel.func_184207_aI() && camel.func_190695_dh();
    }
}

