/*
 * Decompiled with CFR 0.152.
 */
package com.talhanation.camels.network;

import com.google.common.primitives.Doubles;
import com.google.common.primitives.Floats;
import net.minecraft.entity.Entity;
import net.minecraft.entity.MoverType;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.network.INetHandler;
import net.minecraft.network.IPacket;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.PacketThreadUtil;
import net.minecraft.network.play.ServerPlayNetHandler;
import net.minecraft.network.play.client.CMoveVehiclePacket;
import net.minecraft.network.play.server.SMoveVehiclePacket;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.server.ServerWorld;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ModServerPlayNetHandler
extends ServerPlayNetHandler {
    private static final Logger LOGGER = LogManager.getLogger();
    private final MinecraftServer server;
    public ServerPlayerEntity field_147369_b;
    public final NetworkManager field_147371_a;
    private double lowestRiddenX1;
    private double lowestRiddenY1;
    private double lowestRiddenZ1;
    private double lowestRiddenX;
    private double lowestRiddenY;
    private double lowestRiddenZ;
    private Entity lowestRiddenEnt;
    private boolean vehicleFloating;

    public ModServerPlayNetHandler(MinecraftServer server, NetworkManager networkManagerIn, ServerPlayerEntity playerIn) {
        super(server, networkManagerIn, playerIn);
        this.server = server;
        this.field_147371_a = networkManagerIn;
        networkManagerIn.func_150719_a((INetHandler)this);
        this.field_147369_b = playerIn;
        playerIn.field_71135_a = this;
    }

    private static boolean isMoveVehiclePacketInvalid(CMoveVehiclePacket packetIn) {
        return !Doubles.isFinite((double)packetIn.func_187004_a()) || !Doubles.isFinite((double)packetIn.func_187002_b()) || !Doubles.isFinite((double)packetIn.func_187003_c()) || !Floats.isFinite((float)packetIn.func_187005_e()) || !Floats.isFinite((float)packetIn.func_187006_d());
    }

    private boolean func_217264_d() {
        return this.server.func_213199_b(this.field_147369_b.func_146103_bH());
    }

    public void func_184338_a(CMoveVehiclePacket packetIn) {
        PacketThreadUtil.func_218796_a((IPacket)packetIn, (INetHandler)this, (ServerWorld)this.field_147369_b.func_71121_q());
        if (ModServerPlayNetHandler.isMoveVehiclePacketInvalid(packetIn)) {
            this.func_194028_b((ITextComponent)new TranslationTextComponent("multiplayer.disconnect.invalid_vehicle_movement", new Object[0]));
        } else {
            Entity entity = this.field_147369_b.func_184208_bv();
            if (entity != this.field_147369_b && entity.func_184179_bs() == this.field_147369_b && entity == this.lowestRiddenEnt) {
                ServerWorld serverworld = this.field_147369_b.func_71121_q();
                double d0 = entity.func_226277_ct_();
                double d1 = entity.func_226278_cu_();
                double d2 = entity.func_226281_cx_();
                double d3 = packetIn.func_187004_a();
                double d4 = packetIn.func_187002_b();
                double d5 = packetIn.func_187003_c();
                float f = packetIn.func_187006_d();
                float f1 = packetIn.func_187005_e();
                double d6 = d3 - this.lowestRiddenX;
                double d7 = d4 - this.lowestRiddenY;
                double d8 = d5 - this.lowestRiddenZ;
                double d10 = d6 * d6 + d7 * d7 + d8 * d8;
                double d9 = entity.func_213322_ci().func_189985_c();
                if (d10 - d9 > 100.0 && !this.func_217264_d()) {
                    LOGGER.warn("{} (vehicle of {}) moved too quickly! {},{},{}", (Object)entity.func_200200_C_().getString(), (Object)this.field_147369_b.func_200200_C_().getString(), (Object)d6, (Object)d7, (Object)d8);
                    this.field_147371_a.func_179290_a((IPacket)new SMoveVehiclePacket(entity));
                    return;
                }
                boolean flag = serverworld.func_226665_a__(entity, entity.func_174813_aQ().func_186664_h(0.0625));
                d6 = d3 - this.lowestRiddenX1;
                d7 = d4 - this.lowestRiddenY1 - 1.0E-6;
                d8 = d5 - this.lowestRiddenZ1;
                entity.func_213315_a(MoverType.PLAYER, new Vec3d(d6, d7, d8));
                d6 = d3 - entity.func_226277_ct_();
                d7 = d4 - entity.func_226278_cu_();
                if (d7 > -0.5 || d7 < 0.5) {
                    d7 = 0.0;
                }
                d8 = d5 - entity.func_226281_cx_();
                d10 = d6 * d6 + d7 * d7 + d8 * d8;
                boolean flag1 = false;
                if (d10 > 0.07) {
                    flag1 = true;
                    LOGGER.warn("{} moved wrongly!", (Object)entity.func_200200_C_().getString());
                }
                entity.func_70080_a(d3, d4, d5, f, f1);
                this.field_147369_b.func_70080_a(d3, d4, d5, this.field_147369_b.field_70177_z, this.field_147369_b.field_70125_A);
                boolean flag2 = serverworld.func_226665_a__(entity, entity.func_174813_aQ().func_186664_h(0.0625));
                if (flag && (flag1 || !flag2)) {
                    entity.func_70080_a(d0, d1, d2, f, f1);
                    this.field_147369_b.func_70080_a(d3, d4, d5, this.field_147369_b.field_70177_z, this.field_147369_b.field_70125_A);
                    this.field_147371_a.func_179290_a((IPacket)new SMoveVehiclePacket(entity));
                    return;
                }
                this.field_147369_b.func_71121_q().func_72863_F().func_217221_a(this.field_147369_b);
                this.field_147369_b.func_71000_j(this.field_147369_b.func_226277_ct_() - d0, this.field_147369_b.func_226278_cu_() - d1, this.field_147369_b.func_226281_cx_() - d2);
                this.vehicleFloating = d7 >= -0.03125 && !this.server.func_71231_X() && !serverworld.func_72829_c(entity.func_174813_aQ().func_186662_g(0.0625).func_72321_a(0.0, -0.55, 0.0));
                this.lowestRiddenX1 = entity.func_226277_ct_();
                this.lowestRiddenY1 = entity.func_226278_cu_();
                this.lowestRiddenZ1 = entity.func_226281_cx_();
            }
        }
    }
}

