/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.car;

import com.google.common.collect.ImmutableSet;
import com.mojang.brigadier.CommandDispatcher;
import de.maxhenkel.car.blocks.BlockPaint;
import de.maxhenkel.car.blocks.ModBlocks;
import de.maxhenkel.car.blocks.tileentity.TileEntityBackmixReactor;
import de.maxhenkel.car.blocks.tileentity.TileEntityBlastFurnace;
import de.maxhenkel.car.blocks.tileentity.TileEntityCable;
import de.maxhenkel.car.blocks.tileentity.TileEntityCarWorkshop;
import de.maxhenkel.car.blocks.tileentity.TileEntityDynamo;
import de.maxhenkel.car.blocks.tileentity.TileEntityFluidExtractor;
import de.maxhenkel.car.blocks.tileentity.TileEntityGasStation;
import de.maxhenkel.car.blocks.tileentity.TileEntityGenerator;
import de.maxhenkel.car.blocks.tileentity.TileEntityOilMill;
import de.maxhenkel.car.blocks.tileentity.TileEntitySign;
import de.maxhenkel.car.blocks.tileentity.TileEntitySplitTank;
import de.maxhenkel.car.blocks.tileentity.TileEntityTank;
import de.maxhenkel.car.blocks.tileentity.render.TileEntitySpecialRendererSign;
import de.maxhenkel.car.blocks.tileentity.render.TileEntitySpecialRendererSplitTank;
import de.maxhenkel.car.blocks.tileentity.render.TileEntitySpecialRendererTank;
import de.maxhenkel.car.blocks.tileentity.render.TileentitySpecialRendererGasStation;
import de.maxhenkel.car.commands.CommandCarDemo;
import de.maxhenkel.car.config.ClientConfig;
import de.maxhenkel.car.config.FuelConfig;
import de.maxhenkel.car.config.ServerConfig;
import de.maxhenkel.car.corelib.ClientRegistry;
import de.maxhenkel.car.corelib.CommonRegistry;
import de.maxhenkel.car.corelib.config.DynamicConfig;
import de.maxhenkel.car.dataserializers.DataSerializerItemList;
import de.maxhenkel.car.entity.car.base.EntityGenericCar;
import de.maxhenkel.car.entity.model.GenericCarModel;
import de.maxhenkel.car.events.BlockEvents;
import de.maxhenkel.car.events.CapabilityEvents;
import de.maxhenkel.car.events.KeyEvents;
import de.maxhenkel.car.events.PlayerEvents;
import de.maxhenkel.car.events.RenderEvents;
import de.maxhenkel.car.events.SoundEvents;
import de.maxhenkel.car.fluids.ModFluids;
import de.maxhenkel.car.gui.ContainerBackmixReactor;
import de.maxhenkel.car.gui.ContainerBlastFurnace;
import de.maxhenkel.car.gui.ContainerCar;
import de.maxhenkel.car.gui.ContainerCarInventory;
import de.maxhenkel.car.gui.ContainerCarWorkshopCrafting;
import de.maxhenkel.car.gui.ContainerCarWorkshopRepair;
import de.maxhenkel.car.gui.ContainerFactoryTileEntity;
import de.maxhenkel.car.gui.ContainerFluidExtractor;
import de.maxhenkel.car.gui.ContainerGasStation;
import de.maxhenkel.car.gui.ContainerGasStationAdmin;
import de.maxhenkel.car.gui.ContainerGenerator;
import de.maxhenkel.car.gui.ContainerLicensePlate;
import de.maxhenkel.car.gui.ContainerOilMill;
import de.maxhenkel.car.gui.ContainerPainter;
import de.maxhenkel.car.gui.ContainerSign;
import de.maxhenkel.car.gui.ContainerSplitTank;
import de.maxhenkel.car.gui.GuiBackmixReactor;
import de.maxhenkel.car.gui.GuiBlastFurnace;
import de.maxhenkel.car.gui.GuiCar;
import de.maxhenkel.car.gui.GuiCarInventory;
import de.maxhenkel.car.gui.GuiCarWorkshopCrafting;
import de.maxhenkel.car.gui.GuiCarWorkshopRepair;
import de.maxhenkel.car.gui.GuiFluidExtractor;
import de.maxhenkel.car.gui.GuiGasStation;
import de.maxhenkel.car.gui.GuiGasStationAdmin;
import de.maxhenkel.car.gui.GuiGenerator;
import de.maxhenkel.car.gui.GuiLicensePlate;
import de.maxhenkel.car.gui.GuiOilMill;
import de.maxhenkel.car.gui.GuiPainter;
import de.maxhenkel.car.gui.GuiSign;
import de.maxhenkel.car.gui.GuiSplitTank;
import de.maxhenkel.car.items.ItemLicensePlate;
import de.maxhenkel.car.items.ModItems;
import de.maxhenkel.car.loottable.CopyFluid;
import de.maxhenkel.car.net.MessageCarGui;
import de.maxhenkel.car.net.MessageCarHorn;
import de.maxhenkel.car.net.MessageCenterCar;
import de.maxhenkel.car.net.MessageCenterCarClient;
import de.maxhenkel.car.net.MessageControlCar;
import de.maxhenkel.car.net.MessageCrash;
import de.maxhenkel.car.net.MessageEditLicensePlate;
import de.maxhenkel.car.net.MessageEditSign;
import de.maxhenkel.car.net.MessageGasStationAdminAmount;
import de.maxhenkel.car.net.MessageOpenCarWorkshopGui;
import de.maxhenkel.car.net.MessageRepairCar;
import de.maxhenkel.car.net.MessageSpawnCar;
import de.maxhenkel.car.net.MessageStartFuel;
import de.maxhenkel.car.net.MessageStarting;
import de.maxhenkel.car.net.MessageSyncTileEntity;
import de.maxhenkel.car.recipes.BlastFurnaceRecipe;
import de.maxhenkel.car.recipes.KeyRecipe;
import de.maxhenkel.car.recipes.OilMillRecipe;
import de.maxhenkel.car.recipes.RecipeSerializerBlastFurnace;
import de.maxhenkel.car.recipes.RecipeSerializerOilMill;
import de.maxhenkel.car.sounds.ModSounds;
import de.maxhenkel.car.villagers.VillagerEvents;
import de.maxhenkel.tools.EntityTools;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.RenderTypeLookup;
import net.minecraft.client.settings.KeyBinding;
import net.minecraft.command.CommandSource;
import net.minecraft.entity.EntityClassification;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.merchant.villager.VillagerProfession;
import net.minecraft.fluid.Fluid;
import net.minecraft.inventory.container.ContainerType;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.item.crafting.IRecipeType;
import net.minecraft.item.crafting.SpecialRecipeSerializer;
import net.minecraft.loot.ILootSerializer;
import net.minecraft.loot.LootFunctionType;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Hand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.registry.Registry;
import net.minecraft.village.PointOfInterestType;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.RegisterCommandsEvent;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.client.registry.RenderingRegistry;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.ObfuscationReflectionHelper;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.fml.loading.FMLEnvironment;
import net.minecraftforge.fml.network.IContainerFactory;
import net.minecraftforge.fml.network.simple.SimpleChannel;
import net.minecraftforge.registries.DataSerializerEntry;
import net.minecraftforge.registries.IForgeRegistryEntry;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(value="car")
public class Main {
    public static final String MODID = "car";
    public static final Logger LOGGER = LogManager.getLogger((String)"car");
    public static SimpleChannel SIMPLE_CHANNEL;
    public static EntityType<EntityGenericCar> CAR_ENTITY_TYPE;
    public static LootFunctionType COPY_FLUID;
    public static PointOfInterestType POINT_OF_INTEREST_TYPE_GAS_STATION_ATTENDANT;
    public static VillagerProfession VILLAGER_PROFESSION_GAS_STATION_ATTENDANT;
    public static ServerConfig SERVER_CONFIG;
    public static FuelConfig FUEL_CONFIG;
    public static ClientConfig CLIENT_CONFIG;
    public static KeyBinding FORWARD_KEY;
    public static KeyBinding BACK_KEY;
    public static KeyBinding LEFT_KEY;
    public static KeyBinding RIGHT_KEY;
    public static KeyBinding CAR_GUI_KEY;
    public static KeyBinding START_KEY;
    public static KeyBinding HORN_KEY;
    public static KeyBinding CENTER_KEY;
    public static ContainerType<ContainerBackmixReactor> BACKMIX_REACTOR_CONTAINER_TYPE;
    public static ContainerType<ContainerBlastFurnace> BLAST_FURNACE_CONTAINER_TYPE;
    public static ContainerType<ContainerCar> CAR_CONTAINER_TYPE;
    public static ContainerType<ContainerCarInventory> CAR_INVENTORY_CONTAINER_TYPE;
    public static ContainerType<ContainerCarWorkshopCrafting> CAR_WORKSHOP_CRAFTING_CONTAINER_TYPE;
    public static ContainerType<ContainerCarWorkshopRepair> CAR_WORKSHOP_REPAIR_CONTAINER_TYPE;
    public static ContainerType<ContainerFluidExtractor> FLUID_EXTRACTOR_CONTAINER_TYPE;
    public static ContainerType<ContainerGasStation> FUEL_STATION_CONTAINER_TYPE;
    public static ContainerType<ContainerGasStationAdmin> FUEL_STATION_ADMIN_CONTAINER_TYPE;
    public static ContainerType<ContainerGenerator> GENERATOR_CONTAINER_TYPE;
    public static ContainerType<ContainerLicensePlate> LICENSE_PLATE_CONTAINER_TYPE;
    public static ContainerType<ContainerOilMill> OIL_MILL_CONTAINER_TYPE;
    public static ContainerType<ContainerPainter> PAINTER_CONTAINER_TYPE;
    public static ContainerType<ContainerSign> SIGN_CONTAINER_TYPE;
    public static ContainerType<ContainerSplitTank> SPLIT_TANK_CONTAINER_TYPE;
    public static TileEntityType<TileEntityGenerator> GENERATOR_TILE_ENTITY_TYPE;
    public static TileEntityType<TileEntityBackmixReactor> BACKMIX_REACTOR_TILE_ENTITY_TYPE;
    public static TileEntityType<TileEntityBlastFurnace> BLAST_FURNACE_TILE_ENTITY_TYPE;
    public static TileEntityType<TileEntityCable> CABLE_TILE_ENTITY_TYPE;
    public static TileEntityType<TileEntityCarWorkshop> CAR_WORKSHOP_TILE_ENTITY_TYPE;
    public static TileEntityType<TileEntityDynamo> DYNAMO_TILE_ENTITY_TYPE;
    public static TileEntityType<TileEntityFluidExtractor> FLUID_EXTRACTOR_TILE_ENTITY_TYPE;
    public static TileEntityType<TileEntityOilMill> OIL_MILL_TILE_ENTITY_TYPE;
    public static TileEntityType<TileEntitySign> SIGN_TILE_ENTITY_TYPE;
    public static TileEntityType<TileEntitySplitTank> SPLIT_TANK_TILE_ENTITY_TYPE;
    public static TileEntityType<TileEntityTank> TANK_TILE_ENTITY_TYPE;
    public static TileEntityType<TileEntityGasStation> GAS_STATION_TILE_ENTITY_TYPE;
    public static IRecipeSerializer<KeyRecipe> CRAFTING_SPECIAL_KEY;
    public static IRecipeSerializer<BlastFurnaceRecipe> CRAFTING_BLAST_FURNACE;
    public static IRecipeSerializer<OilMillRecipe> CRAFTING_OIL_MILL;
    public static IRecipeType<BlastFurnaceRecipe> RECIPE_TYPE_BLAST_FURNACE;
    public static IRecipeType<BlastFurnaceRecipe> RECIPE_TYPE_OIL_MILL;

    public Main() {
        FMLJavaModLoadingContext.get().getModEventBus().addGenericListener(Item.class, this::registerItems);
        FMLJavaModLoadingContext.get().getModEventBus().addGenericListener(Block.class, this::registerBlocks);
        FMLJavaModLoadingContext.get().getModEventBus().addGenericListener(SoundEvent.class, this::registerSounds);
        FMLJavaModLoadingContext.get().getModEventBus().addGenericListener(EntityType.class, this::registerEntities);
        FMLJavaModLoadingContext.get().getModEventBus().addGenericListener(ContainerType.class, this::registerContainers);
        FMLJavaModLoadingContext.get().getModEventBus().addGenericListener(TileEntityType.class, this::registerTileEntities);
        FMLJavaModLoadingContext.get().getModEventBus().addGenericListener(IRecipeSerializer.class, this::registerRecipes);
        FMLJavaModLoadingContext.get().getModEventBus().addGenericListener(DataSerializerEntry.class, this::registerSerializers);
        FMLJavaModLoadingContext.get().getModEventBus().addGenericListener(Fluid.class, this::registerFluids);
        FMLJavaModLoadingContext.get().getModEventBus().addGenericListener(PointOfInterestType.class, this::registerPointsOfInterest);
        FMLJavaModLoadingContext.get().getModEventBus().addGenericListener(VillagerProfession.class, this::registerVillagerProfessions);
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::commonSetup);
        SERVER_CONFIG = CommonRegistry.registerConfig(ModConfig.Type.SERVER, ServerConfig.class, true);
        FUEL_CONFIG = CommonRegistry.registerDynamicConfig(DynamicConfig.DynamicConfigType.SERVER, MODID, "fuel", FuelConfig.class);
        CLIENT_CONFIG = CommonRegistry.registerConfig(ModConfig.Type.CLIENT, ClientConfig.class);
        DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> () -> FMLJavaModLoadingContext.get().getModEventBus().addListener(this::clientSetup));
    }

    @SubscribeEvent
    public void onRegisterCommands(RegisterCommandsEvent event) {
        CommandCarDemo.register((CommandDispatcher<CommandSource>)event.getDispatcher());
    }

    @SubscribeEvent
    public void commonSetup(FMLCommonSetupEvent event) {
        MinecraftForge.EVENT_BUS.register((Object)this);
        MinecraftForge.EVENT_BUS.register((Object)new CapabilityEvents());
        MinecraftForge.EVENT_BUS.register((Object)new BlockEvents());
        MinecraftForge.EVENT_BUS.register((Object)new VillagerEvents());
        COPY_FLUID = (LootFunctionType)Registry.func_218322_a((Registry)Registry.field_239694_aZ_, (ResourceLocation)new ResourceLocation(MODID, "copy_fluid"), (Object)new LootFunctionType((ILootSerializer)new CopyFluid.Serializer()));
        SIMPLE_CHANNEL = CommonRegistry.registerChannel(MODID, "default");
        CommonRegistry.registerMessage(SIMPLE_CHANNEL, 0, MessageControlCar.class);
        CommonRegistry.registerMessage(SIMPLE_CHANNEL, 1, MessageCarGui.class);
        CommonRegistry.registerMessage(SIMPLE_CHANNEL, 2, MessageStarting.class);
        CommonRegistry.registerMessage(SIMPLE_CHANNEL, 3, MessageCrash.class);
        CommonRegistry.registerMessage(SIMPLE_CHANNEL, 4, MessageStartFuel.class);
        CommonRegistry.registerMessage(SIMPLE_CHANNEL, 6, MessageSyncTileEntity.class);
        CommonRegistry.registerMessage(SIMPLE_CHANNEL, 7, MessageSpawnCar.class);
        CommonRegistry.registerMessage(SIMPLE_CHANNEL, 8, MessageOpenCarWorkshopGui.class);
        CommonRegistry.registerMessage(SIMPLE_CHANNEL, 9, MessageRepairCar.class);
        CommonRegistry.registerMessage(SIMPLE_CHANNEL, 10, MessageCarHorn.class);
        CommonRegistry.registerMessage(SIMPLE_CHANNEL, 11, MessageEditSign.class);
        CommonRegistry.registerMessage(SIMPLE_CHANNEL, 12, MessageGasStationAdminAmount.class);
        CommonRegistry.registerMessage(SIMPLE_CHANNEL, 13, MessageCenterCar.class);
        CommonRegistry.registerMessage(SIMPLE_CHANNEL, 14, MessageCenterCarClient.class);
        CommonRegistry.registerMessage(SIMPLE_CHANNEL, 15, MessageEditLicensePlate.class);
    }

    @SubscribeEvent
    @OnlyIn(value=Dist.CLIENT)
    public void clientSetup(FMLClientSetupEvent event) {
        net.minecraftforge.fml.client.registry.ClientRegistry.bindTileEntityRenderer(GAS_STATION_TILE_ENTITY_TYPE, TileentitySpecialRendererGasStation::new);
        net.minecraftforge.fml.client.registry.ClientRegistry.bindTileEntityRenderer(SPLIT_TANK_TILE_ENTITY_TYPE, TileEntitySpecialRendererSplitTank::new);
        net.minecraftforge.fml.client.registry.ClientRegistry.bindTileEntityRenderer(TANK_TILE_ENTITY_TYPE, TileEntitySpecialRendererTank::new);
        net.minecraftforge.fml.client.registry.ClientRegistry.bindTileEntityRenderer(SIGN_TILE_ENTITY_TYPE, TileEntitySpecialRendererSign::new);
        ClientRegistry.registerScreen(BACKMIX_REACTOR_CONTAINER_TYPE, GuiBackmixReactor::new);
        ClientRegistry.registerScreen(BLAST_FURNACE_CONTAINER_TYPE, GuiBlastFurnace::new);
        ClientRegistry.registerScreen(CAR_CONTAINER_TYPE, GuiCar::new);
        ClientRegistry.registerScreen(CAR_INVENTORY_CONTAINER_TYPE, GuiCarInventory::new);
        ClientRegistry.registerScreen(CAR_WORKSHOP_CRAFTING_CONTAINER_TYPE, GuiCarWorkshopCrafting::new);
        ClientRegistry.registerScreen(CAR_WORKSHOP_REPAIR_CONTAINER_TYPE, GuiCarWorkshopRepair::new);
        ClientRegistry.registerScreen(FLUID_EXTRACTOR_CONTAINER_TYPE, GuiFluidExtractor::new);
        ClientRegistry.registerScreen(FUEL_STATION_CONTAINER_TYPE, GuiGasStation::new);
        ClientRegistry.registerScreen(FUEL_STATION_ADMIN_CONTAINER_TYPE, GuiGasStationAdmin::new);
        ClientRegistry.registerScreen(GENERATOR_CONTAINER_TYPE, GuiGenerator::new);
        ClientRegistry.registerScreen(LICENSE_PLATE_CONTAINER_TYPE, GuiLicensePlate::new);
        ClientRegistry.registerScreen(OIL_MILL_CONTAINER_TYPE, GuiOilMill::new);
        ClientRegistry.registerScreen(PAINTER_CONTAINER_TYPE, GuiPainter::new);
        ClientRegistry.registerScreen(SIGN_CONTAINER_TYPE, (container, playerInventory, name) -> new GuiSign((ContainerSign)container, name));
        ClientRegistry.registerScreen(SPLIT_TANK_CONTAINER_TYPE, GuiSplitTank::new);
        FORWARD_KEY = ClientRegistry.registerKeyBinding("key.car_forward", "category.car", 87);
        BACK_KEY = ClientRegistry.registerKeyBinding("key.car_back", "category.car", 83);
        LEFT_KEY = ClientRegistry.registerKeyBinding("key.car_left", "category.car", 65);
        RIGHT_KEY = ClientRegistry.registerKeyBinding("key.car_right", "category.car", 68);
        CAR_GUI_KEY = ClientRegistry.registerKeyBinding("key.car_gui", "category.car", 73);
        START_KEY = ClientRegistry.registerKeyBinding("key.car_start", "category.car", 82);
        HORN_KEY = ClientRegistry.registerKeyBinding("key.car_horn", "category.car", 72);
        CENTER_KEY = ClientRegistry.registerKeyBinding("key.center_car", "category.car", 32);
        MinecraftForge.EVENT_BUS.register((Object)new RenderEvents());
        MinecraftForge.EVENT_BUS.register((Object)new SoundEvents());
        MinecraftForge.EVENT_BUS.register((Object)new KeyEvents());
        MinecraftForge.EVENT_BUS.register((Object)new PlayerEvents());
        RenderingRegistry.registerEntityRenderingHandler(CAR_ENTITY_TYPE, GenericCarModel::new);
    }

    @SubscribeEvent
    public void registerItems(RegistryEvent.Register<Item> event) {
        event.getRegistry().registerAll((IForgeRegistryEntry[])ModBlocks.getBlocksWithItems().stream().map(block -> block.toItem()).toArray(Item[]::new));
        event.getRegistry().registerAll((IForgeRegistryEntry[])ModItems.getAll().toArray(new Item[0]));
    }

    @SubscribeEvent
    public void registerBlocks(RegistryEvent.Register<Block> event) {
        event.getRegistry().registerAll((IForgeRegistryEntry[])ModBlocks.getAll().toArray(new Block[0]));
        if (FMLEnvironment.dist == Dist.CLIENT) {
            RenderTypeLookup.setRenderLayer((Block)ModBlocks.CANOLA_CROP, (RenderType)RenderType.func_228643_e_());
            RenderTypeLookup.setRenderLayer((Block)ModBlocks.SPLIT_TANK, (RenderType)RenderType.func_228643_e_());
            for (BlockPaint block : ModBlocks.PAINTS) {
                RenderTypeLookup.setRenderLayer((Block)block, (RenderType)RenderType.func_228643_e_());
            }
            for (BlockPaint block : ModBlocks.YELLOW_PAINTS) {
                RenderTypeLookup.setRenderLayer((Block)block, (RenderType)RenderType.func_228643_e_());
            }
        }
    }

    @SubscribeEvent
    public void registerSounds(RegistryEvent.Register<SoundEvent> event) {
        event.getRegistry().registerAll((IForgeRegistryEntry[])ModSounds.getAll().toArray(new SoundEvent[0]));
    }

    @SubscribeEvent
    public void registerEntities(RegistryEvent.Register<EntityType<?>> event) {
        CAR_ENTITY_TYPE = CommonRegistry.registerEntity(MODID, MODID, EntityClassification.MISC, EntityGenericCar.class, builder -> builder.setTrackingRange(128).setUpdateInterval(1).setShouldReceiveVelocityUpdates(true).func_220321_a(1.0f, 1.0f).setCustomClientFactory((spawnEntity, world) -> new EntityGenericCar((World)world)));
        event.getRegistry().register(CAR_ENTITY_TYPE);
    }

    @SubscribeEvent
    public void registerContainers(RegistryEvent.Register<ContainerType<?>> event) {
        BACKMIX_REACTOR_CONTAINER_TYPE = new ContainerType(new ContainerFactoryTileEntity<ContainerBackmixReactor, TileEntityBackmixReactor>(ContainerBackmixReactor::new));
        BACKMIX_REACTOR_CONTAINER_TYPE.setRegistryName(new ResourceLocation(MODID, "backmix_reactor"));
        event.getRegistry().register(BACKMIX_REACTOR_CONTAINER_TYPE);
        BLAST_FURNACE_CONTAINER_TYPE = new ContainerType(new ContainerFactoryTileEntity<ContainerBlastFurnace, TileEntityBlastFurnace>(ContainerBlastFurnace::new));
        BLAST_FURNACE_CONTAINER_TYPE.setRegistryName(new ResourceLocation(MODID, "blast_furnace"));
        event.getRegistry().register(BLAST_FURNACE_CONTAINER_TYPE);
        CAR_CONTAINER_TYPE = new ContainerType((ContainerType.IFactory)((IContainerFactory)(windowId, inv, data) -> {
            EntityGenericCar car = EntityTools.getCarByUUID(inv.field_70458_d, data.func_179253_g());
            if (car == null) {
                return null;
            }
            return new ContainerCar(windowId, car, inv);
        }));
        CAR_CONTAINER_TYPE.setRegistryName(new ResourceLocation(MODID, MODID));
        event.getRegistry().register(CAR_CONTAINER_TYPE);
        CAR_INVENTORY_CONTAINER_TYPE = new ContainerType((ContainerType.IFactory)((IContainerFactory)(windowId, inv, data) -> {
            EntityGenericCar car = EntityTools.getCarByUUID(inv.field_70458_d, data.func_179253_g());
            if (car == null) {
                return null;
            }
            return new ContainerCarInventory(windowId, car, inv);
        }));
        CAR_INVENTORY_CONTAINER_TYPE.setRegistryName(new ResourceLocation(MODID, "car_inventory"));
        event.getRegistry().register(CAR_INVENTORY_CONTAINER_TYPE);
        CAR_WORKSHOP_CRAFTING_CONTAINER_TYPE = new ContainerType(new ContainerFactoryTileEntity<ContainerCarWorkshopCrafting, TileEntityCarWorkshop>(ContainerCarWorkshopCrafting::new));
        CAR_WORKSHOP_CRAFTING_CONTAINER_TYPE.setRegistryName(new ResourceLocation(MODID, "car_workshop_crafting"));
        event.getRegistry().register(CAR_WORKSHOP_CRAFTING_CONTAINER_TYPE);
        CAR_WORKSHOP_REPAIR_CONTAINER_TYPE = new ContainerType(new ContainerFactoryTileEntity<ContainerCarWorkshopRepair, TileEntityCarWorkshop>(ContainerCarWorkshopRepair::new));
        CAR_WORKSHOP_REPAIR_CONTAINER_TYPE.setRegistryName(new ResourceLocation(MODID, "car_workshop_repair"));
        event.getRegistry().register(CAR_WORKSHOP_REPAIR_CONTAINER_TYPE);
        FLUID_EXTRACTOR_CONTAINER_TYPE = new ContainerType(new ContainerFactoryTileEntity<ContainerFluidExtractor, TileEntityFluidExtractor>(ContainerFluidExtractor::new));
        FLUID_EXTRACTOR_CONTAINER_TYPE.setRegistryName(new ResourceLocation(MODID, "fluid_extractor"));
        event.getRegistry().register(FLUID_EXTRACTOR_CONTAINER_TYPE);
        FUEL_STATION_CONTAINER_TYPE = new ContainerType(new ContainerFactoryTileEntity<ContainerGasStation, TileEntityGasStation>(ContainerGasStation::new));
        FUEL_STATION_CONTAINER_TYPE.setRegistryName(new ResourceLocation(MODID, "fuel_station"));
        event.getRegistry().register(FUEL_STATION_CONTAINER_TYPE);
        FUEL_STATION_ADMIN_CONTAINER_TYPE = new ContainerType(new ContainerFactoryTileEntity<ContainerGasStationAdmin, TileEntityGasStation>(ContainerGasStationAdmin::new));
        FUEL_STATION_ADMIN_CONTAINER_TYPE.setRegistryName(new ResourceLocation(MODID, "fuel_station_admin"));
        event.getRegistry().register(FUEL_STATION_ADMIN_CONTAINER_TYPE);
        GENERATOR_CONTAINER_TYPE = new ContainerType(new ContainerFactoryTileEntity<ContainerGenerator, TileEntityGenerator>(ContainerGenerator::new));
        GENERATOR_CONTAINER_TYPE.setRegistryName(new ResourceLocation(MODID, "generator"));
        event.getRegistry().register(GENERATOR_CONTAINER_TYPE);
        LICENSE_PLATE_CONTAINER_TYPE = new ContainerType((id, inv) -> {
            ItemStack licensePlate = null;
            for (Hand hand : Hand.values()) {
                ItemStack stack = inv.field_70458_d.func_184586_b(hand);
                if (!(stack.func_77973_b() instanceof ItemLicensePlate)) continue;
                licensePlate = stack;
                break;
            }
            if (licensePlate != null) {
                return new ContainerLicensePlate(id, licensePlate);
            }
            return null;
        });
        LICENSE_PLATE_CONTAINER_TYPE.setRegistryName(new ResourceLocation(MODID, "license_plate"));
        event.getRegistry().register(LICENSE_PLATE_CONTAINER_TYPE);
        OIL_MILL_CONTAINER_TYPE = new ContainerType(new ContainerFactoryTileEntity<ContainerOilMill, TileEntityOilMill>(ContainerOilMill::new));
        OIL_MILL_CONTAINER_TYPE.setRegistryName(new ResourceLocation(MODID, "oil_mill"));
        event.getRegistry().register(OIL_MILL_CONTAINER_TYPE);
        PAINTER_CONTAINER_TYPE = new ContainerType((ContainerType.IFactory)((IContainerFactory)(windowId, inv, data) -> new ContainerPainter(windowId, inv, data.readBoolean())));
        PAINTER_CONTAINER_TYPE.setRegistryName(new ResourceLocation(MODID, "painter"));
        event.getRegistry().register(PAINTER_CONTAINER_TYPE);
        SIGN_CONTAINER_TYPE = new ContainerType(new ContainerFactoryTileEntity<ContainerSign, TileEntitySign>((windowId, tileEntity, inv) -> new ContainerSign(windowId, (TileEntitySign)tileEntity)));
        SIGN_CONTAINER_TYPE.setRegistryName(new ResourceLocation(MODID, "sign"));
        event.getRegistry().register(SIGN_CONTAINER_TYPE);
        SPLIT_TANK_CONTAINER_TYPE = new ContainerType(new ContainerFactoryTileEntity<ContainerSplitTank, TileEntitySplitTank>(ContainerSplitTank::new));
        SPLIT_TANK_CONTAINER_TYPE.setRegistryName(new ResourceLocation(MODID, "split_tank"));
        event.getRegistry().register(SPLIT_TANK_CONTAINER_TYPE);
    }

    @SubscribeEvent
    public void registerTileEntities(RegistryEvent.Register<TileEntityType<?>> event) {
        GENERATOR_TILE_ENTITY_TYPE = TileEntityType.Builder.func_223042_a(TileEntityGenerator::new, (Block[])new Block[]{ModBlocks.GENERATOR}).func_206865_a(null);
        GENERATOR_TILE_ENTITY_TYPE.setRegistryName(new ResourceLocation(MODID, "generator"));
        event.getRegistry().register(GENERATOR_TILE_ENTITY_TYPE);
        BACKMIX_REACTOR_TILE_ENTITY_TYPE = TileEntityType.Builder.func_223042_a(TileEntityBackmixReactor::new, (Block[])new Block[]{ModBlocks.BACKMIX_REACTOR}).func_206865_a(null);
        BACKMIX_REACTOR_TILE_ENTITY_TYPE.setRegistryName(new ResourceLocation(MODID, "backmix_reactor"));
        event.getRegistry().register(BACKMIX_REACTOR_TILE_ENTITY_TYPE);
        BLAST_FURNACE_TILE_ENTITY_TYPE = TileEntityType.Builder.func_223042_a(TileEntityBlastFurnace::new, (Block[])new Block[]{ModBlocks.BLAST_FURNACE}).func_206865_a(null);
        BLAST_FURNACE_TILE_ENTITY_TYPE.setRegistryName(new ResourceLocation(MODID, "blast_furnace"));
        event.getRegistry().register(BLAST_FURNACE_TILE_ENTITY_TYPE);
        CABLE_TILE_ENTITY_TYPE = TileEntityType.Builder.func_223042_a(TileEntityCable::new, (Block[])new Block[]{ModBlocks.CABLE}).func_206865_a(null);
        CABLE_TILE_ENTITY_TYPE.setRegistryName(new ResourceLocation(MODID, "cable"));
        event.getRegistry().register(CABLE_TILE_ENTITY_TYPE);
        CAR_WORKSHOP_TILE_ENTITY_TYPE = TileEntityType.Builder.func_223042_a(TileEntityCarWorkshop::new, (Block[])new Block[]{ModBlocks.CAR_WORKSHOP}).func_206865_a(null);
        CAR_WORKSHOP_TILE_ENTITY_TYPE.setRegistryName(new ResourceLocation(MODID, "car_workshop"));
        event.getRegistry().register(CAR_WORKSHOP_TILE_ENTITY_TYPE);
        DYNAMO_TILE_ENTITY_TYPE = TileEntityType.Builder.func_223042_a(TileEntityDynamo::new, (Block[])new Block[]{ModBlocks.DYNAMO}).func_206865_a(null);
        DYNAMO_TILE_ENTITY_TYPE.setRegistryName(new ResourceLocation(MODID, "dynamo"));
        event.getRegistry().register(DYNAMO_TILE_ENTITY_TYPE);
        FLUID_EXTRACTOR_TILE_ENTITY_TYPE = TileEntityType.Builder.func_223042_a(TileEntityFluidExtractor::new, (Block[])new Block[]{ModBlocks.FLUID_EXTRACTOR}).func_206865_a(null);
        FLUID_EXTRACTOR_TILE_ENTITY_TYPE.setRegistryName(new ResourceLocation(MODID, "fluid_extractor"));
        event.getRegistry().register(FLUID_EXTRACTOR_TILE_ENTITY_TYPE);
        OIL_MILL_TILE_ENTITY_TYPE = TileEntityType.Builder.func_223042_a(TileEntityOilMill::new, (Block[])new Block[]{ModBlocks.OIL_MILL}).func_206865_a(null);
        OIL_MILL_TILE_ENTITY_TYPE.setRegistryName(new ResourceLocation(MODID, "oil_mill"));
        event.getRegistry().register(OIL_MILL_TILE_ENTITY_TYPE);
        SIGN_TILE_ENTITY_TYPE = TileEntityType.Builder.func_223042_a(TileEntitySign::new, (Block[])new Block[]{ModBlocks.SIGN}).func_206865_a(null);
        SIGN_TILE_ENTITY_TYPE.setRegistryName(new ResourceLocation(MODID, "sign"));
        event.getRegistry().register(SIGN_TILE_ENTITY_TYPE);
        SPLIT_TANK_TILE_ENTITY_TYPE = TileEntityType.Builder.func_223042_a(TileEntitySplitTank::new, (Block[])new Block[]{ModBlocks.SPLIT_TANK}).func_206865_a(null);
        SPLIT_TANK_TILE_ENTITY_TYPE.setRegistryName(new ResourceLocation(MODID, "split_tank"));
        event.getRegistry().register(SPLIT_TANK_TILE_ENTITY_TYPE);
        TANK_TILE_ENTITY_TYPE = TileEntityType.Builder.func_223042_a(TileEntityTank::new, (Block[])new Block[]{ModBlocks.TANK}).func_206865_a(null);
        TANK_TILE_ENTITY_TYPE.setRegistryName(new ResourceLocation(MODID, "tank"));
        event.getRegistry().register(TANK_TILE_ENTITY_TYPE);
        GAS_STATION_TILE_ENTITY_TYPE = TileEntityType.Builder.func_223042_a(TileEntityGasStation::new, (Block[])new Block[]{ModBlocks.GAS_STATION}).func_206865_a(null);
        GAS_STATION_TILE_ENTITY_TYPE.setRegistryName(new ResourceLocation(MODID, "fuel_station"));
        event.getRegistry().register(GAS_STATION_TILE_ENTITY_TYPE);
    }

    @SubscribeEvent
    public void registerRecipes(RegistryEvent.Register<IRecipeSerializer<?>> event) {
        CRAFTING_SPECIAL_KEY = new SpecialRecipeSerializer(KeyRecipe::new);
        CRAFTING_SPECIAL_KEY.setRegistryName(new ResourceLocation(MODID, "crafting_special_key"));
        event.getRegistry().register(CRAFTING_SPECIAL_KEY);
        CRAFTING_BLAST_FURNACE = new RecipeSerializerBlastFurnace(BlastFurnaceRecipe::new);
        CRAFTING_BLAST_FURNACE.setRegistryName(new ResourceLocation(MODID, "blast_furnace"));
        event.getRegistry().register(CRAFTING_BLAST_FURNACE);
        CRAFTING_OIL_MILL = new RecipeSerializerOilMill(OilMillRecipe::new);
        CRAFTING_OIL_MILL.setRegistryName(new ResourceLocation(MODID, "oil_mill"));
        event.getRegistry().register(CRAFTING_OIL_MILL);
    }

    @SubscribeEvent
    public void registerSerializers(RegistryEvent.Register<DataSerializerEntry> event) {
        DataSerializerEntry dataSerializerEntryItemList = new DataSerializerEntry(DataSerializerItemList.ITEM_LIST);
        dataSerializerEntryItemList.setRegistryName(new ResourceLocation(MODID, "serializer_item_list"));
        event.getRegistry().register((IForgeRegistryEntry)dataSerializerEntryItemList);
    }

    @SubscribeEvent
    public void registerFluids(RegistryEvent.Register<Fluid> event) {
        event.getRegistry().registerAll((IForgeRegistryEntry[])new Fluid[]{ModFluids.CANOLA_OIL, ModFluids.CANOLA_OIL_FLOWING, ModFluids.METHANOL, ModFluids.METHANOL_FLOWING, ModFluids.CANOLA_METHANOL_MIX, ModFluids.CANOLA_METHANOL_MIX_FLOWING, ModFluids.GLYCERIN, ModFluids.GLYCERIN_FLOWING, ModFluids.BIO_DIESEL, ModFluids.BIO_DIESEL_FLOWING});
        if (FMLEnvironment.dist == Dist.CLIENT) {
            RenderTypeLookup.setRenderLayer((Fluid)ModFluids.CANOLA_OIL, (RenderType)RenderType.func_228645_f_());
            RenderTypeLookup.setRenderLayer((Fluid)ModFluids.CANOLA_OIL_FLOWING, (RenderType)RenderType.func_228645_f_());
            RenderTypeLookup.setRenderLayer((Fluid)ModFluids.METHANOL, (RenderType)RenderType.func_228645_f_());
            RenderTypeLookup.setRenderLayer((Fluid)ModFluids.METHANOL_FLOWING, (RenderType)RenderType.func_228645_f_());
            RenderTypeLookup.setRenderLayer((Fluid)ModFluids.CANOLA_METHANOL_MIX, (RenderType)RenderType.func_228645_f_());
            RenderTypeLookup.setRenderLayer((Fluid)ModFluids.CANOLA_METHANOL_MIX_FLOWING, (RenderType)RenderType.func_228645_f_());
            RenderTypeLookup.setRenderLayer((Fluid)ModFluids.GLYCERIN, (RenderType)RenderType.func_228645_f_());
            RenderTypeLookup.setRenderLayer((Fluid)ModFluids.GLYCERIN_FLOWING, (RenderType)RenderType.func_228645_f_());
            RenderTypeLookup.setRenderLayer((Fluid)ModFluids.BIO_DIESEL, (RenderType)RenderType.func_228645_f_());
            RenderTypeLookup.setRenderLayer((Fluid)ModFluids.BIO_DIESEL_FLOWING, (RenderType)RenderType.func_228645_f_());
        }
    }

    @SubscribeEvent
    public void registerPointsOfInterest(RegistryEvent.Register<PointOfInterestType> event) {
        POINT_OF_INTEREST_TYPE_GAS_STATION_ATTENDANT = new PointOfInterestType("gas_station_attendant", (Set)ImmutableSet.copyOf((Collection)ModBlocks.GAS_STATION.func_176194_O().func_177619_a()), 1, 1);
        POINT_OF_INTEREST_TYPE_GAS_STATION_ATTENDANT.setRegistryName(MODID, "gas_station_attendant");
        event.getRegistry().registerAll((IForgeRegistryEntry[])new PointOfInterestType[]{POINT_OF_INTEREST_TYPE_GAS_STATION_ATTENDANT});
        try {
            Method register = ObfuscationReflectionHelper.findMethod(PointOfInterestType.class, (String)"func_221052_a", (Class[])new Class[]{PointOfInterestType.class});
            register.invoke(null, POINT_OF_INTEREST_TYPE_GAS_STATION_ATTENDANT);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @SubscribeEvent
    public void registerVillagerProfessions(RegistryEvent.Register<VillagerProfession> event) {
        try {
            Constructor constructor = VillagerProfession.class.getDeclaredConstructor(String.class, PointOfInterestType.class, ImmutableSet.class, ImmutableSet.class, SoundEvent.class);
            constructor.setAccessible(true);
            VILLAGER_PROFESSION_GAS_STATION_ATTENDANT = (VillagerProfession)constructor.newInstance("gas_station_attendant", POINT_OF_INTEREST_TYPE_GAS_STATION_ATTENDANT, ImmutableSet.of(), ImmutableSet.of(), ModSounds.GAS_STATION_ATTENDANT);
            VILLAGER_PROFESSION_GAS_STATION_ATTENDANT.setRegistryName(MODID, "gas_station_attendant");
            event.getRegistry().registerAll((IForgeRegistryEntry[])new VillagerProfession[]{VILLAGER_PROFESSION_GAS_STATION_ATTENDANT});
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    static {
        RECIPE_TYPE_BLAST_FURNACE = (IRecipeType)Registry.func_218322_a((Registry)Registry.field_218367_H, (ResourceLocation)new ResourceLocation(MODID, "blast_furnace"), (Object)new IRecipeType<BlastFurnaceRecipe>(){

            public String toString() {
                return "blast_furnace";
            }
        });
        RECIPE_TYPE_OIL_MILL = (IRecipeType)Registry.func_218322_a((Registry)Registry.field_218367_H, (ResourceLocation)new ResourceLocation(MODID, "oil_mill"), (Object)new IRecipeType<BlastFurnaceRecipe>(){

            public String toString() {
                return "oil_mill";
            }
        });
    }
}

