/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.car.blocks;

import de.maxhenkel.car.ModItemGroups;
import de.maxhenkel.car.blocks.BlockBase;
import de.maxhenkel.car.blocks.BlockFluidPipe;
import de.maxhenkel.car.blocks.tileentity.TileEntityFluidExtractor;
import de.maxhenkel.car.corelib.block.IItemBlock;
import de.maxhenkel.car.corelib.block.VoxelUtils;
import de.maxhenkel.car.gui.ContainerFluidExtractor;
import de.maxhenkel.car.gui.TileEntityContainerProvider;
import javax.annotation.Nullable;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockRenderType;
import net.minecraft.block.BlockState;
import net.minecraft.block.ITileEntityProvider;
import net.minecraft.block.IWaterLoggable;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.material.MaterialColor;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.fluid.FluidState;
import net.minecraft.fluid.Fluids;
import net.minecraft.item.BlockItem;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.Item;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.DirectionProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.ITag;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;

public class BlockFluidExtractor
extends BlockBase
implements ITileEntityProvider,
IItemBlock,
IWaterLoggable {
    public static final DirectionProperty FACING = DirectionProperty.func_196962_a((String)"facing", (Direction[])Direction.values());
    public static final BooleanProperty DOWN = BooleanProperty.func_177716_a((String)"down");
    public static final BooleanProperty UP = BooleanProperty.func_177716_a((String)"up");
    public static final BooleanProperty NORTH = BooleanProperty.func_177716_a((String)"north");
    public static final BooleanProperty SOUTH = BooleanProperty.func_177716_a((String)"south");
    public static final BooleanProperty WEST = BooleanProperty.func_177716_a((String)"west");
    public static final BooleanProperty EAST = BooleanProperty.func_177716_a((String)"east");
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.field_208198_y;
    public static final VoxelShape SHAPE_NORTH = Block.func_208617_a((double)6.0, (double)6.0, (double)6.0, (double)10.0, (double)10.0, (double)0.0);
    public static final VoxelShape SHAPE_SOUTH = Block.func_208617_a((double)6.0, (double)6.0, (double)10.0, (double)10.0, (double)10.0, (double)16.0);
    public static final VoxelShape SHAPE_EAST = Block.func_208617_a((double)10.0, (double)6.0, (double)6.0, (double)16.0, (double)10.0, (double)10.0);
    public static final VoxelShape SHAPE_WEST = Block.func_208617_a((double)6.0, (double)6.0, (double)6.0, (double)0.0, (double)10.0, (double)10.0);
    public static final VoxelShape SHAPE_UP = Block.func_208617_a((double)6.0, (double)10.0, (double)6.0, (double)10.0, (double)16.0, (double)10.0);
    public static final VoxelShape SHAPE_DOWN = Block.func_208617_a((double)6.0, (double)6.0, (double)6.0, (double)10.0, (double)0.0, (double)10.0);
    public static final VoxelShape SHAPE_CORE = Block.func_208617_a((double)6.0, (double)6.0, (double)6.0, (double)10.0, (double)10.0, (double)10.0);
    public static final VoxelShape SHAPE_EXTRACTOR_NORTH = Block.func_208617_a((double)1.0, (double)1.0, (double)0.0, (double)15.0, (double)15.0, (double)1.0);
    public static final VoxelShape SHAPE_EXTRACTOR_SOUTH = Block.func_208617_a((double)1.0, (double)1.0, (double)15.0, (double)15.0, (double)15.0, (double)16.0);
    public static final VoxelShape SHAPE_EXTRACTOR_EAST = Block.func_208617_a((double)15.0, (double)1.0, (double)1.0, (double)16.0, (double)15.0, (double)15.0);
    public static final VoxelShape SHAPE_EXTRACTOR_WEST = Block.func_208617_a((double)0.0, (double)1.0, (double)1.0, (double)1.0, (double)15.0, (double)15.0);
    public static final VoxelShape SHAPE_EXTRACTOR_UP = Block.func_208617_a((double)1.0, (double)15.0, (double)1.0, (double)15.0, (double)16.0, (double)15.0);
    public static final VoxelShape SHAPE_EXTRACTOR_DOWN = Block.func_208617_a((double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)1.0, (double)15.0);

    protected BlockFluidExtractor() {
        super(AbstractBlock.Properties.func_200949_a((Material)Material.field_151580_n, (MaterialColor)MaterialColor.field_151670_w).func_200943_b(0.5f).func_200947_a(SoundType.field_185852_e));
        this.setRegistryName(new ResourceLocation("car", "fluid_extractor"));
        this.func_180632_j((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.field_176227_L.func_177621_b()).func_206870_a((Property)FACING, (Comparable)Direction.NORTH)).func_206870_a((Property)UP, (Comparable)Boolean.valueOf(false))).func_206870_a((Property)DOWN, (Comparable)Boolean.valueOf(false))).func_206870_a((Property)NORTH, (Comparable)Boolean.valueOf(false))).func_206870_a((Property)SOUTH, (Comparable)Boolean.valueOf(false))).func_206870_a((Property)EAST, (Comparable)Boolean.valueOf(false))).func_206870_a((Property)WEST, (Comparable)Boolean.valueOf(false))).func_206870_a((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    @Override
    public Item toItem() {
        return (Item)new BlockItem((Block)this, new Item.Properties().func_200916_a(ModItemGroups.TAB_CAR)).setRegistryName(this.getRegistryName());
    }

    public ActionResultType func_225533_a_(BlockState state, World worldIn, BlockPos pos, PlayerEntity player, Hand handIn, BlockRayTraceResult hit) {
        if (player.func_225608_bj_()) {
            return ActionResultType.FAIL;
        }
        TileEntity te = worldIn.func_175625_s(pos);
        if (!(te instanceof TileEntityFluidExtractor)) {
            return ActionResultType.FAIL;
        }
        TileEntityFluidExtractor fluidExtractor = (TileEntityFluidExtractor)te;
        if (player instanceof ServerPlayerEntity) {
            TileEntityContainerProvider.openGui((ServerPlayerEntity)player, fluidExtractor, (i, playerInventory, playerEntity) -> new ContainerFluidExtractor(i, fluidExtractor, playerInventory));
        }
        return ActionResultType.SUCCESS;
    }

    @Nullable
    public BlockState func_196258_a(BlockItemUseContext context) {
        Direction facing = context.func_196000_l().func_176734_d();
        return (BlockState)this.getState(context.func_195991_k(), context.func_195995_a(), facing).func_206870_a((Property)FACING, (Comparable)facing);
    }

    private BlockState getState(World world, BlockPos pos, Direction except) {
        FluidState ifluidstate = world.func_204610_c(pos);
        return (BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.func_176223_P().func_206870_a((Property)UP, (Comparable)Boolean.valueOf(!except.equals((Object)Direction.UP) && BlockFluidPipe.isConnectedTo((IBlockReader)world, pos, Direction.UP)))).func_206870_a((Property)DOWN, (Comparable)Boolean.valueOf(!except.equals((Object)Direction.DOWN) && BlockFluidPipe.isConnectedTo((IBlockReader)world, pos, Direction.DOWN)))).func_206870_a((Property)NORTH, (Comparable)Boolean.valueOf(!except.equals((Object)Direction.NORTH) && BlockFluidPipe.isConnectedTo((IBlockReader)world, pos, Direction.NORTH)))).func_206870_a((Property)SOUTH, (Comparable)Boolean.valueOf(!except.equals((Object)Direction.SOUTH) && BlockFluidPipe.isConnectedTo((IBlockReader)world, pos, Direction.SOUTH)))).func_206870_a((Property)EAST, (Comparable)Boolean.valueOf(!except.equals((Object)Direction.EAST) && BlockFluidPipe.isConnectedTo((IBlockReader)world, pos, Direction.EAST)))).func_206870_a((Property)WEST, (Comparable)Boolean.valueOf(!except.equals((Object)Direction.WEST) && BlockFluidPipe.isConnectedTo((IBlockReader)world, pos, Direction.WEST)))).func_206870_a((Property)WATERLOGGED, (Comparable)Boolean.valueOf(ifluidstate.func_206884_a((ITag)FluidTags.field_206959_a) && ifluidstate.func_206882_g() == 8));
    }

    public BlockState func_196271_a(BlockState stateIn, Direction facing, BlockState facingState, IWorld worldIn, BlockPos currentPos, BlockPos facingPos) {
        if (((Boolean)stateIn.func_177229_b((Property)WATERLOGGED)).booleanValue()) {
            worldIn.func_205219_F_().func_205360_a(currentPos, (Object)Fluids.field_204546_a, Fluids.field_204546_a.func_205569_a((IWorldReader)worldIn));
        }
        return super.func_196271_a(stateIn, facing, facingState, worldIn, currentPos, facingPos);
    }

    public void func_220069_a(BlockState state, World world, BlockPos pos, Block block, BlockPos pos1, boolean b) {
        super.func_220069_a(state, world, pos, block, pos1, b);
        Direction facing = (Direction)world.func_180495_p(pos).func_177229_b((Property)FACING);
        world.func_175656_a(pos, (BlockState)this.getState(world, pos, facing).func_206870_a((Property)FACING, (Comparable)facing));
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new Property[]{FACING, UP, DOWN, NORTH, SOUTH, EAST, WEST, WATERLOGGED});
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        VoxelShape shape = SHAPE_CORE;
        if (((Boolean)state.func_177229_b((Property)NORTH)).booleanValue()) {
            shape = VoxelUtils.combine(shape, SHAPE_NORTH);
        }
        if (((Boolean)state.func_177229_b((Property)SOUTH)).booleanValue()) {
            shape = VoxelUtils.combine(shape, SHAPE_SOUTH);
        }
        if (((Boolean)state.func_177229_b((Property)EAST)).booleanValue()) {
            shape = VoxelUtils.combine(shape, SHAPE_EAST);
        }
        if (((Boolean)state.func_177229_b((Property)WEST)).booleanValue()) {
            shape = VoxelUtils.combine(shape, SHAPE_WEST);
        }
        if (((Boolean)state.func_177229_b((Property)UP)).booleanValue()) {
            shape = VoxelUtils.combine(shape, SHAPE_UP);
        }
        if (((Boolean)state.func_177229_b((Property)DOWN)).booleanValue()) {
            shape = VoxelUtils.combine(shape, SHAPE_DOWN);
        }
        switch ((Direction)state.func_177229_b((Property)FACING)) {
            case NORTH: {
                shape = VoxelUtils.combine(shape, SHAPE_EXTRACTOR_NORTH, SHAPE_NORTH);
                break;
            }
            case SOUTH: {
                shape = VoxelUtils.combine(shape, SHAPE_EXTRACTOR_SOUTH, SHAPE_SOUTH);
                break;
            }
            case EAST: {
                shape = VoxelUtils.combine(shape, SHAPE_EXTRACTOR_EAST, SHAPE_EAST);
                break;
            }
            case WEST: {
                shape = VoxelUtils.combine(shape, SHAPE_EXTRACTOR_WEST, SHAPE_WEST);
                break;
            }
            case UP: {
                shape = VoxelUtils.combine(shape, SHAPE_EXTRACTOR_UP, SHAPE_UP);
                break;
            }
            case DOWN: {
                shape = VoxelUtils.combine(shape, SHAPE_EXTRACTOR_DOWN, SHAPE_DOWN);
            }
        }
        return shape;
    }

    public FluidState func_204507_t(BlockState state) {
        return (Boolean)state.func_177229_b((Property)WATERLOGGED) != false ? Fluids.field_204546_a.func_207204_a(false) : super.func_204507_t(state);
    }

    public BlockRenderType func_149645_b(BlockState state) {
        return BlockRenderType.MODEL;
    }

    @Nullable
    public TileEntity func_196283_a_(IBlockReader worldIn) {
        return new TileEntityFluidExtractor();
    }
}

