/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.car.blocks.tileentity;

import de.maxhenkel.car.Main;
import de.maxhenkel.car.corelib.entity.EntityUtils;
import de.maxhenkel.car.corelib.net.NetUtils;
import de.maxhenkel.car.net.MessageSyncTileEntity;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SUpdateTileEntityPacket;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.IIntArray;
import net.minecraft.util.INameable;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.server.ServerWorld;

public abstract class TileEntityBase
extends TileEntity
implements INameable {
    private ITextComponent name;
    private CompoundNBT compoundLast;

    public TileEntityBase(TileEntityType<?> tileEntityTypeIn) {
        super(tileEntityTypeIn);
    }

    public void synchronize() {
        if (!this.field_145850_b.field_72995_K && this.field_145850_b instanceof ServerWorld) {
            CompoundNBT last = this.func_189515_b(new CompoundNBT());
            if (this.compoundLast == null || !this.compoundLast.equals((Object)last)) {
                ServerWorld serverWorld = (ServerWorld)this.field_145850_b;
                MessageSyncTileEntity msg = new MessageSyncTileEntity(this.field_174879_c, last);
                EntityUtils.forEachPlayerAround(serverWorld, this.func_174877_v(), 128.0, playerEntity -> NetUtils.sendTo(Main.SIMPLE_CHANNEL, playerEntity, msg));
                this.compoundLast = last;
            }
        }
    }

    public void synchronize(int ticks) {
        if (this.field_145850_b.func_82737_E() % (long)ticks == 0L) {
            this.synchronize();
        }
    }

    public void onDataPacket(NetworkManager net, SUpdateTileEntityPacket pkt) {
        this.func_230337_a_(this.func_195044_w(), pkt.func_148857_g());
    }

    public CompoundNBT func_189517_E_() {
        return this.func_189515_b(new CompoundNBT());
    }

    public abstract ITextComponent getTranslatedName();

    public void setCustomName(ITextComponent name) {
        this.name = name;
    }

    public ITextComponent func_200200_C_() {
        return this.name != null ? this.name : this.getTranslatedName();
    }

    @Nullable
    public ITextComponent func_200201_e() {
        return this.name;
    }

    public abstract IIntArray getFields();

    public CompoundNBT func_189515_b(CompoundNBT compound) {
        if (this.name != null) {
            compound.func_74778_a("CustomName", ITextComponent.Serializer.func_150696_a((ITextComponent)this.name));
        }
        return super.func_189515_b(compound);
    }

    public void func_230337_a_(BlockState blockState, CompoundNBT compound) {
        if (compound.func_74764_b("CustomName")) {
            this.name = ITextComponent.Serializer.func_240643_a_((String)compound.func_74779_i("CustomName"));
        }
        super.func_230337_a_(blockState, compound);
    }
}

