/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.car.integration.jei;

import de.maxhenkel.car.integration.jei.CarRecipe;
import de.maxhenkel.car.items.ModItems;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IItemProvider;

public class CarRecipeBuilder {
    public static List<CarRecipe> getAllRecipes() {
        ArrayList<CarRecipe> recipes = new ArrayList<CarRecipe>();
        ItemStack wheel = new ItemStack((IItemProvider)ModItems.WHEEL);
        ItemStack largeWheel = new ItemStack((IItemProvider)ModItems.BIG_WHEEL);
        for (ItemStack tank : CarRecipeBuilder.getAllTanks()) {
            for (ItemStack engine : CarRecipeBuilder.getAllEngines()) {
                for (ItemStack plate : CarRecipeBuilder.getAllLicensePlateHolders()) {
                    for (ItemStack bumper : CarRecipeBuilder.getAllBumpers()) {
                        for (ItemStack body : CarRecipeBuilder.getWoodBodies()) {
                            recipes.add(new CarRecipe(body, bumper, plate, tank, engine, wheel, wheel, wheel, wheel));
                        }
                    }
                    for (ItemStack body : CarRecipeBuilder.getSUVBodies()) {
                        recipes.add(new CarRecipe(body, plate, tank, engine, largeWheel, largeWheel, largeWheel, largeWheel));
                    }
                    for (ItemStack body : CarRecipeBuilder.getSportBodies()) {
                        recipes.add(new CarRecipe(body, plate, tank, engine, wheel, wheel, wheel, wheel));
                    }
                    for (ItemStack container : CarRecipeBuilder.getAllContainers()) {
                        for (ItemStack body : CarRecipeBuilder.getTransporters()) {
                            recipes.add(new CarRecipe(body, container, plate, tank, engine, wheel, wheel, wheel, wheel, wheel, wheel));
                        }
                    }
                    for (ItemStack container : CarRecipeBuilder.getAllTankContainers()) {
                        for (ItemStack body : CarRecipeBuilder.getTransporters()) {
                            recipes.add(new CarRecipe(body, container, plate, tank, engine, wheel, wheel, wheel, wheel, wheel, wheel));
                        }
                    }
                }
            }
        }
        return recipes;
    }

    public static List<ItemStack> getWoodBodies() {
        return CarRecipeBuilder.concatItems(ModItems.BIG_WOOD_BODIES, ModItems.WOOD_BODIES);
    }

    public static List<ItemStack> getTransporters() {
        return CarRecipeBuilder.concatItems(new Item[][]{ModItems.TRANSPORTER_BODIES});
    }

    public static List<ItemStack> getSUVBodies() {
        return CarRecipeBuilder.concatItems(new Item[][]{ModItems.SUV_BODIES});
    }

    public static List<ItemStack> getSportBodies() {
        return CarRecipeBuilder.concatItems(new Item[][]{ModItems.SPORT_BODIES});
    }

    public static List<ItemStack> getAllBodies() {
        return CarRecipeBuilder.concatItems(ModItems.BIG_WOOD_BODIES, ModItems.WOOD_BODIES, ModItems.SPORT_BODIES, ModItems.SUV_BODIES, ModItems.TRANSPORTER_BODIES);
    }

    public static List<ItemStack> getAllWoodBodies() {
        return CarRecipeBuilder.concatItems(new Item[][]{ModItems.WOOD_BODIES});
    }

    public static List<ItemStack> getAllBigWoodBodies() {
        return CarRecipeBuilder.concatItems(new Item[][]{ModItems.BIG_WOOD_BODIES});
    }

    public static List<ItemStack> getAllBumpers() {
        return CarRecipeBuilder.concatItems(new Item[][]{ModItems.BUMPERS});
    }

    public static List<ItemStack> getAllContainers() {
        return CarRecipeBuilder.concatItems(new Item[][]{ModItems.CONTAINERS});
    }

    public static List<ItemStack> getAllTankContainers() {
        return CarRecipeBuilder.concatItems(new Item[][]{ModItems.TANK_CONTAINERS});
    }

    public static List<ItemStack> getAllLicensePlateHolders() {
        List<ItemStack> bumpers = CarRecipeBuilder.concatItems(new Item[][]{ModItems.WOODEN_LICENSE_PLATE_HOLDERS});
        bumpers.add(new ItemStack((IItemProvider)ModItems.IRON_LICENSE_PLATE_HOLDER));
        bumpers.add(new ItemStack((IItemProvider)ModItems.GOLD_LICENSE_PLATE_HOLDER));
        bumpers.add(new ItemStack((IItemProvider)ModItems.EMERALD_LICENSE_PLATE_HOLDER));
        bumpers.add(new ItemStack((IItemProvider)ModItems.DIAMOND_LICENSE_PLATE_HOLDER));
        return bumpers;
    }

    public static List<ItemStack> getAllEngines() {
        return Arrays.asList(new ItemStack((IItemProvider)ModItems.ENGINE_3_CYLINDER), new ItemStack((IItemProvider)ModItems.ENGINE_6_CYLINDER), new ItemStack((IItemProvider)ModItems.ENGINE_TRUCK));
    }

    public static List<ItemStack> getAllTanks() {
        return Arrays.asList(new ItemStack((IItemProvider)ModItems.SMALL_TANK), new ItemStack((IItemProvider)ModItems.MEDIUM_TANK), new ItemStack((IItemProvider)ModItems.LARGE_TANK));
    }

    public static List<ItemStack> concatItems(Item[] ... items) {
        return CarRecipeBuilder.concatArrays(items).stream().map(item -> new ItemStack((IItemProvider)item)).collect(Collectors.toList());
    }

    private static <T> List<T> concatArrays(T[] ... arrays) {
        ArrayList<T> list = new ArrayList<T>();
        T[][] TArray = arrays;
        int n = TArray.length;
        for (int i = 0; i < n; ++i) {
            T[] array;
            for (T element : array = TArray[i]) {
                list.add(element);
            }
        }
        return list;
    }
}

