/*
 * Decompiled with CFR 0.152.
 */
package com.carpentersblocks.block;

import com.carpentersblocks.block.BlockFacing;
import com.carpentersblocks.tileentity.CbTileEntity;
import com.carpentersblocks.util.block.CollapsibleUtil;
import com.carpentersblocks.util.registry.ConfigRegistry;
import java.util.Arrays;
import java.util.List;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockCarpentersCollapsibleBlock
extends BlockFacing {
    public BlockCarpentersCollapsibleBlock(Material material) {
        super(material);
        this.func_149713_g(0);
    }

    @Override
    protected boolean onHammerLeftClick(CbTileEntity cbTileEntity, EntityPlayer entityPlayer) {
        CollapsibleUtil util = new CollapsibleUtil(cbTileEntity);
        int quad = util.getHitQuad();
        int depth = util.getQuadDepth(quad);
        CollapsibleUtil.setQuadDepth(cbTileEntity, quad, --depth);
        this.smoothAdjacentCollapsibles(cbTileEntity, quad);
        return true;
    }

    @Override
    protected boolean onHammerRightClick(CbTileEntity cbTileEntity, EntityPlayer entityPlayer) {
        CollapsibleUtil util = new CollapsibleUtil(cbTileEntity);
        int quad = util.getHitQuad();
        int depth = util.getQuadDepth(quad);
        CollapsibleUtil.setQuadDepth(cbTileEntity, quad, ++depth);
        this.smoothAdjacentCollapsibles(cbTileEntity, quad);
        return true;
    }

    @Override
    protected void damageItemWithChance(World world, EntityPlayer entityPlayer, EnumHand hand) {
        if ((double)world.field_73012_v.nextFloat() <= ConfigRegistry.itemHammerDamageChanceFromCollapsible) {
            super.damageItemWithChance(world, entityPlayer, hand);
        }
    }

    private boolean isSameOrientation(CbTileEntity cbTileEntity1, CbTileEntity cbTileEntity2) {
        return new CollapsibleUtil(cbTileEntity1).getFacing().equals((Object)new CollapsibleUtil(cbTileEntity2).getFacing());
    }

    private void smoothAdjacentCollapsibles(CbTileEntity cbTileEntity, int src_quadrant) {
        CollapsibleUtil util = new CollapsibleUtil(cbTileEntity);
        CbTileEntity cbTileEntity_XN = this.getTileEntity((IBlockAccess)cbTileEntity.func_145831_w(), cbTileEntity.func_174877_v().func_177982_a(-1, 0, 0));
        CbTileEntity cbTileEntity_XP = this.getTileEntity((IBlockAccess)cbTileEntity.func_145831_w(), cbTileEntity.func_174877_v().func_177982_a(1, 0, 0));
        CbTileEntity cbTileEntity_ZN = this.getTileEntity((IBlockAccess)cbTileEntity.func_145831_w(), cbTileEntity.func_174877_v().func_177982_a(0, 0, -1));
        CbTileEntity cbTileEntity_ZP = this.getTileEntity((IBlockAccess)cbTileEntity.func_145831_w(), cbTileEntity.func_174877_v().func_177982_a(0, 0, 1));
        CbTileEntity cbTileEntity_XZNN = this.getTileEntity((IBlockAccess)cbTileEntity.func_145831_w(), cbTileEntity.func_174877_v().func_177982_a(-1, 0, -1));
        CbTileEntity cbTileEntity_XZNP = this.getTileEntity((IBlockAccess)cbTileEntity.func_145831_w(), cbTileEntity.func_174877_v().func_177982_a(-1, 0, 1));
        CbTileEntity cbTileEntity_XZPN = this.getTileEntity((IBlockAccess)cbTileEntity.func_145831_w(), cbTileEntity.func_174877_v().func_177982_a(1, 0, -1));
        CbTileEntity cbTileEntity_XZPP = this.getTileEntity((IBlockAccess)cbTileEntity.func_145831_w(), cbTileEntity.func_174877_v().func_177982_a(1, 0, 1));
        int depth = util.getQuadDepth(src_quadrant);
        switch (src_quadrant) {
            case 0: {
                if (cbTileEntity_ZN != null && this.isSameOrientation(cbTileEntity, cbTileEntity_ZN)) {
                    CollapsibleUtil.setQuadDepth(cbTileEntity_ZN, 1, depth);
                }
                if (cbTileEntity_XZNN != null && this.isSameOrientation(cbTileEntity, cbTileEntity_XZNN)) {
                    CollapsibleUtil.setQuadDepth(cbTileEntity_XZNN, 3, depth);
                }
                if (cbTileEntity_XN == null || !this.isSameOrientation(cbTileEntity, cbTileEntity_XN)) break;
                CollapsibleUtil.setQuadDepth(cbTileEntity_XN, 2, depth);
                break;
            }
            case 1: {
                if (cbTileEntity_XN != null && this.isSameOrientation(cbTileEntity, cbTileEntity_XN)) {
                    CollapsibleUtil.setQuadDepth(cbTileEntity_XN, 3, depth);
                }
                if (cbTileEntity_XZNP != null && this.isSameOrientation(cbTileEntity, cbTileEntity_XZNP)) {
                    CollapsibleUtil.setQuadDepth(cbTileEntity_XZNP, 2, depth);
                }
                if (cbTileEntity_ZP == null || !this.isSameOrientation(cbTileEntity, cbTileEntity_ZP)) break;
                CollapsibleUtil.setQuadDepth(cbTileEntity_ZP, 0, depth);
                break;
            }
            case 2: {
                if (cbTileEntity_XP != null && this.isSameOrientation(cbTileEntity, cbTileEntity_XP)) {
                    CollapsibleUtil.setQuadDepth(cbTileEntity_XP, 0, depth);
                }
                if (cbTileEntity_XZPN != null && this.isSameOrientation(cbTileEntity, cbTileEntity_XZPN)) {
                    CollapsibleUtil.setQuadDepth(cbTileEntity_XZPN, 1, depth);
                }
                if (cbTileEntity_ZN == null || !this.isSameOrientation(cbTileEntity, cbTileEntity_ZN)) break;
                CollapsibleUtil.setQuadDepth(cbTileEntity_ZN, 3, depth);
                break;
            }
            case 3: {
                if (cbTileEntity_ZP != null && this.isSameOrientation(cbTileEntity, cbTileEntity_ZP)) {
                    CollapsibleUtil.setQuadDepth(cbTileEntity_ZP, 2, depth);
                }
                if (cbTileEntity_XZPP != null && this.isSameOrientation(cbTileEntity, cbTileEntity_XZPP)) {
                    CollapsibleUtil.setQuadDepth(cbTileEntity_XZPP, 0, depth);
                }
                if (cbTileEntity_XP == null || !this.isSameOrientation(cbTileEntity, cbTileEntity_XP)) break;
                CollapsibleUtil.setQuadDepth(cbTileEntity_XP, 1, depth);
            }
        }
    }

    public AxisAlignedBB func_185496_a(IBlockState blockState, IBlockAccess blockAccess, BlockPos blockPos) {
        CbTileEntity cbTileEntity = this.getTileEntity(blockAccess, blockPos);
        if (cbTileEntity != null) {
            CollapsibleUtil util = new CollapsibleUtil(cbTileEntity);
            float maxDepth = util.getBoundsMaxDepth();
            if (util.isPositive()) {
                return new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, (double)maxDepth, 1.0);
            }
            return new AxisAlignedBB(0.0, (double)(1.0f - maxDepth), 0.0, 1.0, 1.0, 1.0);
        }
        return super.func_185496_a(blockState, blockAccess, blockPos);
    }

    public boolean isSideSolid(IBlockState blockState, IBlockAccess blockAccess, BlockPos blockPos, EnumFacing facing) {
        CbTileEntity cbTileEntity = this.getTileEntity(blockAccess, blockPos);
        if (cbTileEntity != null) {
            CollapsibleUtil util = new CollapsibleUtil(cbTileEntity);
            if (this.isBlockSolid(blockAccess, blockPos)) {
                return util.isSideSolid(facing);
            }
        }
        return false;
    }

    private boolean isSlopeBoundary(World world, BlockPos blockPos) {
        CbTileEntity cbTileEntity = this.getTileEntity((IBlockAccess)world, blockPos);
        if (cbTileEntity != null) {
            return true;
        }
        boolean blocksMovement_Y = world.func_180495_p(blockPos).func_185904_a().func_76230_c();
        boolean blocksMovement_YN = world.func_180495_p(blockPos.func_177982_a(0, -1, 0)).func_185904_a().func_76230_c();
        return blocksMovement_Y || blocksMovement_YN;
    }

    private int scanX(World world, BlockPos blockPos, int dir, int maxDist) {
        for (int nx = blockPos.func_177958_n() + dir; nx != blockPos.func_177958_n() + maxDist * dir; nx += dir) {
            if (!this.isSlopeBoundary(world, new BlockPos(nx, blockPos.func_177956_o(), blockPos.func_177952_p()))) continue;
            return nx;
        }
        return blockPos.func_177958_n() + dir;
    }

    private int scanZ(World world, BlockPos blockPos, int dir, int maxDist) {
        for (int nz = blockPos.func_177952_p() + dir; nz != blockPos.func_177952_p() + maxDist * dir; nz += dir) {
            if (!this.isSlopeBoundary(world, new BlockPos(blockPos.func_177958_n(), blockPos.func_177956_o(), nz))) continue;
            return nz;
        }
        return blockPos.func_177952_p() + dir;
    }

    private static int getBlockHeight(IBlockAccess blockAccess, BlockPos blockPos) {
        IBlockState blockState = blockAccess.func_180495_p(blockPos);
        if (!blockState.func_185904_a().func_76230_c()) {
            return 0;
        }
        return (int)(blockState.func_185900_c((IBlockAccess)blockAccess, (BlockPos)blockPos).field_72337_e * 16.0);
    }

    @Override
    public boolean func_176198_a(World world, BlockPos blockPos, EnumFacing facing) {
        if (!this.canAttachToFacing(facing)) {
            EnumFacing.Plane plane = EnumFacing.Plane.VERTICAL;
            for (EnumFacing dir : plane.func_179516_a()) {
                if (!world.isSideSolid(blockPos.func_177972_a(dir.func_176734_d()), dir)) continue;
                return true;
            }
            return false;
        }
        return true;
    }

    @Override
    public void func_180633_a(World world, BlockPos blockPos, IBlockState blockState, EntityLivingBase entityLivingBase, ItemStack itemStack) {
        CbTileEntity cbTileEntity;
        super.func_180633_a(world, blockPos, blockState, entityLivingBase, itemStack);
        if (!entityLivingBase.func_70093_af() && (cbTileEntity = this.getTileEntity((IBlockAccess)world, blockPos)) != null) {
            int hzp2;
            int hzp1;
            int hzn2;
            int hzn1;
            int hxp2;
            int hxp1;
            int hxn2;
            int hxn1;
            CollapsibleUtil util = new CollapsibleUtil(cbTileEntity);
            boolean MIN_HEIGHT = false;
            int MAX_HEIGHT = 16;
            int xn = this.scanX(world, blockPos, -1, 16);
            int xp = this.scanX(world, blockPos, 1, 16);
            int zn = this.scanZ(world, blockPos, -1, 16);
            int zp = this.scanZ(world, blockPos, 1, 16);
            CbTileEntity cbTileEntity_XN = this.getTileEntity((IBlockAccess)world, blockPos.func_177982_a(-1, 0, 0));
            CbTileEntity cbTileEntity_XP = this.getTileEntity((IBlockAccess)world, blockPos.func_177982_a(1, 0, 0));
            CbTileEntity cbTileEntity_ZN = this.getTileEntity((IBlockAccess)world, blockPos.func_177982_a(0, 0, -1));
            CbTileEntity cbTileEntity_ZP = this.getTileEntity((IBlockAccess)world, blockPos.func_177982_a(0, 0, 1));
            int height_XZNN = 0;
            int height_XZPN = 0;
            int height_XZPP = 0;
            int height_XZNP = 0;
            if (cbTileEntity_XN != null && this.isSameOrientation(cbTileEntity, cbTileEntity_XN)) {
                CollapsibleUtil utilXN = new CollapsibleUtil(cbTileEntity_XN);
                hxn1 = utilXN.getQuadDepth(2);
                hxn2 = utilXN.getQuadDepth(3);
            } else {
                hxn1 = hxn2 = BlockCarpentersCollapsibleBlock.getBlockHeight((IBlockAccess)world, blockPos.func_177982_a(-1, 0, 0));
            }
            if (cbTileEntity_XP != null && this.isSameOrientation(cbTileEntity, cbTileEntity_XP)) {
                CollapsibleUtil utilXP = new CollapsibleUtil(cbTileEntity_XP);
                hxp1 = utilXP.getQuadDepth(0);
                hxp2 = utilXP.getQuadDepth(1);
            } else {
                hxp1 = hxp2 = BlockCarpentersCollapsibleBlock.getBlockHeight((IBlockAccess)world, blockPos.func_177982_a(1, 0, 0));
            }
            if (cbTileEntity_ZN != null && this.isSameOrientation(cbTileEntity, cbTileEntity_ZN)) {
                CollapsibleUtil utilZN = new CollapsibleUtil(cbTileEntity_ZN);
                hzn1 = utilZN.getQuadDepth(1);
                hzn2 = utilZN.getQuadDepth(3);
            } else {
                hzn1 = hzn2 = BlockCarpentersCollapsibleBlock.getBlockHeight((IBlockAccess)world, blockPos.func_177982_a(0, 0, -1));
            }
            if (cbTileEntity_ZP != null && this.isSameOrientation(cbTileEntity, cbTileEntity_ZP)) {
                CollapsibleUtil utilZP = new CollapsibleUtil(cbTileEntity_ZP);
                hzp1 = utilZP.getQuadDepth(0);
                hzp2 = utilZP.getQuadDepth(2);
            } else {
                hzp1 = hzp2 = BlockCarpentersCollapsibleBlock.getBlockHeight((IBlockAccess)world, blockPos.func_177982_a(0, 0, 1));
            }
            int xdist = blockPos.func_177958_n() - blockPos.func_177982_a(-1, 0, 0).func_177958_n();
            double dx1 = (double)(hxp1 - hxn1) / (double)(xp - xn - 1);
            double dx2 = (double)(hxp2 - hxn2) / (double)(xp - xn - 1);
            height_XZNN = Math.max(height_XZNN, (int)((double)hxn1 + dx1 * (double)(xdist - 1)));
            height_XZNP = Math.max(height_XZNP, (int)((double)hxn2 + dx2 * (double)(xdist - 1)));
            height_XZPN = Math.max(height_XZPN, (int)((double)hxn1 + dx1 * (double)xdist));
            height_XZPP = Math.max(height_XZPP, (int)((double)hxn2 + dx2 * (double)xdist));
            int zdist = blockPos.func_177952_p() - blockPos.func_177982_a(0, 0, -1).func_177952_p();
            double dz1 = (double)(hzp1 - hzn1) / (double)(zp - zn - 1);
            double dz2 = (double)(hzp2 - hzn2) / (double)(zp - zn - 1);
            height_XZNN = Math.max(height_XZNN, (int)((double)hzn1 + dz1 * (double)(zdist - 1)));
            height_XZNP = Math.max(height_XZNP, (int)((double)hzn1 + dz1 * (double)zdist));
            height_XZPN = Math.max(height_XZPN, (int)((double)hzn2 + dz2 * (double)(zdist - 1)));
            height_XZPP = Math.max(height_XZPP, (int)((double)hzn2 + dz2 * (double)zdist));
            CollapsibleUtil.setQuadDepth(cbTileEntity, 0, height_XZNN);
            CollapsibleUtil.setQuadDepth(cbTileEntity, 1, height_XZNP);
            CollapsibleUtil.setQuadDepth(cbTileEntity, 3, height_XZPP);
            CollapsibleUtil.setQuadDepth(cbTileEntity, 2, height_XZPN);
            for (int quad = 0; quad < 4; ++quad) {
                this.smoothAdjacentCollapsibles(cbTileEntity, quad);
            }
        }
    }

    public void func_185477_a(IBlockState blockState, World world, BlockPos blockPos, AxisAlignedBB axisAlignedBB, List<AxisAlignedBB> collidingBoxes, Entity entity, boolean unused) {
        CbTileEntity cbTileEntity = this.getTileEntity((IBlockAccess)world, blockPos);
        if (cbTileEntity != null) {
            CollapsibleUtil util = new CollapsibleUtil(cbTileEntity);
            for (int quad = 0; quad < 4; ++quad) {
                BlockCarpentersCollapsibleBlock.func_185492_a((BlockPos)blockPos, (AxisAlignedBB)axisAlignedBB, collidingBoxes, (AxisAlignedBB)util.genQuadBoundingBox(quad));
            }
        }
    }

    @Override
    public RayTraceResult func_180636_a(IBlockState blockState, World world, BlockPos blockPos, Vec3d start, Vec3d end) {
        CbTileEntity cbTileEntity = this.getTileEntity((IBlockAccess)world, blockPos);
        if (cbTileEntity == null) {
            return super.func_185503_a(blockPos, start, end, field_185505_j);
        }
        CollapsibleUtil util = new CollapsibleUtil(cbTileEntity);
        RayTraceResult finalTrace = null;
        double currDist = 0.0;
        double maxDist = 0.0;
        for (int quad = 0; quad < 4; ++quad) {
            AxisAlignedBB box = util.genQuadBoundingBox(quad);
            RayTraceResult traceResult = this.func_185503_a(blockPos, start, end, box);
            if (traceResult == null || !((currDist = traceResult.field_72307_f.func_72436_e(end)) > maxDist)) continue;
            finalTrace = traceResult;
            maxDist = currDist;
        }
        return finalTrace;
    }

    @Override
    protected boolean shareFaces(CbTileEntity cbTileEntity_adj, CbTileEntity cbTileEntity_src, EnumFacing side_adj, EnumFacing side_src) {
        return false;
    }

    @Override
    public boolean canAttachToFacing(EnumFacing facing) {
        return Arrays.asList(EnumFacing.Plane.VERTICAL.func_179516_a()).contains(facing);
    }

    @Override
    public boolean canFloat() {
        return true;
    }

    public boolean func_149662_c(IBlockState blockState) {
        return false;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    @Override
    public void setFacing(CbTileEntity cbTileEntity, EnumFacing facing) {
        new CollapsibleUtil(cbTileEntity).setFacing(cbTileEntity, facing);
    }

    @Override
    public EnumFacing getFacing(CbTileEntity cbTileEntity) {
        return new CollapsibleUtil(cbTileEntity).getFacing();
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.SOLID;
    }
}

