/*
 * Decompiled with CFR 0.152.
 */
package com.carpentersblocks.renderer.bakedblock;

import com.carpentersblocks.block.data.SlopeData;
import com.carpentersblocks.renderer.AbstractBakedModel;
import com.carpentersblocks.renderer.Quad;
import com.carpentersblocks.renderer.RenderPkg;
import com.carpentersblocks.renderer.helper.RenderHelper;
import com.carpentersblocks.renderer.helper.RenderHelperSlope;
import com.carpentersblocks.util.RotationUtil;
import com.carpentersblocks.util.registry.SpriteRegistry;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.vertex.VertexFormat;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.Vec3d;
import net.minecraftforge.common.model.IModelState;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class BakedSlope
extends AbstractBakedModel {
    private String _type;
    private static Map<String, List<BakedQuad>> _inventoryBakedQuads = new HashMap<String, List<BakedQuad>>();

    public BakedSlope(IModelState modelState, VertexFormat vertexFormat, Function<ResourceLocation, TextureAtlasSprite> bakedTextureGetter, String type) {
        super(modelState, vertexFormat, bakedTextureGetter);
        this._type = type;
    }

    @Override
    public List<BakedQuad> getInventoryQuads(RenderPkg renderPkg) {
        if (!_inventoryBakedQuads.containsKey(this._type)) {
            switch (this._type) {
                case "wedge": {
                    this.fillWedge(renderPkg);
                    break;
                }
                case "wedge_interior": {
                    this.fillWedgeInterior(renderPkg);
                    break;
                }
                case "wedge_exterior": {
                    this.fillWedgeExterior(renderPkg);
                    break;
                }
                case "oblique_interior": {
                    this.fillObliqueInterior(renderPkg);
                    break;
                }
                case "oblique_exterior": {
                    this.fillObliqueExterior(renderPkg);
                    break;
                }
                case "prism_wedge": {
                    this.fillPrismWedge(renderPkg);
                    break;
                }
                case "prism": {
                    this.fillPrism(renderPkg, 0);
                    break;
                }
                case "invert_prism": {
                    this.fillInvertPrism(renderPkg, 0);
                }
            }
            renderPkg.rotate(RotationUtil.Rotation.X0_Y90_Z0);
            _inventoryBakedQuads.put(this._type, renderPkg.getInventoryQuads());
        }
        return _inventoryBakedQuads.get(this._type);
    }

    @Override
    protected void fillQuads(RenderPkg renderPkg) {
        switch (SlopeData.getType(renderPkg.getData())) {
            case WEDGE: {
                this.fillWedge(renderPkg);
                break;
            }
            case WEDGE_INTERIOR: {
                this.fillWedgeInterior(renderPkg);
                break;
            }
            case WEDGE_EXTERIOR: {
                this.fillWedgeExterior(renderPkg);
                break;
            }
            case OBLIQUE_INTERIOR: {
                this.fillObliqueInterior(renderPkg);
                break;
            }
            case OBLIQUE_EXTERIOR: {
                this.fillObliqueExterior(renderPkg);
                break;
            }
            case PRISM_WEDGE: {
                this.fillPrismWedge(renderPkg);
                break;
            }
            case PRISM: {
                this.fillPrism(renderPkg, 0);
                break;
            }
            case PRISM_1P: {
                this.fillPrism(renderPkg, 1);
                break;
            }
            case PRISM_2P: {
                this.fillPrism(renderPkg, 2);
                break;
            }
            case PRISM_3P: {
                this.fillPrism(renderPkg, 3);
                break;
            }
            case PRISM_4P: {
                this.fillPrism(renderPkg, 4);
                break;
            }
            case INVERT_PRISM: {
                this.fillInvertPrism(renderPkg, 0);
                break;
            }
            case INVERT_PRISM_1P: {
                this.fillInvertPrism(renderPkg, 1);
                break;
            }
            case INVERT_PRISM_2P: {
                this.fillInvertPrism(renderPkg, 2);
                break;
            }
            case INVERT_PRISM_3P: {
                this.fillInvertPrism(renderPkg, 3);
                break;
            }
            case INVERT_PRISM_4P: {
                this.fillInvertPrism(renderPkg, 4);
            }
        }
        RotationUtil.Rotation rotation = RotationUtil.Rotation.get(renderPkg.getData());
        renderPkg.rotate(rotation);
    }

    private void fillWedge(RenderPkg renderPkg) {
        renderPkg.add(RenderHelper.getQuadYNeg(SpriteRegistry.sprite_uncovered_full));
        renderPkg.add(RenderHelper.getQuadZNeg(SpriteRegistry.sprite_uncovered_full));
        renderPkg.add(RenderHelperSlope.getWedgeXNeg());
        renderPkg.add(RenderHelperSlope.getWedgeXPos());
        renderPkg.add(Quad.getQuad(EnumFacing.SOUTH, SpriteRegistry.sprite_uncovered_full, new Vec3d(1.0, 0.0, 1.0), new Vec3d(1.0, 1.0, 0.0), new Vec3d(0.0, 1.0, 0.0), new Vec3d(0.0, 0.0, 1.0)));
    }

    private void fillWedgeExterior(RenderPkg renderPkg) {
        renderPkg.add(RenderHelper.getQuadYNeg(SpriteRegistry.sprite_uncovered_full));
        renderPkg.add(RenderHelperSlope.getWedgeXNeg());
        renderPkg.add(RenderHelperSlope.getWedgeExteriorZNeg());
        renderPkg.add(Quad.getQuad(EnumFacing.SOUTH, SpriteRegistry.sprite_uncovered_full, new Vec3d(0.0, 1.0, 0.0), new Vec3d(0.0, 0.0, 1.0), new Vec3d(1.0, 0.0, 1.0)));
        renderPkg.add(Quad.getQuad(EnumFacing.EAST, SpriteRegistry.sprite_uncovered_full, new Vec3d(1.0, 0.0, 1.0), new Vec3d(1.0, 0.0, 0.0), new Vec3d(0.0, 1.0, 0.0)));
    }

    private void fillWedgeInterior(RenderPkg renderPkg) {
        renderPkg.add(RenderHelper.getQuadYNeg(SpriteRegistry.sprite_uncovered_full));
        renderPkg.add(RenderHelper.getQuadXNeg(SpriteRegistry.sprite_uncovered_full));
        renderPkg.add(RenderHelper.getQuadZNeg(SpriteRegistry.sprite_uncovered_full));
        renderPkg.add(RenderHelperSlope.getWedgeXPos());
        renderPkg.add(RenderHelperSlope.getWedgeInteriorZPos());
        renderPkg.add(Quad.getQuad(EnumFacing.SOUTH, SpriteRegistry.sprite_uncovered_full, new Vec3d(0.0, 1.0, 0.0), new Vec3d(1.0, 0.0, 1.0), new Vec3d(1.0, 1.0, 0.0)));
        renderPkg.add(Quad.getQuad(EnumFacing.EAST, SpriteRegistry.sprite_uncovered_full, new Vec3d(0.0, 1.0, 1.0), new Vec3d(1.0, 0.0, 1.0), new Vec3d(0.0, 1.0, 0.0)));
    }

    private void fillObliqueInterior(RenderPkg renderPkg) {
        renderPkg.add(RenderHelper.getQuadYNeg(SpriteRegistry.sprite_uncovered_full));
        renderPkg.add(RenderHelper.getQuadZNeg(SpriteRegistry.sprite_uncovered_full));
        renderPkg.add(RenderHelper.getQuadXNeg(SpriteRegistry.sprite_uncovered_full));
        renderPkg.add(RenderHelperSlope.getWedgeInteriorZPos());
        renderPkg.add(RenderHelperSlope.getWedgeXPos());
        renderPkg.add(Quad.getQuad(EnumFacing.UP, SpriteRegistry.sprite_uncovered_full, new Vec3d(0.0, 1.0, 0.0), new Vec3d(0.0, 1.0, 1.0), new Vec3d(1.0, 1.0, 0.0)));
        renderPkg.add(Quad.getQuad(EnumFacing.SOUTH, SpriteRegistry.sprite_uncovered_oblique_pos, new Vec3d(0.0, 1.0, 1.0), new Vec3d(1.0, 0.0, 1.0), new Vec3d(0.5, 1.0, 0.5)));
        renderPkg.add(Quad.getQuad(EnumFacing.SOUTH, SpriteRegistry.sprite_uncovered_oblique_pos, new Vec3d(0.5, 1.0, 0.5), new Vec3d(1.0, 0.0, 1.0), new Vec3d(1.0, 1.0, 0.0)));
    }

    private void fillObliqueExterior(RenderPkg renderPkg) {
        renderPkg.add(Quad.getQuad(EnumFacing.DOWN, SpriteRegistry.sprite_uncovered_full, new Vec3d(0.0, 0.0, 1.0), new Vec3d(0.0, 0.0, 0.0), new Vec3d(1.0, 0.0, 0.0)));
        renderPkg.add(Quad.getQuad(EnumFacing.SOUTH, SpriteRegistry.sprite_uncovered_oblique_neg, new Vec3d(0.0, 1.0, 0.0), new Vec3d(0.0, 0.0, 1.0), new Vec3d(1.0, 0.0, 0.0)));
        renderPkg.add(RenderHelperSlope.getWedgeExteriorZNeg());
        renderPkg.add(Quad.getQuad(EnumFacing.WEST, SpriteRegistry.sprite_uncovered_full, new Vec3d(0.0, 1.0, 0.0), new Vec3d(0.0, 0.0, 0.0), new Vec3d(0.0, 0.0, 1.0)));
    }

    private void fillPrismWedge(RenderPkg renderPkg) {
        renderPkg.add(RenderHelper.getQuadYNeg(SpriteRegistry.sprite_uncovered_full));
        renderPkg.add(RenderHelper.getQuadZNeg(SpriteRegistry.sprite_uncovered_full));
        renderPkg.add(RenderHelperSlope.getWedgeXNeg());
        renderPkg.add(RenderHelperSlope.getWedgeXPos());
        renderPkg.add(Quad.getQuad(EnumFacing.SOUTH, SpriteRegistry.sprite_uncovered_full, new Vec3d(0.0, 1.0, 0.0), new Vec3d(0.0, 0.0, 1.0), new Vec3d(0.5, 0.5, 0.5), new Vec3d(0.5, 1.0, 0.0)));
        renderPkg.add(Quad.getQuad(EnumFacing.SOUTH, SpriteRegistry.sprite_uncovered_full, new Vec3d(0.5, 1.0, 0.0), new Vec3d(0.5, 0.5, 0.5), new Vec3d(1.0, 0.0, 1.0), new Vec3d(1.0, 1.0, 0.0)));
        renderPkg.add(Quad.getQuad(EnumFacing.WEST, SpriteRegistry.sprite_uncovered_quartered, new Vec3d(0.5, 0.5, 0.5), new Vec3d(0.0, 0.0, 1.0), new Vec3d(0.5, 0.5, 1.0)));
        renderPkg.add(Quad.getQuad(EnumFacing.EAST, SpriteRegistry.sprite_uncovered_quartered, new Vec3d(0.5, 0.5, 1.0), new Vec3d(1.0, 0.0, 1.0), new Vec3d(0.5, 0.5, 0.5)));
        renderPkg.add(Quad.getQuad(EnumFacing.SOUTH, SpriteRegistry.sprite_uncovered_full, new Vec3d(0.5, 0.5, 1.0), new Vec3d(0.0, 0.0, 1.0), new Vec3d(0.5, 0.0, 1.0)));
        renderPkg.add(Quad.getQuad(EnumFacing.SOUTH, SpriteRegistry.sprite_uncovered_full, new Vec3d(0.5, 0.5, 1.0), new Vec3d(0.5, 0.0, 1.0), new Vec3d(1.0, 0.0, 1.0)));
    }

    private void fillPrism(RenderPkg renderPkg, int numPoints) {
        renderPkg.add(RenderHelper.getQuadYNeg(SpriteRegistry.sprite_uncovered_full));
        switch (numPoints) {
            case 0: {
                renderPkg.add(RenderHelperSlope.getPrismSlopeZNeg());
                renderPkg.add(Quad.getQuad(EnumFacing.SOUTH, SpriteRegistry.sprite_uncovered_full, new Vec3d(0.5, 0.5, 0.5), new Vec3d(0.0, 0.0, 1.0), new Vec3d(1.0, 0.0, 1.0)));
                renderPkg.add(Quad.getQuad(EnumFacing.WEST, SpriteRegistry.sprite_uncovered_full, new Vec3d(0.5, 0.5, 0.5), new Vec3d(0.0, 0.0, 0.0), new Vec3d(0.0, 0.0, 1.0)));
                renderPkg.add(Quad.getQuad(EnumFacing.EAST, SpriteRegistry.sprite_uncovered_full, new Vec3d(0.5, 0.5, 0.5), new Vec3d(1.0, 0.0, 1.0), new Vec3d(1.0, 0.0, 0.0)));
                break;
            }
            case 1: {
                renderPkg.add(RenderHelperSlope.getPrismSlopeZNeg());
                renderPkg.add(RenderHelperSlope.getPrismZPosXNeg());
                renderPkg.add(RenderHelperSlope.getPrismZPosXPos());
                renderPkg.add(Quad.getQuad(EnumFacing.WEST, SpriteRegistry.sprite_uncovered_quartered, new Vec3d(0.5, 0.5, 0.5), new Vec3d(0.0, 0.0, 0.0), new Vec3d(0.0, 0.0, 1.0), new Vec3d(0.5, 0.5, 1.0)));
                renderPkg.add(Quad.getQuad(EnumFacing.EAST, SpriteRegistry.sprite_uncovered_quartered, new Vec3d(0.5, 0.5, 1.0), new Vec3d(1.0, 0.0, 1.0), new Vec3d(1.0, 0.0, 0.0), new Vec3d(0.5, 0.5, 0.5)));
                break;
            }
            case 2: {
                renderPkg.add(RenderHelperSlope.getPrismZNegXNeg());
                renderPkg.add(RenderHelperSlope.getPrismZNegXPos());
                renderPkg.add(RenderHelperSlope.getPrismZPosXNeg());
                renderPkg.add(RenderHelperSlope.getPrismZPosXPos());
                renderPkg.add(Quad.getQuad(EnumFacing.WEST, SpriteRegistry.sprite_uncovered_quartered, new Vec3d(0.5, 0.5, 0.0), new Vec3d(0.0, 0.0, 0.0), new Vec3d(0.0, 0.0, 1.0), new Vec3d(0.5, 0.5, 1.0)));
                renderPkg.add(Quad.getQuad(EnumFacing.EAST, SpriteRegistry.sprite_uncovered_quartered, new Vec3d(0.5, 0.5, 1.0), new Vec3d(1.0, 0.0, 1.0), new Vec3d(1.0, 0.0, 0.0), new Vec3d(0.5, 0.5, 0.0)));
                break;
            }
            case 3: {
                renderPkg.add(Quad.getQuad(EnumFacing.NORTH, SpriteRegistry.sprite_uncovered_quartered, new Vec3d(1.0, 0.5, 0.5), new Vec3d(1.0, 0.0, 0.0), new Vec3d(0.0, 0.0, 0.0), new Vec3d(0.0, 0.5, 0.5)));
                renderPkg.add(RenderHelperSlope.getPrismSlopedZPosXNeg());
                renderPkg.add(RenderHelperSlope.getPrismSlopedZPosXPos());
                renderPkg.add(RenderHelperSlope.getPrismZPosXNeg());
                renderPkg.add(RenderHelperSlope.getPrismZPosXPos());
                renderPkg.add(RenderHelperSlope.getPrismXNegZNeg());
                renderPkg.add(RenderHelperSlope.getPrismXNegZPos());
                renderPkg.add(RenderHelperSlope.getPrismSlopedXNegZPos());
                renderPkg.add(RenderHelperSlope.getPrismXPosZPos());
                renderPkg.add(RenderHelperSlope.getPrismXPosZNeg());
                renderPkg.add(RenderHelperSlope.getPrismSlopedXPosZPos());
                break;
            }
            case 4: {
                renderPkg.add(RenderHelperSlope.getPrismZNegXNeg());
                renderPkg.add(RenderHelperSlope.getPrismZNegXPos());
                renderPkg.add(RenderHelperSlope.getPrismZPosXNeg());
                renderPkg.add(RenderHelperSlope.getPrismZPosXPos());
                renderPkg.add(RenderHelperSlope.getPrismXNegZNeg());
                renderPkg.add(RenderHelperSlope.getPrismXNegZPos());
                renderPkg.add(RenderHelperSlope.getPrismXPosZPos());
                renderPkg.add(RenderHelperSlope.getPrismXPosZNeg());
                renderPkg.add(Quad.getQuad(EnumFacing.NORTH, SpriteRegistry.sprite_uncovered_quartered, new Vec3d(1.0, 0.5, 0.5), new Vec3d(1.0, 0.0, 0.0), new Vec3d(0.5, 0.5, 0.5)));
                renderPkg.add(Quad.getQuad(EnumFacing.NORTH, SpriteRegistry.sprite_uncovered_quartered, new Vec3d(0.5, 0.5, 0.5), new Vec3d(0.0, 0.0, 0.0), new Vec3d(0.0, 0.5, 0.5)));
                renderPkg.add(RenderHelperSlope.getPrismSlopedZPosXNeg());
                renderPkg.add(RenderHelperSlope.getPrismSlopedZPosXPos());
                renderPkg.add(Quad.getQuad(EnumFacing.WEST, SpriteRegistry.sprite_uncovered_quartered, new Vec3d(0.5, 0.5, 0.0), new Vec3d(0.0, 0.0, 0.0), new Vec3d(0.5, 0.5, 0.5)));
                renderPkg.add(RenderHelperSlope.getPrismSlopedXNegZPos());
                renderPkg.add(RenderHelperSlope.getPrismSlopedXPosZPos());
                renderPkg.add(Quad.getQuad(EnumFacing.EAST, SpriteRegistry.sprite_uncovered_quartered, new Vec3d(0.5, 0.5, 0.5), new Vec3d(1.0, 0.0, 0.0), new Vec3d(0.5, 0.5, 0.0)));
            }
        }
    }

    private void fillInvertPrism(RenderPkg renderPkg, int numPoints) {
        renderPkg.add(RenderHelper.getQuadYNeg(SpriteRegistry.sprite_uncovered_full));
        switch (numPoints) {
            case 0: {
                renderPkg.add(RenderHelper.getQuadZNeg(SpriteRegistry.sprite_uncovered_full));
                renderPkg.add(RenderHelper.getQuadZPos(SpriteRegistry.sprite_uncovered_full));
                renderPkg.add(RenderHelper.getQuadXNeg(SpriteRegistry.sprite_uncovered_full));
                renderPkg.add(RenderHelper.getQuadXPos(SpriteRegistry.sprite_uncovered_full));
                renderPkg.add(Quad.getQuad(EnumFacing.NORTH, SpriteRegistry.sprite_uncovered_full, new Vec3d(1.0, 1.0, 1.0), new Vec3d(0.5, 0.5, 0.5), new Vec3d(0.0, 1.0, 1.0)));
                renderPkg.add(RenderHelperSlope.getInvertPrismSlopedZPos());
                renderPkg.add(Quad.getQuad(EnumFacing.WEST, SpriteRegistry.sprite_uncovered_full, new Vec3d(1.0, 1.0, 0.0), new Vec3d(0.5, 0.5, 0.5), new Vec3d(1.0, 1.0, 1.0)));
                renderPkg.add(Quad.getQuad(EnumFacing.EAST, SpriteRegistry.sprite_uncovered_full, new Vec3d(0.0, 1.0, 1.0), new Vec3d(0.5, 0.5, 0.5), new Vec3d(0.0, 1.0, 0.0)));
                break;
            }
            case 1: {
                renderPkg.add(RenderHelper.getQuadZNeg(SpriteRegistry.sprite_uncovered_full));
                renderPkg.add(RenderHelper.getQuadXNeg(SpriteRegistry.sprite_uncovered_full));
                renderPkg.add(RenderHelper.getQuadXPos(SpriteRegistry.sprite_uncovered_full));
                renderPkg.add(RenderHelperSlope.getInvertPrismZPosXNeg());
                renderPkg.add(RenderHelperSlope.getInvertPrismZPosXPos());
                renderPkg.add(RenderHelperSlope.getInvertPrismSlopedZPos());
                renderPkg.add(Quad.getQuad(EnumFacing.WEST, SpriteRegistry.sprite_uncovered_quartered, new Vec3d(1.0, 1.0, 0.0), new Vec3d(0.5, 0.5, 0.5), new Vec3d(0.5, 0.5, 1.0), new Vec3d(1.0, 1.0, 1.0)));
                renderPkg.add(Quad.getQuad(EnumFacing.EAST, SpriteRegistry.sprite_uncovered_quartered, new Vec3d(0.0, 1.0, 1.0), new Vec3d(0.5, 0.5, 1.0), new Vec3d(0.5, 0.5, 0.5), new Vec3d(0.0, 1.0, 0.0)));
                break;
            }
            case 2: {
                renderPkg.add(RenderHelper.getQuadXNeg(SpriteRegistry.sprite_uncovered_full));
                renderPkg.add(RenderHelper.getQuadXPos(SpriteRegistry.sprite_uncovered_full));
                renderPkg.add(RenderHelperSlope.getInvertPrismZPosXNeg());
                renderPkg.add(RenderHelperSlope.getInvertPrismZPosXPos());
                renderPkg.add(RenderHelperSlope.getInvertPrismZNegXPos());
                renderPkg.add(RenderHelperSlope.getInvertPrismZNegXNeg());
                renderPkg.add(Quad.getQuad(EnumFacing.WEST, SpriteRegistry.sprite_uncovered_quartered, new Vec3d(1.0, 1.0, 0.0), new Vec3d(0.5, 0.5, 0.0), new Vec3d(0.5, 0.5, 1.0), new Vec3d(1.0, 1.0, 1.0)));
                renderPkg.add(Quad.getQuad(EnumFacing.EAST, SpriteRegistry.sprite_uncovered_quartered, new Vec3d(0.0, 1.0, 1.0), new Vec3d(0.5, 0.5, 1.0), new Vec3d(0.5, 0.5, 0.0), new Vec3d(0.0, 1.0, 0.0)));
                break;
            }
            case 3: {
                renderPkg.add(RenderHelper.getQuadZNeg(SpriteRegistry.sprite_uncovered_full));
                renderPkg.add(RenderHelperSlope.getInvertPrismZPosXNeg());
                renderPkg.add(RenderHelperSlope.getInvertPrismZPosXPos());
                renderPkg.add(RenderHelperSlope.getInvertPrismXNegZNeg());
                renderPkg.add(RenderHelperSlope.getInvertPrismXNegZPos());
                renderPkg.add(RenderHelperSlope.getInvertPrismXPosZPos());
                renderPkg.add(RenderHelperSlope.getInvertPrismXPosZNeg());
                renderPkg.add(Quad.getQuad(EnumFacing.SOUTH, SpriteRegistry.sprite_uncovered_quartered, new Vec3d(0.0, 1.0, 0.0), new Vec3d(0.0, 0.5, 0.5), new Vec3d(1.0, 0.5, 0.5), new Vec3d(1.0, 1.0, 0.0)));
                renderPkg.add(RenderHelperSlope.getInvertPrismSlopeZNegXPos());
                renderPkg.add(RenderHelperSlope.getInvertPrismSlopeZNegXNeg());
                renderPkg.add(RenderHelperSlope.getInvertPrismSlopeXNegZPos());
                renderPkg.add(RenderHelperSlope.getInvertPrismSlopeXPosZPos());
                break;
            }
            case 4: {
                renderPkg.add(RenderHelperSlope.getInvertPrismZNegXPos());
                renderPkg.add(RenderHelperSlope.getInvertPrismZNegXNeg());
                renderPkg.add(RenderHelperSlope.getInvertPrismZPosXNeg());
                renderPkg.add(RenderHelperSlope.getInvertPrismZPosXPos());
                renderPkg.add(RenderHelperSlope.getInvertPrismXNegZNeg());
                renderPkg.add(RenderHelperSlope.getInvertPrismXNegZPos());
                renderPkg.add(RenderHelperSlope.getInvertPrismXPosZPos());
                renderPkg.add(RenderHelperSlope.getInvertPrismXPosZNeg());
                renderPkg.add(RenderHelperSlope.getInvertPrismSlopeZNegXPos());
                renderPkg.add(RenderHelperSlope.getInvertPrismSlopeZNegXNeg());
                renderPkg.add(Quad.getQuad(EnumFacing.SOUTH, SpriteRegistry.sprite_uncovered_quartered, new Vec3d(0.0, 1.0, 0.0), new Vec3d(0.0, 0.5, 0.5), new Vec3d(0.5, 0.5, 0.5)));
                renderPkg.add(Quad.getQuad(EnumFacing.SOUTH, SpriteRegistry.sprite_uncovered_quartered, new Vec3d(0.5, 0.5, 0.5), new Vec3d(1.0, 0.5, 0.5), new Vec3d(1.0, 1.0, 0.0)));
                renderPkg.add(Quad.getQuad(EnumFacing.WEST, SpriteRegistry.sprite_uncovered_quartered, new Vec3d(1.0, 1.0, 0.0), new Vec3d(0.5, 0.5, 0.0), new Vec3d(0.5, 0.5, 0.5)));
                renderPkg.add(RenderHelperSlope.getInvertPrismSlopeXNegZPos());
                renderPkg.add(RenderHelperSlope.getInvertPrismSlopeXPosZPos());
                renderPkg.add(Quad.getQuad(EnumFacing.EAST, SpriteRegistry.sprite_uncovered_quartered, new Vec3d(0.5, 0.5, 0.5), new Vec3d(0.5, 0.5, 0.0), new Vec3d(0.0, 1.0, 0.0)));
            }
        }
    }
}

