/*
 * Decompiled with CFR 0.152.
 */
package com.carpentersblocks.util;

import net.minecraft.util.EnumFacing;

public class RotationUtil {
    private static final double[] RADS = new double[]{0.0, 1.5707963267948966, Math.PI, 4.71238898038469};
    private static final int ROT_0 = 0;
    private static final int ROT_90 = 1;
    private static final int ROT_180 = 2;
    private static final int ROT_270 = 3;
    private static final Rotation[][] ROTATIONS = new Rotation[][]{{Rotation.X90_Y0_Z0, Rotation.X0_Y90_Z0, Rotation.X0_Y0_Z90}, {Rotation.X90_Y90_Z0, Rotation.X270_Y0_Z90, Rotation.X0_Y0_Z180}, {Rotation.X90_Y180_Z0, Rotation.X180_Y270_Z0, Rotation.X0_Y0_Z270}, {Rotation.X90_Y270_Z0, Rotation.X90_Y270_Z0, Rotation.X0_Y0_Z0}, {Rotation.X90_Y0_Z270, Rotation.X0_Y180_Z0, Rotation.X90_Y90_Z0}, {Rotation.X90_Y0_Z180, Rotation.X0_Y270_Z0, Rotation.X0_Y180_Z90}, {Rotation.X0_Y270_Z90, Rotation.X90_Y180_Z90, Rotation.X180_Y0_Z0}, {Rotation.X90_Y0_Z90, Rotation.X0_Y0_Z0, Rotation.X0_Y270_Z90}, {Rotation.X0_Y0_Z90, Rotation.X270_Y0_Z0, Rotation.X180_Y270_Z0}, {Rotation.X180_Y0_Z0, Rotation.X90_Y90_Z0, Rotation.X90_Y0_Z90}, {Rotation.X180_Y90_Z0, Rotation.X0_Y0_Z90, Rotation.X90_Y0_Z180}, {Rotation.X0_Y0_Z180, Rotation.X0_Y270_Z90, Rotation.X90_Y0_Z270}, {Rotation.X180_Y270_Z0, Rotation.X0_Y180_Z90, Rotation.X90_Y0_Z0}, {Rotation.X0_Y180_Z90, Rotation.X90_Y180_Z0, Rotation.X180_Y90_Z0}, {Rotation.X0_Y180_Z0, Rotation.X90_Y270_Z0, Rotation.X90_Y180_Z90}, {Rotation.X0_Y270_Z0, Rotation.X0_Y0_Z270, Rotation.X270_Y0_Z0}, {Rotation.X180_Y0_Z90, Rotation.X90_Y0_Z0, Rotation.X0_Y270_Z0}, {Rotation.X270_Y0_Z0, Rotation.X180_Y90_Z0, Rotation.X180_Y0_Z90}, {Rotation.X270_Y90_Z0, Rotation.X90_Y0_Z90, Rotation.X0_Y180_Z0}, {Rotation.X90_Y180_Z90, Rotation.X0_Y0_Z180, Rotation.X270_Y90_Z0}, {Rotation.X270_Y0_Z90, Rotation.X180_Y0_Z0, Rotation.X90_Y270_Z0}, {Rotation.X0_Y0_Z0, Rotation.X270_Y90_Z0, Rotation.X270_Y0_Z90}, {Rotation.X0_Y90_Z0, Rotation.X180_Y0_Z90, Rotation.X90_Y180_Z0}, {Rotation.X0_Y0_Z270, Rotation.X90_Y0_Z180, Rotation.X0_Y90_Z0}};

    public static enum Rotation {
        X0_Y0_Z0(0, 0, 0),
        X0_Y0_Z90(0, 0, 1),
        X0_Y0_Z180(0, 0, 2),
        X0_Y0_Z270(0, 0, 3),
        X0_Y90_Z0(0, 1, 0),
        X0_Y180_Z0(0, 2, 0),
        X0_Y180_Z90(0, 2, 1),
        X0_Y270_Z0(0, 3, 0),
        X0_Y270_Z90(0, 3, 1),
        X90_Y0_Z0(1, 0, 0),
        X90_Y0_Z90(1, 0, 1),
        X90_Y0_Z180(1, 0, 2),
        X90_Y0_Z270(1, 0, 3),
        X90_Y90_Z0(1, 1, 0),
        X90_Y180_Z0(1, 2, 0),
        X90_Y180_Z90(1, 2, 1),
        X90_Y270_Z0(1, 3, 0),
        X180_Y0_Z0(2, 0, 0),
        X180_Y0_Z90(2, 0, 1),
        X180_Y90_Z0(2, 1, 0),
        X180_Y270_Z0(2, 3, 0),
        X270_Y0_Z0(3, 0, 0),
        X270_Y0_Z90(3, 0, 1),
        X270_Y90_Z0(3, 1, 0);

        private int _x;
        private int _y;
        private int _z;

        private Rotation(int x, int y, int z) {
            this._x = x;
            this._y = y;
            this._z = z;
        }

        public static Rotation get(int cbMetadata) {
            int val = cbMetadata & 0x3F;
            for (Rotation rotation : Rotation.values()) {
                if (rotation.asInt() != val) continue;
                return rotation;
            }
            return X0_Y0_Z0;
        }

        public double getRadians(EnumFacing.Axis axis) {
            switch (axis) {
                case X: {
                    return RADS[this._x];
                }
                case Y: {
                    return RADS[this._y];
                }
            }
            return RADS[this._z];
        }

        public EnumFacing getRotatedFacing(EnumFacing facing) {
            EnumFacing rotation = facing;
            int x = 0;
            while (x++ < this._x) {
                rotation = rotation.func_176732_a(EnumFacing.Axis.X);
            }
            int y = 0;
            while (y++ < this._y) {
                rotation = rotation.func_176732_a(EnumFacing.Axis.Y);
            }
            int z = 0;
            while (z++ < this._z) {
                rotation = rotation.func_176732_a(EnumFacing.Axis.Z);
            }
            return rotation;
        }

        public Rotation getNext(EnumFacing.Axis axis) {
            return ROTATIONS[this.ordinal()][axis.ordinal()];
        }

        public Integer asInt() {
            return this._x << 4 | this._y << 2 | this._z;
        }
    }
}

