/*
 * Decompiled with CFR 0.152.
 */
package com.carpentersblocks.block;

import com.carpentersblocks.block.BlockCoverable;
import com.carpentersblocks.data.Bed;
import com.carpentersblocks.tileentity.TEBase;
import com.carpentersblocks.util.BlockProperties;
import com.carpentersblocks.util.handler.ChatHandler;
import com.carpentersblocks.util.registry.BlockRegistry;
import com.carpentersblocks.util.registry.IconRegistry;
import com.carpentersblocks.util.registry.ItemRegistry;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.Random;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IconRegister;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EnumStatus;
import net.minecraft.util.ChunkCoordinates;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeGenBase;

public class BlockCarpentersBed
extends BlockCoverable {
    public BlockCarpentersBed(int blockID, Material material) {
        super(blockID, material);
        this.func_71905_a(0.0f, 0.0f, 0.0f, 1.0f, 0.625f, 1.0f);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void func_94332_a(IconRegister iconRegister) {
        IconRegistry.icon_bed_pillow = iconRegister.func_94245_a("CarpentersBlocks:bed/bed_pillow");
    }

    public boolean isBed(World world, int x, int y, int z, EntityLivingBase player) {
        return true;
    }

    @Override
    protected boolean onHammerLeftClick(TEBase TE, EntityPlayer entityPlayer) {
        BlockProperties.setPrevDesign(TE);
        BlockProperties.setDesign(Bed.getOppositeTE(TE), BlockProperties.getDesign(TE));
        return true;
    }

    @Override
    protected boolean onHammerRightClick(TEBase TE, EntityPlayer entityPlayer) {
        if (entityPlayer.func_70093_af()) {
            BlockProperties.clearDesign(TE);
            BlockProperties.clearDesign(Bed.getOppositeTE(TE));
        } else {
            BlockProperties.setNextDesign(TE);
            BlockProperties.setDesign(Bed.getOppositeTE(TE), BlockProperties.getDesign(TE));
        }
        return true;
    }

    @Override
    protected void postOnBlockActivated(TEBase TE, EntityPlayer entityPlayer, int side, float hitX, float hitY, float hitZ, BlockCoverable.ActionResult actionResult) {
        actionResult.setAltered();
        World world = TE.func_70314_l();
        int x = TE.field_70329_l;
        int y = TE.field_70330_m;
        int z = TE.field_70327_n;
        if (!Bed.isHeadOfBed(TE)) {
            TEBase TE_opp = Bed.getOppositeTE(TE);
            if (TE_opp != null) {
                x = TE_opp.field_70329_l;
                z = TE_opp.field_70327_n;
            } else {
                return;
            }
        }
        if (world.field_73011_w.func_76567_e() && world.func_72807_a(x, z) != BiomeGenBase.field_76778_j) {
            EnumStatus enumstatus;
            if (Bed.isOccupied(TE)) {
                EntityPlayer entityPlayer1 = null;
                for (EntityPlayer entityPlayer2 : world.field_73010_i) {
                    if (!entityPlayer2.func_70608_bn()) continue;
                    ChunkCoordinates chunkCoordinates = entityPlayer2.field_71081_bT;
                    if (chunkCoordinates.field_71574_a != x || chunkCoordinates.field_71572_b != y || chunkCoordinates.field_71573_c != z) continue;
                    entityPlayer1 = entityPlayer2;
                }
                if (entityPlayer1 != null) {
                    ChatHandler.sendMessageToPlayer("tile.bed.occupied", entityPlayer, false);
                    return;
                }
                this.setBedOccupied(world, x, y, z, entityPlayer, false);
            }
            if ((enumstatus = entityPlayer.func_71018_a(x, y, z)) == EnumStatus.OK) {
                this.setBedOccupied(world, x, y, z, entityPlayer, true);
            } else if (enumstatus == EnumStatus.NOT_POSSIBLE_NOW) {
                ChatHandler.sendMessageToPlayer("tile.bed.noSleep", entityPlayer, false);
            } else if (enumstatus == EnumStatus.NOT_SAFE) {
                ChatHandler.sendMessageToPlayer("tile.bed.notSafe", entityPlayer, false);
            }
        } else {
            world.func_94571_i(x, y, z);
            world.func_72885_a((Entity)null, (double)((float)x + 0.5f), (double)((float)y + 0.5f), (double)((float)z + 0.5f), 5.0f, true, true);
        }
    }

    @Override
    public void func_71863_a(World world, int x, int y, int z, int blockID) {
        TEBase TE;
        if (!world.field_72995_K && (TE = this.getTileEntity((IBlockAccess)world, x, y, z)) != null && Bed.getOppositeTE(TE) == null) {
            world.func_94571_i(x, y, z);
        }
        super.func_71863_a(world, x, y, z, blockID);
    }

    public int func_71885_a(int par1, Random random, int par2) {
        return ItemRegistry.itemCarpentersBed.field_77779_bT;
    }

    public void setBedOccupied(World world, int x, int y, int z, EntityPlayer entityPlayer, boolean isOccupied) {
        TEBase TE = this.getTileEntity((IBlockAccess)world, x, y, z);
        if (TE != null && !TE.func_70314_l().field_72995_K) {
            Bed.setOccupied(TE, isOccupied);
            TEBase TE_opp = Bed.getOppositeTE(TE);
            if (TE_opp != null) {
                Bed.setOccupied(TE_opp, isOccupied);
            }
        }
    }

    public int getBedDirection(IBlockAccess world, int x, int y, int z) {
        TEBase TE = this.getTileEntity(world, x, y, z);
        switch (Bed.getDirection(TE)) {
            case NORTH: {
                return 0;
            }
            case SOUTH: {
                return 2;
            }
            case WEST: {
                return 3;
            }
        }
        return 1;
    }

    @SideOnly(value=Side.CLIENT)
    public int func_71922_a(World world, int x, int y, int z) {
        return ItemRegistry.itemCarpentersBed.field_77779_bT;
    }

    public int func_71857_b() {
        return BlockRegistry.carpentersBedRenderID;
    }
}

