/*
 * Decompiled with CFR 0.152.
 */
package com.carpentersblocks.block;

import com.carpentersblocks.block.BlockCoverable;
import com.carpentersblocks.tileentity.TEBase;
import com.carpentersblocks.util.BlockProperties;
import com.carpentersblocks.util.handler.EventHandler;
import com.carpentersblocks.util.registry.BlockRegistry;
import com.carpentersblocks.util.registry.IconRegistry;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.Icon;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeDirection;

public class BlockCarpentersBlock
extends BlockCoverable {
    public BlockCarpentersBlock(int blockID, Material material) {
        super(blockID, material);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public Icon getIcon() {
        return IconRegistry.icon_uncovered_quartered;
    }

    @Override
    protected boolean onHammerLeftClick(TEBase TE, EntityPlayer entityPlayer) {
        int data = BlockProperties.getMetadata(TE);
        if (++data > 6) {
            data = 0;
        }
        BlockProperties.setMetadata(TE, data);
        return true;
    }

    @Override
    protected boolean onHammerRightClick(TEBase TE, EntityPlayer entityPlayer) {
        int data = BlockProperties.getMetadata(TE);
        if (data == 0) {
            switch (EventHandler.eventFace) {
                case 0: {
                    data = 4;
                    break;
                }
                case 1: {
                    data = 3;
                    break;
                }
                case 2: {
                    data = 6;
                    break;
                }
                case 3: {
                    data = 5;
                    break;
                }
                case 4: {
                    data = 2;
                    break;
                }
                case 5: {
                    data = 1;
                }
            }
        } else {
            data = 0;
        }
        BlockProperties.setMetadata(TE, data);
        return true;
    }

    public void func_71902_a(IBlockAccess world, int x, int y, int z) {
        TEBase TE = this.getTileEntity(world, x, y, z);
        int data = BlockProperties.getMetadata(TE);
        float[][] bounds = new float[][]{{0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f}, {0.0f, 0.0f, 0.0f, 0.5f, 1.0f, 1.0f}, {0.5f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f}, {0.0f, 0.0f, 0.0f, 1.0f, 0.5f, 1.0f}, {0.0f, 0.5f, 0.0f, 1.0f, 1.0f, 1.0f}, {0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 0.5f}, {0.0f, 0.0f, 0.5f, 1.0f, 1.0f, 1.0f}};
        this.func_71905_a(bounds[data][0], bounds[data][1], bounds[data][2], bounds[data][3], bounds[data][4], bounds[data][5]);
    }

    public void func_71871_a(World world, int x, int y, int z, AxisAlignedBB axisAlignedBB, List list, Entity entity) {
        this.func_71902_a((IBlockAccess)world, x, y, z);
        super.func_71871_a(world, x, y, z, axisAlignedBB, list, entity);
    }

    @Override
    public void func_71860_a(World world, int x, int y, int z, EntityLivingBase entityLiving, ItemStack itemStack) {
        super.func_71860_a(world, x, y, z, entityLiving, itemStack);
        TEBase TE = this.getTileEntity((IBlockAccess)world, x, y, z);
        if (TE != null) {
            int data = 0;
            if (!entityLiving.func_70093_af()) {
                TEBase[] TE_list;
                for (TEBase TE_current : TE_list = this.getAdjacentTileEntities(world, x, y, z)) {
                    if (TE_current == null || !TE_current.func_70311_o().equals((Object)this)) continue;
                    data = BlockProperties.getMetadata(TE_current);
                }
            }
            BlockProperties.setMetadata(TE, data);
        }
    }

    public boolean isBlockNormalCube(World world, int x, int y, int z) {
        return false;
    }

    public boolean isBlockSolidOnSide(World world, int x, int y, int z, ForgeDirection side) {
        TEBase TE = this.getTileEntity((IBlockAccess)world, x, y, z);
        if (TE != null && this.isBlockSolid((IBlockAccess)world, x, y, z)) {
            int data = BlockProperties.getMetadata(TE);
            if (data == 0) {
                return true;
            }
            if (data == 3 && side == ForgeDirection.DOWN) {
                return true;
            }
            if (data == 4 && side == ForgeDirection.UP) {
                return true;
            }
            if (data == 5 && side == ForgeDirection.NORTH) {
                return true;
            }
            if (data == 6 && side == ForgeDirection.SOUTH) {
                return true;
            }
            if (data == 1 && side == ForgeDirection.WEST) {
                return true;
            }
            if (data == 2 && side == ForgeDirection.EAST) {
                return true;
            }
        }
        return false;
    }

    @Override
    protected boolean shareFaces(TEBase TE_adj, TEBase TE_src, ForgeDirection side_adj, ForgeDirection side_src) {
        if (TE_adj.func_70311_o() == this) {
            Block block_src = TE_src.func_70311_o();
            block_src.func_71902_a((IBlockAccess)TE_src.func_70314_l(), TE_src.field_70329_l, TE_src.field_70330_m, TE_src.field_70327_n);
            double[] bounds_src = new double[]{block_src.func_83009_v(), block_src.func_83008_x(), block_src.func_83005_z(), block_src.func_83007_w(), block_src.func_83010_y(), block_src.func_83006_A()};
            this.func_71902_a((IBlockAccess)TE_adj.func_70314_l(), TE_adj.field_70329_l, TE_adj.field_70330_m, TE_adj.field_70327_n);
            switch (side_src) {
                case DOWN: {
                    return this.field_72022_cl == 1.0 && bounds_src[1] == 0.0 && this.field_72026_ch == bounds_src[0] && this.field_72021_ck == bounds_src[3] && this.field_72024_cj == bounds_src[2] && this.field_72019_cm == bounds_src[5];
                }
                case UP: {
                    return this.field_72023_ci == 0.0 && bounds_src[4] == 1.0 && this.field_72026_ch == bounds_src[0] && this.field_72021_ck == bounds_src[3] && this.field_72024_cj == bounds_src[2] && this.field_72019_cm == bounds_src[5];
                }
                case NORTH: {
                    return this.field_72019_cm == 1.0 && bounds_src[2] == 0.0 && this.field_72026_ch == bounds_src[0] && this.field_72021_ck == bounds_src[3] && this.field_72023_ci == bounds_src[1] && this.field_72022_cl == bounds_src[4];
                }
                case SOUTH: {
                    return this.field_72024_cj == 0.0 && bounds_src[5] == 1.0 && this.field_72026_ch == bounds_src[0] && this.field_72021_ck == bounds_src[3] && this.field_72023_ci == bounds_src[1] && this.field_72022_cl == bounds_src[4];
                }
                case WEST: {
                    return this.field_72021_ck == 1.0 && bounds_src[0] == 0.0 && this.field_72023_ci == bounds_src[1] && this.field_72022_cl == bounds_src[4] && this.field_72024_cj == bounds_src[2] && this.field_72019_cm == bounds_src[5];
                }
                case EAST: {
                    return this.field_72026_ch == 0.0 && bounds_src[3] == 1.0 && this.field_72023_ci == bounds_src[1] && this.field_72022_cl == bounds_src[4] && this.field_72024_cj == bounds_src[2] && this.field_72019_cm == bounds_src[5];
                }
            }
            return false;
        }
        return super.shareFaces(TE_adj, TE_src, side_adj, side_src);
    }

    @Override
    public boolean canCoverSide(TEBase TE, World world, int x, int y, int z, int side) {
        return true;
    }

    public int func_71857_b() {
        return BlockRegistry.carpentersBlockRenderID;
    }
}

