/*
 * Decompiled with CFR 0.152.
 */
package com.carpentersblocks.block;

import com.carpentersblocks.block.BlockCoverable;
import com.carpentersblocks.data.Button;
import com.carpentersblocks.tileentity.TEBase;
import com.carpentersblocks.util.handler.ChatHandler;
import com.carpentersblocks.util.registry.BlockRegistry;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeDirection;

public class BlockCarpentersButton
extends BlockCoverable {
    public BlockCarpentersButton(int blockID, Material material) {
        super(blockID, material);
    }

    @Override
    protected boolean onHammerLeftClick(TEBase TE, EntityPlayer entityPlayer) {
        int polarity = Button.getPolarity(TE) == 0 ? 1 : 0;
        Button.setPolarity(TE, polarity);
        this.notifySideNeighbor(TE.func_70314_l(), TE.field_70329_l, TE.field_70330_m, TE.field_70327_n, ForgeDirection.OPPOSITES[Button.getFacing(TE).ordinal()]);
        switch (polarity) {
            case 0: {
                ChatHandler.sendMessageToPlayer("message.polarity_pos.name", entityPlayer);
                break;
            }
            case 1: {
                ChatHandler.sendMessageToPlayer("message.polarity_neg.name", entityPlayer);
            }
        }
        return true;
    }

    public AxisAlignedBB func_71872_e(World world, int x, int y, int z) {
        return null;
    }

    public int func_71859_p_(World world) {
        return 20;
    }

    public boolean func_71850_a_(World world, int x, int y, int z, int side) {
        ForgeDirection dir = ForgeDirection.getOrientation((int)side);
        Block block = Block.field_71973_m[world.func_72798_a(x - dir.offsetX, y, z - dir.offsetZ)];
        return block == null ? false : block.isBlockSolidOnSide(world, x - dir.offsetX, y, z - dir.offsetZ, dir);
    }

    public int func_85104_a(World world, int x, int y, int z, int side, float hitX, float hitY, float hitZ, int metadata) {
        return side;
    }

    @Override
    public void func_71860_a(World world, int x, int y, int z, EntityLivingBase entityLiving, ItemStack itemStack) {
        TEBase TE = this.getTileEntity((IBlockAccess)world, x, y, z);
        if (TE != null) {
            Button.setFacing(TE, world.func_72805_g(x, y, z));
            Button.setReady(TE);
        }
        super.func_71860_a(world, x, y, z, entityLiving, itemStack);
    }

    @Override
    public void func_71863_a(World world, int x, int y, int z, int blockID) {
        ForgeDirection dir;
        TEBase TE;
        if (!world.field_72995_K && (TE = this.getTileEntity((IBlockAccess)world, x, y, z)) != null && Button.isReady(TE) && !this.func_71850_a_(world, x, y, z, (dir = Button.getFacing(TE)).ordinal())) {
            this.func_71929_a(world, x, y, z, this.func_71880_c_(0));
            world.func_94571_i(x, y, z);
        }
        super.func_71863_a(world, x, y, z, blockID);
    }

    public void func_71902_a(IBlockAccess world, int x, int y, int z) {
        TEBase TE = this.getTileEntity(world, x, y, z);
        ForgeDirection dir = Button.getFacing(TE);
        float depth = this.isDepressed(TE) ? 0.0625f : 0.125f;
        switch (dir) {
            case NORTH: {
                this.func_71905_a(0.3125f, 0.375f, 1.0f - depth, 0.6875f, 0.625f, 1.0f);
                break;
            }
            case SOUTH: {
                this.func_71905_a(0.3125f, 0.375f, 0.0f, 0.6875f, 0.625f, depth);
                break;
            }
            case WEST: {
                this.func_71905_a(1.0f - depth, 0.375f, 0.3125f, 1.0f, 0.625f, 0.6875f);
                break;
            }
            case EAST: {
                this.func_71905_a(0.0f, 0.375f, 0.3125f, depth, 0.625f, 0.6875f);
                break;
            }
        }
    }

    @Override
    protected void postOnBlockActivated(TEBase TE, EntityPlayer entityPlayer, int side, float hitX, float hitY, float hitZ, BlockCoverable.ActionResult actionResult) {
        if (!this.isDepressed(TE)) {
            World world = TE.func_70314_l();
            ForgeDirection facing = Button.getFacing(TE);
            Button.setState(TE, 1, true);
            this.notifySideNeighbor(world, TE.field_70329_l, TE.field_70330_m, TE.field_70327_n, facing.ordinal());
            world.func_72836_a(TE.field_70329_l, TE.field_70330_m, TE.field_70327_n, this.field_71990_ca, this.func_71859_p_(world));
            actionResult.setAltered();
        }
    }

    @Override
    public void func_71852_a(World world, int x, int y, int z, int blockID, int metadata) {
        TEBase TE = this.getSimpleTileEntity((IBlockAccess)world, x, y, z);
        if (TE != null && this.isDepressed(TE)) {
            this.notifySideNeighbor(world, x, y, z, Button.getFacing(TE).ordinal());
        }
        super.func_71852_a(world, x, y, z, blockID, metadata);
    }

    private boolean isDepressed(TEBase TE) {
        return Button.getState(TE) == 1;
    }

    @Override
    public int func_71865_a(IBlockAccess world, int x, int y, int z, int side) {
        TEBase TE = this.getTileEntity(world, x, y, z);
        if (TE != null) {
            return this.getPowerSupply((TEBase)world.func_72796_p(x, y, z));
        }
        return 0;
    }

    @Override
    public int func_71855_c(IBlockAccess world, int x, int y, int z, int side) {
        TEBase TE = this.getTileEntity(world, x, y, z);
        if (TE != null) {
            return Button.getFacing(TE).ordinal() == side ? this.getPowerSupply(TE) : 0;
        }
        return 0;
    }

    private int getPowerSupply(TEBase TE) {
        int polarity = Button.getPolarity(TE);
        if (this.isDepressed(TE)) {
            return polarity == 0 ? 15 : 0;
        }
        return polarity == 1 ? 15 : 0;
    }

    public boolean func_71853_i() {
        return true;
    }

    public void func_71847_b(World world, int x, int y, int z, Random random) {
        TEBase TE = this.getTileEntity((IBlockAccess)world, x, y, z);
        if (!world.field_72995_K && TE != null) {
            Button.setState(TE, 0, true);
            this.notifySideNeighbor(world, x, y, z, Button.getFacing(TE).ordinal());
        }
    }

    private void notifySideNeighbor(World world, int x, int y, int z, int side) {
        world.func_72898_h(x, y, z, this.field_71990_ca);
        ForgeDirection dir = ForgeDirection.getOrientation((int)side);
        world.func_72898_h(x - dir.offsetX, y, z - dir.offsetZ, this.field_71990_ca);
    }

    public int func_71857_b() {
        return BlockRegistry.carpentersButtonRenderID;
    }
}

