/*
 * Decompiled with CFR 0.152.
 */
package com.carpentersblocks.block;

import com.carpentersblocks.block.BlockCoverable;
import com.carpentersblocks.data.FlowerPot;
import com.carpentersblocks.network.PacketEnrichPlant;
import com.carpentersblocks.tileentity.TEBase;
import com.carpentersblocks.tileentity.TECarpentersFlowerPot;
import com.carpentersblocks.util.BlockProperties;
import com.carpentersblocks.util.flowerpot.FlowerPotHandler;
import com.carpentersblocks.util.flowerpot.FlowerPotProperties;
import com.carpentersblocks.util.handler.EventHandler;
import com.carpentersblocks.util.handler.PacketHandler;
import com.carpentersblocks.util.registry.BlockRegistry;
import com.carpentersblocks.util.registry.IconRegistry;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IconRegister;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.Icon;
import net.minecraft.util.MathHelper;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeDirection;

public class BlockCarpentersFlowerPot
extends BlockCoverable {
    public BlockCarpentersFlowerPot(int blockID, Material material) {
        super(blockID, material);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void func_94332_a(IconRegister iconRegister) {
        IconRegistry.icon_flower_pot = iconRegister.func_94245_a("CarpentersBlocks:flowerpot/flower_pot");
        IconRegistry.icon_flower_pot_glass = iconRegister.func_94245_a("CarpentersBlocks:flowerpot/flower_pot_glass");
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public Icon func_71858_a(int side, int metadata) {
        if (side == 1 && metadata == 0) {
            return IconRegistry.icon_flower_pot;
        }
        return super.func_71858_a(side, metadata);
    }

    @Override
    protected boolean onHammerLeftClick(TEBase TE, EntityPlayer entityPlayer) {
        BlockProperties.setPrevDesign(TE);
        if (BlockProperties.hasCover(TE, 6)) {
            BlockProperties.setCover(TE, 6, null);
        }
        return true;
    }

    @Override
    protected boolean onHammerRightClick(TEBase TE, EntityPlayer entityPlayer) {
        if (entityPlayer.func_70093_af()) {
            BlockProperties.clearDesign(TE);
        } else {
            BlockProperties.setNextDesign(TE);
        }
        if (BlockProperties.hasCover(TE, 6)) {
            BlockProperties.setCover(TE, 6, null);
        }
        return true;
    }

    @Override
    protected void preOnBlockClicked(TEBase TE, World world, int x, int y, int z, EntityPlayer entityPlayer, BlockCoverable.ActionResult actionResult) {
        if (entityPlayer.func_70093_af()) {
            if (EventHandler.hitY > 0.375f) {
                if (FlowerPot.isEnriched(TE)) {
                    actionResult.setSoundSource(new ItemStack(Block.field_71939_E));
                    FlowerPot.setEnrichment(TE, false);
                    actionResult.setAltered();
                }
                if (!actionResult.altered && FlowerPotProperties.hasPlant(TE)) {
                    actionResult.setSoundSource(FlowerPotProperties.getPlant(TE));
                    FlowerPotProperties.setPlant(TE, null);
                    actionResult.setAltered();
                }
            } else if (FlowerPotProperties.hasSoil(TE) && EventHandler.eventFace == 1 && EventHandler.hitX > 0.375f && EventHandler.hitX < 0.625f && EventHandler.hitZ > 0.375f && EventHandler.hitZ < 0.625f) {
                actionResult.setSoundSource(FlowerPotProperties.getSoil(TE));
                FlowerPotProperties.setSoil(TE, null);
                actionResult.setAltered();
            }
        }
    }

    @Override
    protected void preOnBlockActivated(TEBase TE, EntityPlayer entityPlayer, int side, float hitX, float hitY, float hitZ, BlockCoverable.ActionResult actionResult) {
        ItemStack itemStack = entityPlayer.func_70694_bm();
        if (itemStack != null) {
            boolean soilAreaClicked;
            boolean hasCover = BlockProperties.hasCover(TE, 6);
            boolean hasOverlay = BlockProperties.hasOverlay(TE, 6);
            boolean bl = soilAreaClicked = side == 1 && hitX > 0.375f && hitX < 0.625f && hitZ > 0.375f && hitZ < 0.625f;
            if (FlowerPotProperties.hasSoil(TE)) {
                if (!soilAreaClicked && (!hasCover && BlockProperties.isCover(itemStack) || !hasOverlay && BlockProperties.isOverlay(itemStack))) {
                    return;
                }
                if (!FlowerPotProperties.hasPlant(TE) && FlowerPotProperties.isPlant(itemStack)) {
                    int angle = MathHelper.func_76128_c((double)((double)((entityPlayer.field_70177_z + 180.0f) * 16.0f / 360.0f) + 0.5)) & 0xF;
                    FlowerPot.setAngle(TE, angle);
                    FlowerPotProperties.setPlant(TE, itemStack);
                    actionResult.setAltered().setSoundSource(itemStack).decInventory();
                }
            } else if (FlowerPotProperties.isSoil(itemStack) && (hasCover || soilAreaClicked)) {
                FlowerPotProperties.setSoil(TE, itemStack);
                actionResult.setAltered().setSoundSource(itemStack).decInventory();
            }
        }
    }

    @Override
    public boolean func_71903_a(World world, int x, int y, int z, EntityPlayer entityPlayer, int side, float hitX, float hitY, float hitZ) {
        ItemStack itemStack;
        TEBase TE;
        if (world.field_72995_K && (TE = this.getTileEntity((IBlockAccess)world, x, y, z)) != null && FlowerPotProperties.hasPlant(TE) && (itemStack = entityPlayer.func_71045_bC()) != null && itemStack.func_77973_b().equals(Item.field_77756_aW) && itemStack.func_77960_j() == 15 && !FlowerPot.isEnriched(TE) && FlowerPotProperties.isPlantColorable(TE)) {
            PacketHandler.sendPacketToServer(new PacketEnrichPlant(x, y, z, FlowerPotProperties.getPlantColor(TE)));
            return true;
        }
        return super.func_71903_a(world, x, y, z, entityPlayer, side, hitX, hitY, hitZ);
    }

    @Override
    public void func_71863_a(World world, int x, int y, int z, int blockID) {
        TEBase TE;
        if (!world.field_72995_K && (TE = this.getTileEntity((IBlockAccess)world, x, y, z)) != null && !this.func_71850_a_(world, x, y, z, 1)) {
            this.func_71929_a(world, x, y, z, this.func_71880_c_(0));
            world.func_94571_i(x, y, z);
        }
        super.func_71863_a(world, x, y, z, blockID);
    }

    public boolean func_71930_b(World world, int x, int y, int z) {
        Block block_YN = Block.field_71973_m[world.func_72798_a(x, y - 1, z)];
        if (block_YN != null) {
            return block_YN.isBlockSolidOnSide(world, x, y - 1, z, ForgeDirection.UP) || block_YN.canPlaceTorchOnTop(world, x, y - 1, z);
        }
        return false;
    }

    public void func_71902_a(IBlockAccess world, int x, int y, int z) {
        TEBase TE = this.getTileEntity(world, x, y, z);
        if (TE != null && TE instanceof TECarpentersFlowerPot) {
            if (FlowerPotProperties.hasPlant(TE)) {
                switch (FlowerPotHandler.getPlantProfile(TE)) {
                    case CACTUS: 
                    case LEAVES: {
                        this.func_71905_a(0.3125f, 0.0f, 0.3125f, 0.6875f, 0.99f, 0.6875f);
                        break;
                    }
                    default: {
                        this.func_71905_a(0.3125f, 0.0f, 0.3125f, 0.6875f, 0.75f, 0.6875f);
                        break;
                    }
                }
            } else {
                this.func_71905_a(0.3125f, 0.0f, 0.3125f, 0.6875f, 0.375f, 0.6875f);
            }
        }
    }

    public AxisAlignedBB func_71872_e(World world, int x, int y, int z) {
        TEBase TE = this.getTileEntity((IBlockAccess)world, x, y, z);
        if (TE != null && TE instanceof TECarpentersFlowerPot) {
            AxisAlignedBB axisAlignedBB = AxisAlignedBB.func_72332_a().func_72299_a((double)((float)x + 0.3125f), (double)y, (double)((float)z + 0.3125f), (double)((float)x + 0.6875f), (double)((float)y + 0.375f), (double)((float)z + 0.6875f));
            if (FlowerPotProperties.hasPlant(TE)) {
                switch (FlowerPotHandler.getPlantProfile(TE)) {
                    case CACTUS: 
                    case LEAVES: {
                        axisAlignedBB = AxisAlignedBB.func_72332_a().func_72299_a((double)((float)x + 0.3125f), (double)y, (double)((float)z + 0.3125f), (double)((float)x + 0.6875f), (double)((float)y + 0.99f), (double)((float)z + 0.6875f));
                        break;
                    }
                }
            }
            return axisAlignedBB;
        }
        return super.func_71872_e(world, x, y, z);
    }

    @Override
    public int getLightValue(IBlockAccess world, int x, int y, int z) {
        int lightValue = super.getLightValue(world, x, y, z);
        if (this.grabLightValue) {
            return 0;
        }
        this.grabLightValue = true;
        TEBase TE = this.getTileEntity(world, x, y, z);
        if (TE != null && TE instanceof TECarpentersFlowerPot) {
            ItemStack itemStack;
            int temp;
            if (FlowerPotProperties.hasSoil(TE) && (temp = this.getLightValue(TE, FlowerPotProperties.toBlock(itemStack = FlowerPotProperties.getSoil(TE)), itemStack.func_77960_j())) > lightValue) {
                lightValue = temp;
            }
            if (FlowerPotProperties.hasPlant(TE) && (temp = this.getLightValue(TE, FlowerPotProperties.toBlock(itemStack = FlowerPotProperties.getPlant(TE)), itemStack.func_77960_j())) > lightValue) {
                lightValue = temp;
            }
        }
        this.grabLightValue = false;
        return lightValue;
    }

    @Override
    public void func_71869_a(World world, int x, int y, int z, Entity entity) {
        TEBase TE = this.getTileEntity((IBlockAccess)world, x, y, z);
        if (TE != null && TE instanceof TECarpentersFlowerPot && FlowerPotProperties.hasPlant(TE)) {
            ItemStack itemStack = FlowerPotProperties.getPlant(TE);
            BlockProperties.setHostMetadata(TE, itemStack.func_77960_j());
            FlowerPotProperties.toBlock(itemStack).func_71869_a(world, x, y, z, entity);
            BlockProperties.resetHostMetadata(TE);
        }
        super.func_71869_a(world, x, y, z, entity);
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_82505_u_() {
        return true;
    }

    @Override
    protected boolean canCoverSide(TEBase TE, World world, int x, int y, int z, int side) {
        return side == 6 ? !BlockProperties.hasDesign(TE) : false;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void func_71862_a(World world, int x, int y, int z, Random random) {
        TEBase TE = this.getTileEntity((IBlockAccess)world, x, y, z);
        if (TE != null && TE instanceof TECarpentersFlowerPot) {
            ItemStack itemStack;
            if (FlowerPotProperties.hasPlant(TE)) {
                itemStack = FlowerPotProperties.getPlant(TE);
                BlockProperties.setHostMetadata(TE, itemStack.func_77960_j());
                FlowerPotProperties.toBlock(itemStack).func_71862_a(world, x, y, z, random);
                BlockProperties.resetHostMetadata(TE);
            }
            if (FlowerPotProperties.hasSoil(TE)) {
                itemStack = FlowerPotProperties.getSoil(TE);
                BlockProperties.setHostMetadata(TE, itemStack.func_77960_j());
                BlockProperties.toBlock(itemStack).func_71862_a(world, x, y, z, random);
                BlockProperties.resetHostMetadata(TE);
            }
        }
        super.func_71862_a(world, x, y, z, random);
    }

    @Override
    public ArrayList<ItemStack> getBlockDropped(World world, int x, int y, int z, int metadata, int fortune) {
        ArrayList<ItemStack> ret = super.getBlockDropped(world, x, y, z, metadata, fortune);
        TEBase TE = this.getSimpleTileEntity((IBlockAccess)world, x, y, z);
        if (TE != null && TE instanceof TECarpentersFlowerPot) {
            if (FlowerPot.isEnriched(TE)) {
                ret.add(new ItemStack(Item.field_77756_aW, 1, 15));
            }
            if (FlowerPotProperties.hasPlant(TE)) {
                ret.add(FlowerPotProperties.getPlant(TE));
            }
            if (FlowerPotProperties.hasSoil(TE)) {
                ret.add(FlowerPotProperties.getSoil(TE));
            }
        }
        return ret;
    }

    @Override
    public TileEntity func_72274_a(World world) {
        return new TECarpentersFlowerPot();
    }

    public int func_71857_b() {
        return BlockRegistry.carpentersFlowerPotRenderID;
    }
}

