/*
 * Decompiled with CFR 0.152.
 */
package com.carpentersblocks.block;

import com.carpentersblocks.block.BlockCoverable;
import com.carpentersblocks.data.Barrier;
import com.carpentersblocks.data.Gate;
import com.carpentersblocks.tileentity.TEBase;
import com.carpentersblocks.util.registry.BlockRegistry;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.MathHelper;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class BlockCarpentersGate
extends BlockCoverable {
    public BlockCarpentersGate(int blockID, Material material) {
        super(blockID, material);
    }

    @Override
    protected boolean onHammerRightClick(TEBase TE, EntityPlayer entityPlayer) {
        int type = Gate.getType(TE);
        if (entityPlayer.func_70093_af()) {
            if (type <= 3 && ++type > 3) {
                type = 0;
            }
        } else if (type <= 3) {
            type = 4;
        } else if (++type > 6) {
            type = 0;
        }
        Gate.setType(TE, type);
        return true;
    }

    @Override
    protected void postOnBlockActivated(TEBase TE, EntityPlayer entityPlayer, int side, float hitX, float hitY, float hitZ, BlockCoverable.ActionResult actionResult) {
        if (Gate.getState(TE) == 1) {
            Gate.setState(TE, 0, true);
            this.cycleNeighborGate(TE, TE.func_70314_l(), TE.field_70329_l, TE.field_70330_m, TE.field_70327_n);
        } else {
            int facing = (MathHelper.func_76128_c((double)((double)(entityPlayer.field_70177_z * 4.0f / 360.0f) + 0.5)) & 3) % 4;
            Gate.setState(TE, 1, true);
            if (Gate.getFacing(TE) == 0) {
                Gate.setDirOpen(TE, facing == 0 ? 0 : 1);
            } else {
                Gate.setDirOpen(TE, facing == 3 ? 0 : 1);
            }
            this.cycleNeighborGate(TE, TE.func_70314_l(), TE.field_70329_l, TE.field_70330_m, TE.field_70327_n);
        }
        actionResult.setAltered().setNoSound();
    }

    public boolean func_71930_b(World world, int x, int y, int z) {
        Block blockYN = Block.field_71973_m[world.func_72798_a(x, y - 1, z)];
        return blockYN != null && !blockYN.field_72018_cp.func_76220_a() ? false : super.func_71930_b(world, x, y, z);
    }

    public AxisAlignedBB func_71872_e(World world, int x, int y, int z) {
        TEBase TE = this.getTileEntity((IBlockAccess)world, x, y, z);
        if (TE != null) {
            if (Gate.getState(TE) == 1) {
                return null;
            }
            if (Gate.getFacing(TE) == 1) {
                if (Gate.getType(TE) == 0 || Gate.getType(TE) == 6) {
                    return AxisAlignedBB.func_72332_a().func_72299_a((double)((float)x + 0.4375f), (double)y, (double)z, (double)((float)x + 0.5625f), (double)((float)y + 1.5f), (double)((float)z + 1.0f));
                }
                return AxisAlignedBB.func_72332_a().func_72299_a((double)((float)x + 0.375f), (double)y, (double)z, (double)((float)x + 0.625f), (double)((float)y + 1.5f), (double)((float)z + 1.0f));
            }
            if (Gate.getType(TE) == 0 || Gate.getType(TE) == 6) {
                return AxisAlignedBB.func_72332_a().func_72299_a((double)x, (double)y, (double)((float)z + 0.4375f), (double)((float)x + 1.0f), (double)((float)y + 1.5f), (double)((float)z + 0.5625f));
            }
            return AxisAlignedBB.func_72332_a().func_72299_a((double)x, (double)y, (double)((float)z + 0.375f), (double)((float)x + 1.0f), (double)((float)y + 1.5f), (double)((float)z + 0.625f));
        }
        return null;
    }

    public void func_71902_a(IBlockAccess world, int x, int y, int z) {
        TEBase TE = this.getTileEntity(world, x, y, z);
        if (TE != null) {
            if (Gate.getFacing(TE) == 1) {
                if (Gate.getType(TE) == 0 || Gate.getType(TE) == 6) {
                    this.func_71905_a(0.4375f, 0.0f, 0.0f, 0.5625f, 1.0f, 1.0f);
                } else {
                    this.func_71905_a(0.375f, 0.0f, 0.0f, 0.625f, 1.0f, 1.0f);
                }
            } else if (Gate.getType(TE) == 0 || Gate.getType(TE) == 6) {
                this.func_71905_a(0.0f, 0.0f, 0.4375f, 1.0f, 1.0f, 0.5625f);
            } else {
                this.func_71905_a(0.0f, 0.0f, 0.375f, 1.0f, 1.0f, 0.625f);
            }
        }
    }

    private void cycleNeighborGate(TEBase TE, World world, int x, int y, int z) {
        TEBase TE_YP;
        boolean isGateAbove;
        Block blockYN = Block.field_71973_m[world.func_72798_a(x, y - 1, z)];
        Block blockYP = Block.field_71973_m[world.func_72798_a(x, y + 1, z)];
        boolean isGateBelow = blockYN != null && blockYN.equals((Object)this);
        boolean bl = isGateAbove = blockYP != null && blockYP.equals((Object)this);
        if (isGateBelow) {
            TEBase TE_YN = this.getTileEntity((IBlockAccess)world, x, y - 1, z);
            if (Gate.getFacing(TE_YN) == Gate.getFacing(TE)) {
                Gate.setDirOpen(TE_YN, Gate.getDirOpen(TE));
                Gate.setState(TE_YN, Gate.getState(TE), false);
            }
        } else if (isGateAbove && Gate.getFacing(TE_YP = this.getTileEntity((IBlockAccess)world, x, y + 1, z)) == Gate.getFacing(TE)) {
            Gate.setDirOpen(TE_YP, Gate.getDirOpen(TE));
            Gate.setState(TE_YP, Gate.getState(TE), false);
        }
    }

    @Override
    public void func_71860_a(World world, int x, int y, int z, EntityLivingBase entityLiving, ItemStack itemStack) {
        TEBase TE = this.getTileEntity((IBlockAccess)world, x, y, z);
        if (TE != null) {
            TEBase[] TE_list;
            int facing = (MathHelper.func_76128_c((double)((double)(entityLiving.field_70177_z * 4.0f / 360.0f) + 0.5)) & 3) % 4;
            Gate.setFacing(TE, facing == 3 || facing == 1 ? 1 : 0);
            for (TEBase TE_current : TE_list = this.getAdjacentTileEntities(world, x, y, z)) {
                if (TE_current == null) continue;
                Block block = TE_current.func_70311_o();
                if (block.equals((Object)this)) {
                    Gate.setType(TE, Gate.getType(TE_current));
                    continue;
                }
                if (!block.equals(BlockRegistry.blockCarpentersGate)) continue;
                Gate.setType(TE, Barrier.getType(TE_current));
            }
        }
        super.func_71860_a(world, x, y, z, entityLiving, itemStack);
    }

    @Override
    public void func_71863_a(World world, int x, int y, int z, int blockID) {
        TEBase TE;
        if (!world.field_72995_K && (TE = this.getTileEntity((IBlockAccess)world, x, y, z)) != null) {
            boolean isPowered = world.func_72864_z(x, y, z);
            Block block = Block.field_71973_m[blockID];
            if (isPowered || block != null && block.func_71853_i()) {
                int state = Gate.getState(TE);
                if (isPowered && state == 0) {
                    Gate.setState(TE, 1, true);
                    this.cycleNeighborGate(TE, world, x, y, z);
                } else if (!isPowered && state == 1) {
                    Gate.setState(TE, 0, true);
                    this.cycleNeighborGate(TE, world, x, y, z);
                }
            }
        }
        super.func_71863_a(world, x, y, z, blockID);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public boolean func_71877_c(IBlockAccess world, int x, int y, int z, int side) {
        return true;
    }

    public int func_71857_b() {
        return BlockRegistry.carpentersGateRenderID;
    }
}

