/*
 * Decompiled with CFR 0.152.
 */
package com.carpentersblocks.block;

import com.carpentersblocks.block.BlockCarpentersBlock;
import com.carpentersblocks.block.BlockCarpentersStairs;
import com.carpentersblocks.block.BlockCoverable;
import com.carpentersblocks.data.Hatch;
import com.carpentersblocks.tileentity.TEBase;
import com.carpentersblocks.util.BlockProperties;
import com.carpentersblocks.util.handler.ChatHandler;
import com.carpentersblocks.util.registry.BlockRegistry;
import com.carpentersblocks.util.registry.IconRegistry;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.BlockHalfSlab;
import net.minecraft.block.BlockStairs;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IconRegister;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.Vec3;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeDirection;

public class BlockCarpentersHatch
extends BlockCoverable {
    public BlockCarpentersHatch(int blockID, Material material) {
        super(blockID, material);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void func_94332_a(IconRegister iconRegister) {
        IconRegistry.icon_hatch_glass = iconRegister.func_94245_a("CarpentersBlocks:hatch/hatch_glass");
        IconRegistry.icon_hatch_french_glass = iconRegister.func_94245_a("CarpentersBlocks:hatch/hatch_french_glass");
        IconRegistry.icon_hatch_screen = iconRegister.func_94245_a("CarpentersBlocks:hatch/hatch_screen");
    }

    @Override
    protected boolean onHammerLeftClick(TEBase TE, EntityPlayer entityPlayer) {
        BlockProperties.getMetadata(TE);
        if (!TE.func_70314_l().field_72995_K) {
            this.findNextSideSupportBlock(TE, TE.func_70314_l(), TE.field_70329_l, TE.field_70330_m, TE.field_70327_n);
        }
        return true;
    }

    @Override
    protected boolean onHammerRightClick(TEBase TE, EntityPlayer entityPlayer) {
        if (!entityPlayer.func_70093_af()) {
            int type = Hatch.getType(TE);
            if (++type > 4) {
                type = 0;
            }
            Hatch.setType(TE, type);
        } else {
            int rigidity = Hatch.getRigidity(TE) == 0 ? 1 : 0;
            Hatch.setRigidity(TE, rigidity);
            switch (rigidity) {
                case 0: {
                    ChatHandler.sendMessageToPlayer("message.activation_wood.name", entityPlayer);
                    break;
                }
                case 1: {
                    ChatHandler.sendMessageToPlayer("message.activation_iron.name", entityPlayer);
                }
            }
        }
        return true;
    }

    @Override
    protected void postOnBlockActivated(TEBase TE, EntityPlayer entityPlayer, int side, float hitX, float hitY, float hitZ, BlockCoverable.ActionResult actionResult) {
        if (!this.activationRequiresRedstone(TE)) {
            Hatch.setState(TE, Hatch.getState(TE) == 0 ? 1 : 0);
            actionResult.setAltered().setNoSound();
        }
    }

    private boolean activationRequiresRedstone(TEBase TE) {
        return Hatch.getRigidity(TE) == 1;
    }

    public void func_71902_a(IBlockAccess world, int x, int y, int z) {
        TEBase TE = this.getTileEntity(world, x, y, z);
        if (TE != null) {
            boolean isHigh = Hatch.getPos(TE) == 1;
            boolean isOpen = Hatch.getState(TE) == 1;
            int dir = Hatch.getDir(TE);
            float thickness = 0.1875f;
            if (Hatch.getType(TE) == 0) {
                thickness = 0.125f;
            }
            if (isHigh) {
                this.func_71905_a(0.0f, 1.0f - thickness, 0.0f, 1.0f, 1.0f, 1.0f);
            } else {
                this.func_71905_a(0.0f, 0.0f, 0.0f, 1.0f, thickness, 1.0f);
            }
            if (isOpen) {
                switch (dir) {
                    case 0: {
                        this.func_71905_a(0.0f, 0.0f, 1.0f - thickness, 1.0f, 1.0f, 1.0f);
                        break;
                    }
                    case 1: {
                        this.func_71905_a(0.0f, 0.0f, 0.0f, 1.0f, 1.0f, thickness);
                        break;
                    }
                    case 2: {
                        this.func_71905_a(1.0f - thickness, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f);
                        break;
                    }
                    case 3: {
                        this.func_71905_a(0.0f, 0.0f, 0.0f, thickness, 1.0f, 1.0f);
                    }
                }
            }
        }
    }

    public void func_71871_a(World world, int x, int y, int z, AxisAlignedBB axisAlignedBB, List list, Entity entity) {
        this.func_71902_a((IBlockAccess)world, x, y, z);
        super.func_71871_a(world, x, y, z, axisAlignedBB, list, entity);
    }

    @Override
    public void func_71863_a(World world, int x, int y, int z, int blockID) {
        TEBase TE;
        if (!world.field_72995_K && (TE = this.getTileEntity((IBlockAccess)world, x, y, z)) != null) {
            int dir = Hatch.getDir(TE);
            int state = Hatch.getState(TE);
            int xOffset = x;
            int zOffset = z;
            switch (dir) {
                case 0: {
                    zOffset = z + 1;
                    break;
                }
                case 1: {
                    --zOffset;
                    break;
                }
                case 2: {
                    xOffset = x + 1;
                    break;
                }
                case 3: {
                    --xOffset;
                }
            }
            Block blockOffset = Block.field_71973_m[world.func_72798_a(xOffset, y, zOffset)];
            if (blockOffset != null && !this.isValidSupportBlock(world, x, y, z, blockOffset) && !blockOffset.isBlockSolidOnSide(world, xOffset, y, zOffset, ForgeDirection.getOrientation((int)(dir + 2)))) {
                this.findNextSideSupportBlock(TE, world, x, y, z);
            }
            boolean isPowered = world.func_72864_z(x, y, z);
            boolean isOpen = state == 1;
            Block block = Block.field_71973_m[blockID];
            if (block != null && block.func_71853_i() && isPowered != isOpen) {
                Hatch.setState(TE, state == 1 ? 0 : 1);
            }
        }
        super.func_71863_a(world, x, y, z, blockID);
    }

    public MovingObjectPosition func_71878_a(World world, int x, int y, int z, Vec3 startVec, Vec3 endVec) {
        this.func_71902_a((IBlockAccess)world, x, y, z);
        return super.func_71878_a(world, x, y, z, startVec, endVec);
    }

    public int func_85104_a(World world, int x, int y, int z, int side, float hitX, float hitY, float hitZ, int metadata) {
        int initData = 0;
        if (side > 1) {
            initData = side - 2;
        }
        if (side != 1 && side != 0 && hitY > 0.5f) {
            initData |= 8;
        }
        return initData;
    }

    @Override
    public void func_71860_a(World world, int x, int y, int z, EntityLivingBase entityLiving, ItemStack itemStack) {
        TEBase TE = this.getTileEntity((IBlockAccess)world, x, y, z);
        if (TE != null) {
            int metadata = world.func_72805_g(x, y, z);
            Hatch.setDir(TE, metadata & 3);
            if ((metadata & 8) > 0) {
                Hatch.setPos(TE, 1);
            }
        }
        super.func_71860_a(world, x, y, z, entityLiving, itemStack);
    }

    public boolean func_71850_a_(World world, int x, int y, int z, int side) {
        switch (side) {
            case 2: {
                Block block = Block.field_71973_m[world.func_72798_a(x, y, z + 1)];
                return block != null && (this.isValidSupportBlock(world, x, y, z, block) || block.isBlockSolidOnSide(world, x, y, z + 1, ForgeDirection.getOrientation((int)ForgeDirection.OPPOSITES[3])));
            }
            case 3: {
                Block block = Block.field_71973_m[world.func_72798_a(x, y, z - 1)];
                return block != null && (this.isValidSupportBlock(world, x, y, z, block) || block.isBlockSolidOnSide(world, x, y, z - 1, ForgeDirection.getOrientation((int)ForgeDirection.OPPOSITES[2])));
            }
            case 4: {
                Block block = Block.field_71973_m[world.func_72798_a(x + 1, y, z)];
                return block != null && (this.isValidSupportBlock(world, x, y, z, block) || block.isBlockSolidOnSide(world, x + 1, y, z, ForgeDirection.getOrientation((int)ForgeDirection.OPPOSITES[5])));
            }
            case 5: {
                Block block = Block.field_71973_m[world.func_72798_a(x - 1, y, z)];
                return block != null && (this.isValidSupportBlock(world, x, y, z, block) || block.isBlockSolidOnSide(world, x - 1, y, z, ForgeDirection.getOrientation((int)ForgeDirection.OPPOSITES[4])));
            }
        }
        return false;
    }

    private void findNextSideSupportBlock(TEBase TE, World world, int x, int y, int z) {
        int count;
        int dir = Hatch.getDir(TE);
        if (++dir > 3) {
            dir = 0;
        }
        for (count = 0; !this.func_71850_a_(world, x, y, z, dir + 2) && count < 4; ++count) {
            if (++dir <= 3) continue;
            dir = 0;
        }
        if (count == 4) {
            this.func_71929_a(world, x, y, z, this.func_71880_c_(0));
            world.func_94571_i(x, y, z);
        } else {
            Hatch.setDir(TE, dir);
        }
    }

    public boolean isLadder(World world, int x, int y, int z, EntityLivingBase entityLiving) {
        TEBase TE = this.getTileEntity((IBlockAccess)world, x, y, z);
        return TE != null && Hatch.getType(TE) == 0 && Hatch.getPos(TE) == 1 && Hatch.getState(TE) == 1;
    }

    private boolean isValidSupportBlock(World world, int x, int y, int z, Block block) {
        return block == Block.field_72014_bd || block instanceof BlockCarpentersStairs || block instanceof BlockCarpentersBlock || block instanceof BlockHalfSlab || block instanceof BlockStairs;
    }

    public int func_71857_b() {
        return BlockRegistry.carpentersHatchRenderID;
    }
}

