/*
 * Decompiled with CFR 0.152.
 */
package com.carpentersblocks.block;

import com.carpentersblocks.block.BlockCoverable;
import com.carpentersblocks.data.PressurePlate;
import com.carpentersblocks.tileentity.TEBase;
import com.carpentersblocks.util.BlockProperties;
import com.carpentersblocks.util.handler.ChatHandler;
import com.carpentersblocks.util.registry.BlockRegistry;
import com.carpentersblocks.util.registry.IconRegistry;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import java.util.Random;
import net.minecraft.block.material.Material;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EnumCreatureType;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.Icon;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class BlockCarpentersPressurePlate
extends BlockCoverable {
    public BlockCarpentersPressurePlate(int blockID, Material material) {
        super(blockID, material);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public Icon getIcon() {
        return IconRegistry.icon_uncovered_full;
    }

    @Override
    protected boolean onHammerLeftClick(TEBase TE, EntityPlayer entityPlayer) {
        int polarity = PressurePlate.getPolarity(TE) == 0 ? 1 : 0;
        PressurePlate.setPolarity(TE, polarity);
        TE.func_70314_l().func_72898_h(TE.field_70329_l, TE.field_70330_m - 1, TE.field_70327_n, this.field_71990_ca);
        switch (polarity) {
            case 0: {
                ChatHandler.sendMessageToPlayer("message.polarity_pos.name", entityPlayer);
                break;
            }
            case 1: {
                ChatHandler.sendMessageToPlayer("message.polarity_neg.name", entityPlayer);
            }
        }
        return true;
    }

    @Override
    protected boolean onHammerRightClick(TEBase TE, EntityPlayer entityPlayer) {
        int trigger;
        switch (PressurePlate.getTriggerEntity(TE)) {
            case 0: {
                trigger = 1;
                break;
            }
            case 1: {
                trigger = 2;
                break;
            }
            case 2: {
                trigger = 3;
                break;
            }
            default: {
                trigger = 0;
            }
        }
        PressurePlate.setTriggerEntity(TE, trigger);
        switch (trigger) {
            case 0: {
                ChatHandler.sendMessageToPlayer("message.trigger_player.name", entityPlayer);
                break;
            }
            case 1: {
                ChatHandler.sendMessageToPlayer("message.trigger_monster.name", entityPlayer);
                break;
            }
            case 2: {
                ChatHandler.sendMessageToPlayer("message.trigger_animal.name", entityPlayer);
                break;
            }
            case 3: {
                ChatHandler.sendMessageToPlayer("message.trigger_all.name", entityPlayer);
            }
        }
        return true;
    }

    public void func_71902_a(IBlockAccess world, int x, int y, int z) {
        TEBase TE = this.getTileEntity(world, x, y, z);
        if (TE != null) {
            this.func_71905_a(0.0625f, 0.0f, 0.0625f, 0.9375f, this.isDepressed(TE) ? 0.03125f : 0.0625f, 0.9375f);
        }
    }

    public int func_71859_p_(World world) {
        return 20;
    }

    public AxisAlignedBB func_71872_e(World world, int x, int y, int z) {
        return null;
    }

    public boolean func_71930_b(World world, int x, int y, int z) {
        return world.func_72797_t(x, y - 1, z);
    }

    @Override
    public void func_71863_a(World world, int x, int y, int z, int blockID) {
        TEBase TE;
        if (!world.field_72995_K && (TE = this.getTileEntity((IBlockAccess)world, x, y, z)) != null && !world.func_72797_t(x, y - 1, z)) {
            this.func_71929_a(world, x, y, z, this.func_71880_c_(0));
            world.func_94571_i(x, y, z);
        }
        super.func_71863_a(world, x, y, z, blockID);
    }

    public void func_71847_b(World world, int x, int y, int z, Random random) {
        TEBase TE;
        if (!world.field_72995_K && (TE = this.getTileEntity((IBlockAccess)world, x, y, z)) != null) {
            List entityList = world.func_72872_a(Entity.class, this.getSensitiveAABB(x, y, z));
            boolean shouldActivate = false;
            if (!entityList.isEmpty()) {
                for (int count = 0; count < entityList.size() && !shouldActivate; ++count) {
                    if (!this.shouldTrigger(TE, (Entity)entityList.get(count), world, x, y, z)) continue;
                    shouldActivate = true;
                }
            }
            if (!shouldActivate && this.isDepressed(TE)) {
                this.toggleOff(TE, world, x, y, z);
            } else {
                world.func_72836_a(x, y, z, this.field_71990_ca, this.func_71859_p_(world));
            }
        }
    }

    @Override
    public void func_71869_a(World world, int x, int y, int z, Entity entity) {
        TEBase TE;
        if (!world.field_72995_K && (TE = this.getTileEntity((IBlockAccess)world, x, y, z)) != null && this.shouldTrigger(TE, entity, world, x, y, z) && !this.isDepressed(TE)) {
            this.toggleOn(TE, world, x, y, z);
        }
    }

    private void toggleOn(TEBase TE, World world, int x, int y, int z) {
        PressurePlate.setState(TE, 1, true);
        this.notifyNeighborsOfUpdate(world, x, y, z);
        world.func_72836_a(x, y, z, this.field_71990_ca, this.func_71859_p_(world));
    }

    private void toggleOff(TEBase TE, World world, int x, int y, int z) {
        PressurePlate.setState(TE, 0, true);
        this.notifyNeighborsOfUpdate(world, x, y, z);
    }

    private AxisAlignedBB getSensitiveAABB(int x, int y, int z) {
        return AxisAlignedBB.func_72332_a().func_72299_a((double)((float)x + 0.125f), (double)y, (double)((float)z + 0.125f), (double)((float)x + 1.0f - 0.125f), (double)y + 0.25, (double)((float)z + 1.0f - 0.125f));
    }

    private void notifyNeighborsOfUpdate(World world, int x, int y, int z) {
        world.func_72898_h(x, y, z, this.field_71990_ca);
        world.func_72898_h(x, y - 1, z, this.field_71990_ca);
    }

    private boolean isDepressed(TEBase TE) {
        return PressurePlate.getState(TE) == 1;
    }

    @Override
    public int func_71865_a(IBlockAccess world, int x, int y, int z, int side) {
        TEBase TE = this.getTileEntity(world, x, y, z);
        return TE == null ? 0 : this.getPowerSupply(TE, BlockProperties.getMetadata(TE));
    }

    @Override
    public int func_71855_c(IBlockAccess world, int x, int y, int z, int side) {
        TEBase TE = this.getTileEntity(world, x, y, z);
        return TE == null ? 0 : (side == 1 ? this.getPowerSupply(TE, BlockProperties.getMetadata(TE)) : 0);
    }

    public boolean func_71853_i() {
        return true;
    }

    private int getPowerSupply(TEBase TE, int data) {
        int polarity = PressurePlate.getPolarity(TE);
        if (this.isDepressed(TE)) {
            return polarity == 0 ? 15 : 0;
        }
        return polarity == 1 ? 15 : 0;
    }

    private boolean shouldTrigger(TEBase TE, Entity entity, World world, int x, int y, int z) {
        if (entity == null) {
            return false;
        }
        int trigger = PressurePlate.getTriggerEntity(TE);
        switch (trigger) {
            case 0: {
                return entity instanceof EntityPlayer;
            }
            case 1: {
                return entity.isCreatureType(EnumCreatureType.monster, false);
            }
            case 2: {
                return entity.isCreatureType(EnumCreatureType.creature, false);
            }
        }
        return true;
    }

    @Override
    public void func_71852_a(World world, int x, int y, int z, int blockID, int metadata) {
        TEBase TE = this.getSimpleTileEntity((IBlockAccess)world, x, y, z);
        if (TE != null && this.isDepressed(TE)) {
            this.notifyNeighborsOfUpdate(world, x, y, z);
        }
        super.func_71852_a(world, x, y, z, blockID, metadata);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public boolean func_71877_c(IBlockAccess world, int x, int y, int z, int side) {
        return side != 0;
    }

    public int func_71857_b() {
        return BlockRegistry.carpentersPressurePlateRenderID;
    }
}

