/*
 * Decompiled with CFR 0.152.
 */
package com.carpentersblocks.block;

import com.carpentersblocks.block.BlockCoverable;
import com.carpentersblocks.data.Torch;
import com.carpentersblocks.tileentity.TEBase;
import com.carpentersblocks.tileentity.TECarpentersTorch;
import com.carpentersblocks.util.BlockProperties;
import com.carpentersblocks.util.registry.BlockRegistry;
import com.carpentersblocks.util.registry.FeatureRegistry;
import com.carpentersblocks.util.registry.IconRegistry;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IconRegister;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.Icon;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.Vec3;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeDirection;

public class BlockCarpentersTorch
extends BlockCoverable {
    public BlockCarpentersTorch(int blockID, Material material) {
        super(blockID, material);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void func_94332_a(IconRegister iconRegister) {
        IconRegistry.icon_torch_lit = iconRegister.func_94245_a("CarpentersBlocks:torch/torch_lit");
        IconRegistry.icon_torch_head_smoldering = iconRegister.func_94245_a("CarpentersBlocks:torch/torch_head_smoldering");
        IconRegistry.icon_torch_head_unlit = iconRegister.func_94245_a("CarpentersBlocks:torch/torch_head_unlit");
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public Icon func_71858_a(int side, int metadata) {
        return IconRegistry.icon_torch_lit;
    }

    @Override
    protected void preOnBlockActivated(TEBase TE, EntityPlayer entityPlayer, int side, float hitX, float hitY, float hitZ, BlockCoverable.ActionResult actionResult) {
        Block block;
        ItemStack itemStack = entityPlayer.func_70694_bm();
        if (itemStack != null && itemStack.func_77973_b() instanceof ItemBlock && !Torch.getState(TE).equals((Object)Torch.State.LIT) && ((block = BlockProperties.toBlock(itemStack)).equals(BlockRegistry.blockCarpentersTorch) || block.equals(Block.field_72069_aq))) {
            Torch.setState(TE, Torch.State.LIT);
            actionResult.setAltered();
        }
    }

    @Override
    public int getLightValue(IBlockAccess world, int x, int y, int z) {
        TEBase TE = this.getTileEntity(world, x, y, z);
        if (TE != null) {
            int coverLight = super.getLightValue(world, x, y, z);
            int torchLight = 0;
            switch (Torch.getState(TE)) {
                case LIT: {
                    torchLight = 15;
                    break;
                }
                case SMOLDERING: {
                    torchLight = 10;
                    break;
                }
            }
            return coverLight > torchLight ? coverLight : torchLight;
        }
        return field_71984_q[this.field_71990_ca];
    }

    public AxisAlignedBB func_71872_e(World par1World, int par2, int par3, int par4) {
        return null;
    }

    public boolean func_71850_a_(World world, int x, int y, int z, int side) {
        if (side > 0) {
            ForgeDirection dir = ForgeDirection.getOrientation((int)side);
            Block blockYN = Block.field_71973_m[world.func_72798_a(x, y - 1, z)];
            Block blockOffset = Block.field_71973_m[world.func_72798_a(x - dir.offsetX, y - dir.offsetY, z - dir.offsetZ)];
            return blockOffset != null && blockOffset.isBlockSolidOnSide(world, x - dir.offsetX, y - dir.offsetY, z - dir.offsetZ, dir) || side == 1 && blockYN != null && blockYN.canPlaceTorchOnTop(world, x, y, z);
        }
        return false;
    }

    public int func_85104_a(World world, int x, int y, int z, int side, float hitX, float hitY, float hitZ, int metadata) {
        return side;
    }

    @Override
    public void func_71860_a(World world, int x, int y, int z, EntityLivingBase entityLiving, ItemStack itemStack) {
        TEBase TE = this.getTileEntity((IBlockAccess)world, x, y, z);
        if (TE != null) {
            int facing = world.func_72805_g(x, y, z);
            Torch.setFacing(TE, facing);
            Torch.setReady(TE);
        }
        super.func_71860_a(world, x, y, z, entityLiving, itemStack);
    }

    @Override
    public void func_71863_a(World world, int x, int y, int z, int blockID) {
        TEBase TE;
        if (!world.field_72995_K && (TE = this.getTileEntity((IBlockAccess)world, x, y, z)) != null && Torch.isReady(TE) && !this.func_71850_a_(world, x, y, z, Torch.getFacing(TE).ordinal())) {
            this.func_71929_a(world, x, y, z, this.func_71880_c_(0));
            world.func_94571_i(x, y, z);
        }
        super.func_71863_a(world, x, y, z, blockID);
    }

    public MovingObjectPosition func_71878_a(World world, int x, int y, int z, Vec3 startVec, Vec3 endVec) {
        TEBase TE = this.getTileEntity((IBlockAccess)world, x, y, z);
        if (TE != null) {
            ForgeDirection facing = Torch.getFacing(TE);
            switch (facing) {
                case NORTH: {
                    this.func_71905_a(0.35f, 0.2f, 0.7f, 0.65f, 0.8f, 1.0f);
                    break;
                }
                case SOUTH: {
                    this.func_71905_a(0.35f, 0.2f, 0.0f, 0.65f, 0.8f, 0.3f);
                    break;
                }
                case WEST: {
                    this.func_71905_a(0.7f, 0.2f, 0.35f, 1.0f, 0.8f, 0.65f);
                    break;
                }
                case EAST: {
                    this.func_71905_a(0.0f, 0.2f, 0.35f, 0.3f, 0.8f, 0.65f);
                    break;
                }
                default: {
                    this.func_71905_a(0.4f, 0.0f, 0.4f, 0.6f, 0.6f, 0.6f);
                }
            }
        }
        return super.func_71878_a(world, x, y, z, startVec, endVec);
    }

    public void func_71847_b(World world, int x, int y, int z, Random random) {
        TEBase TE;
        if (!world.field_72995_K && (TE = this.getTileEntity((IBlockAccess)world, x, y, z)) != null) {
            boolean isWet = world.func_72951_B(x, y, z);
            boolean canDropState = FeatureRegistry.enableTorchWeatherEffects;
            switch (Torch.getState(TE)) {
                case LIT: {
                    if (!canDropState || !isWet) break;
                    Torch.setState(TE, Torch.State.SMOLDERING);
                    break;
                }
                case SMOLDERING: {
                    if (canDropState && isWet) {
                        Torch.setState(TE, Torch.State.UNLIT);
                        break;
                    }
                    Torch.setState(TE, Torch.State.LIT);
                    break;
                }
                case UNLIT: {
                    if (canDropState && isWet) break;
                    Torch.setState(TE, Torch.State.SMOLDERING);
                    break;
                }
            }
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void func_71862_a(World world, int x, int y, int z, Random random) {
        Torch.State state;
        TEBase TE = this.getTileEntity((IBlockAccess)world, x, y, z);
        if (TE != null && !(state = Torch.getState(TE)).equals((Object)Torch.State.UNLIT)) {
            double[] headCoords = Torch.getHeadCoordinates(TE);
            world.func_72869_a("smoke", headCoords[0], headCoords[1], headCoords[2], 0.0, 0.0, 0.0);
            if (state.equals((Object)Torch.State.LIT)) {
                world.func_72869_a("flame", headCoords[0], headCoords[1], headCoords[2], 0.0, 0.0, 0.0);
            }
        }
    }

    @Override
    public TileEntity func_72274_a(World world) {
        return new TECarpentersTorch();
    }

    public int func_71857_b() {
        return BlockRegistry.carpentersTorchRenderID;
    }
}

