/*
 * Decompiled with CFR 0.152.
 */
package com.carpentersblocks.block;

import com.carpentersblocks.api.ICarpentersChisel;
import com.carpentersblocks.api.ICarpentersHammer;
import com.carpentersblocks.renderer.helper.ParticleHelper;
import com.carpentersblocks.tileentity.TEBase;
import com.carpentersblocks.util.BlockProperties;
import com.carpentersblocks.util.handler.DesignHandler;
import com.carpentersblocks.util.handler.EventHandler;
import com.carpentersblocks.util.handler.OverlayHandler;
import com.carpentersblocks.util.protection.PlayerPermissions;
import com.carpentersblocks.util.registry.FeatureRegistry;
import com.carpentersblocks.util.registry.IconRegistry;
import com.carpentersblocks.util.registry.ItemRegistry;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockContainer;
import net.minecraft.block.BlockDirectional;
import net.minecraft.block.BlockRedstoneWire;
import net.minecraft.block.material.Material;
import net.minecraft.client.particle.EffectRenderer;
import net.minecraft.client.renderer.texture.IconRegister;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.boss.EntityDragon;
import net.minecraft.entity.boss.EntityWither;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Icon;
import net.minecraft.util.MathHelper;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.client.ForgeHooksClient;
import net.minecraftforge.common.ForgeDirection;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.IPlantable;

public class BlockCoverable
extends BlockContainer {
    protected boolean grabLightValue = false;
    private final int METADATA_DROP_ATTR_ONLY = 16;
    private boolean enableDrops = false;

    public BlockCoverable(int blockID, Material material) {
        super(blockID, material);
        BlockCoverable.setBurnProperties((int)blockID, (int)5, (int)20);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_94332_a(IconRegister iconRegister) {
    }

    @SideOnly(value=Side.CLIENT)
    public Icon getIcon() {
        return IconRegistry.icon_uncovered_solid;
    }

    @SideOnly(value=Side.CLIENT)
    public Icon func_71858_a(int side, int metadata) {
        if (BlockProperties.isMetadataDefaultIcon(metadata)) {
            return this.getIcon();
        }
        return BlockRedstoneWire.func_94409_b((String)"cross_overlay");
    }

    @SideOnly(value=Side.CLIENT)
    public Icon func_71895_b(IBlockAccess world, int x, int y, int z, int side) {
        TEBase TE = this.getTileEntity(world, x, y, z);
        ItemStack itemStack = BlockProperties.getCover(TE, 6);
        Block block = BlockProperties.toBlock(itemStack);
        return block instanceof BlockCoverable ? this.getIcon() : block.func_71858_a(side, itemStack.func_77960_j());
    }

    public boolean func_71883_b(World world, int x, int y, int z, int itemId, int metadata) {
        ItemStack itemStack = new ItemStack(itemId, 1, metadata);
        if (itemStack != null) {
            this.func_71929_a(world, x, y, z, itemStack);
        }
        return true;
    }

    protected TEBase[] getAdjacentTileEntities(World world, int x, int y, int z) {
        return new TEBase[]{this.getSimpleTileEntity((IBlockAccess)world, x, y - 1, z), this.getSimpleTileEntity((IBlockAccess)world, x, y + 1, z), this.getSimpleTileEntity((IBlockAccess)world, x, y, z - 1), this.getSimpleTileEntity((IBlockAccess)world, x, y, z + 1), this.getSimpleTileEntity((IBlockAccess)world, x - 1, y, z), this.getSimpleTileEntity((IBlockAccess)world, x + 1, y, z)};
    }

    protected TEBase getSimpleTileEntity(IBlockAccess world, int x, int y, int z) {
        TileEntity TE = world.func_72796_p(x, y, z);
        return TE instanceof TEBase ? (TEBase)TE : null;
    }

    protected TEBase getTileEntity(IBlockAccess world, int x, int y, int z) {
        TEBase TE = this.getSimpleTileEntity(world, x, y, z);
        return TE != null && TE.func_70311_o().equals((Object)this) ? TE : null;
    }

    protected boolean canPlayerActivate(TEBase TE, EntityPlayer entityPlayer) {
        return true;
    }

    public void func_71921_a(World world, int x, int y, int z, EntityPlayer entityPlayer) {
        TEBase TE;
        if (!world.field_72995_K && (TE = this.getTileEntity((IBlockAccess)world, x, y, z)) != null && PlayerPermissions.canPlayerEdit(TE, TE.field_70329_l, TE.field_70330_m, TE.field_70327_n, entityPlayer)) {
            ActionResult actionResult = new ActionResult();
            ItemStack itemStack = entityPlayer.func_71045_bC();
            if (itemStack != null) {
                int effectiveSide = BlockProperties.hasCover(TE, EventHandler.eventFace) ? EventHandler.eventFace : 6;
                Item item = itemStack.func_77973_b();
                if (item instanceof ICarpentersHammer && ((ICarpentersHammer)item).canUseHammer(world, entityPlayer)) {
                    this.preOnBlockClicked(TE, world, x, y, z, entityPlayer, actionResult);
                    if (!actionResult.altered) {
                        if (entityPlayer.func_70093_af()) {
                            if (BlockProperties.hasOverlay(TE, effectiveSide)) {
                                BlockProperties.setOverlay(TE, effectiveSide, null);
                                actionResult.setAltered();
                            } else if (BlockProperties.hasDye(TE, effectiveSide)) {
                                BlockProperties.setDye(TE, effectiveSide, null);
                                actionResult.setAltered();
                            } else if (BlockProperties.hasCover(TE, effectiveSide)) {
                                BlockProperties.setCover(TE, effectiveSide, null);
                                BlockProperties.setChiselDesign(TE, effectiveSide, "");
                                actionResult.setAltered();
                            }
                        } else {
                            this.onHammerLeftClick(TE, entityPlayer);
                            actionResult.setAltered();
                        }
                    }
                    if (actionResult.altered) {
                        this.func_71863_a(world, x, y, z, this.field_71990_ca);
                        world.func_72898_h(x, y, z, this.field_71990_ca);
                    }
                } else if (item instanceof ICarpentersChisel && ((ICarpentersChisel)item).canUseChisel(world, entityPlayer)) {
                    if (entityPlayer.func_70093_af()) {
                        if (BlockProperties.hasChiselDesign(TE, effectiveSide)) {
                            BlockProperties.setChiselDesign(TE, effectiveSide, "");
                        }
                    } else if (BlockProperties.hasCover(TE, effectiveSide)) {
                        this.onChiselClick(TE, effectiveSide, true);
                    }
                }
            }
        }
    }

    public boolean func_71903_a(World world, int x, int y, int z, EntityPlayer entityPlayer, int side, float hitX, float hitY, float hitZ) {
        ItemStack itemStack = entityPlayer.func_71045_bC();
        if (world.field_72995_K) {
            return true;
        }
        TEBase TE = this.getTileEntity((IBlockAccess)world, x, y, z);
        if (TE != null) {
            ActionResult actionResult = new ActionResult();
            if (this.canPlayerActivate(TE, entityPlayer)) {
                int effectiveSide = BlockProperties.hasCover(TE, side) ? side : 6;
                this.preOnBlockActivated(TE, entityPlayer, side, hitX, hitY, hitZ, actionResult);
                if (PlayerPermissions.canPlayerEdit(TE, TE.field_70329_l, TE.field_70330_m, TE.field_70327_n, entityPlayer) && !actionResult.altered && itemStack != null) {
                    if (itemStack.func_77973_b() instanceof ICarpentersHammer && ((ICarpentersHammer)itemStack.func_77973_b()).canUseHammer(world, entityPlayer)) {
                        if (this.onHammerRightClick(TE, entityPlayer)) {
                            actionResult.setAltered();
                        }
                    } else if (ItemRegistry.enableChisel && itemStack.func_77973_b() instanceof ICarpentersChisel && ((ICarpentersChisel)itemStack.func_77973_b()).canUseChisel(world, entityPlayer)) {
                        if (BlockProperties.hasCover(TE, effectiveSide) && this.onChiselClick(TE, effectiveSide, false)) {
                            actionResult.setAltered();
                        }
                    } else if (FeatureRegistry.enableCovers && BlockProperties.isCover(itemStack)) {
                        int metadata;
                        Block block = BlockProperties.toBlock(itemStack);
                        int n = metadata = block instanceof BlockDirectional ? MathHelper.func_76128_c((double)((double)(entityPlayer.field_70177_z * 4.0f / 360.0f) + 2.5)) & 3 : itemStack.func_77960_j();
                        if (BlockProperties.blockRotates(itemStack)) {
                            int facing = BlockProperties.getOppositeFacing((EntityLivingBase)EventHandler.eventEntityPlayer);
                            int side_interpolated = entityPlayer.field_70125_A < -45.0f ? 0 : (entityPlayer.field_70125_A > 45.0f ? 1 : (facing == 0 ? 3 : (facing == 1 ? 4 : (facing == 2 ? 2 : 5))));
                            metadata = block.func_85104_a(world, x, y, z, side_interpolated, hitX, hitY, hitZ, metadata);
                        }
                        ItemStack tempStack = itemStack.func_77946_l();
                        tempStack.func_77964_b(metadata);
                        if (effectiveSide == 6 && (!this.canCoverSide(TE, world, x, y, z, 6) || BlockProperties.hasCover(TE, 6))) {
                            effectiveSide = side;
                        }
                        if (this.canCoverSide(TE, world, x, y, z, effectiveSide) && !BlockProperties.hasCover(TE, effectiveSide) && BlockProperties.setCover(TE, effectiveSide, tempStack)) {
                            actionResult.setAltered().decInventory();
                        }
                    } else if (entityPlayer.func_70093_af()) {
                        if (FeatureRegistry.enableOverlays && BlockProperties.isOverlay(itemStack)) {
                            if (!BlockProperties.hasOverlay(TE, effectiveSide) && (effectiveSide < 6 && BlockProperties.hasCover(TE, effectiveSide) || effectiveSide == 6) && BlockProperties.setOverlay(TE, effectiveSide, itemStack)) {
                                actionResult.setAltered().decInventory().setSoundSource(itemStack);
                            }
                        } else if (FeatureRegistry.enableDyeColors && BlockProperties.isDye(itemStack, false) && !BlockProperties.hasDye(TE, effectiveSide) && BlockProperties.setDye(TE, effectiveSide, itemStack)) {
                            actionResult.setAltered().decInventory().setSoundSource(itemStack);
                        }
                    }
                }
                if (!actionResult.altered) {
                    this.postOnBlockActivated(TE, entityPlayer, side, hitX, hitY, hitZ, actionResult);
                } else {
                    if (actionResult.itemStack == null) {
                        actionResult.setSoundSource(BlockProperties.getCover(TE, 6));
                    }
                    this.damageItemWithChance(world, entityPlayer);
                    this.func_71863_a(world, x, y, z, this.field_71990_ca);
                    world.func_72898_h(x, y, z, this.field_71990_ca);
                }
                if (actionResult.playSound) {
                    BlockProperties.playBlockSound(TE.func_70314_l(), actionResult.itemStack, TE.field_70329_l, TE.field_70330_m, TE.field_70327_n, false);
                }
                if (actionResult.decInv && !entityPlayer.field_71075_bZ.field_75098_d && --itemStack.field_77994_a <= 0) {
                    entityPlayer.field_71071_by.func_70299_a(entityPlayer.field_71071_by.field_70461_c, (ItemStack)null);
                }
            }
            return actionResult.altered;
        }
        return super.func_71903_a(world, x, y, z, entityPlayer, side, hitX, hitY, hitZ);
    }

    public boolean onChiselClick(TEBase TE, int side, boolean leftClick) {
        String design = BlockProperties.getChiselDesign(TE, side);
        String designAdj = "";
        if (design.equals("")) {
            TEBase[] TE_list;
            World world = TE.func_70314_l();
            for (TEBase TE_current : TE_list = this.getAdjacentTileEntities(world, TE.field_70329_l, TE.field_70330_m, TE.field_70327_n)) {
                if (TE_current == null) continue;
                TE_current.func_70311_o();
                if (!BlockProperties.hasChiselDesign(TE_current, side)) continue;
                designAdj = design = BlockProperties.getChiselDesign(TE_current, side);
            }
        }
        if (designAdj.equals("")) {
            String string = design = leftClick ? DesignHandler.getPrev("chisel", design) : DesignHandler.getNext("chisel", design);
        }
        if (!design.equals("")) {
            BlockProperties.setChiselDesign(TE, side, design);
        }
        return true;
    }

    public void func_71863_a(World world, int x, int y, int z, int blockID) {
        TEBase TE;
        if (!world.field_72995_K && (TE = this.getTileEntity((IBlockAccess)world, x, y, z)) != null && BlockProperties.hasSideCovers(TE)) {
            block8: for (int side = 0; side < 6; ++side) {
                ForgeDirection adj_side;
                if (!BlockProperties.hasCover(TE, side)) continue;
                if (!this.canCoverSide(TE, world, x, y, z, side)) {
                    BlockProperties.ejectAttributes(TE, side);
                    return;
                }
                float sideCoverDepth = BlockProperties.getSideCoverDepth(TE, side);
                ForgeDirection dir = ForgeDirection.getOrientation((int)side);
                int x_offset = x + dir.offsetX;
                int y_offset = y + dir.offsetY;
                int z_offset = z + dir.offsetZ;
                Block adjBlock = Block.field_71973_m[world.func_72798_a(x_offset, y_offset, z_offset)];
                if (adjBlock == null || !adjBlock.isBlockSolidOnSide(world, x_offset, y_offset, z_offset, adj_side = ForgeDirection.getOrientation((int)ForgeDirection.OPPOSITES[side]))) continue;
                switch (adj_side) {
                    case DOWN: {
                        if (!(adjBlock.func_83008_x() < (double)sideCoverDepth)) continue block8;
                        BlockProperties.ejectAttributes(TE, side);
                        continue block8;
                    }
                    case UP: {
                        if (!(adjBlock.func_83010_y() > (double)(1.0f - sideCoverDepth))) continue block8;
                        BlockProperties.ejectAttributes(TE, side);
                        continue block8;
                    }
                    case NORTH: {
                        if (!(adjBlock.func_83005_z() < (double)sideCoverDepth)) continue block8;
                        BlockProperties.ejectAttributes(TE, side);
                        continue block8;
                    }
                    case SOUTH: {
                        if (!(adjBlock.func_83006_A() > (double)(1.0f - sideCoverDepth))) continue block8;
                        BlockProperties.ejectAttributes(TE, side);
                        continue block8;
                    }
                    case WEST: {
                        if (!(adjBlock.func_83009_v() < (double)sideCoverDepth)) continue block8;
                        BlockProperties.ejectAttributes(TE, side);
                        continue block8;
                    }
                    case EAST: {
                        if (!(adjBlock.func_83007_w() > (double)(1.0f - sideCoverDepth))) continue block8;
                        BlockProperties.ejectAttributes(TE, side);
                        continue block8;
                    }
                }
            }
        }
    }

    public int func_71865_a(IBlockAccess world, int x, int y, int z, int side) {
        TEBase TE = this.getTileEntity(world, x, y, z);
        if (TE != null && BlockProperties.hasCover(TE, 6)) {
            int effectiveSide = ForgeDirection.OPPOSITES[side];
            int power = BlockProperties.toBlock(BlockProperties.getCover(TE, 6)).func_71865_a(world, x, y, z, side);
            int power_side = BlockProperties.hasCover(TE, effectiveSide) ? BlockProperties.toBlock(BlockProperties.getCover(TE, effectiveSide)).func_71865_a(world, x, y, z, side) : 0;
            return power_side > power ? power_side : power;
        }
        return 0;
    }

    public int func_71855_c(IBlockAccess world, int x, int y, int z, int side) {
        TEBase TE = this.getTileEntity(world, x, y, z);
        if (TE != null && BlockProperties.hasCover(TE, 6)) {
            int effectiveSide = ForgeDirection.OPPOSITES[side];
            int power = BlockProperties.toBlock(BlockProperties.getCover(TE, 6)).func_71855_c(world, x, y, z, side);
            int power_side = BlockProperties.hasCover(TE, effectiveSide) ? BlockProperties.toBlock(BlockProperties.getCover(TE, effectiveSide)).func_71855_c(world, x, y, z, side) : 0;
            return power_side > power ? power_side : power;
        }
        return 0;
    }

    private boolean suppressDestroyBlock(EntityPlayer entityPlayer) {
        ItemStack itemStack = entityPlayer.func_70694_bm();
        if (itemStack != null) {
            Item item = itemStack.func_77973_b();
            return entityPlayer.field_71075_bZ.field_75098_d && item != null && (item instanceof ICarpentersHammer || item instanceof ICarpentersChisel);
        }
        return false;
    }

    public boolean removeBlockByPlayer(World world, EntityPlayer player, int x, int y, int z) {
        if (!this.suppressDestroyBlock(player)) {
            return super.removeBlockByPlayer(world, player, x, y, z);
        }
        return false;
    }

    protected ItemStack getItemDrop(World world, int metadata) {
        int fortune = 1;
        return new ItemStack(this.func_71885_a(metadata, world.field_73012_v, fortune), 1, metadata);
    }

    @SideOnly(value=Side.CLIENT)
    public boolean addBlockHitEffects(World world, MovingObjectPosition target, EffectRenderer effectRenderer) {
        TEBase TE = this.getTileEntity((IBlockAccess)world, target.field_72311_b, target.field_72312_c, target.field_72309_d);
        if (TE != null) {
            OverlayHandler.Overlay overlay;
            int effectiveSide = BlockProperties.hasCover(TE, target.field_72310_e) ? target.field_72310_e : 6;
            ItemStack itemStack = BlockProperties.getCover(TE, effectiveSide);
            if (BlockProperties.hasOverlay(TE, effectiveSide) && OverlayHandler.coversFullSide(overlay = OverlayHandler.getOverlayType(BlockProperties.getOverlay(TE, effectiveSide)), target.field_72310_e)) {
                itemStack = overlay.getItemStack();
            }
            Block block = BlockProperties.toBlock(itemStack);
            double xOffset = (double)target.field_72311_b + world.field_73012_v.nextDouble() * (block.func_83007_w() - block.func_83009_v() - (double)0.2f) + (double)0.1f + block.func_83009_v();
            double yOffset = (double)target.field_72312_c + world.field_73012_v.nextDouble() * (block.func_83010_y() - block.func_83008_x() - (double)0.2f) + (double)0.1f + block.func_83008_x();
            double zOffset = (double)target.field_72309_d + world.field_73012_v.nextDouble() * (block.func_83006_A() - block.func_83005_z() - (double)0.2f) + (double)0.1f + block.func_83005_z();
            switch (target.field_72310_e) {
                case 0: {
                    yOffset = (double)target.field_72312_c + block.func_83008_x() - 0.1;
                    break;
                }
                case 1: {
                    yOffset = (double)target.field_72312_c + block.func_83010_y() + 0.1;
                    break;
                }
                case 2: {
                    zOffset = (double)target.field_72309_d + block.func_83005_z() - 0.1;
                    break;
                }
                case 3: {
                    zOffset = (double)target.field_72309_d + block.func_83006_A() + 0.1;
                    break;
                }
                case 4: {
                    xOffset = (double)target.field_72311_b + block.func_83009_v() - 0.1;
                    break;
                }
                case 5: {
                    xOffset = (double)target.field_72311_b + block.func_83007_w() + 0.1;
                }
            }
            ParticleHelper.addHitEffect(TE, target, xOffset, yOffset, zOffset, itemStack, effectRenderer);
            return true;
        }
        return super.addBlockHitEffects(world, target, effectRenderer);
    }

    @SideOnly(value=Side.CLIENT)
    public boolean addBlockDestroyEffects(World world, int x, int y, int z, int metadata, EffectRenderer effectRenderer) {
        EntityPlayer entityPlayer;
        TEBase TE = this.getTileEntity((IBlockAccess)world, x, y, z);
        if (TE != null && (entityPlayer = world.func_72977_a((double)x, (double)y, (double)z, 6.5)) != null) {
            if (!this.suppressDestroyBlock(entityPlayer)) {
                ParticleHelper.addDestroyEffect(world, x, y, z, BlockProperties.getCover(TE, 6), effectRenderer);
            } else {
                return true;
            }
        }
        return false;
    }

    protected int getLightValue(TEBase TE, Block block, int metadata) {
        int lightValue = Block.field_71984_q[block.field_71990_ca];
        if (lightValue == 0) {
            BlockProperties.setHostMetadata(TE, metadata);
            lightValue = block.getLightValue((IBlockAccess)TE.func_70314_l(), TE.field_70329_l, TE.field_70330_m, TE.field_70327_n);
            BlockProperties.resetHostMetadata(TE);
        }
        return lightValue;
    }

    public int getLightValue(IBlockAccess world, int x, int y, int z) {
        int lightValue = 0;
        if (this.grabLightValue) {
            return 0;
        }
        this.grabLightValue = true;
        TEBase TE = this.getTileEntity(world, x, y, z);
        if (TE != null) {
            for (int side = 0; side < 7; ++side) {
                ItemStack itemStack;
                int tempLight;
                if (!BlockProperties.hasCover(TE, side) || (tempLight = this.getLightValue(TE, BlockProperties.toBlock(itemStack = BlockProperties.getCover(TE, side)), itemStack.func_77960_j())) <= lightValue) continue;
                lightValue = tempLight;
            }
        }
        this.grabLightValue = false;
        return lightValue;
    }

    public float func_71934_m(World world, int x, int y, int z) {
        TEBase TE = this.getTileEntity((IBlockAccess)world, x, y, z);
        if (TE != null && BlockProperties.hasCover(TE, 6)) {
            return BlockProperties.toBlock(BlockProperties.getCover(TE, 6)).func_71934_m(world, x, y, z);
        }
        return this.field_71989_cb;
    }

    public int getFlammability(IBlockAccess world, int x, int y, int z, int metadata, ForgeDirection face) {
        TEBase TE = this.getTileEntity(world, x, y, z);
        if (TE != null) {
            return blockFlammability[BlockProperties.toBlock((ItemStack)BlockProperties.getCover((TEBase)TE, (int)6)).field_71990_ca];
        }
        return super.getFlammability(world, x, y, z, metadata, face);
    }

    public int getFireSpreadSpeed(World world, int x, int y, int z, int metadata, ForgeDirection dir) {
        TEBase TE = this.getTileEntity((IBlockAccess)world, x, y, z);
        if (TE != null) {
            return blockFlammability[BlockProperties.toBlock((ItemStack)BlockProperties.getCover((TEBase)TE, (int)6)).field_71990_ca];
        }
        return super.getFireSpreadSpeed(world, x, y, z, metadata, dir);
    }

    public boolean isFireSource(World world, int x, int y, int z, int metadata, ForgeDirection side) {
        TEBase TE = this.getTileEntity((IBlockAccess)world, x, y, z);
        if (TE != null && BlockProperties.hasCover(TE, 6)) {
            ItemStack itemStack = BlockProperties.getCover(TE, 6);
            return BlockProperties.toBlock(itemStack).isFireSource(world, x, y, z, itemStack.func_77960_j(), side);
        }
        return false;
    }

    public float getExplosionResistance(Entity entity, World world, int x, int y, int z, double explosionX, double explosionY, double explosionZ) {
        TEBase TE = this.getTileEntity((IBlockAccess)world, x, y, z);
        if (TE != null && BlockProperties.hasCover(TE, 6)) {
            return BlockProperties.toBlock(BlockProperties.getCover(TE, 6)).func_71904_a(entity);
        }
        return this.func_71904_a(entity);
    }

    public boolean isWood(World world, int x, int y, int z) {
        TEBase TE = this.getTileEntity((IBlockAccess)world, x, y, z);
        if (TE != null && BlockProperties.hasCover(TE, 6)) {
            return BlockProperties.toBlock(BlockProperties.getCover(TE, 6)).isWood(world, x, y, z);
        }
        return super.isWood(world, x, y, z);
    }

    public boolean canEntityDestroy(World world, int x, int y, int z, Entity entity) {
        TEBase TE = this.getTileEntity((IBlockAccess)world, x, y, z);
        if (TE != null && BlockProperties.hasCover(TE, 6)) {
            Block block = BlockProperties.toBlock(BlockProperties.getCover(TE, 6));
            if (entity instanceof EntityWither) {
                return !block.equals(Block.field_71986_z) && !block.equals(Block.field_72102_bH) && !block.equals(Block.field_72104_bI);
            }
            if (entity instanceof EntityDragon) {
                return this.canDragonDestroy(world, x, y, z);
            }
        }
        return super.canEntityDestroy(world, x, y, z, entity);
    }

    public void func_71869_a(World world, int x, int y, int z, Entity entity) {
        TEBase TE = this.getTileEntity((IBlockAccess)world, x, y, z);
        if (TE != null && BlockProperties.hasCover(TE, 6)) {
            BlockProperties.toBlock(BlockProperties.getCover(TE, 6)).func_71869_a(world, x, y, z, entity);
        }
    }

    public void func_71914_a(World world, int x, int y, int z, int metadata, float harvestLevel, int fortune) {
        if (this.enableDrops) {
            super.func_71914_a(world, x, y, z, metadata, harvestLevel, fortune);
        } else {
            this.func_71929_a(world, x, y, z, this.getItemDrop(world, metadata));
        }
    }

    public void func_71852_a(World world, int x, int y, int z, int blockId, int metadata) {
        for (ItemStack itemStack : this.getBlockDropped(world, x, y, z, 16, 0)) {
            this.enableDrops = true;
            this.func_71929_a(world, x, y, z, itemStack);
            this.enableDrops = false;
        }
        super.func_71852_a(world, x, y, z, blockId, metadata);
    }

    public ArrayList<ItemStack> getBlockDropped(World world, int x, int y, int z, int metadata, int fortune) {
        ArrayList ret = super.getBlockDropped(world, x, y, z, metadata, fortune);
        TEBase TE = this.getSimpleTileEntity((IBlockAccess)world, x, y, z);
        if (metadata == 16) {
            ret.clear();
        }
        if (TE != null) {
            for (int idx = 0; idx < 7; ++idx) {
                if (BlockProperties.hasCover(TE, idx)) {
                    ret.add(BlockProperties.getCoverForDrop(TE, idx));
                }
                if (BlockProperties.hasOverlay(TE, idx)) {
                    ret.add(BlockProperties.getOverlay(TE, idx));
                }
                if (!BlockProperties.hasDye(TE, idx)) continue;
                ret.add(BlockProperties.getDye(TE, idx));
            }
        }
        return ret;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_71862_a(World world, int x, int y, int z, Random random) {
        TEBase TE = this.getTileEntity((IBlockAccess)world, x, y, z);
        if (TE != null) {
            if (BlockProperties.hasCover(TE, 6)) {
                BlockProperties.toBlock(BlockProperties.getCover(TE, 6)).func_71862_a(world, x, y, z, random);
            }
            if (BlockProperties.hasOverlay(TE, 6) && OverlayHandler.getOverlayType(BlockProperties.getOverlay(TE, 6)).equals((Object)OverlayHandler.Overlay.MYCELIUM)) {
                Block.field_71994_by.func_71862_a(world, x, y, z, random);
            }
        }
    }

    public boolean canSustainPlant(World world, int x, int y, int z, ForgeDirection dir, IPlantable plantable) {
        TEBase TE = this.getTileEntity((IBlockAccess)world, x, y, z);
        if (TE != null) {
            if (!this.isBlockSolidOnSide(world, x, y, z, dir)) {
                return false;
            }
            ArrayList<Integer> blockIDs = new ArrayList<Integer>();
            for (int side = 1; side < 7; side += 5) {
                if (BlockProperties.hasCover(TE, side)) {
                    blockIDs.add(BlockProperties.toBlock((ItemStack)BlockProperties.getCover((TEBase)TE, (int)side)).field_71990_ca);
                }
                if (!BlockProperties.hasOverlay(TE, side)) continue;
                blockIDs.add(BlockProperties.toBlock((ItemStack)OverlayHandler.getOverlayType((ItemStack)BlockProperties.getOverlay((TEBase)TE, (int)side)).getItemStack()).field_71990_ca);
            }
            Material material = BlockProperties.toBlock((ItemStack)BlockProperties.getCover((TEBase)TE, (int)6)).field_72018_cp;
            if (material.equals(Material.field_76247_b)) {
                blockIDs.add(Block.field_71980_u.field_71990_ca);
            } else if (material.equals(Material.field_76248_c)) {
                blockIDs.add(Block.field_71979_v.field_71990_ca);
            } else if (material.equals(Material.field_76251_o)) {
                blockIDs.add(Block.field_71939_E.field_71990_ca);
            }
            switch (plantable.getPlantType(world, x, y + 1, z)) {
                case Desert: {
                    return blockIDs.contains(BlockCoverable.field_71939_E.field_71990_ca);
                }
                case Nether: {
                    return blockIDs.contains(BlockCoverable.field_72013_bc.field_71990_ca);
                }
                case Plains: {
                    return blockIDs.contains(BlockCoverable.field_71980_u.field_71990_ca) || blockIDs.contains(BlockCoverable.field_71979_v.field_71990_ca);
                }
                case Beach: {
                    boolean isBeach = blockIDs.contains(Block.field_71980_u.field_71990_ca) || blockIDs.contains(Block.field_71979_v.field_71990_ca) || blockIDs.contains(Block.field_71939_E.field_71990_ca);
                    boolean hasWater = world.func_72803_f(x - 1, y, z).equals(Material.field_76244_g) || world.func_72803_f(x + 1, y, z).equals(Material.field_76244_g) || world.func_72803_f(x, y, z - 1).equals(Material.field_76244_g) || world.func_72803_f(x, y, z + 1).equals(Material.field_76244_g);
                    return isBeach && hasWater;
                }
            }
        }
        return super.canSustainPlant(world, x, y, z, dir, plantable);
    }

    protected boolean isBlockSolid(IBlockAccess world, int x, int y, int z) {
        TEBase TE = this.getTileEntity(world, x, y, z);
        if (TE != null) {
            return !BlockProperties.hasCover(TE, 6) || BlockProperties.toBlock(BlockProperties.getCover(TE, 6)).func_71926_d();
        }
        return false;
    }

    public void func_71860_a(World world, int x, int y, int z, EntityLivingBase entityLiving, ItemStack itemStack) {
        TEBase TE;
        if (!world.field_72995_K && (TE = this.getTileEntity((IBlockAccess)world, x, y, z)) != null) {
            TE.setOwner(((EntityPlayer)entityLiving).getDisplayName());
        }
    }

    public float func_71908_a(EntityPlayer entityPlayer, World world, int x, int y, int z) {
        Item item;
        ItemStack itemStack = entityPlayer.func_70694_bm();
        if (itemStack != null && ((item = itemStack.func_77973_b()) instanceof ICarpentersHammer || item instanceof ICarpentersChisel)) {
            return -1.0f;
        }
        TEBase TE = this.getTileEntity((IBlockAccess)world, x, y, z);
        if (TE != null) {
            return ForgeHooks.blockStrength((Block)BlockProperties.toBlock(BlockProperties.getCover(TE, 6)), (EntityPlayer)entityPlayer, (World)world, (int)x, (int)y, (int)z);
        }
        return super.func_71908_a(entityPlayer, world, x, y, z);
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_71877_c(IBlockAccess world, int x, int y, int z, int side) {
        TEBase TE = this.getTileEntity(world, x, y, z);
        if (TE != null) {
            ForgeDirection side_src = ForgeDirection.getOrientation((int)side);
            ForgeDirection side_adj = ForgeDirection.getOrientation((int)ForgeDirection.OPPOSITES[side]);
            TEBase TE_adj = (TEBase)world.func_72796_p(x, y, z);
            TEBase TE_src = (TEBase)world.func_72796_p(x + side_adj.offsetX, y + side_adj.offsetY, z + side_adj.offsetZ);
            if (TE_adj.func_70311_o().isBlockSolidOnSide(TE.field_70331_k, x, y, z, side_adj) == TE_src.func_70311_o().isBlockSolidOnSide(TE.field_70331_k, x + side_adj.offsetX, y + side_adj.offsetY, z + side_adj.offsetZ, ForgeDirection.getOrientation((int)side)) && this.shareFaces(TE_adj, TE_src, side_adj, side_src) && this.shareFaces(TE_adj, TE_src, side_adj, side_src)) {
                Block block_adj = BlockProperties.toBlock(BlockProperties.getCover(TE_adj, 6));
                Block block_src = BlockProperties.toBlock(BlockProperties.getCover(TE_src, 6));
                if (!BlockProperties.hasCover(TE_adj, 6)) {
                    return BlockProperties.hasCover(TE_src, 6);
                }
                if (!BlockProperties.hasCover(TE_src, 6) && block_adj.func_71856_s_() == 0) {
                    return !block_adj.func_71926_d();
                }
                return !BlockProperties.hasCover(TE_src, 6) || block_src.func_71926_d() != block_adj.func_71926_d() || block_src.func_71856_s_() != block_adj.func_71856_s_();
            }
        }
        return super.func_71877_c(world, x, y, z, side);
    }

    protected boolean shareFaces(TEBase TE_adj, TEBase TE_src, ForgeDirection side_adj, ForgeDirection side_src) {
        return TE_adj.func_70311_o().isBlockSolidOnSide(TE_adj.func_70314_l(), TE_adj.field_70329_l, TE_adj.field_70330_m, TE_adj.field_70327_n, side_adj) && TE_src.func_70311_o().isBlockSolidOnSide(TE_src.func_70314_l(), TE_src.field_70329_l, TE_src.field_70330_m, TE_src.field_70327_n, side_src);
    }

    public boolean canRenderInPass(int pass) {
        ForgeHooksClient.setRenderPass((int)pass);
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    public int func_71856_s_() {
        return 1;
    }

    public boolean func_71926_d() {
        return false;
    }

    public boolean func_71886_c() {
        return false;
    }

    public void func_71861_g(World world, int x, int y, int z) {
        world.func_72837_a(x, y, z, this.func_72274_a(world));
    }

    public TileEntity func_72274_a(World world) {
        return new TEBase();
    }

    public boolean hasTileEntity(int metadata) {
        return true;
    }

    protected void preOnBlockClicked(TEBase TE, World world, int x, int y, int z, EntityPlayer entityPlayer, ActionResult actionResult) {
    }

    protected void preOnBlockActivated(TEBase TE, EntityPlayer entityPlayer, int side, float hitX, float hitY, float hitZ, ActionResult actionResult) {
    }

    protected void postOnBlockActivated(TEBase TE, EntityPlayer entityPlayer, int side, float hitX, float hitY, float hitZ, ActionResult actionResult) {
    }

    protected boolean onHammerLeftClick(TEBase TE, EntityPlayer entityPlayer) {
        return false;
    }

    protected boolean onHammerRightClick(TEBase TE, EntityPlayer entityPlayer) {
        return false;
    }

    protected void damageItemWithChance(World world, EntityPlayer entityPlayer) {
        Item item = entityPlayer.func_71045_bC().func_77973_b();
        if (item instanceof ICarpentersHammer) {
            ((ICarpentersHammer)item).onHammerUse(world, entityPlayer);
        } else if (item instanceof ICarpentersChisel) {
            ((ICarpentersChisel)item).onChiselUse(world, entityPlayer);
        }
    }

    protected boolean canCoverSide(TEBase TE, World world, int x, int y, int z, int side) {
        return side == 6;
    }

    protected class ActionResult {
        public ItemStack itemStack;
        public boolean playSound = true;
        public boolean altered = false;
        public boolean decInv = false;

        protected ActionResult() {
        }

        public ActionResult setSoundSource(ItemStack itemStack) {
            this.itemStack = itemStack;
            return this;
        }

        public ActionResult setNoSound() {
            this.playSound = false;
            return this;
        }

        public ActionResult setAltered() {
            this.altered = true;
            return this;
        }

        public ActionResult decInventory() {
            this.decInv = true;
            return this;
        }
    }
}

