/*
 * Decompiled with CFR 0.152.
 */
package com.carpentersblocks.block;

import com.carpentersblocks.block.BlockCoverable;
import com.carpentersblocks.data.Hinge;
import com.carpentersblocks.tileentity.TEBase;
import com.carpentersblocks.util.handler.ChatHandler;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class BlockHinged
extends BlockCoverable {
    public BlockHinged(int blockID, Material material) {
        super(blockID, material);
    }

    protected boolean requiresFoundation() {
        return true;
    }

    @Override
    protected boolean onHammerLeftClick(TEBase TE, EntityPlayer entityPlayer) {
        int hinge = Hinge.getHinge(TE);
        this.setHingeSide(TE, hinge == 0 ? 1 : 0);
        return true;
    }

    @Override
    protected boolean onHammerRightClick(TEBase TE, EntityPlayer entityPlayer) {
        if (entityPlayer.func_70093_af()) {
            int rigidity = Hinge.getRigidity(TE) == 0 ? 1 : 0;
            this.setHingeRigidity(TE, rigidity);
            switch (rigidity) {
                case 0: {
                    ChatHandler.sendMessageToPlayer("message.activation_wood.name", entityPlayer);
                    break;
                }
                case 1: {
                    ChatHandler.sendMessageToPlayer("message.activation_iron.name", entityPlayer);
                }
            }
            return true;
        }
        return false;
    }

    @Override
    protected void postOnBlockActivated(TEBase TE, EntityPlayer entityPlayer, int side, float hitX, float hitY, float hitZ, BlockCoverable.ActionResult actionResult) {
        if (!this.activationRequiresRedstone(TE)) {
            this.setHingeState(TE, Hinge.getState(TE) == 1 ? 0 : 1);
            actionResult.setAltered().setNoSound();
        }
    }

    private boolean activationRequiresRedstone(TEBase TE) {
        return Hinge.getRigidity(TE) == 1;
    }

    private List<TEBase> getHingePieces(TEBase TE) {
        ArrayList<TEBase> list = new ArrayList<TEBase>();
        World world = TE.func_70314_l();
        int piece = Hinge.getPiece(TE);
        int facing = Hinge.getFacing(TE);
        int hinge = Hinge.getHinge(TE);
        int neighbor_offset = piece == 1 ? -1 : 1;
        list.add(TE);
        TEBase TE_neighbor = this.getTileEntity((IBlockAccess)world, TE.field_70329_l, TE.field_70330_m + neighbor_offset, TE.field_70327_n);
        if (TE_neighbor == null) {
            return list;
        }
        list.add(TE_neighbor);
        TEBase TE_ZN = this.getTileEntity((IBlockAccess)world, TE.field_70329_l, TE.field_70330_m, TE.field_70327_n - 1);
        TEBase TE_ZP = this.getTileEntity((IBlockAccess)world, TE.field_70329_l, TE.field_70330_m, TE.field_70327_n + 1);
        TEBase TE_XN = this.getTileEntity((IBlockAccess)world, TE.field_70329_l - 1, TE.field_70330_m, TE.field_70327_n);
        TEBase TE_XP = this.getTileEntity((IBlockAccess)world, TE.field_70329_l + 1, TE.field_70330_m, TE.field_70327_n);
        switch (facing) {
            case 2: {
                if (TE_ZN != null && piece == Hinge.getPiece(TE_ZN) && facing == Hinge.getFacing(TE_ZN) && hinge == 0 && Hinge.getHinge(TE_ZN) == 1) {
                    list.add(TE_ZN);
                    list.add((TEBase)world.func_72796_p(TE.field_70329_l, TE.field_70330_m + neighbor_offset, TE.field_70327_n - 1));
                }
                if (TE_ZP == null || piece != Hinge.getPiece(TE_ZP) || facing != Hinge.getFacing(TE_ZP) || hinge != 1 || Hinge.getHinge(TE_ZP) != 0) break;
                list.add(TE_ZP);
                list.add((TEBase)world.func_72796_p(TE.field_70329_l, TE.field_70330_m + neighbor_offset, TE.field_70327_n + 1));
                break;
            }
            case 0: {
                if (TE_ZN != null && piece == Hinge.getPiece(TE_ZN) && facing == Hinge.getFacing(TE_ZN) && hinge == 1 && Hinge.getHinge(TE_ZN) == 0) {
                    list.add(TE_ZN);
                    list.add((TEBase)world.func_72796_p(TE.field_70329_l, TE.field_70330_m + neighbor_offset, TE.field_70327_n - 1));
                }
                if (TE_ZP == null || piece != Hinge.getPiece(TE_ZP) || facing != Hinge.getFacing(TE_ZP) || hinge != 0 || Hinge.getHinge(TE_ZP) != 1) break;
                list.add(TE_ZP);
                list.add((TEBase)world.func_72796_p(TE.field_70329_l, TE.field_70330_m + neighbor_offset, TE.field_70327_n + 1));
                break;
            }
            case 3: {
                if (TE_XN != null && piece == Hinge.getPiece(TE_XN) && facing == Hinge.getFacing(TE_XN) && hinge == 1 && Hinge.getHinge(TE_XN) == 0) {
                    list.add(TE_XN);
                    list.add((TEBase)world.func_72796_p(TE.field_70329_l - 1, TE.field_70330_m + neighbor_offset, TE.field_70327_n));
                }
                if (TE_XP == null || piece != Hinge.getPiece(TE_XP) || facing != Hinge.getFacing(TE_XP) || hinge != 0 || Hinge.getHinge(TE_XP) != 1) break;
                list.add(TE_XP);
                list.add((TEBase)world.func_72796_p(TE.field_70329_l + 1, TE.field_70330_m + neighbor_offset, TE.field_70327_n));
                break;
            }
            case 1: {
                if (TE_XN != null && piece == Hinge.getPiece(TE_XN) && facing == Hinge.getFacing(TE_XN) && hinge == 0 && Hinge.getHinge(TE_XN) == 1) {
                    list.add(TE_XN);
                    list.add((TEBase)world.func_72796_p(TE.field_70329_l - 1, TE.field_70330_m + neighbor_offset, TE.field_70327_n));
                }
                if (TE_XP == null || piece != Hinge.getPiece(TE_XP) || facing != Hinge.getFacing(TE_XP) || hinge != 1 || Hinge.getHinge(TE_XP) != 0) break;
                list.add(TE_XP);
                list.add((TEBase)world.func_72796_p(TE.field_70329_l + 1, TE.field_70330_m + neighbor_offset, TE.field_70327_n));
            }
        }
        return list;
    }

    @SideOnly(value=Side.CLIENT)
    public AxisAlignedBB func_71911_a_(World world, int x, int y, int z) {
        Block block = Block.field_71973_m[world.func_72798_a(x, y, z)];
        if (block != null && block.equals((Object)this)) {
            this.func_71902_a((IBlockAccess)world, x, y, z);
        }
        return super.func_71911_a_(world, x, y, z);
    }

    public AxisAlignedBB func_71872_e(World world, int x, int y, int z) {
        Block block = Block.field_71973_m[world.func_72798_a(x, y, z)];
        if (block != null && block.equals((Object)this)) {
            this.func_71902_a((IBlockAccess)world, x, y, z);
        }
        return super.func_71872_e(world, x, y, z);
    }

    public void func_71902_a(IBlockAccess world, int x, int y, int z) {
        TEBase TE = this.getTileEntity(world, x, y, z);
        if (TE != null) {
            int facing = Hinge.getFacing(TE);
            int hinge = Hinge.getHinge(TE);
            boolean isOpen = Hinge.getState(TE) == 1;
            float x_low = 0.0f;
            float z_low = 0.0f;
            float x_high = 1.0f;
            float z_high = 1.0f;
            switch (facing) {
                case 2: {
                    if (!isOpen) {
                        x_low = 0.8125f;
                        break;
                    }
                    if (hinge == 1) {
                        z_high = 0.1875f;
                        break;
                    }
                    z_low = 0.8125f;
                    break;
                }
                case 0: {
                    if (!isOpen) {
                        x_high = 0.1875f;
                        break;
                    }
                    if (hinge == 1) {
                        z_low = 0.8125f;
                        break;
                    }
                    z_high = 0.1875f;
                    break;
                }
                case 3: {
                    if (!isOpen) {
                        z_low = 0.8125f;
                        break;
                    }
                    if (hinge == 1) {
                        x_low = 0.8125f;
                        break;
                    }
                    x_high = 0.1875f;
                    break;
                }
                case 1: {
                    if (!isOpen) {
                        z_high = 0.1875f;
                        break;
                    }
                    if (hinge == 1) {
                        x_high = 0.1875f;
                        break;
                    }
                    x_low = 0.8125f;
                }
            }
            this.func_71905_a(x_low, 0.0f, z_low, x_high, 1.0f, z_high);
        }
    }

    public void setHingeState(TEBase TE, int state) {
        List<TEBase> hingePieces = this.getHingePieces(TE);
        for (TEBase piece : hingePieces) {
            Hinge.setState(piece, state, piece == TE);
        }
    }

    public void setHingeType(TEBase TE, int type) {
        Hinge.setType(TE, type);
        this.updateAdjoiningPiece(TE);
    }

    public void setHingeRigidity(TEBase TE, int rigidity) {
        List<TEBase> hingePieces = this.getHingePieces(TE);
        for (TEBase piece : hingePieces) {
            Hinge.setRigidity(piece, rigidity);
        }
    }

    public void setHingeSide(TEBase TE, int side) {
        Hinge.setHingeSide(TE, side);
        this.updateAdjoiningPiece(TE);
    }

    @Override
    public void func_71863_a(World world, int x, int y, int z, int blockID) {
        TEBase TE;
        if (!world.field_72995_K && (TE = this.getTileEntity((IBlockAccess)world, x, y, z)) != null) {
            boolean isOpen;
            boolean bl = isOpen = Hinge.getState(TE) == 1;
            if (Hinge.getPiece(TE) == 0) {
                Block blockYP = Block.field_71973_m[world.func_72798_a(x, y + 1, z)];
                if (blockYP == null || blockYP != null && !blockYP.equals((Object)this)) {
                    world.func_94571_i(x, y, z);
                    return;
                }
                if (this.requiresFoundation() && !world.func_72797_t(x, y - 1, z)) {
                    this.func_71929_a(world, x, y, z, this.func_71880_c_(0));
                    world.func_94571_i(x, y + 1, z);
                    return;
                }
            } else {
                Block blockYN = Block.field_71973_m[world.func_72798_a(x, y - 1, z)];
                if (blockYN == null || blockYN != null && !blockYN.equals((Object)this)) {
                    world.func_94571_i(x, y, z);
                    return;
                }
            }
            boolean isPowered = false;
            List<TEBase> hingePieces = this.getHingePieces(TE);
            for (TEBase piece : hingePieces) {
                if (piece == null || !world.func_72864_z(piece.field_70329_l, piece.field_70330_m, piece.field_70327_n)) continue;
                isPowered = true;
            }
            Block block = Block.field_71973_m[blockID];
            if (block != null && block.func_71853_i() && isPowered != isOpen) {
                this.setHingeState(TE, isOpen ? 0 : 1);
            }
        }
        super.func_71863_a(world, x, y, z, blockID);
    }

    private void updateAdjoiningPiece(TEBase TE) {
        int state = Hinge.getState(TE);
        int hinge = Hinge.getHinge(TE);
        int type = Hinge.getType(TE);
        int rigidity = Hinge.getRigidity(TE);
        boolean isTop = Hinge.getPiece(TE) == 1;
        World world = TE.func_70314_l();
        TEBase TE_adj = isTop ? (TEBase)world.func_72796_p(TE.field_70329_l, TE.field_70330_m - 1, TE.field_70327_n) : (TEBase)world.func_72796_p(TE.field_70329_l, TE.field_70330_m + 1, TE.field_70327_n);
        Hinge.setState(TE_adj, state, false);
        Hinge.setHingeSide(TE_adj, hinge);
        Hinge.setType(TE_adj, type);
        Hinge.setRigidity(TE_adj, rigidity);
    }
}

