/*
 * Decompiled with CFR 0.152.
 */
package com.carpentersblocks.data;

import com.carpentersblocks.tileentity.TEBase;
import com.carpentersblocks.util.BlockProperties;

public class Collapsible {
    public static final int QUAD_XZNN = 0;
    public static final int QUAD_XZNP = 1;
    public static final int QUAD_XZPN = 2;
    public static final int QUAD_XZPP = 3;

    public static int getQuad(double hitX, double hitZ) {
        int xOffset = (int)Math.round(hitX);
        int zOffset = (int)Math.round(hitZ);
        if (xOffset == 0) {
            if (zOffset == 0) {
                return 0;
            }
            return 1;
        }
        if (zOffset == 0) {
            return 2;
        }
        return 3;
    }

    public static void setQuadHeight(TEBase TE, int corner, int height) {
        int data = BlockProperties.getMetadata(TE);
        if (--height >= 0 && height < 16) {
            switch (corner) {
                case 0: {
                    data &= 0xFFF;
                    data |= 15 - height << 12;
                    break;
                }
                case 1: {
                    data &= 0xF0FF;
                    data |= 15 - height << 8;
                    break;
                }
                case 2: {
                    data &= 0xFF0F;
                    data |= 15 - height << 4;
                    break;
                }
                case 3: {
                    data &= 0xFFF0;
                    data |= 15 - height;
                }
            }
            if (BlockProperties.getMetadata(TE) != data) {
                BlockProperties.setMetadata(TE, data);
            }
        }
    }

    public static int getQuadHeight(TEBase TE, int corner) {
        int data = BlockProperties.getMetadata(TE);
        switch (corner) {
            case 0: {
                return 16 - ((data &= 0xF000) >> 12);
            }
            case 1: {
                return 16 - ((data &= 0xF00) >> 8);
            }
            case 2: {
                return 16 - ((data &= 0xF0) >> 4);
            }
            case 3: {
                return 16 - (data &= 0xF);
            }
        }
        return 16;
    }
}

