/*
 * Decompiled with CFR 0.152.
 */
package com.carpentersblocks.data;

import com.carpentersblocks.tileentity.TEBase;
import com.carpentersblocks.util.BlockProperties;

public class DaylightSensor {
    public static final byte POLARITY_POSITIVE = 0;
    public static final byte POLARITY_NEGATIVE = 1;
    public static final byte SENSITIVITY_SLEEP = 0;
    public static final byte SENSITIVITY_MONSTERS = 1;

    public static int getLightLevel(TEBase TE) {
        return BlockProperties.getMetadata(TE) & 0xF;
    }

    public static void setLightLevel(TEBase TE, int lightLevel) {
        int temp = BlockProperties.getMetadata(TE) & 0xFFF0;
        BlockProperties.setMetadata(TE, temp |= lightLevel);
    }

    public static int getPolarity(TEBase TE) {
        int temp = BlockProperties.getMetadata(TE) & 0x10;
        return temp >> 4;
    }

    public static void setPolarity(TEBase TE, int state) {
        int temp = BlockProperties.getMetadata(TE) & 0xFFEF;
        BlockProperties.setMetadata(TE, temp |= state << 4);
    }

    public static int getSensitivity(TEBase TE) {
        int temp = BlockProperties.getMetadata(TE) & 0x60;
        return temp >> 5;
    }

    private static void setSensitivity(TEBase TE, int sensitivity) {
        int temp = BlockProperties.getMetadata(TE) & 0xFF9F;
        BlockProperties.setMetadata(TE, temp |= sensitivity << 5);
    }

    public static int setNextSensitivity(TEBase TE) {
        int sensitivity = DaylightSensor.getSensitivity(TE);
        if (++sensitivity > 1) {
            sensitivity = 0;
        }
        DaylightSensor.setSensitivity(TE, sensitivity);
        return sensitivity;
    }

    public static boolean isActive(TEBase TE) {
        boolean posPolarity = DaylightSensor.getPolarity(TE) == 0;
        boolean isActive = false;
        int lightLevel = DaylightSensor.getLightLevel(TE);
        if (DaylightSensor.getSensitivity(TE) == 0) {
            isActive = lightLevel > 11;
        } else {
            boolean bl = isActive = lightLevel > 7;
        }
        return posPolarity ? isActive : !isActive;
    }
}

