/*
 * Decompiled with CFR 0.152.
 */
package com.carpentersblocks.data;

import com.carpentersblocks.tileentity.TEBase;
import com.carpentersblocks.util.BlockProperties;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.world.World;

public class Hinge {
    public static final byte TYPE_GLASS_TOP = 0;
    public static final byte TYPE_GLASS_TALL = 1;
    public static final byte TYPE_PANELS = 2;
    public static final byte TYPE_SCREEN_TALL = 3;
    public static final byte TYPE_FRENCH_GLASS = 4;
    public static final byte TYPE_HIDDEN = 5;
    public static final byte TYPE_SHUTTER = 6;
    public static final byte FACING_XP = 0;
    public static final byte FACING_ZP = 1;
    public static final byte FACING_XN = 2;
    public static final byte FACING_ZN = 3;
    public static final byte HINGE_LEFT = 0;
    public static final byte HINGE_RIGHT = 1;
    public static final byte STATE_CLOSED = 0;
    public static final byte STATE_OPEN = 1;
    public static final byte PIECE_BOTTOM = 0;
    public static final byte PIECE_TOP = 1;
    public static final byte HINGED_NONRIGID = 0;
    public static final byte HINGED_RIGID = 1;

    public static int getType(TEBase TE) {
        return BlockProperties.getMetadata(TE) & 7;
    }

    public static void setType(TEBase TE, int type) {
        int temp = BlockProperties.getMetadata(TE) & 0xFFF8;
        BlockProperties.setMetadata(TE, temp |= type);
    }

    public static int getHinge(TEBase TE) {
        int temp = BlockProperties.getMetadata(TE) & 8;
        return temp >> 3;
    }

    public static void setHingeSide(TEBase TE, int hingeSide) {
        int temp = BlockProperties.getMetadata(TE) & 0xFFF7;
        BlockProperties.setMetadata(TE, temp |= hingeSide << 3);
    }

    public static int getFacing(TEBase TE) {
        int temp = BlockProperties.getMetadata(TE) & 0x30;
        return temp >> 4;
    }

    public static void setFacing(TEBase TE, int facing) {
        int temp = BlockProperties.getMetadata(TE) & 0xFFCF;
        BlockProperties.setMetadata(TE, temp |= facing << 4);
    }

    public static int getState(TEBase TE) {
        int temp = BlockProperties.getMetadata(TE) & 0x40;
        return temp >> 6;
    }

    public static void setState(TEBase TE, int state, boolean playSound) {
        int temp = BlockProperties.getMetadata(TE) & 0xFFBF;
        temp |= state << 6;
        World world = TE.func_70314_l();
        if (!world.field_72995_K && playSound) {
            world.func_72889_a((EntityPlayer)null, 1003, TE.field_70329_l, TE.field_70330_m, TE.field_70327_n, 0);
        }
        BlockProperties.setMetadata(TE, temp);
    }

    public static int getPiece(TEBase TE) {
        int temp = BlockProperties.getMetadata(TE) & 0x80;
        return temp >> 7;
    }

    public static void setPiece(TEBase TE, int piece) {
        int temp = BlockProperties.getMetadata(TE) & 0xFF7F;
        BlockProperties.setMetadata(TE, temp |= piece << 7);
    }

    public static int getRigidity(TEBase TE) {
        int temp = BlockProperties.getMetadata(TE) & 0x100;
        return temp >> 8;
    }

    public static void setRigidity(TEBase TE, int rigid) {
        int temp = BlockProperties.getMetadata(TE) & 0xFEFF;
        BlockProperties.setMetadata(TE, temp |= rigid << 8);
    }
}

