/*
 * Decompiled with CFR 0.152.
 */
package com.carpentersblocks.data;

import com.carpentersblocks.tileentity.TEBase;
import com.carpentersblocks.util.BlockProperties;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeDirection;

public class Safe {
    public static final byte STATE_CLOSED = 0;
    public static final byte STATE_OPEN = 1;
    public static final byte LOCK_SET = 0;
    public static final byte LOCK_UNSET = 1;
    public static final byte AUTOMATION_DISABLED = 0;
    public static final byte AUTOMATION_SEND = 1;
    public static final byte AUTOMATION_RECEIVE = 2;
    public static final byte AUTOMATION_ALL = 3;

    public static ForgeDirection getFacing(TEBase TE) {
        int facing = BlockProperties.getMetadata(TE) & 3;
        return BlockProperties.getDirectionFromFacing(facing);
    }

    public static void setFacing(TEBase TE, int facing) {
        int temp = BlockProperties.getMetadata(TE) & 0xFFFC;
        BlockProperties.setMetadata(TE, temp |= facing);
    }

    public static int getState(TEBase TE) {
        int temp = BlockProperties.getMetadata(TE) & 4;
        return temp >> 2;
    }

    public static void setState(TEBase TE, int state) {
        int temp = BlockProperties.getMetadata(TE) & 0xFFFB;
        temp |= state << 2;
        World world = TE.func_70314_l();
        if (!world.field_72995_K) {
            world.func_72889_a((EntityPlayer)null, 1003, TE.field_70329_l, TE.field_70330_m, TE.field_70327_n, 0);
        }
        BlockProperties.setMetadata(TE, temp);
    }

    public static boolean isLocked(TEBase TE) {
        return (BlockProperties.getMetadata(TE) & 8) == 0;
    }

    public static void setLocked(TEBase TE, boolean isLocked) {
        int temp = BlockProperties.getMetadata(TE) & 0xFFF7;
        BlockProperties.setMetadata(TE, temp |= (isLocked ? 0 : 1) << 3);
    }

    public static int getAutoPerm(TEBase TE) {
        int temp = BlockProperties.getMetadata(TE) & 0x30;
        return temp >> 4;
    }

    public static void setAutoPerm(TEBase TE, int autoPerm) {
        int temp = BlockProperties.getMetadata(TE) & 0xFFCF;
        BlockProperties.setMetadata(TE, temp |= autoPerm << 4);
    }

    public static boolean isOpen(TEBase TE) {
        return Safe.getState(TE) == 1;
    }

    public static boolean allowsInsertion(TEBase TE) {
        int autoPerm = Safe.getAutoPerm(TE);
        return autoPerm == 2 || autoPerm == 3;
    }

    public static boolean allowsExtraction(TEBase TE) {
        int autoPerm = Safe.getAutoPerm(TE);
        return autoPerm == 1 || autoPerm == 3;
    }
}

