/*
 * Decompiled with CFR 0.152.
 */
package com.carpentersblocks.data;

import com.carpentersblocks.tileentity.TEBase;
import com.carpentersblocks.util.BlockProperties;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeDirection;

public class Torch {
    public static ForgeDirection getFacing(TEBase TE) {
        return ForgeDirection.getOrientation((int)(BlockProperties.getMetadata(TE) & 7));
    }

    public static void setFacing(TEBase TE, int side) {
        int temp = BlockProperties.getMetadata(TE) & 0xFFF8;
        BlockProperties.setMetadata(TE, temp |= side);
    }

    public static State getState(TEBase TE) {
        int temp = BlockProperties.getMetadata(TE) & 0x18;
        int val = temp >> 3;
        return val == State.LIT.ordinal() ? State.LIT : (val == State.SMOLDERING.ordinal() ? State.SMOLDERING : State.UNLIT);
    }

    public static void setState(TEBase TE, State state) {
        if (state.ordinal() > Torch.getState(TE).ordinal()) {
            double[] headCoords = Torch.getHeadCoordinates(TE);
            World world = TE.func_70314_l();
            world.func_72908_a(headCoords[0], headCoords[1], headCoords[2], "random.fizz", 0.5f, 2.6f + (world.field_73012_v.nextFloat() - world.field_73012_v.nextFloat()) * 0.8f);
        }
        int temp = BlockProperties.getMetadata(TE) & 0xFFE7;
        BlockProperties.setMetadata(TE, temp |= state.ordinal() << 3);
    }

    public static boolean isReady(TEBase TE) {
        return (BlockProperties.getMetadata(TE) & 0x20) > 0;
    }

    public static void setReady(TEBase TE) {
        int temp = BlockProperties.getMetadata(TE) & 0xFFDF;
        BlockProperties.setMetadata(TE, temp |= 0x20);
    }

    public static double[] getHeadCoordinates(TEBase TE) {
        double[] coords;
        double xOffset = (float)TE.field_70329_l + 0.5f;
        double yOffset = (float)TE.field_70330_m + 0.7f;
        double zOffset = (float)TE.field_70327_n + 0.5f;
        double offset1 = 0.22f;
        double offset2 = 0.27f;
        ForgeDirection facing = Torch.getFacing(TE);
        switch (facing) {
            case NORTH: {
                coords = new double[]{xOffset, yOffset + offset1, zOffset + offset2};
                break;
            }
            case SOUTH: {
                coords = new double[]{xOffset, yOffset + offset1, zOffset - offset2};
                break;
            }
            case WEST: {
                coords = new double[]{xOffset + offset2, yOffset + offset1, zOffset};
                break;
            }
            case EAST: {
                coords = new double[]{xOffset - offset2, yOffset + offset1, zOffset};
                break;
            }
            default: {
                coords = new double[]{xOffset, yOffset, zOffset};
            }
        }
        return coords;
    }

    public static enum State {
        LIT,
        SMOLDERING,
        UNLIT;

    }
}

