/*
 * Decompiled with CFR 0.152.
 */
package com.carpentersblocks.renderer;

import com.carpentersblocks.block.BlockCoverable;
import com.carpentersblocks.renderer.helper.FancyFluidsHelper;
import com.carpentersblocks.renderer.helper.LightingHelper;
import com.carpentersblocks.renderer.helper.RenderHelper;
import com.carpentersblocks.renderer.helper.VertexHelper;
import com.carpentersblocks.tileentity.TEBase;
import com.carpentersblocks.util.BlockProperties;
import com.carpentersblocks.util.handler.DesignHandler;
import com.carpentersblocks.util.handler.DyeHandler;
import com.carpentersblocks.util.handler.OptifineHandler;
import com.carpentersblocks.util.handler.OverlayHandler;
import com.carpentersblocks.util.registry.FeatureRegistry;
import com.carpentersblocks.util.registry.IconRegistry;
import cpw.mods.fml.client.registry.ISimpleBlockRenderingHandler;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.minecraft.block.Block;
import net.minecraft.block.BlockGrass;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.RenderBlocks;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Icon;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.client.MinecraftForgeClient;
import net.minecraftforge.common.ForgeDirection;
import org.lwjgl.opengl.GL11;

@SideOnly(value=Side.CLIENT)
public class BlockHandlerBase
implements ISimpleBlockRenderingHandler {
    public static int PASS_OPAQUE = 0;
    public static int PASS_ALPHA = 1;
    public static final int DOWN = 0;
    public static final int UP = 1;
    public static final int NORTH = 2;
    public static final int SOUTH = 3;
    public static final int WEST = 4;
    public static final int EAST = 5;
    public Tessellator tessellator = Tessellator.field_78398_a;
    public RenderBlocks renderBlocks;
    public LightingHelper lightingHelper;
    public Block srcBlock;
    public TEBase TE;
    public boolean suppressOverlay;
    public boolean suppressChiselDesign;
    public boolean suppressDyeColor;
    public boolean disableAO;
    public boolean hasDyeOverride;
    public int dyeOverride;
    public boolean[] hasIconOverride = new boolean[6];
    public Icon[] iconOverride = new Icon[6];
    public int renderPass;
    public int coverRendering = 6;

    public void renderInventoryBlock(Block block, int metadata, int modelID, RenderBlocks renderBlocks) {
        Tessellator tessellator = Tessellator.field_78398_a;
        GL11.glRotatef((float)90.0f, (float)0.0f, (float)1.0f, (float)0.0f);
        GL11.glTranslatef((float)-0.5f, (float)-0.5f, (float)-0.5f);
        tessellator.func_78382_b();
        if (block instanceof BlockCoverable) {
            Icon icon = renderBlocks.func_96446_b(((BlockCoverable)block).getIcon());
            tessellator.func_78375_b(0.0f, -1.0f, 0.0f);
            renderBlocks.func_78613_a(block, 0.0, 0.0, 0.0, icon);
            tessellator.func_78375_b(0.0f, 1.0f, 0.0f);
            renderBlocks.func_78617_b(block, 0.0, 0.0, 0.0, icon);
            tessellator.func_78375_b(0.0f, 0.0f, -1.0f);
            renderBlocks.func_78611_c(block, 0.0, 0.0, 0.0, icon);
            tessellator.func_78375_b(0.0f, 0.0f, 1.0f);
            renderBlocks.func_78622_d(block, 0.0, 0.0, 0.0, icon);
            tessellator.func_78375_b(-1.0f, 0.0f, 0.0f);
            renderBlocks.func_78573_e(block, 0.0, 0.0, 0.0, icon);
            tessellator.func_78375_b(1.0f, 0.0f, 0.0f);
            renderBlocks.func_78605_f(block, 0.0, 0.0, 0.0, icon);
        } else {
            tessellator.func_78375_b(0.0f, -1.0f, 0.0f);
            renderBlocks.func_78613_a(block, 0.0, 0.0, 0.0, renderBlocks.func_96446_b(block.func_71858_a(0, metadata)));
            tessellator.func_78375_b(0.0f, 1.0f, 0.0f);
            renderBlocks.func_78617_b(block, 0.0, 0.0, 0.0, renderBlocks.func_96446_b(block.func_71858_a(1, metadata)));
            tessellator.func_78375_b(0.0f, 0.0f, -1.0f);
            renderBlocks.func_78611_c(block, 0.0, 0.0, 0.0, renderBlocks.func_96446_b(block.func_71858_a(2, metadata)));
            tessellator.func_78375_b(0.0f, 0.0f, 1.0f);
            renderBlocks.func_78622_d(block, 0.0, 0.0, 0.0, renderBlocks.func_96446_b(block.func_71858_a(3, metadata)));
            tessellator.func_78375_b(-1.0f, 0.0f, 0.0f);
            renderBlocks.func_78573_e(block, 0.0, 0.0, 0.0, renderBlocks.func_96446_b(block.func_71858_a(4, metadata)));
            tessellator.func_78375_b(1.0f, 0.0f, 0.0f);
            renderBlocks.func_78605_f(block, 0.0, 0.0, 0.0, renderBlocks.func_96446_b(block.func_71858_a(5, metadata)));
        }
        tessellator.func_78381_a();
        GL11.glTranslatef((float)0.5f, (float)0.5f, (float)0.5f);
        GL11.glRotatef((float)90.0f, (float)0.0f, (float)-1.0f, (float)0.0f);
    }

    public boolean renderWorldBlock(IBlockAccess blockAccess, int x, int y, int z, Block block, int modelID, RenderBlocks renderBlocks) {
        VertexHelper.vertexCount = 0;
        this.renderPass = MinecraftForgeClient.getRenderPass();
        TileEntity TE_default = blockAccess.func_72796_p(x, y, z);
        if (TE_default != null && TE_default instanceof TEBase) {
            this.TE = (TEBase)TE_default;
            this.srcBlock = block;
            this.renderBlocks = renderBlocks;
            this.lightingHelper = new LightingHelper(renderBlocks);
            this.renderCarpentersBlock(x, y, z);
            this.renderSideBlocks(x, y, z);
            if (Minecraft.func_71375_t() && FeatureRegistry.enableFancyFluids && BlockProperties.hasCover(this.TE, 6)) {
                VertexHelper.vertexCount += FancyFluidsHelper.render(this.TE, renderBlocks, x, y, z) ? 1 : 0;
            }
        }
        return VertexHelper.vertexCount > 0;
    }

    public boolean shouldRender3DInInventory() {
        return true;
    }

    public int getRenderId() {
        return 0;
    }

    protected void renderBlockWithRotation(ItemStack itemStack, int x, int y, int z, double xMin, double yMin, double zMin, double xMax, double yMax, double zMax, ForgeDirection ... dir) {
        this.renderBlocks.func_83020_a(xMin, yMin, zMin, xMax, yMax, zMax);
        for (ForgeDirection rot : dir) {
            this.rotateBounds(this.renderBlocks, rot);
        }
        this.renderBlock(itemStack, x, y, z);
    }

    protected void rotateBounds(RenderBlocks renderBlocks, ForgeDirection dir) {
        switch (dir) {
            case DOWN: {
                renderBlocks.func_83020_a(renderBlocks.field_83021_g, 1.0 - renderBlocks.field_83022_l, renderBlocks.field_83027_i, renderBlocks.field_83026_h, 1.0 - renderBlocks.field_83025_k, renderBlocks.field_83024_j);
                break;
            }
            case UP: {
                renderBlocks.func_83020_a(renderBlocks.field_83021_g, renderBlocks.field_83025_k, renderBlocks.field_83027_i, renderBlocks.field_83026_h, renderBlocks.field_83022_l, renderBlocks.field_83024_j);
                break;
            }
            case NORTH: {
                renderBlocks.func_83020_a(1.0 - renderBlocks.field_83026_h, renderBlocks.field_83027_i, 1.0 - renderBlocks.field_83022_l, 1.0 - renderBlocks.field_83021_g, renderBlocks.field_83024_j, 1.0 - renderBlocks.field_83025_k);
                break;
            }
            case EAST: {
                renderBlocks.func_83020_a(renderBlocks.field_83025_k, renderBlocks.field_83027_i, 1.0 - renderBlocks.field_83026_h, renderBlocks.field_83022_l, renderBlocks.field_83024_j, 1.0 - renderBlocks.field_83021_g);
                break;
            }
            case WEST: {
                renderBlocks.func_83020_a(1.0 - renderBlocks.field_83022_l, renderBlocks.field_83027_i, renderBlocks.field_83021_g, 1.0 - renderBlocks.field_83025_k, renderBlocks.field_83024_j, renderBlocks.field_83026_h);
                break;
            }
        }
    }

    protected ItemStack getCoverForRendering() {
        return BlockProperties.getCoverForRendering(this.TE, this.coverRendering);
    }

    protected void setTextureRotation(int side, int rotation) {
        switch (side) {
            case 0: {
                this.renderBlocks.field_78675_l = rotation;
                break;
            }
            case 1: {
                this.renderBlocks.field_78681_k = rotation;
                break;
            }
            case 2: {
                this.renderBlocks.field_78679_j = rotation;
                break;
            }
            case 3: {
                this.renderBlocks.field_78685_i = rotation;
                break;
            }
            case 4: {
                this.renderBlocks.field_78683_h = rotation;
                break;
            }
            default: {
                this.renderBlocks.field_78662_g = rotation;
            }
        }
    }

    protected void setTextureRotationForDirectionalBlock(int side) {
        int metadata = this.getCoverForRendering().func_77960_j();
        int dir = metadata & 0xC;
        switch (side) {
            case 0: {
                if (metadata != 3 && dir != 4) break;
                this.renderBlocks.field_78675_l = 1;
                break;
            }
            case 1: {
                if (metadata != 3 && dir != 4) break;
                this.renderBlocks.field_78681_k = 1;
                break;
            }
            case 2: {
                if (metadata != 3 && dir != 4) break;
                this.renderBlocks.field_78679_j = 1;
                break;
            }
            case 3: {
                if (metadata != 3 && dir != 4) break;
                this.renderBlocks.field_78685_i = 1;
                break;
            }
            case 4: {
                if (metadata != 3 && dir != 8) break;
                this.renderBlocks.field_78683_h = 1;
                break;
            }
            case 5: {
                if (metadata != 3 && dir != 8) break;
                this.renderBlocks.field_78662_g = 1;
            }
        }
    }

    protected void resetTextureRotation(int side) {
        switch (side) {
            case 0: {
                this.renderBlocks.field_78675_l = 0;
                break;
            }
            case 1: {
                this.renderBlocks.field_78681_k = 0;
                break;
            }
            case 2: {
                this.renderBlocks.field_78679_j = 0;
                break;
            }
            case 3: {
                this.renderBlocks.field_78685_i = 0;
                break;
            }
            case 4: {
                this.renderBlocks.field_78683_h = 0;
                break;
            }
            case 5: {
                this.renderBlocks.field_78662_g = 0;
            }
        }
    }

    protected int getTextureRotation(int side) {
        int[] rotations = new int[]{this.renderBlocks.field_78675_l, this.renderBlocks.field_78681_k, this.renderBlocks.field_78679_j, this.renderBlocks.field_78685_i, this.renderBlocks.field_78683_h, this.renderBlocks.field_78662_g};
        return rotations[side];
    }

    protected void setDyeOverride(int color) {
        this.hasDyeOverride = true;
        this.dyeOverride = color;
    }

    protected void clearDyeOverride() {
        this.hasDyeOverride = false;
    }

    protected void setIconOverride(int side, Icon icon) {
        if (side == 6) {
            for (int count = 0; count < 6; ++count) {
                this.hasIconOverride[count] = true;
                this.iconOverride[count] = icon;
            }
        } else {
            this.hasIconOverride[side] = true;
            this.iconOverride[side] = icon;
        }
    }

    protected void clearIconOverride(int side) {
        if (side == 6) {
            for (int count = 0; count < 6; ++count) {
                this.hasIconOverride[count] = false;
            }
        } else {
            this.hasIconOverride[side] = false;
        }
    }

    protected int[] getSideCoverRenderBounds(int x, int y, int z, int side) {
        Block block;
        double offset = 0.0625;
        if (side == 1 && ((block = BlockProperties.toBlock(this.getCoverForRendering())).equals(Block.field_72039_aU) || block.equals(Block.field_72037_aS))) {
            offset = 0.125;
        }
        switch (side) {
            case 0: {
                if (this.renderBlocks.field_83027_i > 0.0) {
                    this.renderBlocks.field_83024_j = this.renderBlocks.field_83027_i;
                    this.renderBlocks.field_83027_i -= offset;
                    break;
                }
                this.renderBlocks.field_83024_j = 1.0;
                this.renderBlocks.field_83027_i = this.renderBlocks.field_83024_j - offset;
                break;
            }
            case 1: {
                if (this.renderBlocks.field_83024_j < 1.0) {
                    this.renderBlocks.field_83027_i = this.renderBlocks.field_83024_j;
                    this.renderBlocks.field_83024_j += offset;
                    break;
                }
                this.renderBlocks.field_83024_j = offset;
                this.renderBlocks.field_83027_i = 0.0;
                ++y;
                break;
            }
            case 2: {
                if (this.renderBlocks.field_83025_k > 0.0) {
                    this.renderBlocks.field_83022_l = this.renderBlocks.field_83025_k;
                    this.renderBlocks.field_83025_k -= offset;
                    break;
                }
                this.renderBlocks.field_83022_l = 1.0;
                this.renderBlocks.field_83025_k = this.renderBlocks.field_83022_l - offset;
                break;
            }
            case 3: {
                if (this.renderBlocks.field_83022_l < 1.0) {
                    this.renderBlocks.field_83025_k = this.renderBlocks.field_83022_l;
                    this.renderBlocks.field_83022_l += offset;
                    break;
                }
                this.renderBlocks.field_83022_l = offset;
                this.renderBlocks.field_83025_k = 0.0;
                ++z;
                break;
            }
            case 4: {
                if (this.renderBlocks.field_83021_g > 0.0) {
                    this.renderBlocks.field_83026_h = this.renderBlocks.field_83021_g;
                    this.renderBlocks.field_83021_g -= offset;
                    break;
                }
                this.renderBlocks.field_83026_h = 1.0;
                this.renderBlocks.field_83021_g = this.renderBlocks.field_83026_h - offset;
                break;
            }
            case 5: {
                if (this.renderBlocks.field_83026_h < 1.0) {
                    this.renderBlocks.field_83021_g = this.renderBlocks.field_83026_h;
                    this.renderBlocks.field_83026_h += offset;
                    break;
                }
                this.renderBlocks.field_83026_h = offset;
                this.renderBlocks.field_83021_g = 0.0;
                ++x;
            }
        }
        return new int[]{--x, --y, --z};
    }

    protected void renderSideBlocks(int x, int y, int z) {
        this.renderBlocks.field_78661_f = true;
        this.srcBlock.func_71902_a(this.renderBlocks.field_78669_a, x, y, z);
        for (int side = 0; side < 6; ++side) {
            if (!BlockProperties.hasCover(this.TE, side)) continue;
            this.coverRendering = side;
            int[] renderOffset = this.getSideCoverRenderBounds(x, y, z, side);
            this.renderBlock(this.getCoverForRendering(), renderOffset[0], renderOffset[1], renderOffset[2]);
            this.renderBlocks.func_83018_a(this.srcBlock);
        }
        this.renderBlocks.field_78661_f = false;
        this.coverRendering = 6;
    }

    protected Icon getUniqueIcon(ItemStack itemStack, int side, Icon icon) {
        return icon;
    }

    protected Icon getIcon(ItemStack itemStack, int side) {
        BlockProperties.prepareItemStackForRendering(itemStack);
        Icon icon = this.renderBlocks.func_96446_b(this.getUniqueIcon(itemStack, side, BlockProperties.toBlock(itemStack).func_71858_a(side, itemStack.func_77960_j())));
        if (this.hasIconOverride[side]) {
            icon = this.renderBlocks.func_96446_b(this.iconOverride[side]);
        }
        return icon;
    }

    protected void renderMultiTexturedSide(ItemStack itemStack, int x, int y, int z, int side, Icon icon) {
        boolean renderOverlay;
        Block block = BlockProperties.toBlock(itemStack);
        boolean renderCover = block instanceof BlockCoverable ? this.renderPass == PASS_OPAQUE : block.func_71856_s_() == this.renderPass;
        boolean bl = renderOverlay = this.renderPass == PASS_OPAQUE || renderCover && this.renderPass == PASS_ALPHA;
        if (renderCover) {
            int tempRotation = this.getTextureRotation(side);
            if (BlockProperties.blockRotates(itemStack)) {
                this.setTextureRotationForDirectionalBlock(side);
            }
            this.setColorAndRender(itemStack, x, y, z, side, icon);
            this.setTextureRotation(side, tempRotation);
        }
        if (renderOverlay && block.equals(Block.field_71980_u) && side > 0 && !this.isPositiveFace(side)) {
            if (Minecraft.func_71375_t()) {
                this.setColorAndRender(new ItemStack((Block)Block.field_71980_u), x, y, z, side, BlockGrass.func_94434_o());
            } else {
                this.setColorAndRender(new ItemStack(Block.field_71979_v), x, y, z, side, IconRegistry.icon_overlay_fast_grass_side);
            }
        }
        boolean temp_dye_state = this.suppressDyeColor;
        this.suppressDyeColor = true;
        if (this.renderPass == PASS_ALPHA && !this.suppressChiselDesign && BlockProperties.hasChiselDesign(this.TE, this.coverRendering)) {
            this.renderChiselDesign(x, y, z, side);
        }
        if (renderOverlay && !this.suppressOverlay && BlockProperties.hasOverlay(this.TE, this.coverRendering)) {
            this.renderOverlay(x, y, z, side);
        }
        this.suppressDyeColor = temp_dye_state;
    }

    protected void delegateSideRender(ItemStack itemStack, int x, int y, int z, int side) {
        if (this.renderBlocks.func_94167_b()) {
            this.setColorAndRender(itemStack, x, y, z, side, this.renderBlocks.field_78664_d);
        } else {
            this.renderMultiTexturedSide(itemStack, x, y, z, side, this.getIcon(itemStack, side));
        }
    }

    protected void renderOverlay(int x, int y, int z, int side) {
        side = this.isPositiveFace(side) ? 1 : side;
        OverlayHandler.Overlay overlay = OverlayHandler.getOverlayType(BlockProperties.getOverlay(this.TE, this.coverRendering));
        Icon icon = OverlayHandler.getOverlayIcon(overlay, side);
        if (icon != null) {
            this.setColorAndRender(overlay.getItemStack(), x, y, z, side, icon);
        }
    }

    protected void renderChiselDesign(int x, int y, int z, int side) {
        String design = BlockProperties.getChiselDesign(this.TE, this.coverRendering);
        Icon icon = this.renderBlocks.func_96446_b(IconRegistry.icon_design_chisel.get(DesignHandler.listChisel.indexOf(design)));
        this.setColorAndRender(new ItemStack(Block.field_71946_M), x, y, z, side, icon);
    }

    public final void setColorAndRender(ItemStack itemStack, int x, int y, int z, int side, Icon icon) {
        int color = this.getBlockColor(BlockProperties.toBlock(itemStack), itemStack.func_77960_j(), x, y, z, side, icon);
        if (!this.suppressDyeColor && (BlockProperties.hasDye(this.TE, this.coverRendering) || this.hasDyeOverride)) {
            color = this.hasDyeOverride ? this.dyeOverride : DyeHandler.getColor(BlockProperties.getDye(this.TE, this.coverRendering));
        }
        this.lightingHelper.setupColor(x, y, z, side, color, icon);
        this.render(x, y, z, side, icon);
        VertexHelper.postRender();
    }

    public int getBlockColor(Block block, int metadata, int x, int y, int z, int side, Icon icon) {
        BlockProperties.setHostMetadata(this.TE, metadata);
        int color = OptifineHandler.enableOptifineIntegration ? OptifineHandler.getColorMultiplier(block, (IBlockAccess)this.TE.func_70314_l(), x, y, z) : block.func_71920_b((IBlockAccess)this.TE.func_70314_l(), x, y, z);
        BlockProperties.resetHostMetadata(this.TE);
        if (block.equals(Block.field_71980_u) && !this.isPositiveFace(side) && !icon.equals(BlockGrass.func_94434_o())) {
            color = 0xFFFFFF;
        }
        return color;
    }

    protected boolean isPositiveFace(int side) {
        return side == 1;
    }

    protected void render(int x, int y, int z, int side, Icon icon) {
        switch (side) {
            case 0: {
                RenderHelper.renderFaceYNeg(this.renderBlocks, x, y, z, icon);
                break;
            }
            case 1: {
                RenderHelper.renderFaceYPos(this.renderBlocks, x, y, z, icon);
                break;
            }
            case 2: {
                RenderHelper.renderFaceZNeg(this.renderBlocks, x, y, z, icon);
                break;
            }
            case 3: {
                RenderHelper.renderFaceZPos(this.renderBlocks, x, y, z, icon);
                break;
            }
            case 4: {
                RenderHelper.renderFaceXNeg(this.renderBlocks, x, y, z, icon);
                break;
            }
            case 5: {
                RenderHelper.renderFaceXPos(this.renderBlocks, x, y, z, icon);
            }
        }
    }

    protected void renderCarpentersBlock(int x, int y, int z) {
        this.renderBlock(this.getCoverForRendering(), x, y, z);
    }

    public boolean getEnableAO(ItemStack itemStack) {
        Block block = BlockProperties.toBlock(itemStack);
        return Minecraft.func_71379_u() && !this.disableAO && Block.field_71984_q[block.field_71990_ca] == 0;
    }

    protected void renderBlock(ItemStack itemStack, int x, int y, int z) {
        if (BlockProperties.toBlock(itemStack) == null) {
            return;
        }
        this.renderBlocks.field_78677_m = this.getEnableAO(itemStack);
        if (this.renderBlocks.field_78661_f || this.srcBlock.func_71877_c(this.renderBlocks.field_78669_a, x, y - 1, z, 0) || this.renderBlocks.field_83027_i > 0.0) {
            this.lightingHelper.setupLightingYNeg(itemStack, x, y, z);
            this.delegateSideRender(itemStack, x, y, z, 0);
        }
        if (this.renderBlocks.field_78661_f || this.srcBlock.func_71877_c(this.renderBlocks.field_78669_a, x, y + 1, z, 1) || this.renderBlocks.field_83024_j < 1.0) {
            this.lightingHelper.setupLightingYPos(itemStack, x, y, z);
            this.delegateSideRender(itemStack, x, y, z, 1);
        }
        if (this.renderBlocks.field_78661_f || this.srcBlock.func_71877_c(this.renderBlocks.field_78669_a, x, y, z - 1, 2) || this.renderBlocks.field_83025_k > 0.0) {
            this.lightingHelper.setupLightingZNeg(itemStack, x, y, z);
            this.delegateSideRender(itemStack, x, y, z, 2);
        }
        if (this.renderBlocks.field_78661_f || this.srcBlock.func_71877_c(this.renderBlocks.field_78669_a, x, y, z + 1, 3) || this.renderBlocks.field_83022_l < 1.0) {
            this.lightingHelper.setupLightingZPos(itemStack, x, y, z);
            this.delegateSideRender(itemStack, x, y, z, 3);
        }
        if (this.renderBlocks.field_78661_f || this.srcBlock.func_71877_c(this.renderBlocks.field_78669_a, x - 1, y, z, 4) || this.renderBlocks.field_83021_g > 0.0) {
            this.lightingHelper.setupLightingXNeg(itemStack, x, y, z);
            this.delegateSideRender(itemStack, x, y, z, 4);
        }
        if (this.renderBlocks.field_78661_f || this.srcBlock.func_71877_c(this.renderBlocks.field_78669_a, x + 1, y, z, 5) || this.renderBlocks.field_83026_h < 1.0) {
            this.lightingHelper.setupLightingXPos(itemStack, x, y, z);
            this.delegateSideRender(itemStack, x, y, z, 5);
        }
        this.renderBlocks.field_78677_m = false;
    }
}

