/*
 * Decompiled with CFR 0.152.
 */
package com.carpentersblocks.renderer;

import com.carpentersblocks.block.BlockCarpentersBarrier;
import com.carpentersblocks.data.Barrier;
import com.carpentersblocks.renderer.BlockHandlerBase;
import com.carpentersblocks.tileentity.TEBase;
import com.carpentersblocks.util.registry.BlockRegistry;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.RenderBlocks;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeDirection;

@SideOnly(value=Side.CLIENT)
public class BlockHandlerCarpentersBarrier
extends BlockHandlerBase {
    private boolean[] barrier;
    private boolean[] connect;
    private static final int YN = 0;
    private static final int YP = 1;

    @Override
    public void renderInventoryBlock(Block block, int metadata, int modelID, RenderBlocks renderBlocks) {
        renderBlocks.func_83020_a(0.125, 0.0, 0.375, 0.375, 1.0, 0.625);
        super.renderInventoryBlock(block, metadata, modelID, renderBlocks);
        renderBlocks.func_83020_a(0.625, 0.0, 0.375, 0.875, 1.0, 0.625);
        super.renderInventoryBlock(block, metadata, modelID, renderBlocks);
        renderBlocks.func_83020_a(0.0, 0.8125, 0.4375, 1.0, 0.9375, 0.5625);
        super.renderInventoryBlock(block, metadata, modelID, renderBlocks);
        renderBlocks.func_83020_a(0.0, 0.4375, 0.4375, 1.0, 0.5625, 0.5625);
        super.renderInventoryBlock(block, metadata, modelID, renderBlocks);
    }

    @Override
    protected void renderCarpentersBlock(int x, int y, int z) {
        int type = Barrier.getType(this.TE);
        ItemStack itemStack = this.getCoverForRendering();
        this.findBarriers(x, y, z);
        switch (type) {
            case 4: {
                this.renderTypePicket(itemStack, x, y, z);
                break;
            }
            case 5: {
                this.renderTypeShadowbox(itemStack, x, y, z);
                break;
            }
            case 6: {
                this.renderTypeWall(itemStack, x, y, z);
                break;
            }
            default: {
                this.renderTypeVanilla(itemStack, x, y, z);
            }
        }
    }

    private void findBarriers(int x, int y, int z) {
        BlockCarpentersBarrier tempBlock = (BlockCarpentersBarrier)this.srcBlock;
        World world = this.TE.func_70314_l();
        this.connect = new boolean[]{tempBlock.canConnectBarrierTo(world, x, y - 1, z, ForgeDirection.UP), tempBlock.canConnectBarrierTo(world, x, y + 1, z, ForgeDirection.DOWN), tempBlock.canConnectBarrierTo(world, x, y, z - 1, ForgeDirection.SOUTH), tempBlock.canConnectBarrierTo(world, x, y, z + 1, ForgeDirection.NORTH), tempBlock.canConnectBarrierTo(world, x - 1, y, z, ForgeDirection.EAST), tempBlock.canConnectBarrierTo(world, x + 1, y, z, ForgeDirection.WEST), tempBlock.canConnectBarrierTo(world, x, y + 1, z - 1, ForgeDirection.SOUTH), tempBlock.canConnectBarrierTo(world, x, y + 1, z + 1, ForgeDirection.NORTH), tempBlock.canConnectBarrierTo(world, x - 1, y + 1, z, ForgeDirection.EAST), tempBlock.canConnectBarrierTo(world, x + 1, y + 1, z, ForgeDirection.WEST)};
        Block blockYN = Block.field_71973_m[this.renderBlocks.field_78669_a.func_72798_a(x, y - 1, z)];
        Block blockYP = Block.field_71973_m[this.renderBlocks.field_78669_a.func_72798_a(x, y + 1, z)];
        this.barrier = new boolean[]{blockYN != null ? blockYN.equals(this.srcBlock) : false, blockYP != null ? blockYP.equals(this.srcBlock) : false};
    }

    private boolean hasPost(TEBase TE) {
        BlockCarpentersBarrier tempBlock = (BlockCarpentersBarrier)this.srcBlock;
        World world = TE.func_70314_l();
        Block blockYP = Block.field_71973_m[this.renderBlocks.field_78669_a.func_72798_a(TE.field_70329_l, TE.field_70330_m + 1, TE.field_70327_n)];
        boolean flowerPotYP = blockYP != null && blockYP.field_72018_cp.equals(Material.field_76265_p);
        boolean connectZN = tempBlock.canConnectBarrierTo(world, TE.field_70329_l, TE.field_70330_m, TE.field_70327_n - 1, ForgeDirection.SOUTH);
        boolean connectZP = tempBlock.canConnectBarrierTo(world, TE.field_70329_l, TE.field_70330_m, TE.field_70327_n + 1, ForgeDirection.NORTH);
        boolean connectXN = tempBlock.canConnectBarrierTo(world, TE.field_70329_l - 1, TE.field_70330_m, TE.field_70327_n, ForgeDirection.EAST);
        boolean connectXP = tempBlock.canConnectBarrierTo(world, TE.field_70329_l + 1, TE.field_70330_m, TE.field_70327_n, ForgeDirection.WEST);
        Block blockZN = Block.field_71973_m[this.renderBlocks.field_78669_a.func_72798_a(TE.field_70329_l, TE.field_70330_m, TE.field_70327_n - 1)];
        Block blockZP = Block.field_71973_m[this.renderBlocks.field_78669_a.func_72798_a(TE.field_70329_l, TE.field_70330_m, TE.field_70327_n + 1)];
        Block blockXN = Block.field_71973_m[this.renderBlocks.field_78669_a.func_72798_a(TE.field_70329_l - 1, TE.field_70330_m, TE.field_70327_n)];
        Block blockXP = Block.field_71973_m[this.renderBlocks.field_78669_a.func_72798_a(TE.field_70329_l + 1, TE.field_70330_m, TE.field_70327_n)];
        boolean adjGate = blockZN != null && blockZN.equals(BlockRegistry.blockCarpentersGate) || blockZP != null && blockZP.equals(BlockRegistry.blockCarpentersGate) || blockXN != null && blockXN.equals(BlockRegistry.blockCarpentersGate) || blockXP != null && blockXP.equals(BlockRegistry.blockCarpentersGate);
        boolean pathOnX = connectXN && connectXP;
        boolean pathOnZ = connectZN && connectZP;
        return Barrier.getPost(TE) == 1 || flowerPotYP || adjGate || pathOnX == pathOnZ || (connectXN || connectXP) && (connectZN || connectZP);
    }

    private boolean isPostAt() {
        Block block;
        int y;
        if (this.hasPost(this.TE)) {
            return true;
        }
        for (y = this.TE.field_70330_m + 1; y < this.renderBlocks.field_78669_a.func_72800_K() && (block = Block.field_71973_m[this.renderBlocks.field_78669_a.func_72798_a(this.TE.field_70329_l, y, this.TE.field_70327_n)]) != null && block.equals(this.srcBlock); ++y) {
            if (!this.hasPost((TEBase)this.renderBlocks.field_78669_a.func_72796_p(this.TE.field_70329_l, y, this.TE.field_70327_n))) continue;
            return true;
        }
        for (y = this.TE.field_70330_m - 1; y > 0 && (block = Block.field_71973_m[this.renderBlocks.field_78669_a.func_72798_a(this.TE.field_70329_l, y, this.TE.field_70327_n)]) != null && block.equals(this.srcBlock); --y) {
            if (!this.hasPost((TEBase)this.renderBlocks.field_78669_a.func_72796_p(this.TE.field_70329_l, y, this.TE.field_70327_n))) continue;
            return true;
        }
        return false;
    }

    private void renderPost(ItemStack itemStack, int x, int y, int z, double radius) {
        if (this.isPostAt()) {
            double radiusLow = 0.5 - radius;
            double radiusHigh = 0.5 + radius;
            this.renderBlocks.func_83020_a(radiusLow, 0.0, radiusLow, radiusHigh, 1.0, radiusHigh);
            this.renderBlock(itemStack, x, y, z);
        }
    }

    private void renderSupportPlank(ItemStack itemStack, int x, int y, int z, ForgeDirection dir, double depthRadius, double yMin, double yMax, boolean enforce) {
        boolean isTop = yMax - 0.5 > 0.5 - yMin;
        double radiusLow = 0.5 - depthRadius;
        double radiusHigh = 0.5 + depthRadius;
        if (isTop) {
            if (enforce || !this.connect[dir.ordinal() + 4] || !this.barrier[1]) {
                this.renderBlockWithRotation(itemStack, x, y, z, radiusLow, yMin, 0.5, radiusHigh, yMax, 1.0, dir);
            }
        } else if (enforce || !this.barrier[0]) {
            this.renderBlockWithRotation(itemStack, x, y, z, radiusLow, yMin, 0.5, radiusHigh, yMax, 1.0, dir);
        }
    }

    private void renderTypeVanilla(ItemStack itemStack, int x, int y, int z) {
        this.renderPost(itemStack, x, y, z, 0.125);
        double yOffset = (double)Barrier.getType(this.TE) * 0.0625;
        boolean singlePlank = Barrier.getType(this.TE) == 3;
        for (int side = 2; side < 6; ++side) {
            ForgeDirection dir = ForgeDirection.getOrientation((int)side);
            if (!this.connect[side]) continue;
            if (singlePlank) {
                this.renderSupportPlank(itemStack, x, y, z, dir, 0.0625, 0.1875, 0.9375, true);
                continue;
            }
            this.renderSupportPlank(itemStack, x, y, z, dir, 0.0625, 0.75 - yOffset, 0.9375, true);
            this.renderSupportPlank(itemStack, x, y, z, dir, 0.0625, 0.375 - yOffset, 0.5625, true);
        }
    }

    private void renderTypePicket(ItemStack itemStack, int x, int y, int z) {
        this.renderPost(itemStack, x, y, z, 0.0625);
        double yMin = this.barrier[0] ? 0.0 : 0.0625;
        for (int side = 2; side < 6; ++side) {
            ForgeDirection dir = ForgeDirection.getOrientation((int)side);
            if (this.connect[side]) {
                double yMax = this.connect[side + 4] && this.connect[1] ? 1.0 : 0.875;
                this.renderBlockWithRotation(itemStack, x, y, z, 0.5625, yMin, 0.6875, 0.625, yMax, 0.8125, dir);
                this.renderBlockWithRotation(itemStack, x, y, z, 0.375, yMin, 0.6875, 0.4375, yMax, 0.8125, dir);
                yMax = this.connect[side + 4] && this.connect[1] ? 1.0 : 0.8125;
                this.renderBlockWithRotation(itemStack, x, y, z, 0.5625, yMin, 0.9375, 0.625, yMax, 1.0, dir);
                this.renderBlockWithRotation(itemStack, x, y, z, 0.375, yMin, 0.9375, 0.4375, yMax, 1.0, dir);
                this.renderSupportPlank(itemStack, x, y, z, dir, 0.0625, 0.625, 0.6875, false);
                this.renderSupportPlank(itemStack, x, y, z, dir, 0.0625, 0.1875, 0.25, false);
                continue;
            }
            this.renderBlockWithRotation(itemStack, x, y, z, 0.4375, yMin, 0.5625, 0.5625, 1.0, 0.625, dir);
        }
    }

    private void renderTypeWall(ItemStack itemStack, int x, int y, int z) {
        this.renderPost(itemStack, x, y, z, 0.25);
        for (int side = 2; side < 6; ++side) {
            if (!this.connect[side]) continue;
            double yMax = this.connect[side + 4] && this.connect[1] ? 1.0 : 0.8125;
            this.renderBlockWithRotation(itemStack, x, y, z, 0.3125, 0.0, 0.5, 0.6875, yMax, 1.0, ForgeDirection.getOrientation((int)side));
        }
    }

    private void renderTypeShadowbox(ItemStack itemStack, int x, int y, int z) {
        this.renderPost(itemStack, x, y, z, 0.0625);
        for (int side = 2; side < 6; ++side) {
            if (!this.connect[side]) continue;
            ForgeDirection dir = ForgeDirection.getOrientation((int)side);
            this.renderSupportPlank(itemStack, x, y, z, dir, 0.0625, 0.75, 0.875, false);
            this.renderSupportPlank(itemStack, x, y, z, dir, 0.0625, 0.125, 0.25, false);
            this.renderBlockWithRotation(itemStack, x, y, z, 0.5625, 0.0, 0.5, 0.625, 1.0, 0.75, dir);
            this.renderBlockWithRotation(itemStack, x, y, z, 0.375, 0.0, 0.75, 0.4375, 1.0, 1.0, dir);
        }
    }
}

