/*
 * Decompiled with CFR 0.152.
 */
package com.carpentersblocks.renderer;

import com.carpentersblocks.renderer.BlockHandlerBase;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.minecraft.item.ItemStack;
import net.minecraft.util.Icon;

@SideOnly(value=Side.CLIENT)
public abstract class BlockHandlerSloped
extends BlockHandlerBase {
    protected int renderID = 0;
    protected float[][] ao = new float[6][4];
    protected int[][] brightness = new int[6][4];
    protected float[][] offset_ao = new float[6][4];
    protected int[][] offset_brightness = new int[6][4];

    protected final void setIDAndRender(ItemStack itemStack, int renderID, int x, int y, int z, int side) {
        this.renderID = renderID;
        this.delegateSideRender(itemStack, x, y, z, side);
    }

    protected void prepareLighting(ItemStack itemStack) {
        for (int side = 0; side < 6; ++side) {
            this.populateLighting(itemStack, side);
            this.populateOffsetLighting(itemStack, side);
        }
    }

    private void populateLighting(ItemStack itemStack, int side) {
        switch (side) {
            case 0: {
                this.lightingHelper.setupLightingYNeg(itemStack, this.TE.field_70329_l, this.TE.field_70330_m, this.TE.field_70327_n);
                if (!this.renderBlocks.field_78677_m) break;
                this.ao[0] = new float[]{this.lightingHelper.ao[0], this.lightingHelper.ao[1], this.lightingHelper.ao[2], this.lightingHelper.ao[3]};
                this.brightness[0] = new int[]{this.renderBlocks.field_78700_an, this.renderBlocks.field_78694_ao, this.renderBlocks.field_78696_ap, this.renderBlocks.field_78676_aq};
                break;
            }
            case 1: {
                this.lightingHelper.setupLightingYPos(itemStack, this.TE.field_70329_l, this.TE.field_70330_m, this.TE.field_70327_n);
                if (!this.renderBlocks.field_78677_m) break;
                this.ao[1] = new float[]{this.lightingHelper.ao[0], this.lightingHelper.ao[1], this.lightingHelper.ao[2], this.lightingHelper.ao[3]};
                this.brightness[1] = new int[]{this.renderBlocks.field_78700_an, this.renderBlocks.field_78694_ao, this.renderBlocks.field_78696_ap, this.renderBlocks.field_78676_aq};
                break;
            }
            case 2: {
                this.lightingHelper.setupLightingZNeg(itemStack, this.TE.field_70329_l, this.TE.field_70330_m, this.TE.field_70327_n);
                if (!this.renderBlocks.field_78677_m) break;
                this.ao[2] = new float[]{this.lightingHelper.ao[0], this.lightingHelper.ao[1], this.lightingHelper.ao[2], this.lightingHelper.ao[3]};
                this.brightness[2] = new int[]{this.renderBlocks.field_78700_an, this.renderBlocks.field_78694_ao, this.renderBlocks.field_78696_ap, this.renderBlocks.field_78676_aq};
                break;
            }
            case 3: {
                this.lightingHelper.setupLightingZPos(itemStack, this.TE.field_70329_l, this.TE.field_70330_m, this.TE.field_70327_n);
                if (!this.renderBlocks.field_78677_m) break;
                this.ao[3] = new float[]{this.lightingHelper.ao[0], this.lightingHelper.ao[1], this.lightingHelper.ao[2], this.lightingHelper.ao[3]};
                this.brightness[3] = new int[]{this.renderBlocks.field_78700_an, this.renderBlocks.field_78694_ao, this.renderBlocks.field_78696_ap, this.renderBlocks.field_78676_aq};
                break;
            }
            case 4: {
                this.lightingHelper.setupLightingXNeg(itemStack, this.TE.field_70329_l, this.TE.field_70330_m, this.TE.field_70327_n);
                if (!this.renderBlocks.field_78677_m) break;
                this.ao[4] = new float[]{this.lightingHelper.ao[0], this.lightingHelper.ao[1], this.lightingHelper.ao[2], this.lightingHelper.ao[3]};
                this.brightness[4] = new int[]{this.renderBlocks.field_78700_an, this.renderBlocks.field_78694_ao, this.renderBlocks.field_78696_ap, this.renderBlocks.field_78676_aq};
                break;
            }
            case 5: {
                this.lightingHelper.setupLightingXPos(itemStack, this.TE.field_70329_l, this.TE.field_70330_m, this.TE.field_70327_n);
                if (!this.renderBlocks.field_78677_m) break;
                this.ao[5] = new float[]{this.lightingHelper.ao[0], this.lightingHelper.ao[1], this.lightingHelper.ao[2], this.lightingHelper.ao[3]};
                this.brightness[5] = new int[]{this.renderBlocks.field_78700_an, this.renderBlocks.field_78694_ao, this.renderBlocks.field_78696_ap, this.renderBlocks.field_78676_aq};
            }
        }
    }

    private void populateOffsetLighting(ItemStack itemStack, int side) {
        switch (side) {
            case 0: {
                double renderTemp = this.renderBlocks.field_83027_i;
                this.renderBlocks.field_83027_i = 0.0;
                this.lightingHelper.setupLightingYNeg(itemStack, this.TE.field_70329_l, this.TE.field_70330_m + 1, this.TE.field_70327_n);
                this.renderBlocks.field_83027_i = renderTemp;
                if (!this.renderBlocks.field_78677_m) break;
                this.offset_ao[0] = new float[]{this.lightingHelper.ao[0], this.lightingHelper.ao[1], this.lightingHelper.ao[2], this.lightingHelper.ao[3]};
                this.offset_brightness[0] = new int[]{this.renderBlocks.field_78700_an, this.renderBlocks.field_78694_ao, this.renderBlocks.field_78696_ap, this.renderBlocks.field_78676_aq};
                break;
            }
            case 1: {
                double renderTemp = this.renderBlocks.field_83024_j;
                this.renderBlocks.field_83024_j = 1.0;
                this.lightingHelper.setupLightingYPos(itemStack, this.TE.field_70329_l, this.TE.field_70330_m - 1, this.TE.field_70327_n);
                this.renderBlocks.field_83024_j = renderTemp;
                if (!this.renderBlocks.field_78677_m) break;
                this.offset_ao[1] = new float[]{this.lightingHelper.ao[0], this.lightingHelper.ao[1], this.lightingHelper.ao[2], this.lightingHelper.ao[3]};
                this.offset_brightness[1] = new int[]{this.renderBlocks.field_78700_an, this.renderBlocks.field_78694_ao, this.renderBlocks.field_78696_ap, this.renderBlocks.field_78676_aq};
                break;
            }
            case 2: {
                double renderTemp = this.renderBlocks.field_83025_k;
                this.renderBlocks.field_83025_k = 0.0;
                this.lightingHelper.setupLightingZNeg(itemStack, this.TE.field_70329_l, this.TE.field_70330_m, this.TE.field_70327_n + 1);
                this.renderBlocks.field_83025_k = renderTemp;
                if (!this.renderBlocks.field_78677_m) break;
                this.offset_ao[2] = new float[]{this.lightingHelper.ao[0], this.lightingHelper.ao[1], this.lightingHelper.ao[2], this.lightingHelper.ao[3]};
                this.offset_brightness[2] = new int[]{this.renderBlocks.field_78700_an, this.renderBlocks.field_78694_ao, this.renderBlocks.field_78696_ap, this.renderBlocks.field_78676_aq};
                break;
            }
            case 3: {
                double renderTemp = this.renderBlocks.field_83022_l;
                this.renderBlocks.field_83022_l = 1.0;
                this.lightingHelper.setupLightingZPos(itemStack, this.TE.field_70329_l, this.TE.field_70330_m, this.TE.field_70327_n - 1);
                this.renderBlocks.field_83022_l = renderTemp;
                if (!this.renderBlocks.field_78677_m) break;
                this.offset_ao[3] = new float[]{this.lightingHelper.ao[0], this.lightingHelper.ao[1], this.lightingHelper.ao[2], this.lightingHelper.ao[3]};
                this.offset_brightness[3] = new int[]{this.renderBlocks.field_78700_an, this.renderBlocks.field_78694_ao, this.renderBlocks.field_78696_ap, this.renderBlocks.field_78676_aq};
                break;
            }
            case 4: {
                double renderTemp = this.renderBlocks.field_83021_g;
                this.renderBlocks.field_83021_g = 0.0;
                this.lightingHelper.setupLightingXNeg(itemStack, this.TE.field_70329_l + 1, this.TE.field_70330_m, this.TE.field_70327_n);
                this.renderBlocks.field_83021_g = renderTemp;
                if (!this.renderBlocks.field_78677_m) break;
                this.offset_ao[4] = new float[]{this.lightingHelper.ao[0], this.lightingHelper.ao[1], this.lightingHelper.ao[2], this.lightingHelper.ao[3]};
                this.offset_brightness[4] = new int[]{this.renderBlocks.field_78700_an, this.renderBlocks.field_78694_ao, this.renderBlocks.field_78696_ap, this.renderBlocks.field_78676_aq};
                break;
            }
            case 5: {
                double renderTemp = this.renderBlocks.field_83026_h;
                this.renderBlocks.field_83026_h = 1.0;
                this.lightingHelper.setupLightingXPos(itemStack, this.TE.field_70329_l - 1, this.TE.field_70330_m, this.TE.field_70327_n);
                this.renderBlocks.field_83026_h = renderTemp;
                if (!this.renderBlocks.field_78677_m) break;
                this.offset_ao[5] = new float[]{this.lightingHelper.ao[0], this.lightingHelper.ao[1], this.lightingHelper.ao[2], this.lightingHelper.ao[3]};
                this.offset_brightness[5] = new int[]{this.renderBlocks.field_78700_an, this.renderBlocks.field_78694_ao, this.renderBlocks.field_78696_ap, this.renderBlocks.field_78676_aq};
            }
        }
    }

    abstract void renderBaseSide(int var1, int var2, int var3, int var4, Icon var5);

    @Override
    protected final void render(int x, int y, int z, int side, Icon icon) {
        if (this.coverRendering != 6) {
            super.render(x, y, z, side, icon);
        } else {
            this.renderBaseSide(x, y, z, side, icon);
        }
    }

    abstract void renderBaseBlock(ItemStack var1, int var2, int var3, int var4);

    @Override
    protected final void renderBlock(ItemStack itemStack, int x, int y, int z) {
        if (this.coverRendering != 6) {
            super.renderBlock(itemStack, x, y, z);
        } else {
            this.renderBaseBlock(itemStack, x, y, z);
        }
    }
}

