/*
 * Decompiled with CFR 0.152.
 */
package com.carpentersblocks.renderer.helper;

import com.carpentersblocks.util.BlockProperties;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.EntityRenderer;
import net.minecraft.client.renderer.RenderBlocks;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.item.ItemStack;
import net.minecraft.util.Icon;

@SideOnly(value=Side.CLIENT)
public class LightingHelper {
    public RenderBlocks renderBlocks;
    private boolean hasLightnessOverride;
    private float lightnessOverride;
    private boolean hasBrightnessOverride;
    private int brightnessOverride;
    private boolean hasColorOverride;
    private int colorOverride = 0xFFFFFF;
    public static final int NORMAL_BRIGHTNESS = 0xFF00FF;
    public static final int MAX_BRIGHTNESS = 0xF000F0;
    public static float[] LIGHTNESS = new float[]{0.5f, 1.0f, 0.8f, 0.8f, 0.6f, 0.6f};
    public float[] ao = new float[4];
    public int brightness;

    public LightingHelper(RenderBlocks renderBlocks) {
        this.renderBlocks = renderBlocks;
    }

    public LightingHelper setLightnessOverride(float lightness) {
        this.hasLightnessOverride = true;
        this.lightnessOverride = lightness;
        return this;
    }

    public void clearLightnessOverride() {
        this.hasLightnessOverride = false;
    }

    public LightingHelper setBrightnessOverride(int brightness) {
        this.hasBrightnessOverride = true;
        this.brightnessOverride = brightness;
        return this;
    }

    public void clearBrightnessOverride() {
        this.hasBrightnessOverride = false;
    }

    public void setColorOverride(int color) {
        this.hasColorOverride = true;
        this.colorOverride = color;
    }

    public void clearColorOverride() {
        this.hasColorOverride = false;
    }

    public static float[] getRGB(int color) {
        float red = (float)(color >> 16 & 0xFF) / 255.0f;
        float green = (float)(color >> 8 & 0xFF) / 255.0f;
        float blue = (float)(color & 0xFF) / 255.0f;
        return new float[]{red, green, blue};
    }

    public void setupColor(int x, int y, int z, int side, int hexColor, Icon icon) {
        Tessellator tessellator = Tessellator.field_78398_a;
        float lightness = this.hasLightnessOverride ? this.lightnessOverride : LIGHTNESS[side];
        tessellator.func_78380_c(this.hasBrightnessOverride ? this.brightnessOverride : this.brightness);
        float[] rgb = LightingHelper.getRGB(hexColor);
        if (this.hasColorOverride && !this.renderBlocks.func_94167_b()) {
            rgb = LightingHelper.getRGB(this.colorOverride);
        }
        this.applyAnaglyph(rgb);
        if (this.renderBlocks.field_78677_m) {
            if (this.renderBlocks.func_94167_b()) {
                this.renderBlocks.field_78670_at = this.renderBlocks.field_78684_au = rgb[0];
                this.renderBlocks.field_78672_as = this.renderBlocks.field_78684_au;
                this.renderBlocks.field_78674_ar = this.renderBlocks.field_78684_au;
                this.renderBlocks.field_78678_ax = this.renderBlocks.field_78665_ay = rgb[1];
                this.renderBlocks.field_78680_aw = this.renderBlocks.field_78665_ay;
                this.renderBlocks.field_78682_av = this.renderBlocks.field_78665_ay;
                this.renderBlocks.field_78651_aB = this.renderBlocks.field_78652_aC = rgb[2];
                this.renderBlocks.field_78650_aA = this.renderBlocks.field_78652_aC;
                this.renderBlocks.field_78663_az = this.renderBlocks.field_78652_aC;
            } else {
                this.renderBlocks.field_78670_at = this.renderBlocks.field_78684_au = rgb[0] * lightness;
                this.renderBlocks.field_78672_as = this.renderBlocks.field_78684_au;
                this.renderBlocks.field_78674_ar = this.renderBlocks.field_78684_au;
                this.renderBlocks.field_78678_ax = this.renderBlocks.field_78665_ay = rgb[1] * lightness;
                this.renderBlocks.field_78680_aw = this.renderBlocks.field_78665_ay;
                this.renderBlocks.field_78682_av = this.renderBlocks.field_78665_ay;
                this.renderBlocks.field_78651_aB = this.renderBlocks.field_78652_aC = rgb[2] * lightness;
                this.renderBlocks.field_78650_aA = this.renderBlocks.field_78652_aC;
                this.renderBlocks.field_78663_az = this.renderBlocks.field_78652_aC;
                this.renderBlocks.field_78674_ar *= this.ao[0];
                this.renderBlocks.field_78682_av *= this.ao[0];
                this.renderBlocks.field_78663_az *= this.ao[0];
                this.renderBlocks.field_78672_as *= this.ao[1];
                this.renderBlocks.field_78680_aw *= this.ao[1];
                this.renderBlocks.field_78650_aA *= this.ao[1];
                this.renderBlocks.field_78670_at *= this.ao[2];
                this.renderBlocks.field_78678_ax *= this.ao[2];
                this.renderBlocks.field_78651_aB *= this.ao[2];
                this.renderBlocks.field_78684_au *= this.ao[3];
                this.renderBlocks.field_78665_ay *= this.ao[3];
                this.renderBlocks.field_78652_aC *= this.ao[3];
            }
        } else {
            tessellator.func_78386_a(rgb[0] * lightness, rgb[1] * lightness, rgb[2] * lightness);
        }
    }

    public void applyAnaglyph(float[] rgb) {
        if (EntityRenderer.field_78517_a) {
            rgb[0] = (rgb[0] * 30.0f + rgb[1] * 59.0f + rgb[2] * 11.0f) / 100.0f;
            rgb[1] = (rgb[0] * 30.0f + rgb[1] * 70.0f) / 100.0f;
            rgb[2] = (rgb[0] * 30.0f + rgb[2] * 70.0f) / 100.0f;
        }
    }

    public static int getAverageBrightness(int brightness1, int brightness2) {
        int section_1_1 = brightness1 >> 16 & 0xFF;
        int section_1_3 = brightness1 & 0xFF;
        int section_2_1 = brightness2 >> 16 & 0xFF;
        int section_2_3 = brightness2 & 0xFF;
        int difference1 = (int)((float)(section_1_1 + section_2_1) / 2.0f);
        int difference3 = (int)((float)(section_1_3 + section_2_3) / 2.0f);
        return difference1 << 16 | difference3;
    }

    public static float getMixedAo(float ao1, float ao2, double ratio) {
        float diff = (float)((double)Math.abs(ao1 - ao2) * (1.0 - ratio));
        return ao1 > ao2 ? ao1 - diff : ao1 + diff;
    }

    public LightingHelper setupLightingYNeg(ItemStack itemStack, int x, int y, int z) {
        int mixedBrightness;
        Block block = BlockProperties.toBlock(itemStack);
        int y_offset = this.renderBlocks.field_83027_i > 0.0 ? y : y - 1;
        this.brightness = mixedBrightness = block.func_71874_e(this.renderBlocks.field_78669_a, x, y_offset, z);
        if (this.renderBlocks.field_78677_m) {
            float ratio = (float)(1.0 - this.renderBlocks.field_83027_i);
            float aoLightValue = block.func_71888_h(this.renderBlocks.field_78669_a, x, y_offset, z);
            this.renderBlocks.field_78641_T = block.func_71874_e(this.renderBlocks.field_78669_a, x - 1, y_offset, z);
            this.renderBlocks.field_78645_V = block.func_71874_e(this.renderBlocks.field_78669_a, x, y_offset, z - 1);
            this.renderBlocks.field_78643_W = block.func_71874_e(this.renderBlocks.field_78669_a, x, y_offset, z + 1);
            this.renderBlocks.field_78655_Y = block.func_71874_e(this.renderBlocks.field_78669_a, x + 1, y_offset, z);
            this.renderBlocks.field_78649_S = block.func_71874_e(this.renderBlocks.field_78669_a, x - 1, y_offset, z - 1);
            this.renderBlocks.field_78639_U = block.func_71874_e(this.renderBlocks.field_78669_a, x - 1, y_offset, z + 1);
            this.renderBlocks.field_78657_X = block.func_71874_e(this.renderBlocks.field_78669_a, x + 1, y_offset, z - 1);
            this.renderBlocks.field_78660_Z = block.func_71874_e(this.renderBlocks.field_78669_a, x + 1, y_offset, z + 1);
            this.renderBlocks.field_78689_v = LightingHelper.getMixedAo(block.func_71888_h(this.renderBlocks.field_78669_a, x - 1, y - 1, z), block.func_71888_h(this.renderBlocks.field_78669_a, x - 1, y, z), ratio);
            this.renderBlocks.field_78712_x = LightingHelper.getMixedAo(block.func_71888_h(this.renderBlocks.field_78669_a, x, y - 1, z - 1), block.func_71888_h(this.renderBlocks.field_78669_a, x, y, z - 1), ratio);
            this.renderBlocks.field_78710_y = LightingHelper.getMixedAo(block.func_71888_h(this.renderBlocks.field_78669_a, x, y - 1, z + 1), block.func_71888_h(this.renderBlocks.field_78669_a, x, y, z + 1), ratio);
            this.renderBlocks.field_78628_A = LightingHelper.getMixedAo(block.func_71888_h(this.renderBlocks.field_78669_a, x + 1, y - 1, z), block.func_71888_h(this.renderBlocks.field_78669_a, x + 1, y, z), ratio);
            this.renderBlocks.field_78691_u = LightingHelper.getMixedAo(block.func_71888_h(this.renderBlocks.field_78669_a, x - 1, y - 1, z - 1), block.func_71888_h(this.renderBlocks.field_78669_a, x - 1, y, z - 1), ratio);
            this.renderBlocks.field_78687_w = LightingHelper.getMixedAo(block.func_71888_h(this.renderBlocks.field_78669_a, x - 1, y - 1, z + 1), block.func_71888_h(this.renderBlocks.field_78669_a, x - 1, y, z + 1), ratio);
            this.renderBlocks.field_78708_z = LightingHelper.getMixedAo(block.func_71888_h(this.renderBlocks.field_78669_a, x + 1, y - 1, z - 1), block.func_71888_h(this.renderBlocks.field_78669_a, x + 1, y, z - 1), ratio);
            this.renderBlocks.field_78629_B = LightingHelper.getMixedAo(block.func_71888_h(this.renderBlocks.field_78669_a, x + 1, y - 1, z + 1), block.func_71888_h(this.renderBlocks.field_78669_a, x + 1, y, z + 1), ratio);
            int brightnessMixed_XYZPNP = this.renderBlocks.func_78602_a(this.renderBlocks.field_78643_W, this.renderBlocks.field_78660_Z, this.renderBlocks.field_78655_Y, mixedBrightness);
            int brightnessMixed_XYZPNN = this.renderBlocks.func_78602_a(this.renderBlocks.field_78645_V, this.renderBlocks.field_78655_Y, this.renderBlocks.field_78657_X, mixedBrightness);
            int brightnessMixed_XYZNNN = this.renderBlocks.func_78602_a(this.renderBlocks.field_78641_T, this.renderBlocks.field_78649_S, this.renderBlocks.field_78645_V, mixedBrightness);
            int brightnessMixed_XYZNNP = this.renderBlocks.func_78602_a(this.renderBlocks.field_78639_U, this.renderBlocks.field_78641_T, this.renderBlocks.field_78643_W, mixedBrightness);
            if (this.renderBlocks.field_98189_n) {
                float aoMixed_XYZPNP = (this.renderBlocks.field_78710_y + aoLightValue + this.renderBlocks.field_78629_B + this.renderBlocks.field_78628_A) / 4.0f;
                float aoMixed_XYZPNN = (aoLightValue + this.renderBlocks.field_78712_x + this.renderBlocks.field_78628_A + this.renderBlocks.field_78708_z) / 4.0f;
                float aoMixed_XYZNNN = (this.renderBlocks.field_78689_v + this.renderBlocks.field_78691_u + aoLightValue + this.renderBlocks.field_78712_x) / 4.0f;
                float aoMixed_XYZNNP = (this.renderBlocks.field_78687_w + this.renderBlocks.field_78689_v + this.renderBlocks.field_78710_y + aoLightValue) / 4.0f;
                this.ao[0] = (float)((double)aoMixed_XYZNNP * this.renderBlocks.field_83022_l * (1.0 - this.renderBlocks.field_83026_h) + (double)aoMixed_XYZPNP * this.renderBlocks.field_83022_l * this.renderBlocks.field_83026_h + (double)aoMixed_XYZPNN * (1.0 - this.renderBlocks.field_83022_l) * this.renderBlocks.field_83026_h + (double)aoMixed_XYZNNN * (1.0 - this.renderBlocks.field_83022_l) * (1.0 - this.renderBlocks.field_83026_h));
                this.ao[1] = (float)((double)aoMixed_XYZNNP * this.renderBlocks.field_83025_k * (1.0 - this.renderBlocks.field_83026_h) + (double)aoMixed_XYZPNP * this.renderBlocks.field_83025_k * this.renderBlocks.field_83026_h + (double)aoMixed_XYZPNN * (1.0 - this.renderBlocks.field_83025_k) * this.renderBlocks.field_83026_h + (double)aoMixed_XYZNNN * (1.0 - this.renderBlocks.field_83025_k) * (1.0 - this.renderBlocks.field_83026_h));
                this.ao[2] = (float)((double)aoMixed_XYZNNP * this.renderBlocks.field_83025_k * (1.0 - this.renderBlocks.field_83021_g) + (double)aoMixed_XYZPNP * this.renderBlocks.field_83025_k * this.renderBlocks.field_83021_g + (double)aoMixed_XYZPNN * (1.0 - this.renderBlocks.field_83025_k) * this.renderBlocks.field_83021_g + (double)aoMixed_XYZNNN * (1.0 - this.renderBlocks.field_83025_k) * (1.0 - this.renderBlocks.field_83021_g));
                this.ao[3] = (float)((double)aoMixed_XYZNNP * this.renderBlocks.field_83022_l * (1.0 - this.renderBlocks.field_83021_g) + (double)aoMixed_XYZPNP * this.renderBlocks.field_83022_l * this.renderBlocks.field_83021_g + (double)aoMixed_XYZPNN * (1.0 - this.renderBlocks.field_83022_l) * this.renderBlocks.field_83021_g + (double)aoMixed_XYZNNN * (1.0 - this.renderBlocks.field_83022_l) * (1.0 - this.renderBlocks.field_83021_g));
                this.renderBlocks.field_78700_an = this.renderBlocks.func_96444_a(brightnessMixed_XYZNNP, brightnessMixed_XYZPNP, brightnessMixed_XYZPNN, brightnessMixed_XYZNNN, this.renderBlocks.field_83022_l * (1.0 - this.renderBlocks.field_83026_h), this.renderBlocks.field_83022_l * this.renderBlocks.field_83026_h, (1.0 - this.renderBlocks.field_83022_l) * this.renderBlocks.field_83026_h, (1.0 - this.renderBlocks.field_83022_l) * (1.0 - this.renderBlocks.field_83026_h));
                this.renderBlocks.field_78694_ao = this.renderBlocks.func_96444_a(brightnessMixed_XYZNNP, brightnessMixed_XYZPNP, brightnessMixed_XYZPNN, brightnessMixed_XYZNNN, this.renderBlocks.field_83025_k * (1.0 - this.renderBlocks.field_83026_h), this.renderBlocks.field_83025_k * this.renderBlocks.field_83026_h, (1.0 - this.renderBlocks.field_83025_k) * this.renderBlocks.field_83026_h, (1.0 - this.renderBlocks.field_83025_k) * (1.0 - this.renderBlocks.field_83026_h));
                this.renderBlocks.field_78696_ap = this.renderBlocks.func_96444_a(brightnessMixed_XYZNNP, brightnessMixed_XYZPNP, brightnessMixed_XYZPNN, brightnessMixed_XYZNNN, this.renderBlocks.field_83025_k * (1.0 - this.renderBlocks.field_83021_g), this.renderBlocks.field_83025_k * this.renderBlocks.field_83021_g, (1.0 - this.renderBlocks.field_83025_k) * this.renderBlocks.field_83021_g, (1.0 - this.renderBlocks.field_83025_k) * (1.0 - this.renderBlocks.field_83021_g));
                this.renderBlocks.field_78676_aq = this.renderBlocks.func_96444_a(brightnessMixed_XYZNNP, brightnessMixed_XYZPNP, brightnessMixed_XYZPNN, brightnessMixed_XYZNNN, this.renderBlocks.field_83022_l * (1.0 - this.renderBlocks.field_83021_g), this.renderBlocks.field_83022_l * this.renderBlocks.field_83021_g, (1.0 - this.renderBlocks.field_83022_l) * this.renderBlocks.field_83021_g, (1.0 - this.renderBlocks.field_83022_l) * (1.0 - this.renderBlocks.field_83021_g));
            } else {
                this.ao[0] = (this.renderBlocks.field_78710_y + aoLightValue + this.renderBlocks.field_78629_B + this.renderBlocks.field_78628_A) / 4.0f;
                this.ao[1] = (aoLightValue + this.renderBlocks.field_78712_x + this.renderBlocks.field_78628_A + this.renderBlocks.field_78708_z) / 4.0f;
                this.ao[2] = (this.renderBlocks.field_78689_v + this.renderBlocks.field_78691_u + aoLightValue + this.renderBlocks.field_78712_x) / 4.0f;
                this.ao[3] = (this.renderBlocks.field_78687_w + this.renderBlocks.field_78689_v + this.renderBlocks.field_78710_y + aoLightValue) / 4.0f;
                this.renderBlocks.field_78700_an = brightnessMixed_XYZPNP;
                this.renderBlocks.field_78694_ao = brightnessMixed_XYZPNN;
                this.renderBlocks.field_78696_ap = brightnessMixed_XYZNNN;
                this.renderBlocks.field_78676_aq = brightnessMixed_XYZNNP;
            }
        }
        return this;
    }

    public LightingHelper setupLightingYPos(ItemStack itemStack, int x, int y, int z) {
        int mixedBrightness;
        Block block = BlockProperties.toBlock(itemStack);
        int y_offset = this.renderBlocks.field_83024_j < 1.0 ? y : y + 1;
        this.brightness = mixedBrightness = block.func_71874_e(this.renderBlocks.field_78669_a, x, y_offset, z);
        if (this.renderBlocks.field_78677_m) {
            float aoLightValue = block.func_71888_h(this.renderBlocks.field_78669_a, x, y_offset, z);
            this.renderBlocks.field_78705_ab = block.func_71874_e(this.renderBlocks.field_78669_a, x - 1, y_offset, z);
            this.renderBlocks.field_78711_af = block.func_71874_e(this.renderBlocks.field_78669_a, x + 1, y_offset, z);
            this.renderBlocks.field_78703_ad = block.func_71874_e(this.renderBlocks.field_78669_a, x, y_offset, z - 1);
            this.renderBlocks.field_78706_ag = block.func_71874_e(this.renderBlocks.field_78669_a, x, y_offset, z + 1);
            this.renderBlocks.field_78704_aa = block.func_71874_e(this.renderBlocks.field_78669_a, x - 1, y_offset, z - 1);
            this.renderBlocks.field_78709_ae = block.func_71874_e(this.renderBlocks.field_78669_a, x + 1, y_offset, z - 1);
            this.renderBlocks.field_78702_ac = block.func_71874_e(this.renderBlocks.field_78669_a, x - 1, y_offset, z + 1);
            this.renderBlocks.field_78707_ah = block.func_71874_e(this.renderBlocks.field_78669_a, x + 1, y_offset, z + 1);
            this.renderBlocks.field_78624_D = LightingHelper.getMixedAo(block.func_71888_h(this.renderBlocks.field_78669_a, x - 1, y + 1, z), block.func_71888_h(this.renderBlocks.field_78669_a, x - 1, y, z), this.renderBlocks.field_83024_j);
            this.renderBlocks.field_78634_H = LightingHelper.getMixedAo(block.func_71888_h(this.renderBlocks.field_78669_a, x + 1, y + 1, z), block.func_71888_h(this.renderBlocks.field_78669_a, x + 1, y, z), this.renderBlocks.field_83024_j);
            this.renderBlocks.field_78626_F = LightingHelper.getMixedAo(block.func_71888_h(this.renderBlocks.field_78669_a, x, y + 1, z - 1), block.func_71888_h(this.renderBlocks.field_78669_a, x, y, z - 1), this.renderBlocks.field_83024_j);
            this.renderBlocks.field_78635_I = LightingHelper.getMixedAo(block.func_71888_h(this.renderBlocks.field_78669_a, x, y + 1, z + 1), block.func_71888_h(this.renderBlocks.field_78669_a, x, y, z + 1), this.renderBlocks.field_83024_j);
            this.renderBlocks.field_78630_C = LightingHelper.getMixedAo(block.func_71888_h(this.renderBlocks.field_78669_a, x - 1, y + 1, z - 1), block.func_71888_h(this.renderBlocks.field_78669_a, x - 1, y, z - 1), this.renderBlocks.field_83024_j);
            this.renderBlocks.field_78627_G = LightingHelper.getMixedAo(block.func_71888_h(this.renderBlocks.field_78669_a, x + 1, y + 1, z - 1), block.func_71888_h(this.renderBlocks.field_78669_a, x + 1, y, z - 1), this.renderBlocks.field_83024_j);
            this.renderBlocks.field_78625_E = LightingHelper.getMixedAo(block.func_71888_h(this.renderBlocks.field_78669_a, x - 1, y + 1, z + 1), block.func_71888_h(this.renderBlocks.field_78669_a, x - 1, y, z + 1), this.renderBlocks.field_83024_j);
            this.renderBlocks.field_78636_J = LightingHelper.getMixedAo(block.func_71888_h(this.renderBlocks.field_78669_a, x + 1, y + 1, z + 1), block.func_71888_h(this.renderBlocks.field_78669_a, x + 1, y, z + 1), this.renderBlocks.field_83024_j);
            int brightnessMixed_XYZPPP = this.renderBlocks.func_78602_a(this.renderBlocks.field_78706_ag, this.renderBlocks.field_78707_ah, this.renderBlocks.field_78711_af, mixedBrightness);
            int brightnessMixed_XYZPPN = this.renderBlocks.func_78602_a(this.renderBlocks.field_78703_ad, this.renderBlocks.field_78711_af, this.renderBlocks.field_78709_ae, mixedBrightness);
            int brightnessMixed_XYZNPN = this.renderBlocks.func_78602_a(this.renderBlocks.field_78705_ab, this.renderBlocks.field_78704_aa, this.renderBlocks.field_78703_ad, mixedBrightness);
            int brightnessMixed_XYZNPP = this.renderBlocks.func_78602_a(this.renderBlocks.field_78702_ac, this.renderBlocks.field_78705_ab, this.renderBlocks.field_78706_ag, mixedBrightness);
            if (this.renderBlocks.field_98189_n) {
                float aoMixed_XYZPPP = (this.renderBlocks.field_78635_I + aoLightValue + this.renderBlocks.field_78636_J + this.renderBlocks.field_78634_H) / 4.0f;
                float aoMixed_XYZPPN = (aoLightValue + this.renderBlocks.field_78626_F + this.renderBlocks.field_78634_H + this.renderBlocks.field_78627_G) / 4.0f;
                float aoMixed_XYZNPN = (this.renderBlocks.field_78624_D + this.renderBlocks.field_78630_C + aoLightValue + this.renderBlocks.field_78626_F) / 4.0f;
                float aoMixed_XYZNPP = (this.renderBlocks.field_78625_E + this.renderBlocks.field_78624_D + this.renderBlocks.field_78635_I + aoLightValue) / 4.0f;
                this.ao[0] = (float)((double)aoMixed_XYZNPP * this.renderBlocks.field_83022_l * (1.0 - this.renderBlocks.field_83026_h) + (double)aoMixed_XYZPPP * this.renderBlocks.field_83022_l * this.renderBlocks.field_83026_h + (double)aoMixed_XYZPPN * (1.0 - this.renderBlocks.field_83022_l) * this.renderBlocks.field_83026_h + (double)aoMixed_XYZNPN * (1.0 - this.renderBlocks.field_83022_l) * (1.0 - this.renderBlocks.field_83026_h));
                this.ao[1] = (float)((double)aoMixed_XYZNPP * this.renderBlocks.field_83025_k * (1.0 - this.renderBlocks.field_83026_h) + (double)aoMixed_XYZPPP * this.renderBlocks.field_83025_k * this.renderBlocks.field_83026_h + (double)aoMixed_XYZPPN * (1.0 - this.renderBlocks.field_83025_k) * this.renderBlocks.field_83026_h + (double)aoMixed_XYZNPN * (1.0 - this.renderBlocks.field_83025_k) * (1.0 - this.renderBlocks.field_83026_h));
                this.ao[2] = (float)((double)aoMixed_XYZNPP * this.renderBlocks.field_83025_k * (1.0 - this.renderBlocks.field_83021_g) + (double)aoMixed_XYZPPP * this.renderBlocks.field_83025_k * this.renderBlocks.field_83021_g + (double)aoMixed_XYZPPN * (1.0 - this.renderBlocks.field_83025_k) * this.renderBlocks.field_83021_g + (double)aoMixed_XYZNPN * (1.0 - this.renderBlocks.field_83025_k) * (1.0 - this.renderBlocks.field_83021_g));
                this.ao[3] = (float)((double)aoMixed_XYZNPP * this.renderBlocks.field_83022_l * (1.0 - this.renderBlocks.field_83021_g) + (double)aoMixed_XYZPPP * this.renderBlocks.field_83022_l * this.renderBlocks.field_83021_g + (double)aoMixed_XYZPPN * (1.0 - this.renderBlocks.field_83022_l) * this.renderBlocks.field_83021_g + (double)aoMixed_XYZNPN * (1.0 - this.renderBlocks.field_83022_l) * (1.0 - this.renderBlocks.field_83021_g));
                this.renderBlocks.field_78700_an = this.renderBlocks.func_96444_a(brightnessMixed_XYZNPP, brightnessMixed_XYZPPP, brightnessMixed_XYZPPN, brightnessMixed_XYZNPN, this.renderBlocks.field_83022_l * (1.0 - this.renderBlocks.field_83026_h), this.renderBlocks.field_83022_l * this.renderBlocks.field_83026_h, (1.0 - this.renderBlocks.field_83022_l) * this.renderBlocks.field_83026_h, (1.0 - this.renderBlocks.field_83022_l) * (1.0 - this.renderBlocks.field_83026_h));
                this.renderBlocks.field_78694_ao = this.renderBlocks.func_96444_a(brightnessMixed_XYZNPP, brightnessMixed_XYZPPP, brightnessMixed_XYZPPN, brightnessMixed_XYZNPN, this.renderBlocks.field_83025_k * (1.0 - this.renderBlocks.field_83026_h), this.renderBlocks.field_83025_k * this.renderBlocks.field_83026_h, (1.0 - this.renderBlocks.field_83025_k) * this.renderBlocks.field_83026_h, (1.0 - this.renderBlocks.field_83025_k) * (1.0 - this.renderBlocks.field_83026_h));
                this.renderBlocks.field_78696_ap = this.renderBlocks.func_96444_a(brightnessMixed_XYZNPP, brightnessMixed_XYZPPP, brightnessMixed_XYZPPN, brightnessMixed_XYZNPN, this.renderBlocks.field_83025_k * (1.0 - this.renderBlocks.field_83021_g), this.renderBlocks.field_83025_k * this.renderBlocks.field_83021_g, (1.0 - this.renderBlocks.field_83025_k) * this.renderBlocks.field_83021_g, (1.0 - this.renderBlocks.field_83025_k) * (1.0 - this.renderBlocks.field_83021_g));
                this.renderBlocks.field_78676_aq = this.renderBlocks.func_96444_a(brightnessMixed_XYZNPP, brightnessMixed_XYZPPP, brightnessMixed_XYZPPN, brightnessMixed_XYZNPN, this.renderBlocks.field_83022_l * (1.0 - this.renderBlocks.field_83021_g), this.renderBlocks.field_83022_l * this.renderBlocks.field_83021_g, (1.0 - this.renderBlocks.field_83022_l) * this.renderBlocks.field_83021_g, (1.0 - this.renderBlocks.field_83022_l) * (1.0 - this.renderBlocks.field_83021_g));
            } else {
                this.ao[0] = (this.renderBlocks.field_78635_I + aoLightValue + this.renderBlocks.field_78636_J + this.renderBlocks.field_78634_H) / 4.0f;
                this.ao[1] = (aoLightValue + this.renderBlocks.field_78626_F + this.renderBlocks.field_78634_H + this.renderBlocks.field_78627_G) / 4.0f;
                this.ao[2] = (this.renderBlocks.field_78624_D + this.renderBlocks.field_78630_C + aoLightValue + this.renderBlocks.field_78626_F) / 4.0f;
                this.ao[3] = (this.renderBlocks.field_78625_E + this.renderBlocks.field_78624_D + this.renderBlocks.field_78635_I + aoLightValue) / 4.0f;
                this.renderBlocks.field_78700_an = brightnessMixed_XYZPPP;
                this.renderBlocks.field_78694_ao = brightnessMixed_XYZPPN;
                this.renderBlocks.field_78696_ap = brightnessMixed_XYZNPN;
                this.renderBlocks.field_78676_aq = brightnessMixed_XYZNPP;
            }
        }
        return this;
    }

    public LightingHelper setupLightingZNeg(ItemStack itemStack, int x, int y, int z) {
        int mixedBrightness;
        Block block = BlockProperties.toBlock(itemStack);
        int z_offset = this.renderBlocks.field_83025_k > 0.0 ? z : z - 1;
        this.brightness = mixedBrightness = block.func_71874_e(this.renderBlocks.field_78669_a, x, y, z_offset);
        if (this.renderBlocks.field_78677_m) {
            float ratio = (float)(1.0 - this.renderBlocks.field_83025_k);
            float aoLightValue = block.func_71888_h(this.renderBlocks.field_78669_a, x, y, z_offset);
            this.renderBlocks.field_78690_ai = block.func_71874_e(this.renderBlocks.field_78669_a, x - 1, y, z_offset);
            this.renderBlocks.field_78645_V = block.func_71874_e(this.renderBlocks.field_78669_a, x, y - 1, z_offset);
            this.renderBlocks.field_78703_ad = block.func_71874_e(this.renderBlocks.field_78669_a, x, y + 1, z_offset);
            this.renderBlocks.field_78692_aj = block.func_71874_e(this.renderBlocks.field_78669_a, x + 1, y, z_offset);
            this.renderBlocks.field_78649_S = block.func_71874_e(this.renderBlocks.field_78669_a, x - 1, y - 1, z_offset);
            this.renderBlocks.field_78704_aa = block.func_71874_e(this.renderBlocks.field_78669_a, x - 1, y + 1, z_offset);
            this.renderBlocks.field_78657_X = block.func_71874_e(this.renderBlocks.field_78669_a, x + 1, y - 1, z_offset);
            this.renderBlocks.field_78709_ae = block.func_71874_e(this.renderBlocks.field_78669_a, x + 1, y + 1, z_offset);
            this.renderBlocks.field_78637_K = LightingHelper.getMixedAo(block.func_71888_h(this.renderBlocks.field_78669_a, x - 1, y, z - 1), block.func_71888_h(this.renderBlocks.field_78669_a, x - 1, y, z), ratio);
            this.renderBlocks.field_78712_x = LightingHelper.getMixedAo(block.func_71888_h(this.renderBlocks.field_78669_a, x, y - 1, z - 1), block.func_71888_h(this.renderBlocks.field_78669_a, x, y - 1, z), ratio);
            this.renderBlocks.field_78626_F = LightingHelper.getMixedAo(block.func_71888_h(this.renderBlocks.field_78669_a, x, y + 1, z - 1), block.func_71888_h(this.renderBlocks.field_78669_a, x, y + 1, z), ratio);
            this.renderBlocks.field_78631_L = LightingHelper.getMixedAo(block.func_71888_h(this.renderBlocks.field_78669_a, x + 1, y, z - 1), block.func_71888_h(this.renderBlocks.field_78669_a, x + 1, y, z), ratio);
            this.renderBlocks.field_78691_u = LightingHelper.getMixedAo(block.func_71888_h(this.renderBlocks.field_78669_a, x - 1, y - 1, z - 1), block.func_71888_h(this.renderBlocks.field_78669_a, x - 1, y - 1, z), ratio);
            this.renderBlocks.field_78630_C = LightingHelper.getMixedAo(block.func_71888_h(this.renderBlocks.field_78669_a, x - 1, y + 1, z - 1), block.func_71888_h(this.renderBlocks.field_78669_a, x - 1, y + 1, z), ratio);
            this.renderBlocks.field_78708_z = LightingHelper.getMixedAo(block.func_71888_h(this.renderBlocks.field_78669_a, x + 1, y - 1, z - 1), block.func_71888_h(this.renderBlocks.field_78669_a, x + 1, y - 1, z), ratio);
            this.renderBlocks.field_78627_G = LightingHelper.getMixedAo(block.func_71888_h(this.renderBlocks.field_78669_a, x + 1, y + 1, z - 1), block.func_71888_h(this.renderBlocks.field_78669_a, x + 1, y + 1, z), ratio);
            int brightnessMixed_XYZPPN = this.renderBlocks.func_78602_a(this.renderBlocks.field_78703_ad, this.renderBlocks.field_78692_aj, this.renderBlocks.field_78709_ae, mixedBrightness);
            int brightnessMixed_XYZPNN = this.renderBlocks.func_78602_a(this.renderBlocks.field_78645_V, this.renderBlocks.field_78657_X, this.renderBlocks.field_78692_aj, mixedBrightness);
            int brightnessMixed_XYZNNN = this.renderBlocks.func_78602_a(this.renderBlocks.field_78649_S, this.renderBlocks.field_78690_ai, this.renderBlocks.field_78645_V, mixedBrightness);
            int brightnessMixed_XYZNPN = this.renderBlocks.func_78602_a(this.renderBlocks.field_78690_ai, this.renderBlocks.field_78704_aa, this.renderBlocks.field_78703_ad, mixedBrightness);
            if (this.renderBlocks.field_98189_n) {
                float aoMixed_XYZPPN = (aoLightValue + this.renderBlocks.field_78626_F + this.renderBlocks.field_78631_L + this.renderBlocks.field_78627_G) / 4.0f;
                float aoMixed_XYZPNN = (this.renderBlocks.field_78712_x + aoLightValue + this.renderBlocks.field_78708_z + this.renderBlocks.field_78631_L) / 4.0f;
                float aoMixed_XYZNNN = (this.renderBlocks.field_78691_u + this.renderBlocks.field_78637_K + this.renderBlocks.field_78712_x + aoLightValue) / 4.0f;
                float aoMixed_XYZNPN = (this.renderBlocks.field_78637_K + this.renderBlocks.field_78630_C + aoLightValue + this.renderBlocks.field_78626_F) / 4.0f;
                this.ao[0] = (float)((double)aoMixed_XYZNPN * this.renderBlocks.field_83024_j * (1.0 - this.renderBlocks.field_83026_h) + (double)aoMixed_XYZPPN * this.renderBlocks.field_83024_j * this.renderBlocks.field_83026_h + (double)aoMixed_XYZPNN * (1.0 - this.renderBlocks.field_83024_j) * this.renderBlocks.field_83026_h + (double)aoMixed_XYZNNN * (1.0 - this.renderBlocks.field_83024_j) * (1.0 - this.renderBlocks.field_83026_h));
                this.ao[1] = (float)((double)aoMixed_XYZNPN * this.renderBlocks.field_83027_i * (1.0 - this.renderBlocks.field_83026_h) + (double)aoMixed_XYZPPN * this.renderBlocks.field_83027_i * this.renderBlocks.field_83026_h + (double)aoMixed_XYZPNN * (1.0 - this.renderBlocks.field_83027_i) * this.renderBlocks.field_83026_h + (double)aoMixed_XYZNNN * (1.0 - this.renderBlocks.field_83027_i) * (1.0 - this.renderBlocks.field_83026_h));
                this.ao[2] = (float)((double)aoMixed_XYZNPN * this.renderBlocks.field_83027_i * (1.0 - this.renderBlocks.field_83021_g) + (double)aoMixed_XYZPPN * this.renderBlocks.field_83027_i * this.renderBlocks.field_83021_g + (double)aoMixed_XYZPNN * (1.0 - this.renderBlocks.field_83027_i) * this.renderBlocks.field_83021_g + (double)aoMixed_XYZNNN * (1.0 - this.renderBlocks.field_83027_i) * (1.0 - this.renderBlocks.field_83021_g));
                this.ao[3] = (float)((double)aoMixed_XYZNPN * this.renderBlocks.field_83024_j * (1.0 - this.renderBlocks.field_83021_g) + (double)aoMixed_XYZPPN * this.renderBlocks.field_83024_j * this.renderBlocks.field_83021_g + (double)aoMixed_XYZPNN * (1.0 - this.renderBlocks.field_83024_j) * this.renderBlocks.field_83021_g + (double)aoMixed_XYZNNN * (1.0 - this.renderBlocks.field_83024_j) * (1.0 - this.renderBlocks.field_83021_g));
                this.renderBlocks.field_78700_an = this.renderBlocks.func_96444_a(brightnessMixed_XYZNPN, brightnessMixed_XYZPPN, brightnessMixed_XYZPNN, brightnessMixed_XYZNNN, this.renderBlocks.field_83024_j * (1.0 - this.renderBlocks.field_83026_h), this.renderBlocks.field_83024_j * this.renderBlocks.field_83026_h, (1.0 - this.renderBlocks.field_83024_j) * this.renderBlocks.field_83026_h, (1.0 - this.renderBlocks.field_83024_j) * (1.0 - this.renderBlocks.field_83026_h));
                this.renderBlocks.field_78694_ao = this.renderBlocks.func_96444_a(brightnessMixed_XYZNPN, brightnessMixed_XYZPPN, brightnessMixed_XYZPNN, brightnessMixed_XYZNNN, this.renderBlocks.field_83027_i * (1.0 - this.renderBlocks.field_83026_h), this.renderBlocks.field_83027_i * this.renderBlocks.field_83026_h, (1.0 - this.renderBlocks.field_83027_i) * this.renderBlocks.field_83026_h, (1.0 - this.renderBlocks.field_83027_i) * (1.0 - this.renderBlocks.field_83026_h));
                this.renderBlocks.field_78696_ap = this.renderBlocks.func_96444_a(brightnessMixed_XYZNPN, brightnessMixed_XYZPPN, brightnessMixed_XYZPNN, brightnessMixed_XYZNNN, this.renderBlocks.field_83027_i * (1.0 - this.renderBlocks.field_83021_g), this.renderBlocks.field_83027_i * this.renderBlocks.field_83021_g, (1.0 - this.renderBlocks.field_83027_i) * this.renderBlocks.field_83021_g, (1.0 - this.renderBlocks.field_83027_i) * (1.0 - this.renderBlocks.field_83021_g));
                this.renderBlocks.field_78676_aq = this.renderBlocks.func_96444_a(brightnessMixed_XYZNPN, brightnessMixed_XYZPPN, brightnessMixed_XYZPNN, brightnessMixed_XYZNNN, this.renderBlocks.field_83024_j * (1.0 - this.renderBlocks.field_83021_g), this.renderBlocks.field_83024_j * this.renderBlocks.field_83021_g, (1.0 - this.renderBlocks.field_83024_j) * this.renderBlocks.field_83021_g, (1.0 - this.renderBlocks.field_83024_j) * (1.0 - this.renderBlocks.field_83021_g));
            } else {
                this.ao[0] = (aoLightValue + this.renderBlocks.field_78626_F + this.renderBlocks.field_78631_L + this.renderBlocks.field_78627_G) / 4.0f;
                this.ao[1] = (this.renderBlocks.field_78712_x + aoLightValue + this.renderBlocks.field_78708_z + this.renderBlocks.field_78631_L) / 4.0f;
                this.ao[2] = (this.renderBlocks.field_78691_u + this.renderBlocks.field_78637_K + this.renderBlocks.field_78712_x + aoLightValue) / 4.0f;
                this.ao[3] = (this.renderBlocks.field_78637_K + this.renderBlocks.field_78630_C + aoLightValue + this.renderBlocks.field_78626_F) / 4.0f;
                this.renderBlocks.field_78700_an = brightnessMixed_XYZPPN;
                this.renderBlocks.field_78694_ao = brightnessMixed_XYZPNN;
                this.renderBlocks.field_78696_ap = brightnessMixed_XYZNNN;
                this.renderBlocks.field_78676_aq = brightnessMixed_XYZNPN;
            }
        }
        return this;
    }

    public LightingHelper setupLightingZPos(ItemStack itemStack, int x, int y, int z) {
        int mixedBrightness;
        Block block = BlockProperties.toBlock(itemStack);
        int z_offset = this.renderBlocks.field_83022_l < 1.0 ? z : z + 1;
        this.brightness = mixedBrightness = block.func_71874_e(this.renderBlocks.field_78669_a, x, y, z_offset);
        if (this.renderBlocks.field_78677_m) {
            float aoLightValue = block.func_71888_h(this.renderBlocks.field_78669_a, x, y, z_offset);
            this.renderBlocks.field_78686_ak = block.func_71874_e(this.renderBlocks.field_78669_a, x - 1, y, z_offset);
            this.renderBlocks.field_78688_al = block.func_71874_e(this.renderBlocks.field_78669_a, x + 1, y, z_offset);
            this.renderBlocks.field_78643_W = block.func_71874_e(this.renderBlocks.field_78669_a, x, y - 1, z_offset);
            this.renderBlocks.field_78706_ag = block.func_71874_e(this.renderBlocks.field_78669_a, x, y + 1, z_offset);
            this.renderBlocks.field_78639_U = block.func_71874_e(this.renderBlocks.field_78669_a, x - 1, y - 1, z_offset);
            this.renderBlocks.field_78702_ac = block.func_71874_e(this.renderBlocks.field_78669_a, x - 1, y + 1, z_offset);
            this.renderBlocks.field_78660_Z = block.func_71874_e(this.renderBlocks.field_78669_a, x + 1, y - 1, z_offset);
            this.renderBlocks.field_78707_ah = block.func_71874_e(this.renderBlocks.field_78669_a, x + 1, y + 1, z_offset);
            this.renderBlocks.field_78632_M = LightingHelper.getMixedAo(block.func_71888_h(this.renderBlocks.field_78669_a, x - 1, y, z + 1), block.func_71888_h(this.renderBlocks.field_78669_a, x - 1, y, z), this.renderBlocks.field_83022_l);
            this.renderBlocks.field_78633_N = LightingHelper.getMixedAo(block.func_71888_h(this.renderBlocks.field_78669_a, x + 1, y, z + 1), block.func_71888_h(this.renderBlocks.field_78669_a, x + 1, y, z), this.renderBlocks.field_83022_l);
            this.renderBlocks.field_78710_y = LightingHelper.getMixedAo(block.func_71888_h(this.renderBlocks.field_78669_a, x, y - 1, z + 1), block.func_71888_h(this.renderBlocks.field_78669_a, x, y - 1, z), this.renderBlocks.field_83022_l);
            this.renderBlocks.field_78635_I = LightingHelper.getMixedAo(block.func_71888_h(this.renderBlocks.field_78669_a, x, y + 1, z + 1), block.func_71888_h(this.renderBlocks.field_78669_a, x, y + 1, z), this.renderBlocks.field_83022_l);
            this.renderBlocks.field_78687_w = LightingHelper.getMixedAo(block.func_71888_h(this.renderBlocks.field_78669_a, x - 1, y - 1, z + 1), block.func_71888_h(this.renderBlocks.field_78669_a, x - 1, y - 1, z), this.renderBlocks.field_83022_l);
            this.renderBlocks.field_78625_E = LightingHelper.getMixedAo(block.func_71888_h(this.renderBlocks.field_78669_a, x - 1, y + 1, z + 1), block.func_71888_h(this.renderBlocks.field_78669_a, x - 1, y + 1, z), this.renderBlocks.field_83022_l);
            this.renderBlocks.field_78629_B = LightingHelper.getMixedAo(block.func_71888_h(this.renderBlocks.field_78669_a, x + 1, y - 1, z + 1), block.func_71888_h(this.renderBlocks.field_78669_a, x + 1, y - 1, z), this.renderBlocks.field_83022_l);
            this.renderBlocks.field_78636_J = LightingHelper.getMixedAo(block.func_71888_h(this.renderBlocks.field_78669_a, x + 1, y + 1, z + 1), block.func_71888_h(this.renderBlocks.field_78669_a, x + 1, y + 1, z), this.renderBlocks.field_83022_l);
            int brightnessMixed_XYZNPP = this.renderBlocks.func_78602_a(this.renderBlocks.field_78686_ak, this.renderBlocks.field_78702_ac, this.renderBlocks.field_78706_ag, mixedBrightness);
            int brightnessMixed_XYZNNP = this.renderBlocks.func_78602_a(this.renderBlocks.field_78639_U, this.renderBlocks.field_78686_ak, this.renderBlocks.field_78643_W, mixedBrightness);
            int brightnessMixed_XYZPNP = this.renderBlocks.func_78602_a(this.renderBlocks.field_78643_W, this.renderBlocks.field_78660_Z, this.renderBlocks.field_78688_al, mixedBrightness);
            int brightnessMixed_XYZPPP = this.renderBlocks.func_78602_a(this.renderBlocks.field_78706_ag, this.renderBlocks.field_78688_al, this.renderBlocks.field_78707_ah, mixedBrightness);
            if (this.renderBlocks.field_98189_n) {
                float aoMixed_XYZNPP = (this.renderBlocks.field_78632_M + this.renderBlocks.field_78625_E + aoLightValue + this.renderBlocks.field_78635_I) / 4.0f;
                float aoMixed_XYZNNP = (this.renderBlocks.field_78687_w + this.renderBlocks.field_78632_M + this.renderBlocks.field_78710_y + aoLightValue) / 4.0f;
                float aoMixed_XYZPNP = (this.renderBlocks.field_78710_y + aoLightValue + this.renderBlocks.field_78629_B + this.renderBlocks.field_78633_N) / 4.0f;
                float aoMixed_XYZPPP = (aoLightValue + this.renderBlocks.field_78635_I + this.renderBlocks.field_78633_N + this.renderBlocks.field_78636_J) / 4.0f;
                this.ao[0] = (float)((double)aoMixed_XYZNPP * this.renderBlocks.field_83024_j * (1.0 - this.renderBlocks.field_83021_g) + (double)aoMixed_XYZPPP * this.renderBlocks.field_83024_j * this.renderBlocks.field_83021_g + (double)aoMixed_XYZPNP * (1.0 - this.renderBlocks.field_83024_j) * this.renderBlocks.field_83021_g + (double)aoMixed_XYZNNP * (1.0 - this.renderBlocks.field_83024_j) * (1.0 - this.renderBlocks.field_83021_g));
                this.ao[1] = (float)((double)aoMixed_XYZNPP * this.renderBlocks.field_83027_i * (1.0 - this.renderBlocks.field_83021_g) + (double)aoMixed_XYZPPP * this.renderBlocks.field_83027_i * this.renderBlocks.field_83021_g + (double)aoMixed_XYZPNP * (1.0 - this.renderBlocks.field_83027_i) * this.renderBlocks.field_83021_g + (double)aoMixed_XYZNNP * (1.0 - this.renderBlocks.field_83027_i) * (1.0 - this.renderBlocks.field_83021_g));
                this.ao[2] = (float)((double)aoMixed_XYZNPP * this.renderBlocks.field_83027_i * (1.0 - this.renderBlocks.field_83026_h) + (double)aoMixed_XYZPPP * this.renderBlocks.field_83027_i * this.renderBlocks.field_83026_h + (double)aoMixed_XYZPNP * (1.0 - this.renderBlocks.field_83027_i) * this.renderBlocks.field_83026_h + (double)aoMixed_XYZNNP * (1.0 - this.renderBlocks.field_83027_i) * (1.0 - this.renderBlocks.field_83026_h));
                this.ao[3] = (float)((double)aoMixed_XYZNPP * this.renderBlocks.field_83024_j * (1.0 - this.renderBlocks.field_83026_h) + (double)aoMixed_XYZPPP * this.renderBlocks.field_83024_j * this.renderBlocks.field_83026_h + (double)aoMixed_XYZPNP * (1.0 - this.renderBlocks.field_83024_j) * this.renderBlocks.field_83026_h + (double)aoMixed_XYZNNP * (1.0 - this.renderBlocks.field_83024_j) * (1.0 - this.renderBlocks.field_83026_h));
                this.renderBlocks.field_78700_an = this.renderBlocks.func_96444_a(brightnessMixed_XYZNPP, brightnessMixed_XYZNNP, brightnessMixed_XYZPNP, brightnessMixed_XYZPPP, this.renderBlocks.field_83024_j * (1.0 - this.renderBlocks.field_83021_g), (1.0 - this.renderBlocks.field_83024_j) * (1.0 - this.renderBlocks.field_83021_g), (1.0 - this.renderBlocks.field_83024_j) * this.renderBlocks.field_83021_g, this.renderBlocks.field_83024_j * this.renderBlocks.field_83021_g);
                this.renderBlocks.field_78694_ao = this.renderBlocks.func_96444_a(brightnessMixed_XYZNPP, brightnessMixed_XYZNNP, brightnessMixed_XYZPNP, brightnessMixed_XYZPPP, this.renderBlocks.field_83027_i * (1.0 - this.renderBlocks.field_83021_g), (1.0 - this.renderBlocks.field_83027_i) * (1.0 - this.renderBlocks.field_83021_g), (1.0 - this.renderBlocks.field_83027_i) * this.renderBlocks.field_83021_g, this.renderBlocks.field_83027_i * this.renderBlocks.field_83021_g);
                this.renderBlocks.field_78696_ap = this.renderBlocks.func_96444_a(brightnessMixed_XYZNPP, brightnessMixed_XYZNNP, brightnessMixed_XYZPNP, brightnessMixed_XYZPPP, this.renderBlocks.field_83027_i * (1.0 - this.renderBlocks.field_83026_h), (1.0 - this.renderBlocks.field_83027_i) * (1.0 - this.renderBlocks.field_83026_h), (1.0 - this.renderBlocks.field_83027_i) * this.renderBlocks.field_83026_h, this.renderBlocks.field_83027_i * this.renderBlocks.field_83026_h);
                this.renderBlocks.field_78676_aq = this.renderBlocks.func_96444_a(brightnessMixed_XYZNPP, brightnessMixed_XYZNNP, brightnessMixed_XYZPNP, brightnessMixed_XYZPPP, this.renderBlocks.field_83024_j * (1.0 - this.renderBlocks.field_83026_h), (1.0 - this.renderBlocks.field_83024_j) * (1.0 - this.renderBlocks.field_83026_h), (1.0 - this.renderBlocks.field_83024_j) * this.renderBlocks.field_83026_h, this.renderBlocks.field_83024_j * this.renderBlocks.field_83026_h);
            } else {
                this.ao[0] = (this.renderBlocks.field_78632_M + this.renderBlocks.field_78625_E + aoLightValue + this.renderBlocks.field_78635_I) / 4.0f;
                this.ao[1] = (this.renderBlocks.field_78687_w + this.renderBlocks.field_78632_M + this.renderBlocks.field_78710_y + aoLightValue) / 4.0f;
                this.ao[2] = (this.renderBlocks.field_78710_y + aoLightValue + this.renderBlocks.field_78629_B + this.renderBlocks.field_78633_N) / 4.0f;
                this.ao[3] = (aoLightValue + this.renderBlocks.field_78635_I + this.renderBlocks.field_78633_N + this.renderBlocks.field_78636_J) / 4.0f;
                this.renderBlocks.field_78700_an = brightnessMixed_XYZNPP;
                this.renderBlocks.field_78694_ao = brightnessMixed_XYZNNP;
                this.renderBlocks.field_78696_ap = brightnessMixed_XYZPNP;
                this.renderBlocks.field_78676_aq = brightnessMixed_XYZPPP;
            }
        }
        return this;
    }

    public LightingHelper setupLightingXNeg(ItemStack itemStack, int x, int y, int z) {
        int mixedBrightness;
        Block block = BlockProperties.toBlock(itemStack);
        int x_offset = this.renderBlocks.field_83021_g > 0.0 ? x : x - 1;
        this.brightness = mixedBrightness = block.func_71874_e(this.renderBlocks.field_78669_a, x_offset, y, z);
        if (this.renderBlocks.field_78677_m) {
            float ratio = (float)(1.0 - this.renderBlocks.field_83021_g);
            float aoLightValue = block.func_71888_h(this.renderBlocks.field_78669_a, x_offset, y, z);
            this.renderBlocks.field_78641_T = block.func_71874_e(this.renderBlocks.field_78669_a, x_offset, y - 1, z);
            this.renderBlocks.field_78690_ai = block.func_71874_e(this.renderBlocks.field_78669_a, x_offset, y, z - 1);
            this.renderBlocks.field_78686_ak = block.func_71874_e(this.renderBlocks.field_78669_a, x_offset, y, z + 1);
            this.renderBlocks.field_78705_ab = block.func_71874_e(this.renderBlocks.field_78669_a, x_offset, y + 1, z);
            this.renderBlocks.field_78649_S = block.func_71874_e(this.renderBlocks.field_78669_a, x_offset, y - 1, z - 1);
            this.renderBlocks.field_78639_U = block.func_71874_e(this.renderBlocks.field_78669_a, x_offset, y - 1, z + 1);
            this.renderBlocks.field_78704_aa = block.func_71874_e(this.renderBlocks.field_78669_a, x_offset, y + 1, z - 1);
            this.renderBlocks.field_78702_ac = block.func_71874_e(this.renderBlocks.field_78669_a, x_offset, y + 1, z + 1);
            this.renderBlocks.field_78689_v = LightingHelper.getMixedAo(block.func_71888_h(this.renderBlocks.field_78669_a, x - 1, y - 1, z), block.func_71888_h(this.renderBlocks.field_78669_a, x, y - 1, z), ratio);
            this.renderBlocks.field_78637_K = LightingHelper.getMixedAo(block.func_71888_h(this.renderBlocks.field_78669_a, x - 1, y, z - 1), block.func_71888_h(this.renderBlocks.field_78669_a, x, y, z - 1), ratio);
            this.renderBlocks.field_78632_M = LightingHelper.getMixedAo(block.func_71888_h(this.renderBlocks.field_78669_a, x - 1, y, z + 1), block.func_71888_h(this.renderBlocks.field_78669_a, x, y, z + 1), ratio);
            this.renderBlocks.field_78624_D = LightingHelper.getMixedAo(block.func_71888_h(this.renderBlocks.field_78669_a, x - 1, y + 1, z), block.func_71888_h(this.renderBlocks.field_78669_a, x, y + 1, z), ratio);
            this.renderBlocks.field_78691_u = LightingHelper.getMixedAo(block.func_71888_h(this.renderBlocks.field_78669_a, x - 1, y - 1, z - 1), block.func_71888_h(this.renderBlocks.field_78669_a, x, y - 1, z - 1), ratio);
            this.renderBlocks.field_78687_w = LightingHelper.getMixedAo(block.func_71888_h(this.renderBlocks.field_78669_a, x - 1, y - 1, z + 1), block.func_71888_h(this.renderBlocks.field_78669_a, x, y - 1, z + 1), ratio);
            this.renderBlocks.field_78630_C = LightingHelper.getMixedAo(block.func_71888_h(this.renderBlocks.field_78669_a, x - 1, y + 1, z - 1), block.func_71888_h(this.renderBlocks.field_78669_a, x, y + 1, z - 1), ratio);
            this.renderBlocks.field_78625_E = LightingHelper.getMixedAo(block.func_71888_h(this.renderBlocks.field_78669_a, x - 1, y + 1, z + 1), block.func_71888_h(this.renderBlocks.field_78669_a, x, y + 1, z + 1), ratio);
            int brightnessMixed_XYZNPN = this.renderBlocks.func_78602_a(this.renderBlocks.field_78690_ai, this.renderBlocks.field_78704_aa, this.renderBlocks.field_78705_ab, mixedBrightness);
            int brightnessMixed_XYZNNN = this.renderBlocks.func_78602_a(this.renderBlocks.field_78649_S, this.renderBlocks.field_78641_T, this.renderBlocks.field_78690_ai, mixedBrightness);
            int brightnessMixed_XYZNNP = this.renderBlocks.func_78602_a(this.renderBlocks.field_78641_T, this.renderBlocks.field_78639_U, this.renderBlocks.field_78686_ak, mixedBrightness);
            int brightnessMixed_XYZNPP = this.renderBlocks.func_78602_a(this.renderBlocks.field_78686_ak, this.renderBlocks.field_78705_ab, this.renderBlocks.field_78702_ac, mixedBrightness);
            if (this.renderBlocks.field_98189_n) {
                float aoMixed_XYZNPN = (this.renderBlocks.field_78637_K + aoLightValue + this.renderBlocks.field_78630_C + this.renderBlocks.field_78624_D) / 4.0f;
                float aoMixed_XYZNNN = (this.renderBlocks.field_78691_u + this.renderBlocks.field_78689_v + this.renderBlocks.field_78637_K + aoLightValue) / 4.0f;
                float aoMixed_XYZNNP = (this.renderBlocks.field_78689_v + this.renderBlocks.field_78687_w + aoLightValue + this.renderBlocks.field_78632_M) / 4.0f;
                float aoMixed_XYZNPP = (aoLightValue + this.renderBlocks.field_78632_M + this.renderBlocks.field_78624_D + this.renderBlocks.field_78625_E) / 4.0f;
                this.ao[0] = (float)((double)aoMixed_XYZNPP * this.renderBlocks.field_83024_j * this.renderBlocks.field_83025_k + (double)aoMixed_XYZNPN * this.renderBlocks.field_83024_j * (1.0 - this.renderBlocks.field_83025_k) + (double)aoMixed_XYZNNN * (1.0 - this.renderBlocks.field_83024_j) * (1.0 - this.renderBlocks.field_83025_k) + (double)aoMixed_XYZNNP * (1.0 - this.renderBlocks.field_83024_j) * this.renderBlocks.field_83025_k);
                this.ao[1] = (float)((double)aoMixed_XYZNPP * this.renderBlocks.field_83027_i * this.renderBlocks.field_83025_k + (double)aoMixed_XYZNPN * this.renderBlocks.field_83027_i * (1.0 - this.renderBlocks.field_83025_k) + (double)aoMixed_XYZNNN * (1.0 - this.renderBlocks.field_83027_i) * (1.0 - this.renderBlocks.field_83025_k) + (double)aoMixed_XYZNNP * (1.0 - this.renderBlocks.field_83027_i) * this.renderBlocks.field_83025_k);
                this.ao[2] = (float)((double)aoMixed_XYZNPP * this.renderBlocks.field_83027_i * this.renderBlocks.field_83022_l + (double)aoMixed_XYZNPN * this.renderBlocks.field_83027_i * (1.0 - this.renderBlocks.field_83022_l) + (double)aoMixed_XYZNNN * (1.0 - this.renderBlocks.field_83027_i) * (1.0 - this.renderBlocks.field_83022_l) + (double)aoMixed_XYZNNP * (1.0 - this.renderBlocks.field_83027_i) * this.renderBlocks.field_83022_l);
                this.ao[3] = (float)((double)aoMixed_XYZNPP * this.renderBlocks.field_83024_j * this.renderBlocks.field_83022_l + (double)aoMixed_XYZNPN * this.renderBlocks.field_83024_j * (1.0 - this.renderBlocks.field_83022_l) + (double)aoMixed_XYZNNN * (1.0 - this.renderBlocks.field_83024_j) * (1.0 - this.renderBlocks.field_83022_l) + (double)aoMixed_XYZNNP * (1.0 - this.renderBlocks.field_83024_j) * this.renderBlocks.field_83022_l);
                this.renderBlocks.field_78700_an = this.renderBlocks.func_96444_a(brightnessMixed_XYZNPP, brightnessMixed_XYZNPN, brightnessMixed_XYZNNN, brightnessMixed_XYZNNP, this.renderBlocks.field_83024_j * this.renderBlocks.field_83025_k, this.renderBlocks.field_83024_j * (1.0 - this.renderBlocks.field_83025_k), (1.0 - this.renderBlocks.field_83024_j) * (1.0 - this.renderBlocks.field_83025_k), (1.0 - this.renderBlocks.field_83024_j) * this.renderBlocks.field_83025_k);
                this.renderBlocks.field_78694_ao = this.renderBlocks.func_96444_a(brightnessMixed_XYZNPP, brightnessMixed_XYZNPN, brightnessMixed_XYZNNN, brightnessMixed_XYZNNP, this.renderBlocks.field_83027_i * this.renderBlocks.field_83025_k, this.renderBlocks.field_83027_i * (1.0 - this.renderBlocks.field_83025_k), (1.0 - this.renderBlocks.field_83027_i) * (1.0 - this.renderBlocks.field_83025_k), (1.0 - this.renderBlocks.field_83027_i) * this.renderBlocks.field_83025_k);
                this.renderBlocks.field_78696_ap = this.renderBlocks.func_96444_a(brightnessMixed_XYZNPP, brightnessMixed_XYZNPN, brightnessMixed_XYZNNN, brightnessMixed_XYZNNP, this.renderBlocks.field_83027_i * this.renderBlocks.field_83022_l, this.renderBlocks.field_83027_i * (1.0 - this.renderBlocks.field_83022_l), (1.0 - this.renderBlocks.field_83027_i) * (1.0 - this.renderBlocks.field_83022_l), (1.0 - this.renderBlocks.field_83027_i) * this.renderBlocks.field_83022_l);
                this.renderBlocks.field_78676_aq = this.renderBlocks.func_96444_a(brightnessMixed_XYZNPP, brightnessMixed_XYZNPN, brightnessMixed_XYZNNN, brightnessMixed_XYZNNP, this.renderBlocks.field_83024_j * this.renderBlocks.field_83022_l, this.renderBlocks.field_83024_j * (1.0 - this.renderBlocks.field_83022_l), (1.0 - this.renderBlocks.field_83024_j) * (1.0 - this.renderBlocks.field_83022_l), (1.0 - this.renderBlocks.field_83024_j) * this.renderBlocks.field_83022_l);
            } else {
                this.ao[0] = (this.renderBlocks.field_78637_K + aoLightValue + this.renderBlocks.field_78630_C + this.renderBlocks.field_78624_D) / 4.0f;
                this.ao[1] = (this.renderBlocks.field_78691_u + this.renderBlocks.field_78689_v + this.renderBlocks.field_78637_K + aoLightValue) / 4.0f;
                this.ao[2] = (this.renderBlocks.field_78689_v + this.renderBlocks.field_78687_w + aoLightValue + this.renderBlocks.field_78632_M) / 4.0f;
                this.ao[3] = (aoLightValue + this.renderBlocks.field_78632_M + this.renderBlocks.field_78624_D + this.renderBlocks.field_78625_E) / 4.0f;
                this.renderBlocks.field_78700_an = brightnessMixed_XYZNPN;
                this.renderBlocks.field_78694_ao = brightnessMixed_XYZNNN;
                this.renderBlocks.field_78696_ap = brightnessMixed_XYZNNP;
                this.renderBlocks.field_78676_aq = brightnessMixed_XYZNPP;
            }
        }
        return this;
    }

    public LightingHelper setupLightingXPos(ItemStack itemStack, int x, int y, int z) {
        int mixedBrightness;
        Block block = BlockProperties.toBlock(itemStack);
        int x_offset = this.renderBlocks.field_83026_h < 1.0 ? x : x + 1;
        this.brightness = mixedBrightness = block.func_71874_e(this.renderBlocks.field_78669_a, x_offset, y, z);
        if (this.renderBlocks.field_78677_m) {
            float aoLightValue = block.func_71888_h(this.renderBlocks.field_78669_a, x_offset, y, z);
            this.renderBlocks.field_78655_Y = block.func_71874_e(this.renderBlocks.field_78669_a, x_offset, y - 1, z);
            this.renderBlocks.field_78692_aj = block.func_71874_e(this.renderBlocks.field_78669_a, x_offset, y, z - 1);
            this.renderBlocks.field_78688_al = block.func_71874_e(this.renderBlocks.field_78669_a, x_offset, y, z + 1);
            this.renderBlocks.field_78711_af = block.func_71874_e(this.renderBlocks.field_78669_a, x_offset, y + 1, z);
            this.renderBlocks.field_78657_X = block.func_71874_e(this.renderBlocks.field_78669_a, x_offset, y - 1, z - 1);
            this.renderBlocks.field_78660_Z = block.func_71874_e(this.renderBlocks.field_78669_a, x_offset, y - 1, z + 1);
            this.renderBlocks.field_78709_ae = block.func_71874_e(this.renderBlocks.field_78669_a, x_offset, y + 1, z - 1);
            this.renderBlocks.field_78707_ah = block.func_71874_e(this.renderBlocks.field_78669_a, x_offset, y + 1, z + 1);
            this.renderBlocks.field_78628_A = LightingHelper.getMixedAo(block.func_71888_h(this.renderBlocks.field_78669_a, x + 1, y - 1, z), block.func_71888_h(this.renderBlocks.field_78669_a, x, y - 1, z), this.renderBlocks.field_83026_h);
            this.renderBlocks.field_78631_L = LightingHelper.getMixedAo(block.func_71888_h(this.renderBlocks.field_78669_a, x + 1, y, z - 1), block.func_71888_h(this.renderBlocks.field_78669_a, x, y, z - 1), this.renderBlocks.field_83026_h);
            this.renderBlocks.field_78633_N = LightingHelper.getMixedAo(block.func_71888_h(this.renderBlocks.field_78669_a, x + 1, y, z + 1), block.func_71888_h(this.renderBlocks.field_78669_a, x, y, z + 1), this.renderBlocks.field_83026_h);
            this.renderBlocks.field_78634_H = LightingHelper.getMixedAo(block.func_71888_h(this.renderBlocks.field_78669_a, x + 1, y + 1, z), block.func_71888_h(this.renderBlocks.field_78669_a, x, y + 1, z), this.renderBlocks.field_83026_h);
            this.renderBlocks.field_78708_z = LightingHelper.getMixedAo(block.func_71888_h(this.renderBlocks.field_78669_a, x + 1, y - 1, z - 1), block.func_71888_h(this.renderBlocks.field_78669_a, x, y - 1, z - 1), this.renderBlocks.field_83026_h);
            this.renderBlocks.field_78629_B = LightingHelper.getMixedAo(block.func_71888_h(this.renderBlocks.field_78669_a, x + 1, y - 1, z + 1), block.func_71888_h(this.renderBlocks.field_78669_a, x, y - 1, z + 1), this.renderBlocks.field_83026_h);
            this.renderBlocks.field_78627_G = LightingHelper.getMixedAo(block.func_71888_h(this.renderBlocks.field_78669_a, x + 1, y + 1, z - 1), block.func_71888_h(this.renderBlocks.field_78669_a, x, y + 1, z - 1), this.renderBlocks.field_83026_h);
            this.renderBlocks.field_78636_J = LightingHelper.getMixedAo(block.func_71888_h(this.renderBlocks.field_78669_a, x + 1, y + 1, z + 1), block.func_71888_h(this.renderBlocks.field_78669_a, x, y + 1, z + 1), this.renderBlocks.field_83026_h);
            int brightnessMixed_XYZPPP = this.renderBlocks.func_78602_a(this.renderBlocks.field_78688_al, this.renderBlocks.field_78711_af, this.renderBlocks.field_78707_ah, mixedBrightness);
            int brightnessMixed_XYZPNP = this.renderBlocks.func_78602_a(this.renderBlocks.field_78655_Y, this.renderBlocks.field_78660_Z, this.renderBlocks.field_78688_al, mixedBrightness);
            int brightnessMixed_XYZPNN = this.renderBlocks.func_78602_a(this.renderBlocks.field_78657_X, this.renderBlocks.field_78655_Y, this.renderBlocks.field_78692_aj, mixedBrightness);
            int brightnessMixed_XYZPPN = this.renderBlocks.func_78602_a(this.renderBlocks.field_78692_aj, this.renderBlocks.field_78709_ae, this.renderBlocks.field_78711_af, mixedBrightness);
            if (this.renderBlocks.field_98189_n) {
                float aoMixed_XYZPPP = (aoLightValue + this.renderBlocks.field_78633_N + this.renderBlocks.field_78634_H + this.renderBlocks.field_78636_J) / 4.0f;
                float aoMixed_XYZPNP = (this.renderBlocks.field_78628_A + this.renderBlocks.field_78629_B + aoLightValue + this.renderBlocks.field_78633_N) / 4.0f;
                float aoMixed_XYZPNN = (this.renderBlocks.field_78708_z + this.renderBlocks.field_78628_A + this.renderBlocks.field_78631_L + aoLightValue) / 4.0f;
                float aoMixed_XYZPPN = (this.renderBlocks.field_78631_L + aoLightValue + this.renderBlocks.field_78627_G + this.renderBlocks.field_78634_H) / 4.0f;
                this.ao[0] = (float)((double)aoMixed_XYZPNP * (1.0 - this.renderBlocks.field_83024_j) * this.renderBlocks.field_83022_l + (double)aoMixed_XYZPNN * (1.0 - this.renderBlocks.field_83024_j) * (1.0 - this.renderBlocks.field_83022_l) + (double)aoMixed_XYZPPN * this.renderBlocks.field_83024_j * (1.0 - this.renderBlocks.field_83022_l) + (double)aoMixed_XYZPPP * this.renderBlocks.field_83024_j * this.renderBlocks.field_83022_l);
                this.ao[1] = (float)((double)aoMixed_XYZPNP * (1.0 - this.renderBlocks.field_83027_i) * this.renderBlocks.field_83022_l + (double)aoMixed_XYZPNN * (1.0 - this.renderBlocks.field_83027_i) * (1.0 - this.renderBlocks.field_83022_l) + (double)aoMixed_XYZPPN * this.renderBlocks.field_83027_i * (1.0 - this.renderBlocks.field_83022_l) + (double)aoMixed_XYZPPP * this.renderBlocks.field_83027_i * this.renderBlocks.field_83022_l);
                this.ao[2] = (float)((double)aoMixed_XYZPNP * (1.0 - this.renderBlocks.field_83027_i) * this.renderBlocks.field_83025_k + (double)aoMixed_XYZPNN * (1.0 - this.renderBlocks.field_83027_i) * (1.0 - this.renderBlocks.field_83025_k) + (double)aoMixed_XYZPPN * this.renderBlocks.field_83027_i * (1.0 - this.renderBlocks.field_83025_k) + (double)aoMixed_XYZPPP * this.renderBlocks.field_83027_i * this.renderBlocks.field_83025_k);
                this.ao[3] = (float)((double)aoMixed_XYZPNP * (1.0 - this.renderBlocks.field_83024_j) * this.renderBlocks.field_83025_k + (double)aoMixed_XYZPNN * (1.0 - this.renderBlocks.field_83024_j) * (1.0 - this.renderBlocks.field_83025_k) + (double)aoMixed_XYZPPN * this.renderBlocks.field_83024_j * (1.0 - this.renderBlocks.field_83025_k) + (double)aoMixed_XYZPPP * this.renderBlocks.field_83024_j * this.renderBlocks.field_83025_k);
                this.renderBlocks.field_78700_an = this.renderBlocks.func_96444_a(brightnessMixed_XYZPNP, brightnessMixed_XYZPNN, brightnessMixed_XYZPPN, brightnessMixed_XYZPPP, (1.0 - this.renderBlocks.field_83024_j) * this.renderBlocks.field_83022_l, (1.0 - this.renderBlocks.field_83024_j) * (1.0 - this.renderBlocks.field_83022_l), this.renderBlocks.field_83024_j * (1.0 - this.renderBlocks.field_83022_l), this.renderBlocks.field_83024_j * this.renderBlocks.field_83022_l);
                this.renderBlocks.field_78694_ao = this.renderBlocks.func_96444_a(brightnessMixed_XYZPNP, brightnessMixed_XYZPNN, brightnessMixed_XYZPPN, brightnessMixed_XYZPPP, (1.0 - this.renderBlocks.field_83027_i) * this.renderBlocks.field_83022_l, (1.0 - this.renderBlocks.field_83027_i) * (1.0 - this.renderBlocks.field_83022_l), this.renderBlocks.field_83027_i * (1.0 - this.renderBlocks.field_83022_l), this.renderBlocks.field_83027_i * this.renderBlocks.field_83022_l);
                this.renderBlocks.field_78696_ap = this.renderBlocks.func_96444_a(brightnessMixed_XYZPNP, brightnessMixed_XYZPNN, brightnessMixed_XYZPPN, brightnessMixed_XYZPPP, (1.0 - this.renderBlocks.field_83027_i) * this.renderBlocks.field_83025_k, (1.0 - this.renderBlocks.field_83027_i) * (1.0 - this.renderBlocks.field_83025_k), this.renderBlocks.field_83027_i * (1.0 - this.renderBlocks.field_83025_k), this.renderBlocks.field_83027_i * this.renderBlocks.field_83025_k);
                this.renderBlocks.field_78676_aq = this.renderBlocks.func_96444_a(brightnessMixed_XYZPNP, brightnessMixed_XYZPNN, brightnessMixed_XYZPPN, brightnessMixed_XYZPPP, (1.0 - this.renderBlocks.field_83024_j) * this.renderBlocks.field_83025_k, (1.0 - this.renderBlocks.field_83024_j) * (1.0 - this.renderBlocks.field_83025_k), this.renderBlocks.field_83024_j * (1.0 - this.renderBlocks.field_83025_k), this.renderBlocks.field_83024_j * this.renderBlocks.field_83025_k);
            } else {
                this.ao[0] = (aoLightValue + this.renderBlocks.field_78633_N + this.renderBlocks.field_78634_H + this.renderBlocks.field_78636_J) / 4.0f;
                this.ao[1] = (this.renderBlocks.field_78628_A + this.renderBlocks.field_78629_B + aoLightValue + this.renderBlocks.field_78633_N) / 4.0f;
                this.ao[2] = (this.renderBlocks.field_78708_z + this.renderBlocks.field_78628_A + this.renderBlocks.field_78631_L + aoLightValue) / 4.0f;
                this.ao[3] = (this.renderBlocks.field_78631_L + aoLightValue + this.renderBlocks.field_78627_G + this.renderBlocks.field_78634_H) / 4.0f;
                this.renderBlocks.field_78700_an = brightnessMixed_XYZPPP;
                this.renderBlocks.field_78694_ao = brightnessMixed_XYZPNP;
                this.renderBlocks.field_78696_ap = brightnessMixed_XYZPNN;
                this.renderBlocks.field_78676_aq = brightnessMixed_XYZPPN;
            }
        }
        return this;
    }
}

