/*
 * Decompiled with CFR 0.152.
 */
package com.carpentersblocks.renderer.helper;

import com.carpentersblocks.data.Torch;
import com.carpentersblocks.tileentity.TEBase;
import com.carpentersblocks.tileentity.TECarpentersTorch;
import com.carpentersblocks.util.BlockProperties;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.minecraft.client.particle.EffectRenderer;
import net.minecraft.client.particle.EntityDiggingFX;
import net.minecraft.client.particle.EntityFX;
import net.minecraft.entity.Entity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.world.World;

@SideOnly(value=Side.CLIENT)
public class ParticleHelper {
    public static void spawnTorchBigSmoke(TECarpentersTorch TE) {
        double[] headCoords = Torch.getHeadCoordinates(TE);
        TE.func_70314_l().func_72869_a("largesmoke", headCoords[0], headCoords[1], headCoords[2], 0.0, 0.0, 0.0);
    }

    public static void spawnTileParticleAt(Entity entity, ItemStack itemStack) {
        BlockProperties.prepareItemStackForRendering(itemStack);
        entity.field_70170_p.func_72869_a("tilecrack_" + itemStack.field_77993_c + "_" + itemStack.func_77960_j(), entity.field_70165_t + ((double)entity.field_70170_p.field_73012_v.nextFloat() - 0.5) * (double)entity.field_70130_N, entity.field_70121_D.field_72338_b + 0.1, entity.field_70161_v + ((double)entity.field_70170_p.field_73012_v.nextFloat() - 0.5) * (double)entity.field_70130_N, -entity.field_70159_w * 4.0, 1.5, -entity.field_70179_y * 4.0);
    }

    public static void addDestroyEffect(World world, int x, int y, int z, ItemStack itemStack, EffectRenderer effectRenderer) {
        BlockProperties.prepareItemStackForRendering(itemStack);
        int factor = 4;
        for (int posX = 0; posX < factor; ++posX) {
            for (int posY = 0; posY < factor; ++posY) {
                for (int posZ = 0; posZ < factor; ++posZ) {
                    double dirX = (double)x + ((double)posX + 0.5) / (double)factor;
                    double dirY = (double)y + ((double)posY + 0.5) / (double)factor;
                    double dirZ = (double)z + ((double)posZ + 0.5) / (double)factor;
                    EntityDiggingFX particle = new EntityDiggingFX(world, dirX, dirY, dirZ, dirX - (double)x - 0.5, dirY - (double)y - 0.5, dirZ - (double)z - 0.5, BlockProperties.toBlock(itemStack), itemStack.func_77960_j());
                    effectRenderer.func_78873_a((EntityFX)particle.func_70596_a(x, y, z));
                }
            }
        }
    }

    public static void addHitEffect(TEBase TE, MovingObjectPosition target, double x, double y, double z, ItemStack itemStack, EffectRenderer effectRenderer) {
        BlockProperties.prepareItemStackForRendering(itemStack);
        EntityDiggingFX particle = new EntityDiggingFX(TE.func_70314_l(), x, y, z, 0.0, 0.0, 0.0, BlockProperties.toBlock(itemStack), itemStack.func_77960_j());
        effectRenderer.func_78873_a(particle.func_70596_a(target.field_72311_b, target.field_72312_c, target.field_72309_d).func_70543_e(0.2f).func_70541_f(0.6f));
    }
}

