/*
 * Decompiled with CFR 0.152.
 */
package com.carpentersblocks.renderer.helper;

import com.carpentersblocks.renderer.helper.VertexHelper;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.minecraft.block.BlockGrass;
import net.minecraft.client.renderer.RenderBlocks;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.util.Icon;
import net.minecraftforge.common.ForgeDirection;

@SideOnly(value=Side.CLIENT)
public class RenderHelper
extends VertexHelper {
    private static boolean rotationOverride = false;
    private static int rotation;
    private static double uMin;
    private static double uMax;
    private static double vMin;
    private static double vMax;
    protected static double xMin;
    protected static double xMax;
    protected static double yMin;
    protected static double yMax;
    protected static double zMin;
    protected static double zMax;
    protected static double uTL;
    protected static double vTL;
    protected static double uBL;
    protected static double vBL;
    protected static double uBR;
    protected static double vBR;
    protected static double uTR;
    protected static double vTR;
    public static double renderOffset;

    public static void setOffset(double offset) {
        renderOffset = offset;
    }

    public static void clearOffset() {
        renderOffset = 0.0;
    }

    public static void setTextureRotationOverride(int in_rotation) {
        rotationOverride = true;
        rotation = in_rotation;
    }

    public static void clearTextureRotationOverride() {
        rotationOverride = false;
    }

    public static void setBounds(double in_xMin, double in_yMin, double in_zMin, double in_xMax, double in_yMax, double in_zMax) {
        xMin = in_xMin;
        yMin = in_yMin;
        zMin = in_zMin;
        xMax = in_xMax;
        yMax = in_yMax;
        zMax = in_zMax;
    }

    public static void startDrawing(int drawMode) {
        Tessellator.field_78398_a.func_78381_a();
        Tessellator.field_78398_a.func_78371_b(drawMode);
    }

    private static void setCornerUV(double t_uTL, double t_vTL, double t_uBL, double t_vBL, double t_uBR, double t_vBR, double t_uTR, double t_vTR) {
        uTL = t_uTL;
        vTL = t_vTL;
        uBL = t_uBL;
        vBL = t_vBL;
        uBR = t_uBR;
        vBR = t_vBR;
        uTR = t_uTR;
        vTR = t_vTR;
    }

    protected static void prepareRender(RenderBlocks renderBlocks, ForgeDirection side, double x, double y, double z, Icon icon) {
        if (icon == BlockGrass.func_94434_o() || icon.func_94215_i().contains("overlay/overlay_") && icon.func_94215_i().endsWith("_side")) {
            RenderHelper.setFloatingIcon();
        }
        xMin = x + renderBlocks.field_83021_g - renderOffset;
        xMax = x + renderBlocks.field_83026_h + renderOffset;
        yMin = y + renderBlocks.field_83027_i - renderOffset;
        yMax = y + renderBlocks.field_83024_j + renderOffset;
        zMin = z + renderBlocks.field_83025_k - renderOffset;
        zMax = z + renderBlocks.field_83022_l + renderOffset;
        if (!rotationOverride) {
            switch (side) {
                case DOWN: {
                    rotation = renderBlocks.field_78675_l;
                    break;
                }
                case UP: {
                    rotation = renderBlocks.field_78681_k;
                    break;
                }
                case NORTH: {
                    rotation = renderBlocks.field_78679_j;
                    break;
                }
                case SOUTH: {
                    rotation = renderBlocks.field_78685_i;
                    break;
                }
                case WEST: {
                    rotation = renderBlocks.field_78683_h;
                    break;
                }
                case EAST: {
                    rotation = renderBlocks.field_78662_g;
                    break;
                }
            }
        }
        switch (side) {
            case DOWN: {
                switch (rotation) {
                    case 0: {
                        uMin = icon.func_94214_a(renderBlocks.field_83021_g * 16.0);
                        uMax = icon.func_94214_a(renderBlocks.field_83026_h * 16.0);
                        vMin = icon.func_94207_b(renderBlocks.field_83025_k * 16.0);
                        vMax = icon.func_94207_b(renderBlocks.field_83022_l * 16.0);
                        RenderHelper.setCornerUV(uMax, vMax, uMax, vMin, uMin, vMin, uMin, vMax);
                        break;
                    }
                    case 1: {
                        uMin = icon.func_94214_a(16.0 - renderBlocks.field_83022_l * 16.0);
                        uMax = icon.func_94214_a(16.0 - renderBlocks.field_83025_k * 16.0);
                        vMin = icon.func_94207_b(renderBlocks.field_83021_g * 16.0);
                        vMax = icon.func_94207_b(renderBlocks.field_83026_h * 16.0);
                        RenderHelper.setCornerUV(uMin, vMax, uMax, vMax, uMax, vMin, uMin, vMin);
                        break;
                    }
                    case 2: {
                        uMin = icon.func_94214_a(16.0 - renderBlocks.field_83021_g * 16.0);
                        uMax = icon.func_94214_a(16.0 - renderBlocks.field_83026_h * 16.0);
                        vMin = icon.func_94207_b(16.0 - renderBlocks.field_83025_k * 16.0);
                        vMax = icon.func_94207_b(16.0 - renderBlocks.field_83022_l * 16.0);
                        RenderHelper.setCornerUV(uMax, vMax, uMax, vMin, uMin, vMin, uMin, vMax);
                        break;
                    }
                    case 3: {
                        uMin = icon.func_94214_a(renderBlocks.field_83022_l * 16.0);
                        uMax = icon.func_94214_a(renderBlocks.field_83025_k * 16.0);
                        vMin = icon.func_94207_b(16.0 - renderBlocks.field_83021_g * 16.0);
                        vMax = icon.func_94207_b(16.0 - renderBlocks.field_83026_h * 16.0);
                        RenderHelper.setCornerUV(uMin, vMax, uMax, vMax, uMax, vMin, uMin, vMin);
                    }
                }
                break;
            }
            case UP: {
                switch (rotation) {
                    case 0: {
                        uMin = icon.func_94214_a(renderBlocks.field_83021_g * 16.0);
                        uMax = icon.func_94214_a(renderBlocks.field_83026_h * 16.0);
                        vMin = icon.func_94207_b(renderBlocks.field_83025_k * 16.0);
                        vMax = icon.func_94207_b(renderBlocks.field_83022_l * 16.0);
                        RenderHelper.setCornerUV(uMax, vMax, uMax, vMin, uMin, vMin, uMin, vMax);
                        break;
                    }
                    case 1: {
                        uMin = icon.func_94214_a(renderBlocks.field_83022_l * 16.0);
                        uMax = icon.func_94214_a(renderBlocks.field_83025_k * 16.0);
                        vMin = icon.func_94207_b(16.0 - renderBlocks.field_83021_g * 16.0);
                        vMax = icon.func_94207_b(16.0 - renderBlocks.field_83026_h * 16.0);
                        RenderHelper.setCornerUV(uMin, vMax, uMax, vMax, uMax, vMin, uMin, vMin);
                        break;
                    }
                    case 2: {
                        uMin = icon.func_94214_a(16.0 - renderBlocks.field_83021_g * 16.0);
                        uMax = icon.func_94214_a(16.0 - renderBlocks.field_83026_h * 16.0);
                        vMin = icon.func_94207_b(16.0 - renderBlocks.field_83025_k * 16.0);
                        vMax = icon.func_94207_b(16.0 - renderBlocks.field_83022_l * 16.0);
                        RenderHelper.setCornerUV(uMax, vMax, uMax, vMin, uMin, vMin, uMin, vMax);
                        break;
                    }
                    case 3: {
                        uMin = icon.func_94214_a(16.0 - renderBlocks.field_83022_l * 16.0);
                        uMax = icon.func_94214_a(16.0 - renderBlocks.field_83025_k * 16.0);
                        vMin = icon.func_94207_b(renderBlocks.field_83021_g * 16.0);
                        vMax = icon.func_94207_b(renderBlocks.field_83026_h * 16.0);
                        RenderHelper.setCornerUV(uMin, vMax, uMax, vMax, uMax, vMin, uMin, vMin);
                    }
                }
                break;
            }
            case NORTH: {
                switch (rotation) {
                    case 0: {
                        uMin = icon.func_94214_a(16.0 - renderBlocks.field_83026_h * 16.0);
                        uMax = icon.func_94214_a(16.0 - renderBlocks.field_83021_g * 16.0);
                        vMin = icon.func_94207_b(16.0 - (floatingIcon ? 1.0 - (renderBlocks.field_83024_j - renderBlocks.field_83027_i) : renderBlocks.field_83027_i) * 16.0);
                        vMax = icon.func_94207_b(16.0 - (floatingIcon ? 1.0 : renderBlocks.field_83024_j) * 16.0);
                        RenderHelper.setCornerUV(uMin, vMax, uMin, vMin, uMax, vMin, uMax, vMax);
                        break;
                    }
                    case 1: {
                        uMin = icon.func_94214_a(16.0 - renderBlocks.field_83024_j * 16.0);
                        uMax = icon.func_94214_a(16.0 - renderBlocks.field_83027_i * 16.0);
                        vMin = icon.func_94207_b(renderBlocks.field_83026_h * 16.0);
                        vMax = icon.func_94207_b(renderBlocks.field_83021_g * 16.0);
                        RenderHelper.setCornerUV(uMin, vMin, uMax, vMin, uMax, vMax, uMin, vMax);
                        break;
                    }
                    case 2: {
                        uMin = icon.func_94214_a(renderBlocks.field_83026_h * 16.0);
                        uMax = icon.func_94214_a(renderBlocks.field_83021_g * 16.0);
                        vMin = icon.func_94207_b(renderBlocks.field_83027_i * 16.0);
                        vMax = icon.func_94207_b(renderBlocks.field_83024_j * 16.0);
                        RenderHelper.setCornerUV(uMin, vMax, uMin, vMin, uMax, vMin, uMax, vMax);
                        break;
                    }
                    case 3: {
                        uMin = icon.func_94214_a(renderBlocks.field_83024_j * 16.0);
                        uMax = icon.func_94214_a(renderBlocks.field_83027_i * 16.0);
                        vMin = icon.func_94207_b(16.0 - renderBlocks.field_83026_h * 16.0);
                        vMax = icon.func_94207_b(16.0 - renderBlocks.field_83021_g * 16.0);
                        RenderHelper.setCornerUV(uMin, vMin, uMax, vMin, uMax, vMax, uMin, vMax);
                    }
                }
                break;
            }
            case SOUTH: {
                switch (rotation) {
                    case 0: {
                        uMin = icon.func_94214_a(renderBlocks.field_83021_g * 16.0);
                        uMax = icon.func_94214_a(renderBlocks.field_83026_h * 16.0);
                        vMin = icon.func_94207_b(16.0 - (floatingIcon ? 1.0 - (renderBlocks.field_83024_j - renderBlocks.field_83027_i) : renderBlocks.field_83027_i) * 16.0);
                        vMax = icon.func_94207_b(16.0 - (floatingIcon ? 1.0 : renderBlocks.field_83024_j) * 16.0);
                        RenderHelper.setCornerUV(uMin, vMax, uMin, vMin, uMax, vMin, uMax, vMax);
                        break;
                    }
                    case 1: {
                        uMin = icon.func_94214_a(16.0 - renderBlocks.field_83024_j * 16.0);
                        uMax = icon.func_94214_a(16.0 - renderBlocks.field_83027_i * 16.0);
                        vMin = icon.func_94207_b(16.0 - renderBlocks.field_83021_g * 16.0);
                        vMax = icon.func_94207_b(16.0 - renderBlocks.field_83026_h * 16.0);
                        RenderHelper.setCornerUV(uMin, vMin, uMax, vMin, uMax, vMax, uMin, vMax);
                        break;
                    }
                    case 2: {
                        uMin = icon.func_94214_a(16.0 - renderBlocks.field_83021_g * 16.0);
                        uMax = icon.func_94214_a(16.0 - renderBlocks.field_83026_h * 16.0);
                        vMin = icon.func_94207_b(renderBlocks.field_83027_i * 16.0);
                        vMax = icon.func_94207_b(renderBlocks.field_83024_j * 16.0);
                        RenderHelper.setCornerUV(uMin, vMax, uMin, vMin, uMax, vMin, uMax, vMax);
                        break;
                    }
                    case 3: {
                        uMin = icon.func_94214_a(renderBlocks.field_83024_j * 16.0);
                        uMax = icon.func_94214_a(renderBlocks.field_83027_i * 16.0);
                        vMin = icon.func_94207_b(renderBlocks.field_83021_g * 16.0);
                        vMax = icon.func_94207_b(renderBlocks.field_83026_h * 16.0);
                        RenderHelper.setCornerUV(uMin, vMin, uMax, vMin, uMax, vMax, uMin, vMax);
                    }
                }
                break;
            }
            case WEST: {
                switch (rotation) {
                    case 0: {
                        uMin = icon.func_94214_a(renderBlocks.field_83025_k * 16.0);
                        uMax = icon.func_94214_a(renderBlocks.field_83022_l * 16.0);
                        vMax = icon.func_94207_b(16.0 - (floatingIcon ? 1.0 : renderBlocks.field_83024_j) * 16.0);
                        vMin = icon.func_94207_b(16.0 - (floatingIcon ? 1.0 - (renderBlocks.field_83024_j - renderBlocks.field_83027_i) : renderBlocks.field_83027_i) * 16.0);
                        RenderHelper.setCornerUV(uMin, vMax, uMin, vMin, uMax, vMin, uMax, vMax);
                        break;
                    }
                    case 1: {
                        uMin = icon.func_94214_a(16.0 - renderBlocks.field_83024_j * 16.0);
                        uMax = icon.func_94214_a(16.0 - renderBlocks.field_83027_i * 16.0);
                        vMin = icon.func_94207_b(16.0 - renderBlocks.field_83025_k * 16.0);
                        vMax = icon.func_94207_b(16.0 - renderBlocks.field_83022_l * 16.0);
                        RenderHelper.setCornerUV(uMin, vMin, uMax, vMin, uMax, vMax, uMin, vMax);
                        break;
                    }
                    case 2: {
                        uMin = icon.func_94214_a(16.0 - renderBlocks.field_83025_k * 16.0);
                        uMax = icon.func_94214_a(16.0 - renderBlocks.field_83022_l * 16.0);
                        vMin = icon.func_94207_b(renderBlocks.field_83027_i * 16.0);
                        vMax = icon.func_94207_b(renderBlocks.field_83024_j * 16.0);
                        RenderHelper.setCornerUV(uMin, vMax, uMin, vMin, uMax, vMin, uMax, vMax);
                        break;
                    }
                    case 3: {
                        uMin = icon.func_94214_a(renderBlocks.field_83024_j * 16.0);
                        uMax = icon.func_94214_a(renderBlocks.field_83027_i * 16.0);
                        vMin = icon.func_94207_b(renderBlocks.field_83025_k * 16.0);
                        vMax = icon.func_94207_b(renderBlocks.field_83022_l * 16.0);
                        RenderHelper.setCornerUV(uMin, vMin, uMax, vMin, uMax, vMax, uMin, vMax);
                    }
                }
                break;
            }
            case EAST: {
                switch (rotation) {
                    case 0: {
                        uMin = icon.func_94214_a(16.0 - renderBlocks.field_83022_l * 16.0);
                        uMax = icon.func_94214_a(16.0 - renderBlocks.field_83025_k * 16.0);
                        vMax = icon.func_94207_b(16.0 - (floatingIcon ? 1.0 : renderBlocks.field_83024_j) * 16.0);
                        vMin = icon.func_94207_b(16.0 - (floatingIcon ? 1.0 - (renderBlocks.field_83024_j - renderBlocks.field_83027_i) : renderBlocks.field_83027_i) * 16.0);
                        RenderHelper.setCornerUV(uMin, vMax, uMin, vMin, uMax, vMin, uMax, vMax);
                        break;
                    }
                    case 1: {
                        uMin = icon.func_94214_a(16.0 - renderBlocks.field_83024_j * 16.0);
                        uMax = icon.func_94214_a(16.0 - renderBlocks.field_83027_i * 16.0);
                        vMin = icon.func_94207_b(renderBlocks.field_83022_l * 16.0);
                        vMax = icon.func_94207_b(renderBlocks.field_83025_k * 16.0);
                        RenderHelper.setCornerUV(uMin, vMin, uMax, vMin, uMax, vMax, uMin, vMax);
                        break;
                    }
                    case 2: {
                        uMin = icon.func_94214_a(renderBlocks.field_83022_l * 16.0);
                        uMax = icon.func_94214_a(renderBlocks.field_83025_k * 16.0);
                        vMin = icon.func_94207_b(renderBlocks.field_83027_i * 16.0);
                        vMax = icon.func_94207_b(renderBlocks.field_83024_j * 16.0);
                        RenderHelper.setCornerUV(uMin, vMax, uMin, vMin, uMax, vMin, uMax, vMax);
                        break;
                    }
                    case 3: {
                        uMin = icon.func_94214_a(renderBlocks.field_83024_j * 16.0);
                        uMax = icon.func_94214_a(renderBlocks.field_83027_i * 16.0);
                        vMin = icon.func_94207_b(16.0 - renderBlocks.field_83022_l * 16.0);
                        vMax = icon.func_94207_b(16.0 - renderBlocks.field_83025_k * 16.0);
                        RenderHelper.setCornerUV(uMin, vMin, uMax, vMin, uMax, vMax, uMin, vMax);
                    }
                }
                break;
            }
        }
    }

    public static void renderFaceYNeg(RenderBlocks renderBlocks, double x, double y, double z, Icon icon) {
        RenderHelper.prepareRender(renderBlocks, ForgeDirection.DOWN, x, y, z, icon);
        RenderHelper.setupVertex(renderBlocks, xMin, yMin, zMax, uTR, vTR, 3);
        RenderHelper.setupVertex(renderBlocks, xMin, yMin, zMin, uBR, vBR, 2);
        RenderHelper.setupVertex(renderBlocks, xMax, yMin, zMin, uBL, vBL, 1);
        RenderHelper.setupVertex(renderBlocks, xMax, yMin, zMax, uTL, vTL, 0);
    }

    public static void renderFaceYPos(RenderBlocks renderBlocks, double x, double y, double z, Icon icon) {
        RenderHelper.prepareRender(renderBlocks, ForgeDirection.UP, x, y, z, icon);
        RenderHelper.setupVertex(renderBlocks, xMax, yMax, zMax, uTL, vTL, 0);
        RenderHelper.setupVertex(renderBlocks, xMax, yMax, zMin, uBL, vBL, 1);
        RenderHelper.setupVertex(renderBlocks, xMin, yMax, zMin, uBR, vBR, 2);
        RenderHelper.setupVertex(renderBlocks, xMin, yMax, zMax, uTR, vTR, 3);
    }

    public static void renderFaceZNeg(RenderBlocks renderBlocks, double x, double y, double z, Icon icon) {
        RenderHelper.prepareRender(renderBlocks, ForgeDirection.NORTH, x, y, z, icon);
        RenderHelper.setupVertex(renderBlocks, xMax, yMax, zMin, uTL, vTL, 0);
        RenderHelper.setupVertex(renderBlocks, xMax, yMin, zMin, uBL, vBL, 1);
        RenderHelper.setupVertex(renderBlocks, xMin, yMin, zMin, uBR, vBR, 2);
        RenderHelper.setupVertex(renderBlocks, xMin, yMax, zMin, uTR, vTR, 3);
    }

    public static void renderFaceZPos(RenderBlocks renderBlocks, double x, double y, double z, Icon icon) {
        RenderHelper.prepareRender(renderBlocks, ForgeDirection.SOUTH, x, y, z, icon);
        RenderHelper.setupVertex(renderBlocks, xMin, yMax, zMax, uTL, vTL, 0);
        RenderHelper.setupVertex(renderBlocks, xMin, yMin, zMax, uBL, vBL, 1);
        RenderHelper.setupVertex(renderBlocks, xMax, yMin, zMax, uBR, vBR, 2);
        RenderHelper.setupVertex(renderBlocks, xMax, yMax, zMax, uTR, vTR, 3);
    }

    public static void renderFaceXNeg(RenderBlocks renderBlocks, double x, double y, double z, Icon icon) {
        RenderHelper.prepareRender(renderBlocks, ForgeDirection.WEST, x, y, z, icon);
        RenderHelper.setupVertex(renderBlocks, xMin, yMax, zMin, uTL, vTL, 0);
        RenderHelper.setupVertex(renderBlocks, xMin, yMin, zMin, uBL, vBL, 1);
        RenderHelper.setupVertex(renderBlocks, xMin, yMin, zMax, uBR, vBR, 2);
        RenderHelper.setupVertex(renderBlocks, xMin, yMax, zMax, uTR, vTR, 3);
    }

    public static void renderFaceXPos(RenderBlocks renderBlocks, double x, double y, double z, Icon icon) {
        RenderHelper.prepareRender(renderBlocks, ForgeDirection.EAST, x, y, z, icon);
        RenderHelper.setupVertex(renderBlocks, xMax, yMax, zMax, uTL, vTL, 0);
        RenderHelper.setupVertex(renderBlocks, xMax, yMin, zMax, uBL, vBL, 1);
        RenderHelper.setupVertex(renderBlocks, xMax, yMin, zMin, uBR, vBR, 2);
        RenderHelper.setupVertex(renderBlocks, xMax, yMax, zMin, uTR, vTR, 3);
    }
}

