/*
 * Decompiled with CFR 0.152.
 */
package com.carpentersblocks.renderer.helper;

import com.carpentersblocks.data.FlowerPot;
import com.carpentersblocks.renderer.BlockHandlerBase;
import com.carpentersblocks.renderer.helper.LightingHelper;
import com.carpentersblocks.renderer.helper.RenderHelper;
import com.carpentersblocks.util.BlockProperties;
import com.carpentersblocks.util.flowerpot.FlowerPotProperties;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.RenderBlocks;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.item.ItemStack;
import net.minecraft.util.Icon;

@SideOnly(value=Side.CLIENT)
public class RenderHelperFlowerPot
extends RenderHelper {
    public static void setPlantColor(BlockHandlerBase blockHandler, ItemStack itemStack, int x, int y, int z) {
        Block block = FlowerPotProperties.toBlock(itemStack);
        Tessellator tessellator = Tessellator.field_78398_a;
        float[] rgb = LightingHelper.getRGB(blockHandler.getBlockColor(block, itemStack.func_77960_j(), x, y, z, 1, null));
        blockHandler.lightingHelper.applyAnaglyph(rgb);
        tessellator.func_78386_a(rgb[0], rgb[1], rgb[2]);
        if (FlowerPot.isEnriched(blockHandler.TE) && FlowerPotProperties.getPlantColor(blockHandler.TE) != 0xFFFFFF) {
            tessellator.func_78386_a(0.45f, 0.8f, 0.3f);
        }
    }

    public static boolean renderPlantCrossedSquares(RenderBlocks renderBlocks, Block block, Icon icon, int x, int y, int z, float scale, boolean flip_vertical) {
        Tessellator tessellator = Tessellator.field_78398_a;
        tessellator.func_78380_c(block.func_71874_e(renderBlocks.field_78669_a, x, y, z));
        double uMin = icon.func_94209_e();
        double vMin = icon.func_94206_g();
        double uMax = icon.func_94212_f();
        double vMax = icon.func_94210_h();
        double rotation = 0.45 * (double)scale;
        double xMin = (double)x + 0.5 - rotation;
        double xMax = (double)x + 0.5 + rotation;
        double zMin = (double)z + 0.5 - rotation;
        double zMax = (double)z + 0.5 + rotation;
        if (flip_vertical) {
            double temp = vMin;
            vMin = vMax;
            vMax = temp;
        }
        tessellator.func_78374_a(xMin, (double)y + (double)scale, zMin, uMin, vMin);
        tessellator.func_78374_a(xMin, (double)y + 0.0, zMin, uMin, vMax);
        tessellator.func_78374_a(xMax, (double)y + 0.0, zMax, uMax, vMax);
        tessellator.func_78374_a(xMax, (double)y + (double)scale, zMax, uMax, vMin);
        tessellator.func_78374_a(xMax, (double)y + (double)scale, zMax, uMin, vMin);
        tessellator.func_78374_a(xMax, (double)y + 0.0, zMax, uMin, vMax);
        tessellator.func_78374_a(xMin, (double)y + 0.0, zMin, uMax, vMax);
        tessellator.func_78374_a(xMin, (double)y + (double)scale, zMin, uMax, vMin);
        tessellator.func_78374_a(xMin, (double)y + (double)scale, zMax, uMin, vMin);
        tessellator.func_78374_a(xMin, (double)y + 0.0, zMax, uMin, vMax);
        tessellator.func_78374_a(xMax, (double)y + 0.0, zMin, uMax, vMax);
        tessellator.func_78374_a(xMax, (double)y + (double)scale, zMin, uMax, vMin);
        tessellator.func_78374_a(xMax, (double)y + (double)scale, zMin, uMin, vMin);
        tessellator.func_78374_a(xMax, (double)y + 0.0, zMin, uMin, vMax);
        tessellator.func_78374_a(xMin, (double)y + 0.0, zMax, uMax, vMax);
        tessellator.func_78374_a(xMin, (double)y + (double)scale, zMax, uMax, vMin);
        return true;
    }

    public static void renderPlantThinCrossedSquares(RenderBlocks renderBlocks, Block block, Icon icon, int x, int y, int z, boolean flip_vertical) {
        Tessellator tessellator = Tessellator.field_78398_a;
        tessellator.func_78380_c(block.func_71874_e(renderBlocks.field_78669_a, x, y, z));
        double uMin = icon.func_94214_a(0.0);
        double uMax = icon.func_94214_a(4.0);
        double vMin = icon.func_94207_b(16.0);
        double vMax = icon.func_94207_b(0.0);
        double rotatedScaleFactor = 0.16875;
        double xMin = (double)x + 0.5 - rotatedScaleFactor;
        double xMax = (double)x + 0.5 + rotatedScaleFactor;
        double zMin = (double)z + 0.5 - rotatedScaleFactor;
        double zMax = (double)z + 0.5 + rotatedScaleFactor;
        if (flip_vertical) {
            double temp = vMin;
            vMin = vMax;
            vMax = temp;
        }
        tessellator.func_78374_a(xMin, (double)y + 0.75, zMin, uMin, vMax);
        tessellator.func_78374_a(xMin, (double)y + 0.0, zMin, uMin, vMin);
        tessellator.func_78374_a((double)x + 0.5, (double)y + 0.0, (double)z + 0.5, uMax, vMin);
        tessellator.func_78374_a((double)x + 0.5, (double)y + 0.75, (double)z + 0.5, uMax, vMax);
        tessellator.func_78374_a(xMax, (double)y + 0.75, zMin, uMin, vMax);
        tessellator.func_78374_a(xMax, (double)y + 0.0, zMin, uMin, vMin);
        tessellator.func_78374_a((double)x + 0.5, (double)y + 0.0, (double)z + 0.5, uMax, vMin);
        tessellator.func_78374_a((double)x + 0.5, (double)y + 0.75, (double)z + 0.5, uMax, vMax);
        tessellator.func_78374_a(xMax, (double)y + 0.75, zMax, uMin, vMax);
        tessellator.func_78374_a(xMax, (double)y + 0.0, zMax, uMin, vMin);
        tessellator.func_78374_a((double)x + 0.5, (double)y + 0.0, (double)z + 0.5, uMax, vMin);
        tessellator.func_78374_a((double)x + 0.5, (double)y + 0.75, (double)z + 0.5, uMax, vMax);
        tessellator.func_78374_a(xMin, (double)y + 0.75, zMax, uMin, vMax);
        tessellator.func_78374_a(xMin, (double)y + 0.0, zMax, uMin, vMin);
        tessellator.func_78374_a((double)x + 0.5, (double)y + 0.0, (double)z + 0.5, uMax, vMin);
        tessellator.func_78374_a((double)x + 0.5, (double)y + 0.75, (double)z + 0.5, uMax, vMax);
        uMin = icon.func_94214_a(12.0);
        uMax = icon.func_94214_a(16.0);
        tessellator.func_78374_a((double)x + 0.5, (double)y + 0.75, (double)z + 0.5, uMin, vMax);
        tessellator.func_78374_a((double)x + 0.5, (double)y + 0.0, (double)z + 0.5, uMin, vMin);
        tessellator.func_78374_a(xMin, (double)y + 0.0, zMin, uMax, vMin);
        tessellator.func_78374_a(xMin, (double)y + 0.75, zMin, uMax, vMax);
        tessellator.func_78374_a((double)x + 0.5, (double)y + 0.75, (double)z + 0.5, uMin, vMax);
        tessellator.func_78374_a((double)x + 0.5, (double)y + 0.0, (double)z + 0.5, uMin, vMin);
        tessellator.func_78374_a(xMax, (double)y + 0.0, zMin, uMax, vMin);
        tessellator.func_78374_a(xMax, (double)y + 0.75, zMin, uMax, vMax);
        tessellator.func_78374_a((double)x + 0.5, (double)y + 0.75, (double)z + 0.5, uMin, vMax);
        tessellator.func_78374_a((double)x + 0.5, (double)y + 0.0, (double)z + 0.5, uMin, vMin);
        tessellator.func_78374_a(xMax, (double)y + 0.0, zMax, uMax, vMin);
        tessellator.func_78374_a(xMax, (double)y + 0.75, zMax, uMax, vMax);
        tessellator.func_78374_a((double)x + 0.5, (double)y + 0.75, (double)z + 0.5, uMin, vMax);
        tessellator.func_78374_a((double)x + 0.5, (double)y + 0.0, (double)z + 0.5, uMin, vMin);
        tessellator.func_78374_a(xMin, (double)y + 0.0, zMax, uMax, vMin);
        tessellator.func_78374_a(xMin, (double)y + 0.75, zMax, uMax, vMax);
    }

    public static void drawPlantCactus(LightingHelper lightingHelper, RenderBlocks renderBlocks, ItemStack itemStack, int x, int y, int z) {
        Block block = BlockProperties.toBlock(itemStack);
        Icon icon = block.func_71851_a(2);
        double uMinL = icon.func_94214_a(0.0);
        double uMaxL = icon.func_94214_a(3.0);
        double uMinR = icon.func_94214_a(13.0);
        double uMaxR = icon.func_94214_a(16.0);
        double vMin = icon.func_94207_b(16.0);
        double vMax = icon.func_94207_b(0.0);
        renderBlocks.field_78677_m = true;
        renderBlocks.func_83020_a(0.375, 0.25, 0.375, 0.6875, 1.0, 0.6875);
        lightingHelper.setupLightingZNeg(itemStack, x, y, z);
        lightingHelper.setupColor(x, y, z, 2, 0xFFFFFF, icon);
        RenderHelperFlowerPot.setupVertex(renderBlocks, (float)x + 0.6875f, (float)y + 0.75f, (float)z + 0.375f, uMinL, vMax, 0);
        RenderHelperFlowerPot.setupVertex(renderBlocks, (float)x + 0.6875f, y, (float)z + 0.375f, uMinL, vMin, 1);
        RenderHelperFlowerPot.setupVertex(renderBlocks, (float)x + 0.5f, y, (float)z + 0.375f, uMaxL, vMin, 5);
        RenderHelperFlowerPot.setupVertex(renderBlocks, (float)x + 0.5f, (float)y + 0.75f, (float)z + 0.375f, uMaxL, vMax, 4);
        RenderHelperFlowerPot.setupVertex(renderBlocks, (float)x + 0.5f, (float)y + 0.75f, (float)z + 0.375f, uMinR, vMax, 4);
        RenderHelperFlowerPot.setupVertex(renderBlocks, (float)x + 0.5f, y, (float)z + 0.375f, uMinR, vMin, 5);
        RenderHelperFlowerPot.setupVertex(renderBlocks, (float)x + 0.3125f, y, (float)z + 0.375f, uMaxR, vMin, 2);
        RenderHelperFlowerPot.setupVertex(renderBlocks, (float)x + 0.3125f, (float)y + 0.75f, (float)z + 0.375f, uMaxR, vMax, 3);
        lightingHelper.setupLightingZPos(itemStack, x, y, z);
        lightingHelper.setupColor(x, y, z, 3, 0xFFFFFF, icon);
        RenderHelperFlowerPot.setupVertex(renderBlocks, (float)x + 0.3125f, (float)y + 0.75f, (float)z + 0.625f, uMinL, vMax, 0);
        RenderHelperFlowerPot.setupVertex(renderBlocks, (float)x + 0.3125f, y, (float)z + 0.625f, uMinL, vMin, 1);
        RenderHelperFlowerPot.setupVertex(renderBlocks, (float)x + 0.5f, y, (float)z + 0.625f, uMaxL, vMin, 5);
        RenderHelperFlowerPot.setupVertex(renderBlocks, (float)x + 0.5f, (float)y + 0.75f, (float)z + 0.625f, uMaxL, vMax, 4);
        RenderHelperFlowerPot.setupVertex(renderBlocks, (float)x + 0.5f, (float)y + 0.75f, (float)z + 0.625f, uMinR, vMax, 4);
        RenderHelperFlowerPot.setupVertex(renderBlocks, (float)x + 0.5f, y, (float)z + 0.625f, uMinR, vMin, 5);
        RenderHelperFlowerPot.setupVertex(renderBlocks, (float)x + 0.6875f, y, (float)z + 0.625f, uMaxR, vMin, 2);
        RenderHelperFlowerPot.setupVertex(renderBlocks, (float)x + 0.6875f, (float)y + 0.75f, (float)z + 0.625f, uMaxR, vMax, 3);
        lightingHelper.setupLightingXNeg(itemStack, x, y, z);
        lightingHelper.setupColor(x, y, z, 4, 0xFFFFFF, icon);
        RenderHelperFlowerPot.setupVertex(renderBlocks, (float)x + 0.375f, (float)y + 0.75f, (float)z + 0.3125f, uMinL, vMax, 0);
        RenderHelperFlowerPot.setupVertex(renderBlocks, (float)x + 0.375f, y, (float)z + 0.3125f, uMinL, vMin, 1);
        RenderHelperFlowerPot.setupVertex(renderBlocks, (float)x + 0.375f, y, (float)z + 0.5f, uMaxL, vMin, 5);
        RenderHelperFlowerPot.setupVertex(renderBlocks, (float)x + 0.375f, (float)y + 0.75f, (float)z + 0.5f, uMaxL, vMax, 4);
        RenderHelperFlowerPot.setupVertex(renderBlocks, (float)x + 0.375f, (float)y + 0.75f, (float)z + 0.5f, uMinR, vMax, 4);
        RenderHelperFlowerPot.setupVertex(renderBlocks, (float)x + 0.375f, y, (float)z + 0.5f, uMinR, vMin, 5);
        RenderHelperFlowerPot.setupVertex(renderBlocks, (float)x + 0.375f, y, (float)z + 0.6875f, uMaxR, vMin, 2);
        RenderHelperFlowerPot.setupVertex(renderBlocks, (float)x + 0.375f, (float)y + 0.75f, (float)z + 0.6875f, uMaxR, vMax, 3);
        lightingHelper.setupLightingXPos(itemStack, x, y, z);
        lightingHelper.setupColor(x, y, z, 5, 0xFFFFFF, icon);
        RenderHelperFlowerPot.setupVertex(renderBlocks, (float)x + 0.625f, (float)y + 0.75f, (float)z + 0.6875f, uMinL, vMax, 0);
        RenderHelperFlowerPot.setupVertex(renderBlocks, (float)x + 0.625f, y, (float)z + 0.6875f, uMinL, vMin, 1);
        RenderHelperFlowerPot.setupVertex(renderBlocks, (float)x + 0.625f, y, (float)z + 0.5f, uMaxL, vMin, 5);
        RenderHelperFlowerPot.setupVertex(renderBlocks, (float)x + 0.625f, (float)y + 0.75f, (float)z + 0.5f, uMaxL, vMax, 4);
        RenderHelperFlowerPot.setupVertex(renderBlocks, (float)x + 0.625f, (float)y + 0.75f, (float)z + 0.5f, uMinR, vMax, 4);
        RenderHelperFlowerPot.setupVertex(renderBlocks, (float)x + 0.625f, y, (float)z + 0.5f, uMinR, vMin, 5);
        RenderHelperFlowerPot.setupVertex(renderBlocks, (float)x + 0.625f, y, (float)z + 0.3125f, uMaxR, vMin, 2);
        RenderHelperFlowerPot.setupVertex(renderBlocks, (float)x + 0.625f, (float)y + 0.75f, (float)z + 0.3125f, uMaxR, vMax, 3);
        lightingHelper.setupLightingYPos(itemStack, x, y, z);
        lightingHelper.setupColor(x, y, z, 1, 0xFFFFFF, icon);
        icon = block.func_71851_a(1);
        double uMin = icon.func_94214_a(6.0);
        double uMax = icon.func_94214_a(10.0);
        vMin = icon.func_94207_b(10.0);
        vMax = icon.func_94207_b(6.0);
        RenderHelperFlowerPot.setupVertex(renderBlocks, (float)x + 0.375f, (float)y + 0.75f, (float)z + 0.625f, uMin, vMin, 0);
        RenderHelperFlowerPot.setupVertex(renderBlocks, (float)x + 0.625f, (float)y + 0.75f, (float)z + 0.625f, uMin, vMax, 1);
        RenderHelperFlowerPot.setupVertex(renderBlocks, (float)x + 0.625f, (float)y + 0.75f, (float)z + 0.375f, uMax, vMax, 2);
        RenderHelperFlowerPot.setupVertex(renderBlocks, (float)x + 0.375f, (float)y + 0.75f, (float)z + 0.375f, uMax, vMin, 3);
        renderBlocks.field_78677_m = false;
    }
}

