/*
 * Decompiled with CFR 0.152.
 */
package com.carpentersblocks.tileentity;

import com.carpentersblocks.tileentity.TEBase;
import com.carpentersblocks.tileentity.TECarpentersFlowerPot;
import com.carpentersblocks.util.registry.BlockRegistry;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;

public class MigrationHelper {
    boolean containsCache = false;
    boolean containsFlowerPotCache = false;
    private final String TAG_COVER = "cover";
    private final String TAG_DYE = "dye";
    private final String TAG_OVERLAY = "overlay";
    private final String TAG_ITEMSTACKS = "itemstacks";
    private final String TAG_METADATA = "metadata";
    private final String TAG_SOIL = "soil";
    private final String TAG_PLANT = "plant";
    private final String TAG_PLANT_ITEMSTACKS = "plantitemstacks";
    private short[] cachedCover = new short[7];
    private byte[] cachedColor = new byte[7];
    private byte[] cachedOverlay = new byte[7];
    private short cachedData;
    private short cachedPlant;
    private short cachedSoil;

    public void cacheNBT(NBTTagCompound nbt) {
        for (int count = 0; count < 7; ++count) {
            this.cachedCover[count] = nbt.func_74765_d("cover_" + count);
        }
        this.cachedColor = nbt.func_74770_j("color");
        this.cachedOverlay = nbt.func_74770_j("overlay");
        this.cachedData = nbt.func_74765_d("data");
        this.containsCache = true;
    }

    public void cacheFlowerPotNBT(NBTTagCompound nbt) {
        this.cachedPlant = nbt.func_74765_d("plant");
        this.cachedSoil = nbt.func_74765_d("soil");
        this.containsFlowerPotCache = true;
    }

    public void writeToNBT(TEBase TE, NBTTagCompound nbt) {
        short data;
        NBTTagList list = new NBTTagList();
        TE.cover = this.getCoversAsItemStacks();
        TE.dye = this.getColorAsItemStacks();
        TE.overlay = this.getOverlaysAsItemStacks();
        for (byte side = 0; side < 7; side = (byte)(side + 1)) {
            NBTTagCompound nbt1;
            if (TE.cover[side] != null) {
                nbt1 = new NBTTagCompound();
                nbt1.func_74774_a("cover", side);
                TE.cover[side].func_77955_b(nbt1);
                list.func_74742_a((NBTBase)nbt1);
            }
            if (TE.dye[side] != null) {
                nbt1 = new NBTTagCompound();
                nbt1.func_74774_a("dye", side);
                TE.dye[side].func_77955_b(nbt1);
                list.func_74742_a((NBTBase)nbt1);
            }
            if (TE.overlay[side] == null) continue;
            nbt1 = new NBTTagCompound();
            nbt1.func_74774_a("overlay", side);
            TE.overlay[side].func_77955_b(nbt1);
            list.func_74742_a((NBTBase)nbt1);
        }
        TE.metadata = data = this.filterData(TE, this.cachedData);
        nbt.func_74777_a("metadata", data);
        nbt.func_74782_a("itemstacks", (NBTBase)list);
    }

    public void writeFlowerPotToNBT(TECarpentersFlowerPot TE, NBTTagCompound nbt) {
        NBTTagCompound nbt1;
        NBTTagList list = new NBTTagList();
        if (this.hasBlock(this.cachedSoil)) {
            TE.soil = new ItemStack(this.getBlockId(this.cachedSoil), 1, this.getBlockMetadata(this.cachedSoil));
            nbt1 = new NBTTagCompound();
            nbt1.func_74774_a("soil", (byte)0);
            TE.soil.func_77955_b(nbt1);
            list.func_74742_a((NBTBase)nbt1);
        }
        if (this.hasBlock(this.cachedPlant)) {
            TE.plant = new ItemStack(this.getBlockId(this.cachedPlant), 1, this.getBlockMetadata(this.cachedPlant));
            nbt1 = new NBTTagCompound();
            nbt1.func_74774_a("plant", (byte)0);
            TE.plant.func_77955_b(nbt1);
            list.func_74742_a((NBTBase)nbt1);
        }
        nbt.func_74782_a("plantitemstacks", (NBTBase)list);
    }

    private ItemStack[] getOverlaysAsItemStacks() {
        ItemStack[] overlayStack = new ItemStack[]{null, new ItemStack(Item.field_77690_S), new ItemStack(Item.field_77768_aD), new ItemStack(Item.field_77683_K), new ItemStack(Block.field_71998_bu), new ItemStack(Item.field_77685_T), new ItemStack((Block)Block.field_72109_af)};
        ItemStack[] itemStack = new ItemStack[7];
        for (int idx = 0; idx < 7; ++idx) {
            if (!this.hasData(this.cachedOverlay[idx])) continue;
            itemStack[idx] = overlayStack[this.cachedOverlay[idx]];
        }
        return itemStack;
    }

    private ItemStack[] getCoversAsItemStacks() {
        ItemStack[] itemStack = new ItemStack[7];
        for (int idx = 0; idx < 7; ++idx) {
            if (!this.hasBlock(this.cachedCover[idx])) continue;
            itemStack[idx] = new ItemStack(this.getBlockId(this.cachedCover[idx]), 1, this.getBlockMetadata(this.cachedCover[idx]));
        }
        return itemStack;
    }

    private ItemStack[] getColorAsItemStacks() {
        ItemStack[] itemStack = new ItemStack[7];
        for (int idx = 0; idx < 7; ++idx) {
            if (!this.hasData(this.cachedColor[idx])) continue;
            itemStack[idx] = new ItemStack(Item.field_77756_aW, 1, 15 - this.cachedColor[idx]);
        }
        return itemStack;
    }

    private short filterData(TEBase TE, short data) {
        Block block = TE.func_70311_o();
        if (block.equals(BlockRegistry.blockCarpentersSlope) || block.equals(BlockRegistry.blockCarpentersStairs)) {
            byte[] oldIdToNewId = new byte[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 18, 14, 17, 13, 19, 15, 16, 12, 27, 23, 24, 20, 26, 22, 25, 21, 34, 30, 33, 29, 35, 31, 32, 28, 43, 39, 40, 36, 42, 38, 41, 37, 45, 44, 46, 47, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61, 62, 63, 64};
            return oldIdToNewId[data];
        }
        return data;
    }

    private int getBlockId(Short data) {
        return data & 0xFFF;
    }

    private int getBlockMetadata(Short data) {
        return (data & 0xF000) >>> 12;
    }

    private boolean hasBlock(Short data) {
        int blockID = this.getBlockId(data);
        return blockID > 0 && Block.field_71973_m[blockID] != null;
    }

    private boolean hasData(byte data) {
        return data > 0;
    }
}

