/*
 * Decompiled with CFR 0.152.
 */
package com.carpentersblocks.util.flowerpot;

import com.carpentersblocks.tileentity.TEBase;
import com.carpentersblocks.tileentity.TECarpentersFlowerPot;
import com.carpentersblocks.util.BlockProperties;
import com.carpentersblocks.util.flowerpot.FlowerPotHandler;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.IPlantable;
import net.minecraftforge.common.IShearable;

public class FlowerPotProperties {
    public static Block toBlock(ItemStack itemStack) {
        Block plant = FlowerPotHandler.itemPlant.get(itemStack.func_77973_b());
        if (plant != null) {
            return plant;
        }
        return BlockProperties.toBlock(itemStack);
    }

    @SideOnly(value=Side.CLIENT)
    public static int getPlantColor(TEBase TE) {
        ItemStack itemStack = FlowerPotProperties.getPlant(TE);
        Block block = FlowerPotProperties.toBlock(itemStack);
        BlockProperties.setHostMetadata(TE, itemStack.func_77960_j());
        int color1 = block.func_71933_m();
        int color2 = block.func_71920_b((IBlockAccess)TE.func_70314_l(), TE.field_70329_l, TE.field_70330_m, TE.field_70327_n);
        BlockProperties.resetHostMetadata(TE);
        return color1 < color2 ? color1 : color2;
    }

    @SideOnly(value=Side.CLIENT)
    public static boolean isPlantColorable(TEBase TE) {
        return FlowerPotProperties.getPlantColor(TE) != 0xFFFFFF;
    }

    public static boolean hasSoil(TEBase TE) {
        ItemStack itemStack = ((TECarpentersFlowerPot)TE).soil;
        return itemStack != null && FlowerPotProperties.isSoil(itemStack);
    }

    public static boolean isSoil(ItemStack itemStack) {
        Block block;
        if (itemStack.func_77973_b() instanceof ItemBlock && (block = BlockProperties.toBlock(itemStack)) != null && !block.hasTileEntity(itemStack.func_77960_j())) {
            Material material = block.field_72018_cp;
            return material.equals(Material.field_76247_b) || material.equals(Material.field_76248_c) || material.equals(Material.field_76251_o);
        }
        return false;
    }

    public static ItemStack getSoil(TEBase TE) {
        return ((TECarpentersFlowerPot)TE).soil;
    }

    public static boolean setSoil(TEBase TE, ItemStack itemStack) {
        World world = TE.func_70314_l();
        if (FlowerPotProperties.hasSoil(TE)) {
            BlockProperties.dropAttribute(TE, FlowerPotProperties.getSoil(TE));
        }
        ((TECarpentersFlowerPot)TE).soil = BlockProperties.getReducedStack(itemStack);
        int blockID = itemStack == null ? 0 : itemStack.field_77993_c;
        world.func_72898_h(TE.field_70329_l, TE.field_70330_m, TE.field_70327_n, blockID);
        world.func_72845_h(TE.field_70329_l, TE.field_70330_m, TE.field_70327_n);
        return true;
    }

    public static boolean hasPlant(TEBase TE) {
        ItemStack itemStack = ((TECarpentersFlowerPot)TE).plant;
        return itemStack != null && FlowerPotProperties.isPlant(itemStack);
    }

    public static boolean isPlant(ItemStack itemStack) {
        Block block = FlowerPotProperties.toBlock(itemStack);
        if (block != null) {
            if (!block.hasTileEntity(itemStack.func_77960_j())) {
                return block instanceof IPlantable || block instanceof IShearable;
            }
            return false;
        }
        return FlowerPotHandler.itemPlant.containsKey(itemStack.func_77973_b());
    }

    public static ItemStack getPlant(TEBase TE) {
        return ((TECarpentersFlowerPot)TE).plant;
    }

    public static boolean setPlant(TEBase TE, ItemStack itemStack) {
        World world = TE.func_70314_l();
        if (FlowerPotProperties.hasPlant(TE)) {
            BlockProperties.dropAttribute(TE, FlowerPotProperties.getPlant(TE));
        }
        ((TECarpentersFlowerPot)TE).plant = BlockProperties.getReducedStack(itemStack);
        int blockID = itemStack == null ? 0 : itemStack.field_77993_c;
        world.func_72898_h(TE.field_70329_l, TE.field_70330_m, TE.field_70327_n, blockID);
        world.func_72845_h(TE.field_70329_l, TE.field_70330_m, TE.field_70327_n);
        return true;
    }
}

