/*
 * Decompiled with CFR 0.152.
 */
package com.carpentersblocks.util.handler;

import com.carpentersblocks.CarpentersBlocksCachedResources;
import com.carpentersblocks.util.ModLogger;
import com.carpentersblocks.util.registry.BlockRegistry;
import com.carpentersblocks.util.registry.FeatureRegistry;
import com.carpentersblocks.util.registry.IconRegistry;
import com.carpentersblocks.util.registry.ItemRegistry;
import cpw.mods.fml.common.event.FMLPreInitializationEvent;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.io.File;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.logging.Level;
import java.util.zip.ZipEntry;
import javax.imageio.ImageIO;
import net.minecraft.client.renderer.texture.IconRegister;
import net.minecraft.client.resources.ResourceManager;
import net.minecraft.util.Icon;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.classloading.FMLForgePlugin;
import org.apache.commons.io.FileUtils;

public class DesignHandler {
    public static ArrayList<String> listChisel = new ArrayList();
    public static ArrayList<String> listBed = new ArrayList();
    public static ArrayList<String> listFlowerPot = new ArrayList();
    public static ArrayList<String> listTile = new ArrayList();
    private static final String PATH_BASE = "assets/carpentersblocks/textures/blocks/";
    private static final String PATH_EXEMPT = "template/";
    private static final String PATH_CHISEL = "designs/chisel/";
    private static final String PATH_BED = "designs/bed/";
    private static final String PATH_FLOWER_POT = "designs/flowerpot/";
    private static final String PATH_TILE = "designs/tile/";

    private static boolean isPathValid(String path) {
        return path.contains(PATH_BASE) && path.endsWith(".png") && !path.contains(PATH_EXEMPT);
    }

    public static void preInit(FMLPreInitializationEvent event) {
        if (FMLForgePlugin.RUNTIME_DEOBF) {
            try {
                JarFile jarFile = new JarFile(event.getSourceFile());
                Enumeration<JarEntry> enumeration = jarFile.entries();
                while (enumeration.hasMoreElements()) {
                    DesignHandler.processPath(((ZipEntry)enumeration.nextElement()).getName());
                }
                jarFile.close();
            }
            catch (Exception e) {}
        } else {
            File folder = new File(event.getSourceFile().getAbsolutePath());
            for (File file : FileUtils.listFiles((File)folder, (String[])new String[]{"png"}, (boolean)true)) {
                DesignHandler.processPath(file.getAbsolutePath().replace("\\", "/"));
            }
        }
        ModLogger.log(Level.INFO, String.format("Designs found: Bed(%s), Chisel(%s), FlowerPot(%s), Tile(%s)", listBed.size(), listChisel.size(), listFlowerPot.size(), listTile.size()));
    }

    private static void processPath(String path) {
        if (DesignHandler.isPathValid(path)) {
            String name = path.substring(path.lastIndexOf(47) + 1, path.lastIndexOf(46));
            if (path.contains(PATH_CHISEL)) {
                listChisel.add(name);
            } else if (path.contains(PATH_BED)) {
                listBed.add(name);
            } else if (path.contains(PATH_FLOWER_POT)) {
                listFlowerPot.add(name);
            } else if (path.contains(PATH_TILE)) {
                listTile.add(name);
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    public static void addResources(ResourceManager resourceManager) {
        for (String iconName : listBed) {
            ArrayList<BufferedImage> tempList = DesignHandler.getBedIcons(resourceManager, iconName);
            for (BufferedImage image : tempList) {
                CarpentersBlocksCachedResources.INSTANCE.addResource("/textures/blocks/designs/bed/cache/" + iconName + "_" + tempList.indexOf(image), image);
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    public static void registerIcons(IconRegister iconRegister) {
        if (BlockRegistry.enableBed) {
            for (String iconName : listBed) {
                Icon[] icons = new Icon[8];
                for (int count = 0; count < 8; ++count) {
                    icons[count] = iconRegister.func_94245_a(CarpentersBlocksCachedResources.INSTANCE.getModId() + ":" + PATH_BED + "cache/" + iconName + "_" + count);
                }
                IconRegistry.icon_design_bed.add(icons);
            }
        }
        if (FeatureRegistry.enableChiselDesigns) {
            for (String iconName : listChisel) {
                IconRegistry.icon_design_chisel.add(iconRegister.func_94245_a("CarpentersBlocks:designs/chisel/" + iconName));
            }
        }
        if (BlockRegistry.enableFlowerPot) {
            for (String iconName : listFlowerPot) {
                IconRegistry.icon_design_flower_pot.add(iconRegister.func_94245_a("CarpentersBlocks:designs/flowerpot/" + iconName));
            }
        }
        if (ItemRegistry.enableTile) {
            for (String iconName : listTile) {
                IconRegistry.icon_design_tile.add(iconRegister.func_94245_a("CarpentersBlocks:designs/tile/" + iconName));
            }
        }
    }

    public static ArrayList<String> getListForType(String type) {
        return (ArrayList)(type.equals("chisel") ? listChisel.clone() : (type.equals("bed") ? listBed.clone() : (type.equals("flowerpot") ? listFlowerPot.clone() : (type.equals("tile") ? listTile.clone() : null))));
    }

    public static String getNext(String type, String iconName) {
        ArrayList<String> tempList = DesignHandler.getListForType(type);
        if (tempList.isEmpty()) {
            return iconName;
        }
        int idx = tempList.indexOf(iconName) + 1;
        return tempList.get(idx >= tempList.size() ? 0 : idx);
    }

    public static String getPrev(String type, String iconName) {
        ArrayList<String> tempList = DesignHandler.getListForType(type);
        if (tempList.isEmpty()) {
            return iconName;
        }
        int idx = iconName.equals("") ? tempList.size() - 1 : tempList.indexOf(iconName) - 1;
        return tempList.get(idx < 0 ? tempList.size() - 1 : idx);
    }

    @SideOnly(value=Side.CLIENT)
    public static ArrayList<BufferedImage> getBedIcons(ResourceManager resourceManager, String atlas) {
        ArrayList<BufferedImage> imageList = new ArrayList<BufferedImage>();
        try {
            ResourceLocation resourceLocation = new ResourceLocation("CarpentersBlocks:textures/blocks/designs/bed/" + atlas + ".png");
            BufferedImage image = ImageIO.read(resourceManager.func_110536_a(resourceLocation).func_110527_b());
            int size = image.getWidth() / 3;
            int rows = image.getHeight() / size;
            int cols = image.getWidth() / size;
            int count = -1;
            for (int x = 0; x < rows; ++x) {
                block10: for (int y = 0; y < cols; ++y) {
                    switch (++count) {
                        case 0: 
                        case 2: 
                        case 9: 
                        case 11: {
                            continue block10;
                        }
                        default: {
                            BufferedImage bufferedImage = new BufferedImage(size, size, image.getType());
                            Graphics2D gr = bufferedImage.createGraphics();
                            switch (count) {
                                case 3: 
                                case 6: {
                                    gr.rotate(Math.toRadians(270.0), size / 2, size / 2);
                                    break;
                                }
                                case 5: 
                                case 8: {
                                    gr.rotate(Math.toRadians(90.0), size / 2, size / 2);
                                }
                            }
                            gr.drawImage(image, 0, 0, size, size, size * y, size * x, size * y + size, size * x + size, null);
                            gr.dispose();
                            imageList.add(bufferedImage);
                        }
                    }
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return imageList;
    }
}

