/*
 * Decompiled with CFR 0.152.
 */
package com.carpentersblocks.util.handler;

import com.carpentersblocks.api.ICarpentersChisel;
import com.carpentersblocks.api.ICarpentersHammer;
import com.carpentersblocks.block.BlockCoverable;
import com.carpentersblocks.network.PacketActivateBlock;
import com.carpentersblocks.network.PacketSlopeSelect;
import com.carpentersblocks.renderer.helper.ParticleHelper;
import com.carpentersblocks.tileentity.TEBase;
import com.carpentersblocks.util.BlockProperties;
import com.carpentersblocks.util.handler.OverlayHandler;
import com.carpentersblocks.util.handler.PacketHandler;
import com.carpentersblocks.util.handler.ShadersHandler;
import com.carpentersblocks.util.registry.BlockRegistry;
import cpw.mods.fml.client.FMLClientHandler;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityClientPlayerMP;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.MathHelper;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.Vec3;
import net.minecraft.world.World;
import net.minecraftforge.client.event.GuiOpenEvent;
import net.minecraftforge.client.event.MouseEvent;
import net.minecraftforge.client.event.sound.PlaySoundEvent;
import net.minecraftforge.event.ForgeSubscribe;
import net.minecraftforge.event.entity.PlaySoundAtEntityEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;

public class EventHandler {
    public static float hitX;
    public static float hitY;
    public static float hitZ;
    public static int eventFace;
    public static EntityPlayer eventEntityPlayer;

    @ForgeSubscribe
    @SideOnly(value=Side.CLIENT)
    public void onPreRenderWorldEvent(GuiOpenEvent event) {
        if (ShadersHandler.enableShadersModCoreIntegration) {
            ShadersHandler.updateLightness();
        }
    }

    @ForgeSubscribe
    public void onPlayerInteractEvent(PlayerInteractEvent event) {
        Block block = Block.field_71973_m[event.entity.field_70170_p.func_72798_a(event.x, event.y, event.z)];
        if (block != null && block instanceof BlockCoverable) {
            eventFace = event.face;
            eventEntityPlayer = event.entityPlayer;
            ItemStack itemStack = eventEntityPlayer.func_70694_bm();
            MovingObjectPosition object = this.getMovingObjectPositionFromPlayer(EventHandler.eventEntityPlayer.field_70170_p, eventEntityPlayer);
            if (object != null) {
                hitX = (float)object.field_72307_f.field_72450_a - (float)event.x;
                hitY = (float)object.field_72307_f.field_72448_b - (float)event.y;
                hitZ = (float)object.field_72307_f.field_72449_c - (float)event.z;
            } else {
                hitZ = 1.0f;
                hitY = 1.0f;
                hitX = 1.0f;
            }
            switch (event.action) {
                case LEFT_CLICK_BLOCK: {
                    boolean toolEquipped;
                    boolean bl = toolEquipped = itemStack != null && (itemStack.func_77973_b() instanceof ICarpentersHammer || itemStack.func_77973_b() instanceof ICarpentersChisel);
                    if (!toolEquipped || !EventHandler.eventEntityPlayer.field_71075_bZ.field_75098_d) break;
                    block.func_71921_a(EventHandler.eventEntityPlayer.field_70170_p, event.x, event.y, event.z, eventEntityPlayer);
                    break;
                }
                case RIGHT_CLICK_BLOCK: {
                    if (!eventEntityPlayer.func_70093_af() || itemStack != null && itemStack.func_77973_b() instanceof ItemBlock && !BlockProperties.isOverlay(itemStack)) break;
                    event.setCanceled(true);
                    if (!event.entity.field_70170_p.field_72995_K) break;
                    PacketHandler.sendPacketToServer(new PacketActivateBlock(event.x, event.y, event.z, event.face));
                    break;
                }
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    @ForgeSubscribe
    public void onMouseEvent(MouseEvent event) {
        ItemStack itemStack;
        EntityClientPlayerMP entityPlayer;
        if (event.button < 0 && (entityPlayer = Minecraft.func_71410_x().field_71439_g).func_70093_af() && (itemStack = entityPlayer.func_70694_bm()) != null && itemStack.func_77973_b() instanceof ItemBlock && Block.field_71973_m[itemStack.field_77993_c].equals(BlockRegistry.blockCarpentersSlope)) {
            if (event.dwheel != 0) {
                PacketHandler.sendPacketToServer(new PacketSlopeSelect(entityPlayer.field_71071_by.field_70461_c, event.dwheel == 120));
            }
            event.setCanceled(true);
        }
    }

    private MovingObjectPosition getMovingObjectPositionFromPlayer(World world, EntityPlayer entityPlayer) {
        double xPos = entityPlayer.field_70169_q + (entityPlayer.field_70165_t - entityPlayer.field_70169_q);
        double yPos = entityPlayer.field_70167_r + (entityPlayer.field_70163_u - entityPlayer.field_70167_r) + (double)(world.field_72995_K ? entityPlayer.func_70047_e() - entityPlayer.getDefaultEyeHeight() : entityPlayer.func_70047_e());
        double zPos = entityPlayer.field_70166_s + (entityPlayer.field_70161_v - entityPlayer.field_70166_s);
        float pitch = entityPlayer.field_70127_C + (entityPlayer.field_70125_A - entityPlayer.field_70127_C);
        float yaw = entityPlayer.field_70126_B + (entityPlayer.field_70177_z - entityPlayer.field_70126_B);
        float commonComp = -MathHelper.func_76134_b((float)(-pitch * ((float)Math.PI / 180)));
        float xComp = MathHelper.func_76126_a((float)(-yaw * ((float)Math.PI / 180) - (float)Math.PI)) * commonComp;
        float yComp = MathHelper.func_76126_a((float)(-pitch * ((float)Math.PI / 180)));
        float zComp = MathHelper.func_76134_b((float)(-yaw * ((float)Math.PI / 180) - (float)Math.PI)) * commonComp;
        double reachDist = 5.0;
        if (entityPlayer instanceof EntityPlayerMP) {
            reachDist = ((EntityPlayerMP)entityPlayer).field_71134_c.getBlockReachDistance();
        }
        Vec3 vec1 = world.func_82732_R().func_72345_a(xPos, yPos, zPos);
        Vec3 vec2 = vec1.func_72441_c((double)xComp * reachDist, (double)yComp * reachDist, (double)zComp * reachDist);
        return world.func_72933_a(vec1, vec2);
    }

    @ForgeSubscribe
    public void onLivingUpdateEvent(LivingEvent.LivingUpdateEvent event) {
        int z;
        int y;
        EntityLivingBase entity = event.entityLiving;
        World world = entity.field_70170_p;
        int x = MathHelper.func_76128_c((double)entity.field_70165_t);
        Block block = Block.field_71973_m[world.func_72798_a(x, y = MathHelper.func_76128_c((double)(entity.field_70163_u - (double)0.2f - (double)entity.field_70129_M)), z = MathHelper.func_76128_c((double)entity.field_70161_v))];
        if (block != null && block instanceof BlockCoverable) {
            OverlayHandler.Overlay overlay;
            TEBase TE = (TEBase)world.func_72796_p(x, y, z);
            int effectiveSide = BlockProperties.hasCover(TE, 1) ? 1 : 6;
            ItemStack itemStack = BlockProperties.getCover(TE, effectiveSide);
            if (BlockProperties.hasOverlay(TE, effectiveSide) && OverlayHandler.coversFullSide(overlay = OverlayHandler.getOverlayType(BlockProperties.getOverlay(TE, effectiveSide)), 1)) {
                itemStack = overlay.getItemStack();
            }
            if (world.field_72995_K && entity.func_70051_ag() && !entity.func_70090_H()) {
                ParticleHelper.spawnTileParticleAt((Entity)entity, itemStack);
            }
            TE.func_70311_o().field_72016_cq = BlockProperties.toBlock(itemStack) instanceof BlockCoverable ? Block.field_71979_v.field_72016_cq : BlockProperties.toBlock((ItemStack)itemStack).field_72016_cq;
        }
    }

    @SideOnly(value=Side.CLIENT)
    @ForgeSubscribe
    public void onSoundEvent(PlaySoundEvent event) {
        if (event != null && event.name != null && event.name.contains("CarpentersBlocks") && FMLCommonHandler.instance().getSide() == Side.CLIENT) {
            WorldClient world = FMLClientHandler.instance().getClient().field_71441_e;
            int x = MathHelper.func_76141_d((float)event.x);
            int y = MathHelper.func_76141_d((float)event.y);
            int z = MathHelper.func_76141_d((float)event.z);
            world.func_72798_a(x, y, z);
            Block block = Block.field_71973_m[world.func_72798_a(x, y, z)];
            if (block != null) {
                TileEntity TE = world.func_72796_p(x, y, z);
                if (TE != null && TE instanceof TEBase) {
                    block = BlockProperties.toBlock(BlockProperties.getCover((TEBase)TE, 6));
                }
                if (block instanceof BlockCoverable) {
                    block = Block.field_71988_x;
                }
                event.result = event.manager.field_77379_b.func_77458_a(block.field_72020_cn.func_72676_a());
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    @ForgeSubscribe
    public void onPlaySoundAtEntityEvent(PlaySoundAtEntityEvent event) {
        if (event != null && event.name != null && event.name.contains("CarpentersBlocks")) {
            int x = MathHelper.func_76128_c((double)event.entity.field_70165_t);
            int y = MathHelper.func_76128_c((double)(event.entity.field_70163_u - (double)0.2f - (double)event.entity.field_70129_M));
            int z = MathHelper.func_76128_c((double)event.entity.field_70161_v);
            Block block = Block.field_71973_m[event.entity.field_70170_p.func_72798_a(x, y, z)];
            String prefix = event.name.substring(0, event.name.indexOf(".") + 1);
            if (block != null && block instanceof BlockCoverable) {
                block = BlockProperties.toBlock(BlockProperties.getCover((TEBase)event.entity.field_70170_p.func_72796_p(x, y, z), 6));
                if (block instanceof BlockCoverable) {
                    event.name = prefix + Block.field_71988_x.field_72020_cn.field_72681_a;
                } else if (block.field_72020_cn != null) {
                    event.name = prefix + block.field_72020_cn.field_72681_a;
                }
            } else {
                event.name = prefix + Block.field_71988_x.field_72020_cn.field_72681_a;
            }
        }
    }
}

