/*
 * Decompiled with CFR 0.152.
 */
package com.carpentersblocks.util.handler;

import com.carpentersblocks.util.ModLogger;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.lang.reflect.Method;
import java.util.logging.Level;
import net.minecraft.block.Block;
import net.minecraft.world.IBlockAccess;

@SideOnly(value=Side.CLIENT)
public class OptifineHandler {
    public static boolean enableOptifineIntegration = false;
    private static Method getColorMultiplier;

    public static void init() {
        try {
            Class<?> CustomColorizer = Class.forName("CustomColorizer");
            getColorMultiplier = CustomColorizer.getMethod("getColorMultiplier", Block.class, IBlockAccess.class, Integer.TYPE, Integer.TYPE, Integer.TYPE);
            ModLogger.log(Level.INFO, "Optifine integration successful.");
            enableOptifineIntegration = true;
        }
        catch (Exception e) {
            ModLogger.log(Level.WARNING, "Optifine integration failed: " + e.getMessage());
        }
    }

    public static int getColorMultiplier(Block block, IBlockAccess blockAccess, int x, int y, int z) {
        int colorMultiplier = block.func_71920_b(blockAccess, x, y, z);
        try {
            colorMultiplier = (Integer)getColorMultiplier.invoke(null, block, blockAccess, x, y, z);
        }
        catch (Exception e) {
            ModLogger.log(Level.WARNING, "Block custom coloring failed, disabling Optifine integration: " + e.getMessage());
            enableOptifineIntegration = false;
        }
        return colorMultiplier;
    }
}

